/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.io;

import java.util.Map;
import java.util.TreeMap;
import org.apache.jackrabbit.vault.util.PathComparator;
import org.jetbrains.annotations.NotNull;

public class ExportInfo {
    private final TreeMap<String, Entry> entries = new TreeMap(new PathComparator(true));

    public void update(@NotNull Type type, @NotNull String path) {
        Entry e = this.entries.get(path);
        if (e == null) {
            e = new Entry(type, path);
        } else if (e.type != Type.ADD) {
            e = new Entry(type, path);
        }
        this.entries.put(path, e);
    }

    @NotNull
    public Map<String, Entry> getEntries() {
        return this.entries;
    }

    public static class Entry {
        public final Type type;
        public final String path;

        public Entry(Type type, String path) {
            this.type = type;
            this.path = path;
        }

        public String toString() {
            return this.type + " " + this.path;
        }
    }

    public static enum Type {
        ADD,
        DELETE,
        UPDATE,
        MKDIR,
        RMDIR,
        NOP;

    }
}

