/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.api;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.BitSet;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepositoryAddress {
    public static final String JCR_ROOT = "/jcr:root";
    private final URI uri;
    private final URI specific;
    private final String workspace;
    private final String path;
    private static BitSet URISaveEx;
    private static final char[] hexTable;

    public RepositoryAddress(@NotNull String uri) throws URISyntaxException {
        this(new URI(uri));
    }

    public RepositoryAddress(@NotNull URI uri) throws URISyntaxException {
        int idx1;
        String workspace;
        Object path = uri.getPath();
        String prefix = "/";
        String localPath = "/";
        if (((String)path).length() == 0 || "/".equals(path)) {
            workspace = "-";
            localPath = "/";
        } else if (!uri.isAbsolute()) {
            idx1 = ((String)path).indexOf(47, 1);
            if (idx1 < 0) {
                workspace = ((String)path).substring(1);
            } else {
                workspace = ((String)path).substring(1, idx1);
                localPath = ((String)path).substring(idx1);
            }
        } else {
            String segment;
            if (((String)path).charAt(((String)path).length() - 1) != '/') {
                path = (String)path + "/";
            }
            idx1 = -1;
            int idx2 = 0;
            int idx3 = ((String)path).indexOf(47, 1);
            while (idx3 > 0 && !(segment = ((String)path).substring(idx2, idx3)).equals(JCR_ROOT)) {
                idx1 = idx2;
                idx2 = idx3;
                idx3 = ((String)path).indexOf(47, idx3 + 1);
            }
            if (idx3 < 0) {
                if (uri.getScheme() != null && "rmi".equals(uri.getScheme())) {
                    idx1 = ((String)path).indexOf(47, 1);
                    idx2 = ((String)path).indexOf(47, idx1 + 1);
                    if (idx2 < 0) {
                        workspace = "-";
                        prefix = ((String)path).substring(0, idx1);
                        localPath = "/";
                    } else {
                        workspace = ((String)path).substring(idx1 + 1, idx2);
                        prefix = ((String)path).substring(0, idx1);
                        int end = ((String)path).length();
                        if (end != idx2 + 1) {
                            --end;
                        }
                        localPath = ((String)path).substring(idx2, end);
                    }
                } else {
                    workspace = idx1 < 0 ? "-" : ((String)path).substring(idx1 + 1, idx2);
                    prefix = idx1 <= 0 ? "/" : ((String)path).substring(0, idx1);
                    localPath = "/";
                }
            } else {
                workspace = ((String)path).substring(idx1 + 1, idx2);
                prefix = ((String)path).substring(0, idx1);
                int end = ((String)path).length();
                if (end - idx3 > 1) {
                    --end;
                }
                localPath = ((String)path).substring(idx3, end);
            }
        }
        if (uri.getScheme() != null && uri.getScheme().startsWith("http") && ("/".equals(prefix) || "/crx".equals(prefix))) {
            prefix = "/crx/server";
            workspace = "-";
        }
        if (prefix.length() == 0) {
            prefix = "/";
        }
        this.path = localPath;
        this.workspace = workspace;
        this.specific = uri.resolve(prefix);
        StringBuilder buf = new StringBuilder(this.specific.toString());
        if (buf.charAt(buf.length() - 1) != '/') {
            buf.append('/');
        }
        buf.append(workspace);
        buf.append(JCR_ROOT);
        if (!"/".equals(localPath)) {
            buf.append(RepositoryAddress.escapePath(localPath));
        }
        this.uri = new URI(buf.toString());
    }

    private RepositoryAddress(@NotNull URI uri, @NotNull URI specific, @Nullable String workspace, @NotNull String path) {
        this.uri = uri;
        this.specific = specific;
        this.workspace = workspace;
        this.path = path;
    }

    @NotNull
    public URI getURI() {
        return this.uri;
    }

    @NotNull
    public RepositoryAddress resolve(@Nullable String path) {
        if (path == null || ((String)path).length() == 0 || ".".equals(path) || "./".equals(path)) {
            return this;
        }
        StringBuilder newPath = new StringBuilder(this.specific.getPath());
        newPath.append("/");
        newPath.append(this.workspace);
        newPath.append(JCR_ROOT);
        if (((String)path).charAt(0) != '/') {
            path = this.path.endsWith("/") ? this.path + (String)path : this.path + "/" + (String)path;
        }
        newPath.append(RepositoryAddress.escapePath((String)path));
        URI uri = this.specific.resolve(newPath.toString());
        return new RepositoryAddress(uri, this.specific, this.workspace, (String)path);
    }

    @Nullable
    public String getWorkspace() {
        return "-".equals(this.workspace) ? null : this.workspace;
    }

    @NotNull
    public URI getSpecificURI() {
        return this.specific;
    }

    @NotNull
    public String getPath() {
        return this.path;
    }

    @Nullable
    public Credentials getCredentials() {
        String userinfo = this.uri.getUserInfo();
        if (userinfo == null) {
            return null;
        }
        int idx = userinfo.indexOf(58);
        if (idx < 0) {
            return new SimpleCredentials(userinfo, new char[0]);
        }
        return new SimpleCredentials(userinfo.substring(0, idx), userinfo.substring(idx + 1).toCharArray());
    }

    @NotNull
    public String toString() {
        URI uri = this.getURI();
        String userInfo = uri.getRawUserInfo();
        if (userInfo != null) {
            return uri.toString().replace(userInfo, "******:******");
        }
        return uri.toString();
    }

    public int hashCode() {
        return this.getURI().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RepositoryAddress) {
            return this.getURI().equals(((RepositoryAddress)obj).getURI());
        }
        return false;
    }

    @NotNull
    private static String escapePath(@NotNull String string) {
        try {
            byte[] bytes = string.getBytes("utf-8");
            StringBuilder out = new StringBuilder(bytes.length);
            for (byte aByte : bytes) {
                int c = aByte & 0xFF;
                if (URISaveEx.get(c) && c != 37) {
                    out.append((char)c);
                    continue;
                }
                out.append('%');
                out.append(hexTable[c >> 4 & 0xF]);
                out.append(hexTable[c & 0xF]);
            }
            return out.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e.toString());
        }
    }

    static {
        int i;
        URISaveEx = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            URISaveEx.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            URISaveEx.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            URISaveEx.set(i);
        }
        URISaveEx.set(45);
        URISaveEx.set(95);
        URISaveEx.set(46);
        URISaveEx.set(33);
        URISaveEx.set(126);
        URISaveEx.set(42);
        URISaveEx.set(39);
        URISaveEx.set(40);
        URISaveEx.set(41);
        URISaveEx.set(47);
        hexTable = "0123456789abcdef".toCharArray();
    }
}

