/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.user.util;

import java.util.Objects;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.AuthorizableTypeException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.plugins.tree.TreeUtil;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.UserConstants;
import org.apache.jackrabbit.oak.spi.xml.ImportBehavior;
import org.apache.jackrabbit.util.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UserUtil
implements UserConstants {
    private UserUtil() {
    }

    public static boolean isAdmin(@NotNull ConfigurationParameters parameters, @NotNull String userId) {
        return UserUtil.getAdminId(parameters).equals(userId);
    }

    @NotNull
    public static String getAdminId(@NotNull ConfigurationParameters parameters) {
        return parameters.getConfigValue("adminId", "admin");
    }

    @NotNull
    public static String getAnonymousId(@NotNull ConfigurationParameters parameters) {
        return parameters.getConfigValue("anonymousId", "anonymous");
    }

    public static boolean isType(@Nullable Tree authorizableTree, @NotNull AuthorizableType type) {
        if (authorizableTree != null) {
            String ntName = TreeUtil.getPrimaryTypeName(authorizableTree);
            switch (type) {
                case GROUP: {
                    return "rep:Group".equals(ntName);
                }
                case USER: {
                    return "rep:User".equals(ntName) || "rep:SystemUser".equals(ntName);
                }
            }
            return "rep:User".equals(ntName) || "rep:Group".equals(ntName) || "rep:SystemUser".equals(ntName);
        }
        return false;
    }

    @Nullable
    public static AuthorizableType getType(@NotNull Tree authorizableNode) {
        String ntName = TreeUtil.getPrimaryTypeName(authorizableNode);
        return UserUtil.getType(ntName);
    }

    @Nullable
    public static AuthorizableType getType(@Nullable String primaryTypeName) {
        if (primaryTypeName != null) {
            if ("rep:Group".equals(primaryTypeName)) {
                return AuthorizableType.GROUP;
            }
            if ("rep:User".equals(primaryTypeName)) {
                return AuthorizableType.USER;
            }
            if ("rep:SystemUser".equals(primaryTypeName)) {
                return AuthorizableType.USER;
            }
        }
        return null;
    }

    public static boolean isSystemUser(@Nullable Tree authorizableTree) {
        return authorizableTree != null && "rep:SystemUser".equals(TreeUtil.getPrimaryTypeName(authorizableTree));
    }

    @Nullable
    public static String getAuthorizableRootPath(@NotNull ConfigurationParameters parameters, @Nullable AuthorizableType type) {
        String path = null;
        if (type != null) {
            switch (type) {
                case USER: {
                    path = parameters.getConfigValue("usersPath", "/rep:security/rep:authorizables/rep:users");
                    break;
                }
                case GROUP: {
                    path = parameters.getConfigValue("groupsPath", "/rep:security/rep:authorizables/rep:groups");
                    break;
                }
                default: {
                    path = parameters.getConfigValue("usersPath", "/rep:security/rep:authorizables/rep:users");
                    String groupRoot = parameters.getConfigValue("groupsPath", "/rep:security/rep:authorizables/rep:groups");
                    while (!Text.isDescendantOrEqual(path, groupRoot)) {
                        path = Text.getRelativeParent(path, 1);
                    }
                    break block0;
                }
            }
        }
        return path;
    }

    @Nullable
    public static String getAuthorizableId(@NotNull Tree authorizableTree) {
        Objects.requireNonNull(authorizableTree);
        if (UserUtil.isType(authorizableTree, AuthorizableType.AUTHORIZABLE)) {
            PropertyState idProp = authorizableTree.getProperty("rep:authorizableId");
            if (idProp != null) {
                return idProp.getValue(Type.STRING);
            }
            return Text.unescapeIllegalJcrChars(authorizableTree.getName());
        }
        return null;
    }

    @NotNull
    public static String getAuthorizableId(@NotNull Tree authorizableTree, @NotNull AuthorizableType type) {
        Validate.checkArgument((boolean)UserUtil.isType(authorizableTree, type));
        PropertyState idProp = authorizableTree.getProperty("rep:authorizableId");
        if (idProp != null) {
            return idProp.getValue(Type.STRING);
        }
        return Text.unescapeIllegalJcrChars(authorizableTree.getName());
    }

    @Nullable
    public static <T extends Authorizable> T castAuthorizable(@Nullable Authorizable authorizable, Class<T> authorizableClass) throws AuthorizableTypeException {
        if (authorizable == null) {
            return null;
        }
        if (authorizableClass != null && authorizableClass.isInstance(authorizable)) {
            return (T)((Authorizable)authorizableClass.cast(authorizable));
        }
        throw new AuthorizableTypeException("Invalid authorizable type '" + String.valueOf(authorizableClass == null ? "null" : authorizableClass) + "'");
    }

    public static int getImportBehavior(@NotNull ConfigurationParameters config) {
        String importBehaviorStr = config.getConfigValue("importBehavior", "ignore");
        return ImportBehavior.valueFromString(importBehaviorStr);
    }
}

