/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.blob;

import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.oak.spi.blob.SharedBackend;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSharedBackend
implements SharedBackend {
    private static Logger LOG = LoggerFactory.getLogger(AbstractSharedBackend.class);
    private static final String ALGORITHM = "HmacSHA1";
    private byte[] referenceKey = null;

    protected String getReferenceFromIdentifier(DataIdentifier identifier) {
        try {
            String id = identifier.toString();
            Mac mac = Mac.getInstance(ALGORITHM);
            mac.init(new SecretKeySpec(this.getReferenceKey(), ALGORITHM));
            byte[] hash = mac.doFinal(id.getBytes("UTF-8"));
            return id + ":" + Hex.encodeHexString(hash);
        }
        catch (Exception e) {
            LOG.error("Failed to hash identifier using MAC (Message Authentication Code) algorithm.", e);
            return null;
        }
    }

    public byte[] getOrCreateReferenceKey() throws DataStoreException {
        byte[] referenceKeyValue = new byte[256];
        new SecureRandom().nextBytes(referenceKeyValue);
        return referenceKeyValue;
    }

    private synchronized byte[] getReferenceKey() throws DataStoreException {
        if (this.referenceKey == null) {
            this.referenceKey = this.getOrCreateReferenceKey();
        }
        return this.referenceKey;
    }
}

