/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.property;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.collections.IterableUtils;
import org.apache.jackrabbit.oak.plugins.index.property.Multiplexers;
import org.apache.jackrabbit.oak.plugins.index.property.PropertyIndexUtil;
import org.apache.jackrabbit.oak.plugins.index.property.ValuePattern;
import org.apache.jackrabbit.oak.plugins.index.property.strategy.IndexStoreStrategy;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.mount.Mounts;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyIndexLookup {
    static final Logger LOG = LoggerFactory.getLogger(PropertyIndexLookup.class);
    public static final double COST_OVERHEAD = 2.0;
    static final int MAX_COST = 100;
    private final NodeState root;
    private final MountInfoProvider mountInfoProvider;

    public PropertyIndexLookup(NodeState root) {
        this(root, Mounts.defaultMountInfoProvider());
    }

    public PropertyIndexLookup(NodeState root, MountInfoProvider mountInfoProvider) {
        this.root = root;
        this.mountInfoProvider = mountInfoProvider;
    }

    public boolean isIndexed(String propertyName, String path, Filter filter) {
        if (PathUtils.denotesRoot(path)) {
            return this.getIndexNode(this.root, propertyName, filter) != null;
        }
        NodeState node = this.root;
        for (String s : PathUtils.elements(path)) {
            if (this.getIndexNode(node, propertyName, filter) != null) {
                return true;
            }
            node = node.getChildNode(s);
        }
        return false;
    }

    public Iterable<String> query(Filter filter, String propertyName, PropertyValue value) {
        NodeState indexMeta = this.getIndexNode(this.root, propertyName, filter);
        if (indexMeta == null) {
            throw new IllegalArgumentException("No index for " + propertyName);
        }
        ArrayList<Iterable<String>> iterables = new ArrayList<Iterable<String>>();
        ValuePattern pattern = new ValuePattern(indexMeta);
        for (IndexStoreStrategy s : this.getStrategies(indexMeta)) {
            iterables.add(s.query(filter, propertyName, indexMeta, PropertyIndexUtil.encode(value, pattern)));
        }
        return IterableUtils.chainedIterable(iterables);
    }

    Set<IndexStoreStrategy> getStrategies(NodeState definition) {
        boolean unique = definition.getBoolean("unique");
        return Multiplexers.getStrategies(unique, this.mountInfoProvider, definition, ":index");
    }

    public double getCost(Filter filter, String propertyName, PropertyValue value) {
        NodeState indexMeta = this.getIndexNode(this.root, propertyName, filter);
        if (indexMeta == null) {
            return Double.POSITIVE_INFINITY;
        }
        Set<IndexStoreStrategy> strategies = this.getStrategies(indexMeta);
        ValuePattern pattern = new ValuePattern(indexMeta);
        double cost = strategies.isEmpty() ? 100.0 : 2.0;
        for (IndexStoreStrategy s : strategies) {
            cost += (double)s.count(filter, this.root, indexMeta, PropertyIndexUtil.encode(value, pattern), 100);
        }
        return cost;
    }

    @Nullable
    NodeState getIndexNode(NodeState node, String propertyName, Filter filter) {
        NodeState fallback = null;
        NodeState state = node.getChildNode("oak:index");
        for (ChildNodeEntry childNodeEntry : state.getChildNodeEntries()) {
            NodeState indexContent;
            NodeState index = childNodeEntry.getNodeState();
            PropertyState type = index.getProperty("type");
            if (type == null || type.isArray() || !this.getType().equals(type.getValue(Type.STRING)) || !IterableUtils.contains(PropertyIndexLookup.getNames(index, "propertyNames"), (Object)propertyName) || !(indexContent = index.getChildNode(":index")).exists()) continue;
            Set<String> supertypes = PropertyIndexLookup.getSuperTypes(filter);
            if (index.hasProperty("declaringNodeTypes")) {
                if (supertypes == null) continue;
                for (String typeName : PropertyIndexLookup.getNames(index, "declaringNodeTypes")) {
                    if (!supertypes.contains(typeName)) continue;
                    return index;
                }
                continue;
            }
            if (supertypes == null) {
                return index;
            }
            if (fallback != null) continue;
            fallback = index;
        }
        return fallback;
    }

    String getType() {
        return "property";
    }

    @Nullable
    private static Set<String> getSuperTypes(Filter filter) {
        if (filter != null && !filter.matchesAllTypes()) {
            return filter.getSupertypes();
        }
        return null;
    }

    @NotNull
    private static Iterable<String> getNames(@NotNull NodeState state, @NotNull String propertyName) {
        Iterable<String> ret = state.getNames(propertyName);
        if (ret.iterator().hasNext()) {
            return ret;
        }
        PropertyState property = state.getProperty(propertyName);
        if (property != null) {
            LOG.warn("Expected '{}' as type of property '{}' but found '{}'. Node - '{}'", Type.NAMES, propertyName, property.getType(), state);
            ret = property.getValue(Type.STRINGS);
        } else {
            ret = Collections.emptyList();
        }
        return ret;
    }
}

