/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.importer;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.index.AsyncIndexUpdate;
import org.apache.jackrabbit.oak.plugins.index.importer.AsyncIndexerLock;
import org.apache.jackrabbit.oak.plugins.index.importer.ClusteredLockToken;
import org.apache.jackrabbit.oak.plugins.index.importer.NodeStoreUtils;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.stats.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterNodeStoreLock
implements AsyncIndexerLock<ClusteredLockToken> {
    private static final long LOCK_TIMEOUT = TimeUnit.HOURS.toMillis(6L);
    private static final long MAX_RETRY_TIME = 120000L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final NodeStore nodeStore;
    private final Clock clock;

    public ClusterNodeStoreLock(NodeStore nodeStore) {
        this(nodeStore, Clock.SIMPLE);
    }

    public ClusterNodeStoreLock(NodeStore nodeStore, Clock clock) {
        this.nodeStore = nodeStore;
        this.clock = clock;
    }

    @Override
    public ClusteredLockToken lock(String asyncIndexerLane) throws CommitFailedException {
        return this.retryIfNeeded(() -> this.tryLock(asyncIndexerLane));
    }

    private ClusteredLockToken tryLock(String asyncIndexerLane) throws CommitFailedException {
        NodeBuilder builder = this.nodeStore.getRoot().builder();
        NodeBuilder async = builder.child(":async");
        String leaseName = AsyncIndexUpdate.leasify(asyncIndexerLane);
        long leaseEndTime = this.clock.getTime() + LOCK_TIMEOUT;
        if (async.hasProperty(leaseName)) {
            this.log.info("AsyncIndexer found to be running currently. Lease update would cause itscommit to fail. Such a failure should be ignored");
        }
        async.setProperty(leaseName, leaseEndTime);
        async.setProperty(ClusterNodeStoreLock.lockName(asyncIndexerLane), true);
        NodeStoreUtils.mergeWithConcurrentCheck(this.nodeStore, builder);
        this.log.info("Acquired the lock for async indexer lane [{}]", (Object)asyncIndexerLane);
        return new ClusteredLockToken(asyncIndexerLane, leaseEndTime);
    }

    private <T> T retryIfNeeded(Callable<T> r) throws CommitFailedException {
        int backOffMaxMillis = 1;
        long start = System.currentTimeMillis();
        while (true) {
            try {
                return r.call();
            }
            catch (Exception e) {
                this.log.info("Commit failed, retrying: " + String.valueOf(e));
                long time = System.currentTimeMillis() - start;
                if (time > 120000L) {
                    if (e instanceof CommitFailedException) {
                        throw (CommitFailedException)e;
                    }
                    this.log.error("Unexpected failure retrying", e);
                    throw new CommitFailedException("Unsupported", 2, e.getMessage(), e);
                }
                int sleep = (int)((double)backOffMaxMillis * Math.random());
                backOffMaxMillis *= 2;
                this.log.info("Wait " + sleep + " ms");
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    @Override
    public void unlock(ClusteredLockToken token) throws CommitFailedException {
        this.retryIfNeeded(() -> this.tryUnlock(token));
    }

    private Void tryUnlock(ClusteredLockToken token) throws CommitFailedException {
        String leaseName = AsyncIndexUpdate.leasify(token.laneName);
        NodeBuilder builder = this.nodeStore.getRoot().builder();
        NodeBuilder async = builder.child(":async");
        async.removeProperty(leaseName);
        async.removeProperty(ClusterNodeStoreLock.lockName(token.laneName));
        NodeStoreUtils.mergeWithConcurrentCheck(this.nodeStore, builder);
        this.log.info("Remove the lock for async indexer lane [{}]", (Object)token.laneName);
        return null;
    }

    public boolean isLocked(String asyncIndexerLane) {
        NodeState async = this.nodeStore.getRoot().getChildNode(":async");
        String leaseName = ClusterNodeStoreLock.lockName(asyncIndexerLane);
        return async.hasProperty(leaseName);
    }

    private static String lockName(String asyncIndexerLane) {
        return asyncIndexerLane + "-lock";
    }
}

