/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.blob.datastore;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.FileDataRecord;
import org.apache.jackrabbit.core.data.FileDataStore;
import org.apache.jackrabbit.oak.commons.conditions.Validate;
import org.apache.jackrabbit.oak.commons.io.FileTreeTraverser;
import org.apache.jackrabbit.oak.plugins.blob.SharedDataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated(since="2024-09-23")
public class OakFileDataStore
extends FileDataStore
implements SharedDataStore {
    public static final Logger LOG = LoggerFactory.getLogger(OakFileDataStore.class);
    private static final int DEFAULT_MIN_RECORD_LENGTH = 4096;
    private byte[] referenceKey;

    public OakFileDataStore() {
        this.inUse = new NoOpMap();
        this.setMinRecordLength(4096);
    }

    @Override
    public Iterator<DataIdentifier> getAllIdentifiers() {
        String path = FilenameUtils.normalizeNoEndSeparator(new File(this.getPath()).getAbsolutePath());
        return FileTreeTraverser.depthFirstPostOrder(new File(path)).filter(file -> file.isFile() && !file.getParent().equals(path)).map(file -> new DataIdentifier(file.getName())).iterator();
    }

    @Override
    protected byte[] getOrCreateReferenceKey() throws DataStoreException {
        if (this.referenceKey != null) {
            return this.referenceKey;
        }
        return super.getOrCreateReferenceKey();
    }

    public void setReferenceKeyEncoded(String encodedKey) {
        this.referenceKey = Base64.getDecoder().decode(encodedKey);
    }

    public void setReferenceKeyPlainText(String textKey) {
        this.referenceKey = textKey.getBytes(StandardCharsets.UTF_8);
    }

    public void setReferenceKey(byte[] referenceKey) {
        this.referenceKey = referenceKey;
    }

    @Override
    public void addMetadataRecord(InputStream input, String name) throws DataStoreException {
        Validate.checkArgument((input != null ? 1 : 0) != 0, (String)"input should not be null");
        Validate.checkArgument((!StringUtils.isEmpty(name) ? 1 : 0) != 0, (String)"name should not be empty");
        try {
            File file = new File(this.getPath(), name);
            try (InputStream inputStream = input;
                 FileOutputStream os = new FileOutputStream(file);){
                IOUtils.copyLarge(input, os);
            }
        }
        catch (IOException e) {
            LOG.error("Exception while adding metadata record with name {}, {}", new Object[]{name, e});
            throw new DataStoreException("Could not add root record", e);
        }
    }

    @Override
    public void addMetadataRecord(File input, String name) throws DataStoreException {
        Validate.checkArgument((input != null ? 1 : 0) != 0, (String)"input should not be null");
        Validate.checkArgument((!StringUtils.isEmpty(name) ? 1 : 0) != 0, (String)"name should not be empty");
        try {
            File file = new File(this.getPath(), name);
            FileUtils.copyFile(input, file);
        }
        catch (IOException e) {
            LOG.error("Exception while adding metadata record file {} with name {}, {}", input, name, e);
            throw new DataStoreException("Could not add root record", e);
        }
    }

    @Override
    public DataRecord getMetadataRecord(String name) {
        Validate.checkArgument((!StringUtils.isEmpty(name) ? 1 : 0) != 0, (String)"name should not be empty");
        File root = new File(this.getPath());
        for (File file : FileFilterUtils.filter(FileFilterUtils.nameFileFilter(name), root.listFiles())) {
            if (file.isDirectory()) continue;
            return new FileDataRecord(this, new DataIdentifier(file.getName()), file);
        }
        return null;
    }

    @Override
    public boolean metadataRecordExists(String name) {
        Validate.checkArgument((!StringUtils.isEmpty(name) ? 1 : 0) != 0, (String)"name should not be empty");
        File root = new File(this.getPath());
        for (File file : FileFilterUtils.filterList(FileFilterUtils.nameFileFilter(name), root.listFiles())) {
            if (file.isDirectory()) continue;
            if (!file.exists()) {
                LOG.debug("File does not exist {} ", new Object[]{file.getAbsolutePath()});
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public List<DataRecord> getAllMetadataRecords(String prefix) {
        Validate.checkArgument((null != prefix ? 1 : 0) != 0, (String)"prefix should not be null");
        File root = new File(this.getPath());
        ArrayList<DataRecord> rootRecords = new ArrayList<DataRecord>();
        for (File file : FileFilterUtils.filterList(FileFilterUtils.prefixFileFilter(prefix), root.listFiles())) {
            if (file.isDirectory()) continue;
            rootRecords.add(new FileDataRecord(this, new DataIdentifier(file.getName()), file));
        }
        return rootRecords;
    }

    @Override
    public boolean deleteMetadataRecord(String name) {
        Validate.checkArgument((!StringUtils.isEmpty(name) ? 1 : 0) != 0, (String)"name should not be empty");
        File root = new File(this.getPath());
        for (File file : FileFilterUtils.filterList(FileFilterUtils.nameFileFilter(name), root.listFiles())) {
            if (file.isDirectory()) continue;
            if (!file.delete()) {
                LOG.warn("Failed to delete root record {} ", new Object[]{file.getAbsolutePath()});
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public void deleteAllMetadataRecords(String prefix) {
        Validate.checkArgument((null != prefix ? 1 : 0) != 0, (String)"prefix should not be empty");
        File root = new File(this.getPath());
        for (File file : FileFilterUtils.filterList(FileFilterUtils.prefixFileFilter(prefix), root.listFiles())) {
            if (file.isDirectory() || file.delete()) continue;
            LOG.warn("Failed to delete root record {} ", new Object[]{file.getAbsolutePath()});
        }
    }

    @Override
    public Iterator<DataRecord> getAllRecords() {
        String path = FilenameUtils.normalizeNoEndSeparator(new File(this.getPath()).getAbsolutePath());
        OakFileDataStore store = this;
        return FileTreeTraverser.depthFirstPostOrder(new File(path)).filter(file -> file.isFile() && !file.getParent().equals(path)).map(file -> new FileDataRecord(store, new DataIdentifier(file.getName()), (File)file)).iterator();
    }

    @Override
    public DataRecord getRecordForId(DataIdentifier id) throws DataStoreException {
        return this.getRecord(id);
    }

    @Override
    public SharedDataStore.Type getType() {
        return SharedDataStore.Type.SHARED;
    }

    @Deprecated(since="2024-09-23")
    static class NoOpMap<K, V>
    extends AbstractMap<K, V> {
        NoOpMap() {
        }

        @Override
        public V put(K key, V value) {
            return null;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.emptySet();
        }
    }
}

