/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.jackrabbit.oak.composite.CompositeNodeStoreMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringCache {
    private static final int CACHE_SIZE = 1000;
    private static final Logger LOG = LoggerFactory.getLogger(StringCache.class);
    private final ConcurrentMap<String, String> cache = new ConcurrentHashMap<String, String>(1000);
    private CompositeNodeStoreMonitor monitor;

    public String get(String path) {
        if (this.cache.size() >= 1000 && !this.cache.containsKey(path)) {
            LOG.debug("Cache size too big. Revise your mount setup.");
            return path;
        }
        return this.cache.computeIfAbsent(path, k -> {
            if (this.monitor != null) {
                this.monitor.onAddStringCacheEntry();
            }
            return path;
        });
    }

    public StringCache withMonitor(CompositeNodeStoreMonitor monitor) {
        this.monitor = monitor;
        return this;
    }
}

