/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={MountInfoConfig.class})
@Designate(ocd=Props.class, factory=true)
public class MountInfoConfig {
    private List<String> paths;
    private String mountName;
    private List<String> pathsSupportingFragments;
    private boolean readOnly;

    public MountInfoConfig() {
    }

    MountInfoConfig(String mountName, List<String> paths, List<String> pathsSupportingFragments, boolean readOnly) {
        this.mountName = mountName;
        this.paths = MountInfoConfig.trimAll(paths);
        this.pathsSupportingFragments = MountInfoConfig.trimAll(pathsSupportingFragments);
        this.readOnly = readOnly;
    }

    @Activate
    void activate(BundleContext bundleContext, Props props) {
        this.paths = MountInfoConfig.trimAll(Arrays.asList(props.mountedPaths()));
        this.mountName = props.mountName().trim();
        this.pathsSupportingFragments = MountInfoConfig.trimAll(Arrays.asList(props.pathsSupportingFragments()));
        this.readOnly = props.readOnlyMount();
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public String getMountName() {
        return this.mountName;
    }

    public List<String> getPathsSupportingFragments() {
        return this.pathsSupportingFragments;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    private static List<String> trimAll(List<String> strings) {
        return strings.stream().map(String::trim).collect(Collectors.toList());
    }

    @ObjectClassDefinition(name="MountInfoConfig Properties")
    public static @interface Props {
        public static final String DEFAULT_MOUNT_NAME = "private";

        @AttributeDefinition(name="Mounted paths", description="Paths which are part of private mount")
        public String[] mountedPaths() default {};

        @AttributeDefinition(name="Mount name", description="Name of the mount")
        public String mountName() default "private";

        @AttributeDefinition(name="Readonly", description="If enabled then mount would be considered as readonly")
        public boolean readOnlyMount() default true;

        @AttributeDefinition(name="Paths supporting fragments", description="oak:mount-* under this paths will be included to mounts")
        public String[] pathsSupportingFragments() default {"/"};
    }
}

