/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.composite;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.composite.CompositeNodeState;
import org.apache.jackrabbit.oak.composite.CompositeNodeStoreMonitor;
import org.apache.jackrabbit.oak.composite.MountedNodeStore;
import org.apache.jackrabbit.oak.composite.NodeMap;
import org.apache.jackrabbit.oak.composite.StringCache;
import org.apache.jackrabbit.oak.spi.mount.Mount;
import org.apache.jackrabbit.oak.spi.mount.MountInfoProvider;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.PrefetchNodeStore;

class CompositionContext {
    private final MountInfoProvider mip;
    private final MountedNodeStore globalStore;
    private final PrefetchNodeStore prefetchNodeStore;
    private final List<MountedNodeStore> nonDefaultStores;
    private final Map<Mount, MountedNodeStore> nodeStoresByMount;
    private final Set<MountedNodeStore> allStores;
    private final StringCache pathCache;
    private final CompositeNodeStoreMonitor nodeStateMonitor;
    private final CompositeNodeStoreMonitor nodeBuilderMonitor;

    CompositionContext(MountInfoProvider mip, NodeStore globalStore, List<MountedNodeStore> nonDefaultStores, CompositeNodeStoreMonitor nodeStateMonitor, CompositeNodeStoreMonitor nodeBuilderMonitor) {
        this.pathCache = new StringCache().withMonitor(nodeStateMonitor);
        this.mip = mip;
        this.globalStore = new MountedNodeStore(mip.getDefaultMount(), globalStore);
        this.prefetchNodeStore = globalStore instanceof PrefetchNodeStore ? (PrefetchNodeStore)((Object)globalStore) : PrefetchNodeStore.NOOP;
        this.nonDefaultStores = nonDefaultStores;
        LinkedHashSet<MountedNodeStore> b = new LinkedHashSet<MountedNodeStore>();
        b.add(this.globalStore);
        b.addAll(this.nonDefaultStores);
        this.allStores = Collections.unmodifiableSet(b);
        this.nodeStoresByMount = this.allStores.stream().collect(Collectors.toMap(MountedNodeStore::getMount, Function.identity()));
        this.nodeStateMonitor = nodeStateMonitor;
        this.nodeBuilderMonitor = nodeBuilderMonitor;
    }

    MountedNodeStore getGlobalStore() {
        return this.globalStore;
    }

    List<MountedNodeStore> getNonDefaultStores() {
        return this.nonDefaultStores;
    }

    MountedNodeStore getOwningStore(String path) {
        Mount mount = this.mip.getMountByPath(path);
        if (this.nodeStoresByMount.containsKey(mount)) {
            return this.nodeStoresByMount.get(mount);
        }
        throw new IllegalArgumentException("Unable to find an owning store for path " + path);
    }

    List<MountedNodeStore> getContributingStoresForNodes(String path, NodeMap<NodeState> nodeStates) {
        return this.getContributingStores(path, mns -> ((NodeState)nodeStates.get((MountedNodeStore)mns)).getChildNodeNames());
    }

    List<MountedNodeStore> getContributingStoresForBuilders(String path, NodeMap<NodeBuilder> nodeBuilders) {
        return this.getContributingStores(path, mns -> ((NodeBuilder)nodeBuilders.get((MountedNodeStore)mns)).getChildNodeNames());
    }

    boolean shouldBeComposite(String path) {
        boolean supportMounts = false;
        if (this.mip.getNonDefaultMounts().stream().anyMatch(m -> m.isSupportFragmentUnder(path))) {
            supportMounts = true;
        } else if (!this.mip.getMountsPlacedUnder(path).isEmpty()) {
            supportMounts = true;
        }
        return supportMounts && this.mip.getMountByPath(path).isDefault();
    }

    private List<MountedNodeStore> getContributingStores(String path, Function<MountedNodeStore, Iterable<String>> childrenProvider) {
        MountedNodeStore nodeStore;
        Mount owningMount = this.mip.getMountByPath(path);
        if (!owningMount.isDefault() && this.nodeStoresByMount.containsKey(owningMount) && (nodeStore = this.nodeStoresByMount.get(owningMount)) != this.globalStore) {
            return Collections.singletonList(nodeStore);
        }
        ArrayList<MountedNodeStore> mountedStores = new ArrayList<MountedNodeStore>();
        mountedStores.add(this.globalStore);
        Collection<Mount> mounts = this.mip.getMountsPlacedDirectlyUnder(path);
        for (MountedNodeStore mountedNodeStore : this.nonDefaultStores) {
            Mount mount = mountedNodeStore.getMount();
            if (mounts.contains(mount)) {
                mountedStores.add(mountedNodeStore);
                continue;
            }
            if (!this.hasChildrenContainingPathFragmentName(mountedNodeStore, path, childrenProvider)) continue;
            mountedStores.add(mountedNodeStore);
        }
        return mountedStores;
    }

    private boolean hasChildrenContainingPathFragmentName(MountedNodeStore mns, String parentPath, Function<MountedNodeStore, Iterable<String>> childrenProvider) {
        Mount mount = mns.getMount();
        if (!mount.isSupportFragment(parentPath)) {
            return false;
        }
        return StreamSupport.stream(childrenProvider.apply(mns).spliterator(), false).anyMatch(i -> i.contains(mount.getPathFragmentName()));
    }

    Set<MountedNodeStore> getAllMountedNodeStores() {
        return this.allStores;
    }

    Blob createBlob(InputStream inputStream) throws IOException {
        return this.globalStore.getNodeStore().createBlob(inputStream);
    }

    boolean belongsToStore(MountedNodeStore mountedNodeStore, String parentPath, String childName) {
        return this.getOwningStore(PathUtils.concat(parentPath, childName)) == mountedNodeStore;
    }

    CompositeNodeState createRootNodeState(NodeState globalRootState) {
        HashMap<MountedNodeStore, NodeState> nodeStates = new HashMap<MountedNodeStore, NodeState>();
        nodeStates.put(this.getGlobalStore(), globalRootState);
        for (MountedNodeStore nodeStore : this.getNonDefaultStores()) {
            nodeStates.put(nodeStore, nodeStore.getNodeStore().getRoot());
        }
        return this.createRootNodeState(nodeStates);
    }

    CompositeNodeState createRootNodeState(Map<MountedNodeStore, NodeState> rootStates) {
        for (Map.Entry<MountedNodeStore, NodeState> e : rootStates.entrySet()) {
            MountedNodeStore mns = e.getKey();
            NodeState nodeState = e.getValue();
            if (nodeState instanceof CompositeNodeState) {
                throw new IllegalArgumentException("Nesting composite node states is not supported");
            }
            if (nodeState != null) continue;
            throw new NullPointerException("Passed null as a nodestate for " + mns.getMount().getName());
        }
        for (MountedNodeStore mns : this.nonDefaultStores) {
            if (rootStates.containsKey(mns)) continue;
            throw new IllegalArgumentException("Can't find node state for " + mns.getMount().getName());
        }
        if (!rootStates.containsKey(this.globalStore)) {
            throw new IllegalArgumentException("Can't find node state for the global store");
        }
        if (rootStates.size() != this.nonDefaultStores.size() + 1) {
            throw new IllegalArgumentException("Too many root states passed: " + rootStates.size());
        }
        return new CompositeNodeState("/", NodeMap.create(rootStates), this);
    }

    StringCache getPathCache() {
        return this.pathCache;
    }

    CompositeNodeStoreMonitor getNodeStateMonitor() {
        return this.nodeStateMonitor;
    }

    CompositeNodeStoreMonitor getNodeBuilderMonitor() {
        return this.nodeBuilderMonitor;
    }

    public void prefetch(Collection<String> paths, NodeState rootState) {
        if (rootState instanceof CompositeNodeState) {
            CompositeNodeState compositeRoot = (CompositeNodeState)rootState;
            rootState = compositeRoot.getNodeState(this.globalStore);
        }
        this.prefetchNodeStore.prefetch(paths, rootState);
    }
}

