/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.commons.io;

import java.io.File;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.collections4.FluentIterable;
import org.apache.jackrabbit.oak.commons.internal.graph.Traverser;
import org.jetbrains.annotations.NotNull;

public class FileTreeTraverser {
    @NotNull
    private static final Function<File, Iterable<? extends File>> FILE_SYSTEM_TREE = new FileSystemTree();

    public static Stream<File> depthFirstPostOrder(File startNode) {
        FluentIterable iterable = Traverser.postOrderTraversal((Object)startNode, FILE_SYSTEM_TREE);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static Stream<File> breadthFirst(File startNode) {
        FluentIterable iterable = Traverser.breadthFirstTraversal((Object)startNode, FILE_SYSTEM_TREE);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static Stream<File> depthFirstPreOrder(File startNode) {
        FluentIterable iterable = Traverser.preOrderTraversal((Object)startNode, FILE_SYSTEM_TREE);
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    private static class FileSystemTree
    implements Function<File, Iterable<? extends File>> {
        private FileSystemTree() {
        }

        @Override
        @NotNull
        public Iterable<? extends File> apply(File file) {
            if (!file.isDirectory()) {
                return Set.of();
            }
            File[] children = file.listFiles();
            if (children == null || children.length == 0) {
                return Set.of();
            }
            return Set.copyOf(Arrays.asList(children));
        }
    }
}

