/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.felix.hc.api.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultLog
implements Iterable<Entry> {
    private static final String HC_LOGGING_SYS_PROP = "org.apache.felix.hc.autoLogging";
    private static final String HC_LOGGING_PREFIX = "healthchecks.";
    private List<Entry> entries = new LinkedList<Entry>();
    private Result.Status aggregateStatus;
    private Logger hcLogger = null;

    public ResultLog() {
        this.aggregateStatus = Result.Status.WARN;
        this.setupLogger();
    }

    public ResultLog(ResultLog log) {
        this.aggregateStatus = log.aggregateStatus;
        this.entries = new ArrayList<Entry>(log.entries);
        this.setupLogger();
    }

    public ResultLog add(Entry entry) {
        if (this.entries.isEmpty()) {
            this.aggregateStatus = Result.Status.OK;
        }
        this.entries.add(entry);
        this.logEntry(entry);
        if (entry.getStatus().ordinal() > this.aggregateStatus.ordinal()) {
            this.aggregateStatus = entry.getStatus();
        }
        return this;
    }

    private void setupLogger() {
        if (Boolean.valueOf(System.getProperty(HC_LOGGING_SYS_PROP)).booleanValue()) {
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            for (int i = 2; i < stackTraceElements.length; ++i) {
                StackTraceElement stackTraceElement = stackTraceElements[i];
                String className = stackTraceElement.getClassName();
                if (className.startsWith(this.getClass().getPackage().getName())) continue;
                if (className.startsWith("org.apache.felix.hc.core.impl.executor")) break;
                this.hcLogger = LoggerFactory.getLogger(HC_LOGGING_PREFIX + className);
                break;
            }
        }
    }

    private void logEntry(Entry entry) {
        if (this.hcLogger != null) {
            if (entry.isDebug()) {
                if (this.hcLogger.isDebugEnabled()) {
                    this.hcLogger.debug(this.getAutoLogMessage(entry), entry.exception);
                }
            } else {
                switch (entry.getStatus()) {
                    case OK: 
                    case TEMPORARILY_UNAVAILABLE: {
                        if (!this.hcLogger.isInfoEnabled()) break;
                        this.hcLogger.info(this.getAutoLogMessage(entry), entry.exception);
                        break;
                    }
                    case WARN: {
                        this.hcLogger.warn(this.getAutoLogMessage(entry), entry.exception);
                        break;
                    }
                    case CRITICAL: 
                    case HEALTH_CHECK_ERROR: {
                        this.hcLogger.error(this.getAutoLogMessage(entry), entry.exception);
                    }
                }
            }
        }
    }

    private String getAutoLogMessage(Entry e) {
        return e.status.name() + " " + e.getMessage();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.entries.iterator();
    }

    public Result.Status getAggregateStatus() {
        return this.aggregateStatus;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ResultLog: ");
        sb.append(this.entries.toString());
        return sb.toString();
    }

    public static class Entry {
        private final Result.Status status;
        private final String message;
        private final boolean isDebug;
        private final Exception exception;

        public Entry(Result.Status s, String message) {
            this(s, message, false, null);
        }

        public Entry(String message, boolean isDebug) {
            this(Result.Status.OK, message, isDebug, null);
        }

        public Entry(String message, boolean isDebug, Exception exception) {
            this(Result.Status.OK, message, isDebug, exception);
        }

        public Entry(Result.Status s, String message, Exception exception) {
            this(s, message, false, exception);
        }

        private Entry(Result.Status s, String message, boolean isDebug, Exception exception) {
            this.status = s;
            this.message = message;
            this.exception = exception;
            this.isDebug = isDebug;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.getLogLevel()).append(" ").append(this.message);
            if (this.exception != null) {
                builder.append(" Exception: " + this.exception.getMessage());
            }
            return builder.toString();
        }

        public Result.Status getStatus() {
            return this.status;
        }

        public String getLogLevel() {
            switch (this.status) {
                case OK: {
                    return this.isDebug ? "DEBUG" : "INFO";
                }
            }
            return this.status.toString();
        }

        public String getMessage() {
            return this.message;
        }

        public Exception getException() {
            return this.exception;
        }

        public boolean isDebug() {
            return this.isDebug;
        }
    }
}

