/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.hc.api;

import java.text.NumberFormat;
import java.util.Locale;
import org.apache.felix.hc.api.Result;
import org.apache.felix.hc.api.ResultLog;
import org.osgi.annotation.versioning.ProviderType;
import org.slf4j.helpers.MessageFormatter;

@ProviderType
public class FormattingResultLog
extends ResultLog {
    public void debug(String message, Object ... args) {
        this.add(this.createEntry(true, message, args));
    }

    public void info(String message, Object ... args) {
        this.add(this.createEntry(false, message, args));
    }

    public void warn(String message, Object ... args) {
        this.add(this.createEntry(Result.Status.WARN, message, args));
    }

    public void critical(String message, Object ... args) {
        this.add(this.createEntry(Result.Status.CRITICAL, message, args));
    }

    public void temporarilyUnavailable(String message, Object ... args) {
        this.add(this.createEntry(Result.Status.TEMPORARILY_UNAVAILABLE, message, args));
    }

    public void healthCheckError(String message, Object ... args) {
        this.add(this.createEntry(Result.Status.HEALTH_CHECK_ERROR, message, args));
    }

    public static String msHumanReadable(long millis) {
        double number;
        double currentDivisor;
        String[] units = new String[]{"ms", "sec", "min", "h", "days"};
        double[] divisors = new double[]{1000.0, 60.0, 60.0, 24.0};
        int magnitude = 0;
        for (number = (double)millis; !(number < (currentDivisor = divisors[Math.min(magnitude, divisors.length - 1)])); number /= currentDivisor) {
            if (++magnitude < units.length - 1) continue;
        }
        NumberFormat format = NumberFormat.getNumberInstance(Locale.UK);
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(1);
        String result = format.format(number) + units[magnitude];
        return result;
    }

    public static String bytesHumanReadable(double size) {
        int i;
        double step;
        double current = step = 1024.0;
        String[] SIZES = new String[]{"kB", "MB", "GB", "TB"};
        for (i = 0; i < SIZES.length - 1 && !(size < current * step); ++i) {
            current *= step;
        }
        String unit = SIZES[i];
        double value = size / current;
        String retVal = String.format("%.1f", value) + unit;
        return retVal;
    }

    private ResultLog.Entry createEntry(Result.Status status, String message, Object ... args) {
        return new ResultLog.Entry(status, MessageFormatter.arrayFormat(message, args).getMessage());
    }

    private ResultLog.Entry createEntry(boolean isDebug, String message, Object ... args) {
        return new ResultLog.Entry(MessageFormatter.arrayFormat(message, args).getMessage(), isDebug);
    }
}

