/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ControllerThreadSocketFactory;
import org.apache.commons.httpclient.protocol.ReflectionSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;

@Deprecated
public class SSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final SSLProtocolSocketFactory factory = new SSLProtocolSocketFactory();
    private static final Boolean STRICT_WITH_SUBDOMAIN = Boolean.getBoolean(SSLProtocolSocketFactory.class.getName() + ".strictWithSubDomains");
    private static final String[] BAD_COUNTRY_2LDS = new String[]{"ac", "co", "com", "ed", "edu", "go", "gouv", "gov", "info", "lg", "ne", "net", "or", "org"};
    private static final Pattern IPV4_PATTERN = Pattern.compile("^(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)(\\.(25[0-5]|2[0-4]\\d|[0-1]?\\d?\\d)){3}$");
    private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}$");
    private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)::((?:[0-9A-Fa-f]{1,4}(?::[0-9A-Fa-f]{1,4})*)?)$");

    static SSLProtocolSocketFactory getSocketFactory() {
        return factory;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        Socket sslSocket = SSLSocketFactory.getDefault().createSocket(host, port, clientHost, clientPort);
        SSLProtocolSocketFactory.verifyHostName(host, (SSLSocket)sslSocket);
        return sslSocket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        if (timeout == 0) {
            Socket sslSocket = this.createSocket(host, port, localAddress, localPort);
            SSLProtocolSocketFactory.verifyHostName(host, (SSLSocket)sslSocket);
            return sslSocket;
        }
        Socket sslSocket = ReflectionSocketFactory.createSocket("javax.net.ssl.SSLSocketFactory", host, port, localAddress, localPort, timeout);
        if (sslSocket == null) {
            sslSocket = ControllerThreadSocketFactory.createSocket(this, host, port, localAddress, localPort, timeout);
        }
        SSLProtocolSocketFactory.verifyHostName(host, (SSLSocket)sslSocket);
        return sslSocket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket sslSocket = SSLSocketFactory.getDefault().createSocket(host, port);
        SSLProtocolSocketFactory.verifyHostName(host, (SSLSocket)sslSocket);
        return sslSocket;
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        Socket sslSocket = ((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(socket, host, port, autoClose);
        SSLProtocolSocketFactory.verifyHostName(host, (SSLSocket)sslSocket);
        return sslSocket;
    }

    private static void verifyHostName(String host, SSLSocket ssl) throws IOException {
        if (host == null) {
            throw new IllegalArgumentException("host to verify was null");
        }
        SSLSession session = ssl.getSession();
        if (session == null) {
            InputStream in = ssl.getInputStream();
            in.available();
            session = ssl.getSession();
            if (session == null) {
                ssl.startHandshake();
                session = ssl.getSession();
            }
        }
        Certificate[] certs = session.getPeerCertificates();
        SSLProtocolSocketFactory.verifyHostName(host.trim().toLowerCase(Locale.US), (X509Certificate)certs[0]);
    }

    private static void verifyHostName(String host, X509Certificate cert) throws SSLException {
        String[] cns = SSLProtocolSocketFactory.getCNs(cert);
        String[] subjectAlts = SSLProtocolSocketFactory.getDNSSubjectAlts(cert);
        SSLProtocolSocketFactory.verifyHostName(host, cns, subjectAlts);
    }

    private static void verifyHostName(String host, String[] cns, String[] subjectAlts) throws SSLException {
        LinkedList<String> names = new LinkedList<String>();
        if (cns != null && cns.length > 0 && cns[0] != null) {
            names.add(cns[0]);
        }
        if (subjectAlts != null) {
            for (String subjectAlt : subjectAlts) {
                if (subjectAlt == null) continue;
                names.add(subjectAlt);
            }
        }
        if (names.isEmpty()) {
            String msg = "Certificate for <" + host + "> doesn't contain CN or DNS subjectAlt";
            throw new SSLException(msg);
        }
        StringBuilder buf = new StringBuilder();
        String hostName = SSLProtocolSocketFactory.normaliseIPv6Address(host.trim().toLowerCase(Locale.ENGLISH));
        boolean match = false;
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String[] parts;
            boolean doWildcard;
            String cn = (String)it.next();
            cn = cn.toLowerCase(Locale.ENGLISH);
            buf.append(" <");
            buf.append(cn);
            buf.append('>');
            if (it.hasNext()) {
                buf.append(" OR");
            }
            boolean bl = doWildcard = (parts = cn.split("\\.")).length >= 3 && parts[0].endsWith("*") && SSLProtocolSocketFactory.validCountryWildcard(cn) && !SSLProtocolSocketFactory.isIPAddress(host);
            if (doWildcard) {
                String firstpart = parts[0];
                if (firstpart.length() > 1) {
                    String prefix = firstpart.substring(0, firstpart.length() - 1);
                    String suffix = cn.substring(firstpart.length());
                    String hostSuffix = hostName.substring(prefix.length());
                    match = hostName.startsWith(prefix) && hostSuffix.endsWith(suffix);
                } else {
                    match = hostName.endsWith(cn.substring(1));
                }
                if (match && STRICT_WITH_SUBDOMAIN.booleanValue()) {
                    match = SSLProtocolSocketFactory.countDots(hostName) == SSLProtocolSocketFactory.countDots(cn);
                }
            } else {
                match = hostName.equals(SSLProtocolSocketFactory.normaliseIPv6Address(cn));
            }
            if (!match) continue;
            break;
        }
        if (!match) {
            throw new SSLException("hostname in certificate didn't match: <" + host + "> !=" + buf);
        }
    }

    private static String[] getDNSSubjectAlts(X509Certificate cert) {
        LinkedList<String> subjectAltList = new LinkedList<String>();
        Collection<List<?>> c = null;
        try {
            c = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException cpe) {
            cpe.printStackTrace();
        }
        if (c != null) {
            for (List<?> list : c) {
                int type = (Integer)list.get(0);
                if (type != 2) continue;
                String s = (String)list.get(1);
                subjectAltList.add(s);
            }
        }
        if (!subjectAltList.isEmpty()) {
            String[] subjectAlts = new String[subjectAltList.size()];
            subjectAltList.toArray(subjectAlts);
            return subjectAlts;
        }
        return new String[0];
    }

    private static boolean verifyHostName(String host, String cn) {
        if (SSLProtocolSocketFactory.doWildCard(cn) && !SSLProtocolSocketFactory.isIPAddress(host)) {
            return SSLProtocolSocketFactory.matchesWildCard(cn, host);
        }
        return host.equalsIgnoreCase(cn);
    }

    private static String normaliseIPv6Address(String hostname) {
        if (hostname == null || !InetAddressUtils.isIPv6Address(hostname)) {
            return hostname;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(hostname);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException uhe) {
            return hostname;
        }
    }

    private static boolean doWildCard(String cn) {
        String[] parts = cn.split("\\.");
        return parts.length >= 3 && parts[0].endsWith("*") && SSLProtocolSocketFactory.acceptableCountryWildcard(cn) && !SSLProtocolSocketFactory.isIPAddress(cn);
    }

    private static boolean isIPAddress(String hostname) {
        return hostname != null && (IPV4_PATTERN.matcher(hostname).matches() || IPV6_STD_PATTERN.matcher(hostname).matches() || IPV6_HEX_COMPRESSED_PATTERN.matcher(hostname).matches());
    }

    private static boolean acceptableCountryWildcard(String cn) {
        String[] parts = cn.split("\\.");
        if (parts.length > 3 || parts[parts.length - 1].length() != 2) {
            return true;
        }
        String countryCode = parts[parts.length - 2];
        return Arrays.binarySearch(BAD_COUNTRY_2LDS, countryCode) < 0;
    }

    private static boolean matchesWildCard(String cn, String hostName) {
        String[] parts = cn.split("\\.");
        boolean match = false;
        String firstpart = parts[0];
        if (firstpart.length() > 1) {
            String prefix = firstpart.substring(0, firstpart.length() - 1);
            String suffix = cn.substring(firstpart.length());
            String hostSuffix = hostName.substring(prefix.length());
            match = hostName.startsWith(prefix) && hostSuffix.endsWith(suffix);
        } else {
            match = hostName.endsWith(cn.substring(1));
        }
        if (match) {
            match = SSLProtocolSocketFactory.countDots(hostName) == SSLProtocolSocketFactory.countDots(cn);
        }
        return match;
    }

    private static int countDots(String data) {
        int dots = 0;
        for (int i = 0; i < data.length(); ++i) {
            if (data.charAt(i) != '.') continue;
            ++dots;
        }
        return dots;
    }

    private static String[] getCNs(X509Certificate cert) throws SSLException {
        String subjectPrincipal = cert.getSubjectX500Principal().toString();
        return SSLProtocolSocketFactory.extractCNs(subjectPrincipal);
    }

    static String[] extractCNs(String subjectPrincipal) throws SSLException {
        if (subjectPrincipal == null) {
            return null;
        }
        ArrayList<String> cns = new ArrayList<String>();
        try {
            LdapName subjectDN = new LdapName(subjectPrincipal);
            List<Rdn> rdns = subjectDN.getRdns();
            for (int i = rdns.size() - 1; i >= 0; --i) {
                Rdn rds = rdns.get(i);
                Attributes attributes = rds.toAttributes();
                Attribute cn = attributes.get("cn");
                if (cn == null) continue;
                try {
                    Object value = cn.get();
                    if (value == null) continue;
                    cns.add(value.toString());
                    continue;
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
        catch (InvalidNameException e) {
            throw new SSLException(subjectPrincipal + " is not a valid X500 distinguished name");
        }
        return cns.isEmpty() ? null : cns.toArray(new String[cns.size()]);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    private static boolean validCountryWildcard(String cn) {
        String[] parts = cn.split("\\.");
        if (parts.length != 3 || parts[2].length() != 2) {
            return true;
        }
        return Arrays.binarySearch(BAD_COUNTRY_2LDS, parts[1]) < 0;
    }

    static class InetAddressUtils {
        private static final String IPV4_BASIC_PATTERN_STRING = "(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])";
        private static final Pattern IPV4_PATTERN = Pattern.compile("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
        private static final Pattern IPV4_MAPPED_IPV6_PATTERN = Pattern.compile("^::[fF]{4}:(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
        private static final Pattern IPV6_STD_PATTERN = Pattern.compile("^[0-9a-fA-F]{1,4}(:[0-9a-fA-F]{1,4}){7}$");
        private static final Pattern IPV6_HEX_COMPRESSED_PATTERN = Pattern.compile("^(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)::(([0-9A-Fa-f]{1,4}(:[0-9A-Fa-f]{1,4}){0,5})?)$");
        private static final char COLON_CHAR = ':';
        private static final int MAX_COLON_COUNT = 7;

        private InetAddressUtils() {
        }

        public static boolean isIPv4Address(String input) {
            return IPV4_PATTERN.matcher(input).matches();
        }

        public static boolean isIPv4MappedIPv64Address(String input) {
            return IPV4_MAPPED_IPV6_PATTERN.matcher(input).matches();
        }

        public static boolean isIPv6StdAddress(String input) {
            return IPV6_STD_PATTERN.matcher(input).matches();
        }

        public static boolean isIPv6HexCompressedAddress(String input) {
            int colonCount = 0;
            for (int i = 0; i < input.length(); ++i) {
                if (input.charAt(i) != ':') continue;
                ++colonCount;
            }
            return colonCount <= 7 && IPV6_HEX_COMPRESSED_PATTERN.matcher(input).matches();
        }

        public static boolean isIPv6Address(String input) {
            return InetAddressUtils.isIPv6StdAddress(input) || InetAddressUtils.isIPv6HexCompressedAddress(input);
        }
    }
}

