/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.photoshop.PsdHeaderDirectory;

@Deprecated(since="2024-11-20")
public class PsdHeaderDescriptor
extends TagDescriptor<PsdHeaderDirectory> {
    public PsdHeaderDescriptor(@NotNull PsdHeaderDirectory directory) {
        super(directory);
    }

    @Override
    public String getDescription(int tagType) {
        switch (tagType) {
            case 1: {
                return this.getChannelCountDescription();
            }
            case 4: {
                return this.getBitsPerChannelDescription();
            }
            case 5: {
                return this.getColorModeDescription();
            }
            case 2: {
                return this.getImageHeightDescription();
            }
            case 3: {
                return this.getImageWidthDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getChannelCountDescription() {
        Integer value = ((PsdHeaderDirectory)this._directory).getInteger(1);
        if (value == null) {
            return null;
        }
        return value + " channel" + (value == 1 ? "" : "s");
    }

    @Nullable
    public String getBitsPerChannelDescription() {
        Integer value = ((PsdHeaderDirectory)this._directory).getInteger(4);
        if (value == null) {
            return null;
        }
        return value + " bit" + (value == 1 ? "" : "s") + " per channel";
    }

    @Nullable
    public String getColorModeDescription() {
        return this.getIndexedDescription(5, "Bitmap", "Grayscale", "Indexed", "RGB", "CMYK", null, null, "Multichannel", "Duotone", "Lab");
    }

    @Nullable
    public String getImageHeightDescription() {
        Integer value = ((PsdHeaderDirectory)this._directory).getInteger(2);
        if (value == null) {
            return null;
        }
        return value + " pixel" + (value == 1 ? "" : "s");
    }

    @Nullable
    public String getImageWidthDescription() {
        try {
            Integer value = ((PsdHeaderDirectory)this._directory).getInteger(3);
            if (value == null) {
                return null;
            }
            return value + " pixel" + (value == 1 ? "" : "s");
        }
        catch (Exception e) {
            return null;
        }
    }
}

