/*
 * Decompiled with CFR 0.152.
 */
package com.drew.lang;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.StringValue;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

@Deprecated(since="2024-11-20")
public abstract class RandomAccessReader {
    private boolean _isMotorolaByteOrder = true;

    public abstract int toUnshiftedOffset(int var1);

    public abstract byte getByte(int var1) throws IOException;

    @NotNull
    public abstract byte[] getBytes(int var1, int var2) throws IOException;

    protected abstract void validateIndex(int var1, int var2) throws IOException;

    protected abstract boolean isValidIndex(int var1, int var2) throws IOException;

    public abstract long getLength() throws IOException;

    public void setMotorolaByteOrder(boolean motorolaByteOrder) {
        this._isMotorolaByteOrder = motorolaByteOrder;
    }

    public boolean isMotorolaByteOrder() {
        return this._isMotorolaByteOrder;
    }

    public boolean getBit(int index) throws IOException {
        int byteIndex = index / 8;
        int bitIndex = index % 8;
        this.validateIndex(byteIndex, 1);
        byte b = this.getByte(byteIndex);
        return (b >> bitIndex & 1) == 1;
    }

    public short getUInt8(int index) throws IOException {
        this.validateIndex(index, 1);
        return (short)(this.getByte(index) & 0xFF);
    }

    public byte getInt8(int index) throws IOException {
        this.validateIndex(index, 1);
        return this.getByte(index);
    }

    public int getUInt16(int index) throws IOException {
        this.validateIndex(index, 2);
        if (this._isMotorolaByteOrder) {
            return this.getByte(index) << 8 & 0xFF00 | this.getByte(index + 1) & 0xFF;
        }
        return this.getByte(index + 1) << 8 & 0xFF00 | this.getByte(index) & 0xFF;
    }

    public short getInt16(int index) throws IOException {
        this.validateIndex(index, 2);
        if (this._isMotorolaByteOrder) {
            return (short)((short)this.getByte(index) << 8 & 0xFFFFFF00 | (short)this.getByte(index + 1) & 0xFF);
        }
        return (short)((short)this.getByte(index + 1) << 8 & 0xFFFFFF00 | (short)this.getByte(index) & 0xFF);
    }

    public int getInt24(int index) throws IOException {
        this.validateIndex(index, 3);
        if (this._isMotorolaByteOrder) {
            return this.getByte(index) << 16 & 0xFF0000 | this.getByte(index + 1) << 8 & 0xFF00 | this.getByte(index + 2) & 0xFF;
        }
        return this.getByte(index + 2) << 16 & 0xFF0000 | this.getByte(index + 1) << 8 & 0xFF00 | this.getByte(index) & 0xFF;
    }

    public long getUInt32(int index) throws IOException {
        this.validateIndex(index, 4);
        if (this._isMotorolaByteOrder) {
            return (long)this.getByte(index) << 24 & 0xFF000000L | (long)this.getByte(index + 1) << 16 & 0xFF0000L | (long)this.getByte(index + 2) << 8 & 0xFF00L | (long)this.getByte(index + 3) & 0xFFL;
        }
        return (long)this.getByte(index + 3) << 24 & 0xFF000000L | (long)this.getByte(index + 2) << 16 & 0xFF0000L | (long)this.getByte(index + 1) << 8 & 0xFF00L | (long)this.getByte(index) & 0xFFL;
    }

    public int getInt32(int index) throws IOException {
        this.validateIndex(index, 4);
        if (this._isMotorolaByteOrder) {
            return this.getByte(index) << 24 & 0xFF000000 | this.getByte(index + 1) << 16 & 0xFF0000 | this.getByte(index + 2) << 8 & 0xFF00 | this.getByte(index + 3) & 0xFF;
        }
        return this.getByte(index + 3) << 24 & 0xFF000000 | this.getByte(index + 2) << 16 & 0xFF0000 | this.getByte(index + 1) << 8 & 0xFF00 | this.getByte(index) & 0xFF;
    }

    public long getInt64(int index) throws IOException {
        this.validateIndex(index, 8);
        if (this._isMotorolaByteOrder) {
            return (long)this.getByte(index) << 56 & 0xFF00000000000000L | (long)this.getByte(index + 1) << 48 & 0xFF000000000000L | (long)this.getByte(index + 2) << 40 & 0xFF0000000000L | (long)this.getByte(index + 3) << 32 & 0xFF00000000L | (long)this.getByte(index + 4) << 24 & 0xFF000000L | (long)this.getByte(index + 5) << 16 & 0xFF0000L | (long)this.getByte(index + 6) << 8 & 0xFF00L | (long)this.getByte(index + 7) & 0xFFL;
        }
        return (long)this.getByte(index + 7) << 56 & 0xFF00000000000000L | (long)this.getByte(index + 6) << 48 & 0xFF000000000000L | (long)this.getByte(index + 5) << 40 & 0xFF0000000000L | (long)this.getByte(index + 4) << 32 & 0xFF00000000L | (long)this.getByte(index + 3) << 24 & 0xFF000000L | (long)this.getByte(index + 2) << 16 & 0xFF0000L | (long)this.getByte(index + 1) << 8 & 0xFF00L | (long)this.getByte(index) & 0xFFL;
    }

    public float getS15Fixed16(int index) throws IOException {
        this.validateIndex(index, 4);
        if (this._isMotorolaByteOrder) {
            float res = (this.getByte(index) & 0xFF) << 8 | this.getByte(index + 1) & 0xFF;
            int d = (this.getByte(index + 2) & 0xFF) << 8 | this.getByte(index + 3) & 0xFF;
            return (float)((double)res + (double)d / 65536.0);
        }
        float res = (this.getByte(index + 3) & 0xFF) << 8 | this.getByte(index + 2) & 0xFF;
        int d = (this.getByte(index + 1) & 0xFF) << 8 | this.getByte(index) & 0xFF;
        return (float)((double)res + (double)d / 65536.0);
    }

    public float getFloat32(int index) throws IOException {
        return Float.intBitsToFloat(this.getInt32(index));
    }

    public double getDouble64(int index) throws IOException {
        return Double.longBitsToDouble(this.getInt64(index));
    }

    @NotNull
    public StringValue getStringValue(int index, int bytesRequested, @Nullable Charset charset) throws IOException {
        return new StringValue(this.getBytes(index, bytesRequested), charset);
    }

    @NotNull
    public String getString(int index, int bytesRequested, @NotNull Charset charset) throws IOException {
        return new String(this.getBytes(index, bytesRequested), charset.name());
    }

    @NotNull
    public String getString(int index, int bytesRequested, @NotNull String charset) throws IOException {
        byte[] bytes = this.getBytes(index, bytesRequested);
        try {
            return new String(bytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }

    @NotNull
    public String getNullTerminatedString(int index, int maxLengthBytes, @NotNull Charset charset) throws IOException {
        return new String(this.getNullTerminatedBytes(index, maxLengthBytes), charset.name());
    }

    @NotNull
    public StringValue getNullTerminatedStringValue(int index, int maxLengthBytes, @Nullable Charset charset) throws IOException {
        byte[] bytes = this.getNullTerminatedBytes(index, maxLengthBytes);
        return new StringValue(bytes, charset);
    }

    @NotNull
    public byte[] getNullTerminatedBytes(int index, int maxLengthBytes) throws IOException {
        int length;
        byte[] buffer = this.getBytes(index, maxLengthBytes);
        for (length = 0; length < buffer.length && buffer[length] != 0; ++length) {
        }
        if (length == maxLengthBytes) {
            return buffer;
        }
        byte[] bytes = new byte[length];
        if (length > 0) {
            System.arraycopy(buffer, 0, bytes, 0, length);
        }
        return bytes;
    }
}

