/*
 * Decompiled with CFR 0.152.
 */
package com.day.image;

import com.day.image.ColorCurve;
import com.day.image.DistortOp;
import com.day.image.DitherOp;
import com.day.image.EmbossOp;
import com.day.image.ImageSupport;
import com.day.image.LineStyle;
import com.day.image.MultitoneOp;
import com.day.image.ResizeOp;
import com.day.image.font.AbstractFont;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.IndexColorModel;
import java.awt.image.Kernel;
import java.awt.image.RescaleOp;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.imageio.IIOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Layer {
    private static final Logger log = LoggerFactory.getLogger(Layer.class);
    public static final LuminanceSystem GAMMA22;
    public static final LuminanceSystem LINEAR;
    public static final LuminanceSystem REC709;
    public static final String DEFAULT_MIME_TYPE = "image/gif";
    public static final int RED_CHANNEL_ID = 0;
    public static final int GREEN_CHANNEL_ID = 1;
    public static final int BLUE_CHANNEL_ID = 2;
    public static final int ALPHA_CHANNEL_ID = 3;
    private static final int DEFAULT_IMAGE_ORIGINX = 0;
    private static final int DEFAULT_IMAGE_ORIGINY = 0;
    private static final int DEFAULT_IMAGE_WIDTH = 1;
    private static final int DEFAULT_IMAGE_HEIGHT = 1;
    protected static final Color TRANSPARENT_IMAGE_BACKGROUND;
    private static final float DEFAULT_IMAGE_OPACITY = 1.0f;
    private static final Composite DEFAULT_LAYER_COMPOSITE;
    static final int IMAGE_TYPE = 2;
    private static final AffineTransform IDENTITY_XFORM;
    private static Map RENDERING_HINTS;
    private static final int MAX_SUBSAMPLING_SIZE = 1280;
    private boolean baseImgIsRGBA;
    private BufferedImage baseImg;
    private Graphics2D g2;
    private int x;
    private int y;
    private int width;
    private int height;
    private Paint backGround;
    private Color bgColor;
    private float opacity;
    private Color transparency;
    private String mimeType;
    private LuminanceSystem lumSys = GAMMA22;
    private Composite layerComposite;
    private int imageIndex;
    private int numImages;
    private static final int RGBA_BLUR_KERNEL_MAX = 256;
    private static final int RGBA_BLUR_KERNEL_HALF = 128;

    public Layer(int width, int height, Paint bground) {
        this.init(width, height, bground);
    }

    public Layer(InputStream input) throws IOException, IIOException {
        this(input, 0, null);
    }

    public Layer(InputStream input, Dimension max) throws IOException, IIOException {
        this(input, 0, max);
    }

    public Layer(InputStream input, int idx) throws IOException, IIOException {
        this(input, idx, null);
    }

    public Layer(InputStream input, int idx, Dimension max) throws IOException, IIOException {
        this(input, idx, max, null);
    }

    public Layer(InputStream input, int idx, Dimension max, ImageReadParam params) throws IOException, IIOException {
        ImageInputStream ios = null;
        ImageReader reader = null;
        boolean inputWrapped = false;
        try {
            if (!input.markSupported()) {
                input = new BufferedInputStream(input, 0x100000){

                    public void close() {
                        if (this.in == null) {
                            return;
                        }
                        this.in = null;
                        this.buf = null;
                    }
                };
                inputWrapped = true;
            }
            input.mark(0x100000);
            ios = ImageIO.createImageInputStream(input);
            Iterator<ImageReader> readers = ImageIO.getImageReaders(ios);
            while (readers.hasNext()) {
                reader = readers.next();
                reader.setInput(ios, true);
                if (params == null) {
                    params = reader.getDefaultReadParam();
                }
                IOException imageReadFailure = null;
                if (max != null) {
                    max = new Dimension(max);
                    ios.mark();
                    int samplefactor = 0;
                    try {
                        samplefactor = Layer.calculateSampleFactor(max, reader.getWidth(idx), reader.getHeight(idx));
                    }
                    catch (IOException e) {
                        imageReadFailure = e;
                    }
                    try {
                        ios.reset();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (samplefactor > 1) {
                        params.setSourceSubsampling(samplefactor, samplefactor, 0, 0);
                    }
                }
                BufferedImage fromInput = null;
                if (imageReadFailure == null) {
                    try {
                        ios.mark();
                        fromInput = reader.read(idx, params);
                    }
                    catch (IOException e) {
                        log.warn("Reading image with {} failed: {}. trying next reader.", (Object)reader, (Object)e.toString());
                        imageReadFailure = e;
                    }
                    catch (IllegalArgumentException e) {
                        log.warn("Reading image with {} failed: {}. trying next reader.", (Object)reader, (Object)e.toString());
                        imageReadFailure = new IOException("Error reading image");
                        imageReadFailure.initCause(e);
                    }
                }
                if (imageReadFailure != null) {
                    if (readers.hasNext()) {
                        reader.dispose();
                        ios.reset();
                        continue;
                    }
                    try {
                        ios.reset();
                        input.reset();
                        fromInput = Imaging.getBufferedImage(input);
                        log.info("Reading image with apache-imaging was successful.");
                    }
                    catch (ImageReadException e) {
                        log.warn("reading image with commons-imaging failed: {}", (Object)e.toString());
                        throw imageReadFailure;
                    }
                }
                if (fromInput == null) {
                    throw new IllegalStateException("Unexpected missing image");
                }
                this.imageIndex = idx;
                ColorModel cm = fromInput.getColorModel();
                if (cm instanceof IndexColorModel) {
                    IndexColorModel icm = (IndexColorModel)cm;
                    if (max != null) {
                        this.init(max.width, max.height, TRANSPARENT_IMAGE_BACKGROUND);
                        BufferedImage bm = icm.convertToIntDiscrete(fromInput.getRaster(), true);
                        ResizeOp.doFilter_progressive(bm, this.baseImg);
                        bm.flush();
                    } else {
                        this.init(1, 1, TRANSPARENT_IMAGE_BACKGROUND);
                        this.setImage(icm.convertToIntDiscrete(fromInput.getRaster(), true));
                    }
                } else if (max != null) {
                    this.init(max.width, max.height, TRANSPARENT_IMAGE_BACKGROUND);
                    ResizeOp.doFilter_progressive(fromInput, this.baseImg);
                } else {
                    this.init(1, 1, TRANSPARENT_IMAGE_BACKGROUND);
                    this.setImage(fromInput);
                    fromInput = null;
                }
                this.mimeType = reader.getOriginatingProvider().getMIMETypes()[0];
                if (this.mimeType.toLowerCase().endsWith("gif")) {
                    ImageSupport.getGIFMetaData(this, reader);
                }
                if (fromInput != null) {
                    fromInput.flush();
                }
                this.numImages = this.imageIndex + 1;
                while (true) {
                    try {
                        reader.read(this.numImages).flush();
                    }
                    catch (IndexOutOfBoundsException ioo) {
                        break;
                    }
                    catch (Throwable t) {
                        break;
                    }
                    ++this.numImages;
                }
                return;
            }
            try {
                throw new IIOException("No decoder available to load the image");
            }
            catch (OutOfMemoryError oome) {
                throw new IIOException("Not enough memory to load the image");
            }
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
            try {
                if (ios != null) {
                    ios.close();
                }
            }
            catch (IOException iOException) {}
            if (inputWrapped) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected static int calculateSampleFactor(Dimension max, int w, int h) {
        int tw = w;
        int th = h;
        if (max.width > 0 && max.width < tw) {
            th = h * max.width / w;
            tw = max.width;
        }
        if (max.height > 0 && max.height < th) {
            tw = w * max.height / h;
            th = max.height;
        }
        if (tw != 0) {
            max.width = tw;
        }
        if (th != 0) {
            max.height = th;
        }
        if (tw == 0 || th == 0) {
            return 0;
        }
        if (tw > th && tw < 1280) {
            tw = 1280;
        }
        if (th > tw && th < 1280) {
            th = 1280;
        }
        return Math.min(w / tw, h / th);
    }

    public Layer(Layer src) {
        this.init(src.width, src.height, src.backGround);
        this.x = src.x;
        this.y = src.y;
        this.opacity = src.opacity;
        this.transparency = src.transparency;
        this.mimeType = src.mimeType;
        this.layerComposite = src.layerComposite;
        this.imageIndex = src.imageIndex;
        this.numImages = src.numImages;
        this.g2.drawRenderedImage(src.getImage(), IDENTITY_XFORM);
    }

    public Layer(BufferedImage image) {
        if (image == null) {
            throw new NullPointerException("image");
        }
        this.setImage(image, false);
        this.x = 0;
        this.y = 0;
        this.bgColor = TRANSPARENT_IMAGE_BACKGROUND;
        this.backGround = this.bgColor;
        this.opacity = 1.0f;
        this.transparency = null;
        this.mimeType = DEFAULT_MIME_TYPE;
        this.layerComposite = DEFAULT_LAYER_COMPOSITE;
    }

    /*
     * Loose catch block
     */
    public boolean write(String mimeType, double quality, OutputStream outStream) throws IIOException, IOException {
        block39: {
            if (mimeType == null || mimeType.length() == 0) {
                mimeType = this.mimeType;
            }
            if (mimeType == null || mimeType.length() == 0) {
                mimeType = DEFAULT_MIME_TYPE;
            }
            String format = mimeType.substring(mimeType.indexOf(47) + 1);
            ImageWriter writer = null;
            ImageOutputStream ios = null;
            try {
                writer = ImageSupport.getImageWriter(format);
                if (writer != null) {
                    BufferedImage writableImage;
                    ios = ImageIO.createImageOutputStream(outStream);
                    writer.setOutput(ios);
                    IIOMetadata streamMetadata222222 = null;
                    IIOMetadata imageMetadata = null;
                    JPEGImageWriteParam iwp = null;
                    int targetImageType = this.getImage().getType();
                    if ("gif".equalsIgnoreCase(format)) {
                        IIOMetadata[] gifMeta = ImageSupport.createGIFMetadata(this, writer, (int)quality);
                        targetImageType = this.getImage().getType();
                        if (gifMeta[0] != null) {
                            streamMetadata222222 = gifMeta[0];
                        }
                        if (gifMeta[1] != null) {
                            imageMetadata = gifMeta[1];
                        }
                    } else if ("jpg".equalsIgnoreCase(format) || "jpeg".equalsIgnoreCase(format)) {
                        if (quality < 0.0 || quality > 1.0) {
                            quality = 0.82;
                        }
                        iwp = new JPEGImageWriteParam(null);
                        iwp.setCompressionMode(2);
                        iwp.setCompressionQuality((float)quality);
                        targetImageType = 1;
                    } else if (this.transparency != null) {
                        long trans = this.transparency.getRGB();
                        this.replaceColor(trans, trans & 0xFFFFFFL, false);
                    }
                    ImageTypeSpecifier its = ImageTypeSpecifier.createFromRenderedImage(this.getImage());
                    if (!writer.getOriginatingProvider().canEncodeImage(its)) {
                        for (int bit = 1; bit <= 13; ++bit) {
                            its = ImageTypeSpecifier.createFromBufferedImageType(bit);
                            if (!writer.getOriginatingProvider().canEncodeImage(its)) continue;
                            targetImageType = bit;
                            break;
                        }
                    }
                    if (targetImageType != this.getImage().getType()) {
                        boolean sourceHasAlpha = this.getImage().getColorModel().hasAlpha();
                        boolean targetSupportsAlpha = ImageTypeSpecifier.createFromBufferedImageType(targetImageType).getColorModel().hasAlpha();
                        writableImage = new BufferedImage(this.width, this.height, targetImageType);
                        Graphics2D g2d = writableImage.createGraphics();
                        if (sourceHasAlpha && !targetSupportsAlpha) {
                            g2d.drawImage(this.getImage(), 0, 0, this.getBackgroundColor(), null);
                        } else {
                            g2d.drawRenderedImage(this.getImage(), IDENTITY_XFORM);
                        }
                    } else {
                        writableImage = this.getImage();
                    }
                    if (writer.getOriginatingProvider().canEncodeImage(writableImage)) {
                        IIOImage image = new IIOImage(writableImage, null, imageMetadata);
                        writer.write(streamMetadata222222, image, iwp);
                    }
                    break block39;
                }
                boolean streamMetadata222222 = false;
                return streamMetadata222222;
            }
            catch (IllegalArgumentException iae) {
                boolean bl = false;
                return bl;
            }
            catch (IOException ioe) {
                boolean bl = false;
                return bl;
            }
            catch (OutOfMemoryError oome) {
                throw new IIOException("Not enough memory to store the image");
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (writer != null) {
                    writer.dispose();
                }
                if (ios != null) {
                    try {
                        ios.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return true;
    }

    public void dispose() {
        if (this.g2 != null) {
            this.g2.dispose();
            this.g2 = null;
        }
        if (this.baseImg != null) {
            this.baseImg.flush();
            this.baseImg = null;
        }
        this.backGround = null;
        this.bgColor = null;
        this.lumSys = null;
        this.mimeType = null;
        this.transparency = null;
    }

    public void merge(Layer layer) {
        if (layer != null) {
            this.merge(new Layer[]{layer});
        }
    }

    public void merge(Layer[] layers) {
        if (layers == null || layers.length == 0) {
            return;
        }
        int newX = this.x;
        int newY = this.y;
        int newR = this.x + this.width;
        int newB = this.y + this.height;
        for (int i = 0; i < layers.length; ++i) {
            Layer l = layers[i];
            int r = l.x + l.width;
            int b = l.y + l.height;
            if (newX > l.x) {
                newX = l.x;
            }
            if (newY > l.y) {
                newY = l.y;
            }
            if (newR < r) {
                newR = r;
            }
            if (newB >= b) continue;
            newB = b;
        }
        int newW = newR - newX;
        int newH = newB - newY;
        if (newX != this.x || newY != this.y || newW != this.width || newH != this.height) {
            BufferedImage oldImage = this.getImage();
            Graphics2D oldG2 = this.getG2();
            Composite oldComposite = oldG2.getComposite();
            Paint oldPaint = this.g2.getPaint();
            Stroke oldStroke = this.g2.getStroke();
            AffineTransform oldAffineTransform = this.g2.getTransform();
            BufferedImage newImage = new BufferedImage(newW, newH, 2);
            Graphics2D newG2 = newImage.createGraphics();
            newG2.setPaint(this.backGround);
            newG2.fillRect(0, 0, newW, newH);
            newG2.drawRenderedImage(oldImage, AffineTransform.getTranslateInstance(this.x - newX, this.y - newY));
            newG2.dispose();
            this.setImage(newImage);
            this.getG2().setComposite(oldComposite);
            this.getG2().setPaint(oldPaint);
            this.getG2().setStroke(oldStroke);
            this.getG2().setTransform(oldAffineTransform);
            this.x = newX;
            this.y = newY;
        }
        Composite oldComposite = this.g2.getComposite();
        for (int i = 0; i < layers.length; ++i) {
            float op = layers[i].opacity;
            Composite composite = layers[i].layerComposite;
            if ((double)op < 0.99999 && composite instanceof AlphaComposite) {
                int acRule = ((AlphaComposite)composite).getRule();
                composite = AlphaComposite.getInstance(acRule, op);
            }
            this.g2.setComposite(composite);
            this.g2.drawRenderedImage(layers[i].getImage(), AffineTransform.getTranslateInstance(layers[i].x - newX, layers[i].y - newY));
        }
        this.g2.setComposite(oldComposite);
    }

    public void blit(Layer src, int dw, int dh) {
        this.blit(src, 0, 0, dw, dh, 0, 0);
    }

    public void blit(Layer src, int dx, int dy, int dw, int dh, int sx, int sy) {
        BufferedImage srcImage = src.getImage().getSubimage(sx, sy, dw, dh);
        this.g2.drawRenderedImage(srcImage, AffineTransform.getTranslateInstance(dx, dy));
    }

    public void copyChannel(Layer src, int fromChannel, int toChannel) {
        if (src == null) {
            src = this;
        }
        if (fromChannel < 0) {
            fromChannel = 3;
        }
        if (toChannel < 0) {
            toChannel = fromChannel;
        }
        if (src == this && fromChannel == toChannel) {
            return;
        }
        int w = Math.min(this.width, src.width);
        int h = Math.min(this.height, src.height);
        if (fromChannel > src.getImageRGBA().getRaster().getNumBands()) {
            throw new IndexOutOfBoundsException("fromChannel");
        }
        if (toChannel > this.getImageRGBA().getRaster().getNumBands()) {
            throw new IndexOutOfBoundsException("toChannel");
        }
        this.getImageRGBA().getRaster().setSamples(0, 0, w, h, toChannel, src.getImageRGBA().getRaster().getSamples(0, 0, w, h, fromChannel, (int[])null));
    }

    public void colorMask(Layer src, Color col) {
        if (src == null) {
            src = this;
        }
        if (col == null) {
            col = Color.black;
        }
        int w = Math.min(this.width, src.width);
        int h = Math.min(this.height, src.height);
        int color = col.getRGB();
        BufferedImage image = this.getImageRGBA();
        int[] de = (int[])image.getRaster().getDataElements(0, 0, w, h, null);
        int[] se = (int[])src.getImageRGBA().getRaster().getDataElements(0, 0, w, h, null);
        for (int i = 0; i < se.length; ++i) {
            if (se[i] != de[i]) continue;
            de[i] = color;
        }
        image.getRaster().setDataElements(0, 0, w, h, de);
    }

    public void flatten(Color color) {
        if (color == null) {
            color = this.backGround instanceof Color ? (Color)this.backGround : this.getBackgroundColor();
        }
        Paint op = this.g2.getPaint();
        Composite oc = this.g2.getComposite();
        this.g2.setPaint(color);
        this.g2.setComposite(AlphaComposite.DstOver);
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.g2.fillRect(0, 0, this.width, this.height);
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2.setComposite(oc);
        this.g2.setPaint(op);
    }

    public void rotate(double degrees) {
        int xmax;
        int xmin;
        int ymax;
        int ymin;
        double theta = Math.toRadians(degrees);
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        int q = (int)(degrees / 90.0);
        if ((q & 1) == 1) {
            double y2 = (double)this.width * sin + 0.0 * cos;
            double y4 = 0.0 * sin + (double)this.height * cos;
            double x1 = 0.0;
            double x3 = (double)this.width * cos - (double)this.height * sin;
            if (q == 1) {
                ymin = (int)Math.floor(y4);
                ymax = (int)Math.ceil(y2);
                xmin = (int)Math.floor(x3);
                xmax = (int)Math.ceil(x1);
            } else {
                ymin = (int)Math.floor(y2);
                ymax = (int)Math.ceil(y4);
                xmin = (int)Math.floor(x1);
                xmax = (int)Math.ceil(x3);
            }
        } else {
            double y1 = 0.0;
            double y3 = (double)this.width * sin + (double)this.height * cos;
            double x2 = (double)this.width * cos - 0.0 * sin;
            double x4 = 0.0 * cos - (double)this.height * sin;
            if (q == 0) {
                ymin = (int)Math.floor(y1);
                ymax = (int)Math.ceil(y3);
                xmin = (int)Math.floor(x4);
                xmax = (int)Math.ceil(x2);
            } else {
                ymin = (int)Math.floor(y3);
                ymax = (int)Math.ceil(y1);
                xmin = (int)Math.floor(x2);
                xmax = (int)Math.ceil(x4);
            }
        }
        this.width = xmax - xmin;
        this.height = ymax - ymin;
        xmin = xmin < 0 ? -xmin : 0;
        ymin = ymin < 0 ? -ymin : 0;
        AffineTransform rot = new AffineTransform();
        rot.translate(xmin, ymin);
        rot.rotate(theta);
        BufferedImage newImage = new BufferedImage(this.width, this.height, 2);
        this.transformImage(newImage, rot);
    }

    public void flipHorizontally() {
        AffineTransform scale = new AffineTransform();
        scale.scale(-1.0, 1.0);
        scale.translate(-this.width, 0.0);
        BufferedImage newImage = new BufferedImage(this.width, this.height, 2);
        this.transformImage(newImage, scale);
    }

    public void flipVertically() {
        AffineTransform scale = new AffineTransform();
        scale.scale(1.0, -1.0);
        scale.translate(0.0, -this.height);
        BufferedImage newImage = new BufferedImage(this.width, this.height, 2);
        this.transformImage(newImage, scale);
    }

    public void resize(int width, int height) {
        this.resize(width, height, false);
    }

    public void resize(int width, int height, boolean fast) {
        if (width <= 0) {
            width = this.width;
        }
        if (height <= 0) {
            height = this.height;
        }
        if (width == this.width && height == this.height) {
            return;
        }
        double sx = (double)width / (double)this.width;
        double sy = (double)height / (double)this.height;
        ResizeOp op = new ResizeOp(sx, sy, this.g2.getRenderingHints());
        op.setFast(fast);
        this.setImage(op.filter(this.getImageRGBA(), null));
    }

    public void crop(Rectangle2D rect) {
        rect = this.checkRect(rect);
        BufferedImage newImage = this.getImage().getSubimage((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
        this.transformImage(newImage, null);
    }

    public void emboss(Layer bump, int azimut, int elevation, int filtersize) {
        if (bump == null) {
            bump = this;
        }
        if (azimut < 0) {
            azimut = 30;
        }
        if (elevation < 0) {
            elevation = 30;
        }
        if (filtersize < 0) {
            filtersize = 3;
        }
        EmbossOp op = new EmbossOp(bump.getImageRGBA(), azimut += 180, elevation, filtersize);
        BufferedImage newImage = op.filter(this.getImageRGBA(), null);
        this.setImage(newImage);
    }

    public void xForm(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, boolean crop) {
        float fx1 = (float)x1 / (float)this.width;
        float fx2 = (float)x2 / (float)this.width;
        float fx3 = (float)x3 / (float)this.width;
        float fx4 = (float)x4 / (float)this.width;
        float fy1 = (float)y1 / (float)this.height;
        float fy2 = (float)y2 / (float)this.height;
        float fy3 = (float)y3 / (float)this.height;
        float fy4 = (float)y4 / (float)this.height;
        float[][] coords = new float[][]{{fx1, fy1}, {fx2, fy2}, {fx3, fy3}, {fx4, fy4}};
        DistortOp bop = new DistortOp(coords, crop, this.getBackgroundColor());
        BufferedImage newImg = bop.filter(this.getImageRGBA(), null);
        this.setImage(newImg);
    }

    public void grayscale() {
        float[][] bwBopEl = new float[][]{{this.lumSys.r(), this.lumSys.g(), this.lumSys.b(), 0.0f, 0.0f}, {this.lumSys.r(), this.lumSys.g(), this.lumSys.b(), 0.0f, 0.0f}, {this.lumSys.r(), this.lumSys.g(), this.lumSys.b(), 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 1.0f, 0.0f}};
        this.setImage(ImageSupport.coerceData(this.getImageRGBA(), true));
        WritableRaster raster = this.getImageRGBA().getRaster();
        BandCombineOp bco = new BandCombineOp(bwBopEl, null);
        bco.filter(raster, raster);
    }

    public void colorize(Color darkcolor, Color brightcolor) {
        this.grayscale();
        ColorCurve[] curves = new ColorCurve[]{new ColorCurve(darkcolor, new float[]{0.0f, 1.0f}), new ColorCurve(brightcolor, new float[]{1.0f, 0.0f})};
        MultitoneOp mo = new MultitoneOp(curves, null);
        BufferedImage image = this.getImageRGBA();
        mo.filter(image, image);
    }

    public void monotone(Color color) {
        if (color == null) {
            throw new NullPointerException("color");
        }
        this.multitone(new Color[]{color});
    }

    public void multitone(Color[] colors) {
        if (colors == null) {
            throw new NullPointerException("colors");
        }
        if (colors.length == 0) {
            throw new IllegalArgumentException("empty colors");
        }
        int numcols = colors.length;
        for (int i = 0; i < numcols; ++i) {
            if (colors[i] != null) continue;
            throw new NullPointerException("colors[" + i + "]");
        }
        this.grayscale();
        MultitoneOp mo = new MultitoneOp(colors, null);
        BufferedImage image = this.getImageRGBA();
        mo.filter(image, image);
    }

    public void multitone(ColorCurve[] colorCurves) {
        this.grayscale();
        MultitoneOp mo = new MultitoneOp(colorCurves, null);
        BufferedImage image = this.getImageRGBA();
        mo.filter(image, image);
    }

    public void blur(double radius, double scale, int flags, double gran, double maxdata) {
        double tmp;
        if (radius < 0.0) {
            radius = 1.0;
        }
        if (scale < 0.0) {
            scale = 1.0;
        }
        if (flags < 0) {
            flags = 2;
        }
        if (gran < 0.0) {
            gran = 1.0;
        }
        if (maxdata < 0.0) {
            maxdata = 255.0;
        }
        double[] kField = new double[256];
        double max = 0.0;
        double delta = gran / (2.0 * maxdata);
        int kernelEdge = 0;
        for (int j = 0; j < 256; ++j) {
            tmp = (double)(j - 128) / radius;
            kField[j] = Math.exp(-tmp * tmp / 2.0);
            max += kField[j];
        }
        int kernelsize = 255;
        for (tmp = 2.0 * (kField[kernelsize] / max); tmp < delta && kernelsize > 128; tmp += 2.0 * kField[kernelsize] / max, --kernelsize) {
            kField[kernelsize] = 0.0;
            kField[256 - kernelsize] = 0.0;
        }
        kernelEdge = 2 * kernelsize - 256;
        if (kernelEdge == 0) {
            return;
        }
        float[] kField2 = new float[kernelEdge * kernelEdge];
        int kfoff = 256 - kernelsize;
        for (int x = 0; x < kernelEdge; ++x) {
            for (int y = 0; y < kernelEdge; ++y) {
                int off = kernelEdge * y + x;
                kField2[off] = (float)(kField[x + kfoff] + kField[y + kfoff]);
                max += (double)kField2[off];
            }
        }
        max /= scale;
        int i = 0;
        while (i < kField2.length) {
            int n = i++;
            kField2[n] = (float)((double)kField2[n] / max);
        }
        Kernel kernel = new Kernel(kernelEdge, kernelEdge, kField2);
        ConvolveOp blur = new ConvolveOp(kernel, 1, this.g2.getRenderingHints());
        BufferedImage image = this.getImageRGBA();
        this.setImage(blur.filter(image, null));
    }

    public void sharpen(float amount, float radius) {
        if (amount <= 0.0f || (double)radius < 0.5) {
            return;
        }
        if (amount > 1.0f) {
            amount = 1.0f;
        }
        if (radius > 10.0f) {
            radius = 10.0f;
        }
        int edge = 2 * (int)((double)radius + 0.5) + 1;
        float[] matrix = new float[edge * edge];
        for (int i = 0; i < matrix.length; ++i) {
            matrix[i] = -1.0f;
        }
        matrix[(edge + 1) * (edge / 2)] = (float)(matrix.length - 1) + amount;
        Kernel kernel = new Kernel(edge, edge, matrix);
        ConvolveOp sharpen = new ConvolveOp(kernel);
        this.setImage(sharpen.filter(this.getImage(), null));
    }

    public void xFormColors(double[][] matrix, double[] vector, boolean crop) {
        int i;
        float[][] bopEl = new float[4][5];
        for (i = 0; i < 4 && i < matrix.length; ++i) {
            for (int j = 0; j < 4 && j < matrix[i].length; ++j) {
                bopEl[i][j] = (float)matrix[i][j];
            }
        }
        for (i = 0; i < 4 && i < vector.length; ++i) {
            bopEl[i][4] = (float)vector[i];
        }
        BufferedImage image = this.getImageRGBA();
        new BandCombineOp(bopEl, null).filter(image.getRaster(), image.getRaster());
    }

    public void replaceColor(long color1, long color2, boolean ignoreAlpha) {
        BufferedImage image = this.getImageRGBA();
        int[] rgbArray = image.getRGB(0, 0, this.width, this.height, null, 0, this.width);
        int len = rgbArray.length;
        int c1 = (int)color1;
        int c2 = (int)color2;
        if (ignoreAlpha) {
            c1 &= 0xFFFFFF;
            c2 &= 0xFFFFFF;
            for (int i = 0; i < len; ++i) {
                if ((rgbArray[i] & 0xFFFFFF) != c1) continue;
                rgbArray[i] = rgbArray[i] & 0xFF000000 | c2;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (rgbArray[i] != c1) continue;
                rgbArray[i] = c2;
            }
        }
        image.setRGB(0, 0, this.width, this.height, rgbArray, 0, this.width);
    }

    public void adjust(int brightness, float contrast) {
        if (brightness < -255) {
            brightness = -255;
        }
        if (brightness > 255) {
            brightness = 255;
        }
        if (contrast < 0.0f) {
            contrast = 0.0f;
        }
        RescaleOp rop = new RescaleOp(contrast, brightness, null);
        BufferedImage image = this.getImageRGBA();
        rop.filter(image, image);
    }

    public void reduceColors(int numColors) {
        DitherOp dither = new DitherOp(numColors, this.transparency, this.bgColor, DitherOp.DITHER_NONE, null);
        this.setImage(dither.filter(this.getImageRGBA(), null));
    }

    public void setPaint(Paint paint) {
        this.g2.setPaint(paint);
    }

    public Paint getPaint() {
        return this.g2.getPaint();
    }

    public void setStroke(Stroke stroke) {
        this.g2.setStroke(stroke);
    }

    public Stroke getStroke() {
        return this.g2.getStroke();
    }

    public void setLineStyle(LineStyle lineStyle) {
        this.g2.setPaint(lineStyle);
        this.g2.setStroke(lineStyle);
    }

    public void setComposite(Composite composite) {
        this.g2.setComposite(composite);
    }

    public Composite getComposite() {
        return this.g2.getComposite();
    }

    public void setTransform(AffineTransform transfrom) {
        this.g2.setTransform(transfrom);
    }

    public void setLuminanceSystem(LuminanceSystem system) {
        if (system != null) {
            this.lumSys = system;
        }
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.g2.setRenderingHint(hintKey, hintValue);
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.g2.getRenderingHint(hintKey);
    }

    public int drawText(int x, int y, int width, int height, String text, AbstractFont font, int align, double cs, int ls) {
        return font.drawText(this, x, y, width, height, text, this.g2.getPaint(), this.g2.getStroke(), align, cs, ls);
    }

    public void fillRect(Rectangle2D rect) {
        if (rect == null) {
            this.g2.fillRect(0, 0, this.width, this.height);
        } else {
            this.g2.fill(rect);
        }
    }

    public void fillRect(Layer src, Rectangle2D rect) {
        if (src == null) {
            throw new NullPointerException("src");
        }
        if (src == this) {
            return;
        }
        TexturePaint tp = new TexturePaint(src.getImage(), new Rectangle(0, 0, src.width, src.height));
        Paint oldPaint = this.g2.getPaint();
        this.g2.setPaint(tp);
        this.fillRect(rect);
        this.g2.setPaint(oldPaint);
    }

    public void drawRect(Rectangle2D rect) {
        if (rect == null) {
            this.g2.drawRect(0, 0, this.width - 1, this.height - 1);
        } else {
            this.g2.draw(rect);
        }
    }

    public void drawLine(float x1, float y1, float x2, float y2) {
        this.g2.draw(new Line2D.Float(x1, y1, x2, y2));
    }

    public void drawPolyLine(float[][] points) {
        GeneralPath shape = new GeneralPath();
        shape.moveTo(points[0][0], points[0][1]);
        for (int i = 1; i < points.length; ++i) {
            shape.lineTo(points[i][0], points[i][1]);
        }
        this.g2.draw(shape);
    }

    public void drawEllipse(float cx, float cy, float a, float b) {
        this.g2.draw(new Ellipse2D.Double(cx - a, cy - b, a * 2.0f, b * 2.0f));
    }

    public void fillEllipse(float cx, float cy, float a, float b) {
        this.g2.fill(new Ellipse2D.Double(cx - a, cy - b, a * 2.0f, b * 2.0f));
    }

    public void drawSegment(float cx, float cy, float a, float b, double from, double extent) {
        this.g2.draw(new Arc2D.Double(cx - a, cy - b, a * 2.0f, b * 2.0f, from, extent, 0));
    }

    public void drawSector(float cx, float cy, float a, float b, double from, double extent) {
        this.g2.draw(new Arc2D.Double(cx - a, cy - b, a * 2.0f, b * 2.0f, from, extent, 2));
    }

    public void fillSector(float cx, float cy, float a, float b, double from, double extent) {
        this.g2.fill(new Arc2D.Double(cx - a, cy - b, a * 2.0f, b * 2.0f, from, extent, 2));
    }

    public void draw(Shape shape) {
        this.g2.draw(shape);
    }

    public void fill(Shape shape) {
        this.g2.fill(shape);
    }

    public int getPixel(int x, int y) {
        return this.getImage().getRGB(x, y);
    }

    public void setPixel(int x, int y, long color) {
        this.getImage().setRGB(x, y, (int)color);
    }

    public Rectangle2D getBoundingBox() {
        return this.getBoundingBox(this.getBackgroundColor());
    }

    public Rectangle2D getBoundingBox(Color bgcolor) {
        int i;
        int[] pixels = this.getImageRGBA().getRGB(0, 0, this.width, this.height, null, 0, this.width);
        int br = pixels.length - 1;
        int bgcol = bgcolor.getRGB();
        int top = 0;
        int bottom = 0;
        int left = 0;
        int right = 0;
        if (br == 0) {
            return new Rectangle(1, 1);
        }
        for (i = 0; i <= br; ++i) {
            if (bgcol == pixels[i]) continue;
            top = i / this.width;
            break;
        }
        for (i = br; i >= 0; --i) {
            if (bgcol == pixels[i]) continue;
            bottom = i / this.width + 1;
            break;
        }
        for (i = 0; i != br; i += this.width) {
            if (i > br) {
                i -= br;
            }
            if (bgcol == pixels[i]) continue;
            left = i % this.width;
            break;
        }
        for (i = br; i != 0; i -= this.width) {
            if (i < 0) {
                i += br;
            }
            if (bgcol == pixels[i]) continue;
            right = i % this.width + 1;
            break;
        }
        return new Rectangle(left, top, right, bottom);
    }

    public void floodFill(Color fillColor, int blur) {
        this.floodFill(fillColor, blur, this.getBackgroundColor());
    }

    public void floodFill(Color fillColor, int blur, Color bgColor) {
        int i;
        int bc;
        int fc = fillColor.getRGB();
        if (this.isColorNear(fc, bc = bgColor.getRGB(), blur)) {
            return;
        }
        Rectangle2D rect = this.getBoundingBox(bgColor);
        int l = (int)rect.getMinX();
        int r = (int)rect.getMaxX();
        int t = (int)rect.getMinY();
        int b = (int)rect.getMaxY();
        Paint oldPaint = this.g2.getPaint();
        this.g2.setPaint(fillColor);
        this.g2.fillRect(0, 0, this.width, t);
        this.g2.fillRect(0, b, this.width, this.height - b);
        this.g2.fillRect(0, t, l, b);
        this.g2.fillRect(r, t, this.width - r, b);
        BufferedImage image = this.getImageRGBA();
        int[] pixels = image.getRGB(0, 0, this.width, this.height, null, 0, this.width);
        int end = r + this.width * t;
        int di = this.width * (b - t - 1);
        for (i = l + this.width * t; i < end; ++i) {
            if (this.isColorNear(pixels[i], bc, blur)) {
                this.floodRecursive(pixels, i, fc, bc, blur);
            }
            if (!this.isColorNear(pixels[i + di], bc, blur)) continue;
            this.floodRecursive(pixels, i + di, fc, bc, blur);
        }
        end = l + this.width * b;
        di = r - l - 1;
        for (i = l + this.width * t; i < end; i += this.width) {
            if (this.isColorNear(pixels[i], bc, blur)) {
                this.floodRecursive(pixels, i, fc, bc, blur);
            }
            if (!this.isColorNear(pixels[i + di], bc, blur)) continue;
            this.floodRecursive(pixels, i + di, fc, bc, blur);
        }
        image.setRGB(0, 0, this.width, this.height, pixels, 0, this.width);
        if (this.transparency == bgColor) {
            this.transparency = fillColor;
        }
        this.g2.setPaint(oldPaint);
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
        this.g2.drawImage(img, op, x, y);
    }

    public void draw(Graphics g) {
        g.drawImage(this.getImage(), 0, 0, null);
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public Rectangle getBounds() {
        return this.getImage().getRaster().getBounds();
    }

    public int getImageIndex() {
        return this.imageIndex;
    }

    public int getNumImages() {
        return this.numImages;
    }

    public Paint getBackground() {
        return this.backGround;
    }

    public void setBackground(Paint bground) {
        Paint paint = this.backGround = bground != null ? bground : TRANSPARENT_IMAGE_BACKGROUND;
        if (this.backGround instanceof Color) {
            this.bgColor = (Color)this.backGround;
        }
    }

    public void setBackgroundColor(Color bgColor) {
        this.bgColor = bgColor;
    }

    public Color getBackgroundColor() {
        if (this.bgColor == null) {
            if (this.backGround instanceof Color) {
                this.bgColor = (Color)this.backGround;
            } else {
                long[] cs = new long[2 * this.width + 2 * this.height];
                int[] numCs = new int[2 * this.width + 2 * this.height];
                int cols = -1;
                BufferedImage image = this.getImageRGBA();
                int[] rowT = image.getRGB(0, 0, this.width, 1, null, 0, this.width);
                int[] rowB = image.getRGB(0, this.height - 1, this.width, 1, null, 0, this.width);
                for (int i = 0; i < rowT.length; ++i) {
                    long c1 = (long)rowT[i] & 0xFFFFFFFFL;
                    long c2 = (long)rowB[i] & 0xFFFFFFFFL;
                    for (int j = 0; j <= cols; ++j) {
                        if (c1 == cs[j]) {
                            int n = j;
                            numCs[n] = numCs[n] + 1;
                            c1 = -1L;
                        }
                        if (c2 != cs[j]) continue;
                        int n = j;
                        numCs[n] = numCs[n] + 1;
                        c2 = -1L;
                    }
                    if (c1 >= 0L) {
                        cs[++cols] = c1;
                    }
                    if (c2 < 0L) continue;
                    cs[++cols] = c2;
                }
                int[] colL = image.getRGB(0, 0, 1, this.height, null, 0, 1);
                int[] colR = image.getRGB(this.width - 1, 0, 1, this.height, null, 0, 1);
                for (int i = 0; i < colL.length; ++i) {
                    long c1 = (long)colL[i] & 0xFFFFFFFFL;
                    long c2 = (long)colR[i] & 0xFFFFFFFFL;
                    for (int j = 0; j <= cols; ++j) {
                        if (c1 == cs[j]) {
                            int n = j;
                            numCs[n] = numCs[n] + 1;
                            c1 = -1L;
                        }
                        if (c2 != cs[j]) continue;
                        int n = j;
                        numCs[n] = numCs[n] + 1;
                        c2 = -1L;
                    }
                    if (c1 >= 0L) {
                        cs[++cols] = c1;
                    }
                    if (c2 < 0L) continue;
                    cs[++cols] = c2;
                }
                int max = 0;
                int maxOcc = numCs[0];
                for (int i = 1; i < cols; ++i) {
                    if (numCs[i] <= maxOcc) continue;
                    max = i;
                    maxOcc = numCs[i];
                }
                this.bgColor = new Color((int)cs[max], true);
            }
        }
        return this.bgColor;
    }

    public Color getTransparency() {
        return this.transparency;
    }

    public void setTransparency(Color transparency) {
        this.transparency = transparency;
    }

    public void setMimeType(String mimeType) {
        if (mimeType != null && mimeType.length() > 0) {
            this.mimeType = mimeType;
        }
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float opacity) {
        if (!Float.isNaN(opacity)) {
            if (opacity > 1.0f) {
                opacity = 1.0f;
            }
            if (opacity < 0.0f) {
                opacity = 0.0f;
            }
            this.opacity = opacity;
        }
    }

    public Composite getLayerComposite() {
        return this.layerComposite;
    }

    public void setLayerComposite(Composite layerComposite) {
        if (layerComposite != null) {
            this.layerComposite = layerComposite;
        }
    }

    public BufferedImage getImage() {
        return this.baseImg;
    }

    private BufferedImage getImageRGBA() {
        if (!this.baseImgIsRGBA) {
            BufferedImage newImage = new BufferedImage(this.baseImg.getWidth(), this.baseImg.getHeight(), 2);
            Graphics2D g2 = newImage.createGraphics();
            g2.drawRenderedImage(this.baseImg, IDENTITY_XFORM);
            g2.dispose();
            this.setImage(newImage);
        }
        return this.baseImg;
    }

    public Graphics2D getG2() {
        return this.g2;
    }

    void setImage(BufferedImage image) {
        this.setImage(image, false);
    }

    private void setImage(BufferedImage image, boolean paintBackground) {
        if (image != null && image != this.baseImg) {
            if (this.baseImg != null) {
                this.baseImg.flush();
            }
            if (this.g2 != null) {
                this.g2.dispose();
            }
            this.baseImg = image;
            this.baseImgIsRGBA = this.baseImg.getType() == 6;
            this.width = this.baseImg.getWidth();
            this.height = this.baseImg.getHeight();
            this.g2 = this.baseImg.createGraphics();
            this.setRenderingHints(this.g2);
            this.g2.setBackground(this.backGround instanceof Color ? (Color)this.backGround : Color.white);
            if (paintBackground) {
                this.g2.setPaint(this.backGround);
                this.g2.fillRect(0, 0, this.width, this.height);
            }
        }
    }

    public String toString() {
        return "Layer: left=" + this.x + ", top=" + this.y + ", width=" + this.width + ", height=" + this.height + ", background=" + this.backGround + ", mime=" + this.mimeType;
    }

    private void init(int width, int height, Paint bground) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("width or height <= 0");
        }
        this.x = 0;
        this.y = 0;
        this.setBackground(bground);
        this.opacity = 1.0f;
        this.transparency = null;
        this.mimeType = DEFAULT_MIME_TYPE;
        this.layerComposite = DEFAULT_LAYER_COMPOSITE;
        this.setImage(new BufferedImage(width, height, 2), true);
    }

    private void setRenderingHints(Graphics2D g2) {
        if (RENDERING_HINTS == null) {
            HashMap<RenderingHints.Key, Object> tmp = new HashMap<RenderingHints.Key, Object>(7);
            tmp.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            tmp.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
            tmp.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            tmp.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
            tmp.put(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            tmp.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            tmp.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            RENDERING_HINTS = tmp;
        }
        g2.setRenderingHints(RENDERING_HINTS);
    }

    private Rectangle2D checkRect(Rectangle2D rect) {
        if (rect == null) {
            return new Rectangle2D.Float(this.x, this.y, this.x + this.width, this.y + this.height);
        }
        double rx = rect.getX();
        double ry = rect.getY();
        double rw = rect.getWidth();
        double rh = rect.getHeight();
        if (rx < (double)this.x) {
            rx = this.x;
        }
        if (ry < (double)this.y) {
            ry = this.y;
        }
        if (rx + rw > (double)(this.x + this.width)) {
            rw = (double)(this.x + this.width) - rx;
        } else if (rw == 0.0) {
            rw = 1.0;
        }
        if (ry + rh > (double)(this.y + this.height)) {
            rh = (double)(this.y + this.height) - ry;
        } else if (rh == 0.0) {
            rh = 1.0;
        }
        rect.setRect(rx, ry, rw, rh);
        return rect;
    }

    private void transformImage(BufferedImage newImage, AffineTransform xform) {
        Graphics2D newG2 = newImage.createGraphics();
        this.setRenderingHints(newG2);
        if (xform != null) {
            newG2.drawRenderedImage(this.getImage(), xform);
        }
        this.setImage(newImage);
    }

    private boolean isColorNear(int col1, int col2, long maxDist) {
        if (col1 == col2) {
            return true;
        }
        int a1 = col1 >>> 24 & 0xFF;
        int a2 = col2 >>> 24 & 0xFF;
        long r = a1 * (col1 >>> 16 & 0xFF) - a2 * (col2 >>> 16 & 0xFF);
        long g = a1 * (col1 >>> 8 & 0xFF) - a2 * (col2 >>> 8 & 0xFF);
        long b = a1 * (col1 & 0xFF) - a2 * (col2 & 0xFF);
        return r * r + g * g + b * b <= maxDist * maxDist * 255L * 255L;
    }

    private void floodRecursive(int[] pixels, int pos, int fillCol, int bgCol, int blur) {
        int j = blur > 0 ? blur / 2 : 0;
        int pix = pixels[pos];
        if (bgCol == pix) {
            pixels[pos] = fillCol;
        } else if (blur > 0) {
            int pr = pix >>> 16 & 0xFF;
            int pg = pix >>> 8 & 0xFF;
            int pb = pix & 0xFF;
            int br = bgCol >>> 16 & 0xFF;
            int bg = bgCol >>> 8 & 0xFF;
            int bb = bgCol & 0xFF;
            int dr = pr - br;
            int dg = pg - bg;
            int db = pb - bb;
            int aq = (int)Math.sqrt(dr * dr + dg * dg + db * db);
            int ai = blur - aq;
            int r = (pr * aq - br * ai) / blur;
            int g = (pg * aq - bg * ai) / blur;
            int b = (pb * aq - bb * ai) / blur;
            pixels[pos] = pix & -16777216 + (r << 16) + (g << 8) + b;
        }
        int[] o = new int[4];
        int i = 0;
        int x = pos % this.width;
        int y = pos / this.width;
        if (x + 1 < this.width) {
            o[i++] = pos + 1;
        }
        if (x > 0) {
            o[i++] = pos - 1;
        }
        if (y > 0) {
            o[i++] = pos - this.width;
        }
        if (y + 1 < this.height) {
            o[i++] = pos + this.width;
        }
        while (i > 0) {
            if (!this.isColorNear(pixels[o[--i]], bgCol, blur)) continue;
            try {
                this.floodRecursive(pixels, o[i], fillCol, bgCol, j);
            }
            catch (StackOverflowError soe) {
                return;
            }
        }
    }

    static {
        ImageSupport.initialize();
        GAMMA22 = new LuminanceSystem("Gamma 2.2", 0.229f, 0.587f, 0.114f);
        LINEAR = new LuminanceSystem("Linear", 0.3086f, 0.6094f, 0.082f);
        REC709 = new LuminanceSystem("Rec709", 0.2125f, 0.7154f, 0.0721f);
        TRANSPARENT_IMAGE_BACKGROUND = new Color(0, 0, 0, 0);
        DEFAULT_LAYER_COMPOSITE = AlphaComposite.SrcOver;
        IDENTITY_XFORM = new AffineTransform();
        RENDERING_HINTS = null;
    }

    public static final class LuminanceSystem {
        private final String name;
        private final float r;
        private final float g;
        private final float b;
        private String stringRep;

        LuminanceSystem(String name, float r, float g, float b) {
            this.name = name;
            this.r = r;
            this.g = g;
            this.b = b;
            this.stringRep = null;
        }

        LuminanceSystem(float r, float g, float b) {
            this(null, r, g, b);
        }

        float r() {
            return this.r;
        }

        float g() {
            return this.g;
        }

        float b() {
            return this.b;
        }

        public String toString() {
            if (this.stringRep == null) {
                StringBuffer buf = new StringBuffer();
                if (this.name != null) {
                    buf.append(this.name);
                    buf.append(' ');
                }
                this.stringRep = buf.append('[').append(this.r).append(',').append(this.g).append(',').append(this.b).append(']').toString();
            }
            return this.stringRep;
        }
    }
}

