/*
 * Decompiled with CFR 0.152.
 */
package com.day.crx.statistics.loader;

import com.day.crx.statistics.Entry;
import com.day.crx.statistics.loader.Access;
import com.day.crx.statistics.query.Query;
import com.day.crx.statistics.result.ResultSelected;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.StringTokenizer;

public class AccessLogLoader {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z", Locale.US);
    private ProgressListener listener;
    private final String ql;
    private final String rl;
    private final String qpp;
    private final String qpn;
    private final String rpp;

    public AccessLogLoader(String ql, String rl, String qpp, String qpn, String rpp) {
        this.ql = ql;
        this.rl = rl;
        this.qpp = qpp;
        this.qpn = qpn;
        this.rpp = rpp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] processFile(InputStream in) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in, "ISO-8859-1"));
        try {
            String line;
            int lineCount = 0;
            int queryCount = 0;
            int resultCount = 0;
            while ((line = reader.readLine()) != null) {
                Entry entry = null;
                ++lineCount;
                try {
                    String query;
                    Access a = Access.fromString(line);
                    URI uri = new URI(a.requestURI);
                    URI referer = new URI(a.referer);
                    if (referer.getPath() != null && referer.getPath().startsWith(this.qpp)) {
                        long time = this.dateFormat.parse(a.dateTime + " " + a.timeZone).getTime();
                        String path = uri.getPath();
                        if (this.rpp != null && path.startsWith(this.rpp)) {
                            String query2;
                            int extIdx = path.lastIndexOf(46);
                            if (extIdx != -1) {
                                path = path.substring(0, extIdx).trim();
                            }
                            if ((query2 = this.getQuery(referer.getQuery())) != null) {
                                entry = new ResultSelected(this.rl, path, 1L, query2);
                                entry.setTimestamp(time);
                                ++resultCount;
                            }
                        }
                    } else if (uri.getPath().startsWith(this.qpp) && (query = this.getQuery(uri.getQuery())) != null) {
                        long time = this.dateFormat.parse(a.dateTime + " " + a.timeZone).getTime();
                        entry = new Query(this.ql, query, 0L, 0L);
                        entry.setTimestamp(time);
                        ++queryCount;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (ParseException parseException) {
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
                this.notifyListener(lineCount, queryCount, resultCount, entry);
            }
            int[] nArray = new int[]{queryCount, resultCount};
            return nArray;
        }
        finally {
            reader.close();
        }
    }

    private void notifyListener(int lineCount, int queryCount, int resultCount, Entry entry) {
        if (this.listener != null) {
            this.listener.lineProcessed(lineCount, queryCount, resultCount, entry);
        }
    }

    private String getQuery(String uriQueryPart) {
        if (uriQueryPart == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(uriQueryPart, "&");
        while (tokenizer.hasMoreTokens()) {
            String query;
            String param = tokenizer.nextToken();
            if (!param.startsWith(this.qpn + "=") || (query = param.substring(this.qpn.length() + 1)).length() <= 0) continue;
            query = query.replaceAll("\\+", " ").trim();
            return query;
        }
        return null;
    }

    public void setProgressListener(ProgressListener listener) {
        this.listener = listener;
    }

    public static interface ProgressListener {
        public void lineProcessed(int var1, int var2, int var3, Entry var4);
    }
}

