/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.tags;

import com.day.cq.commons.LanguageUtil;
import com.day.cq.wcm.api.LanguageManager;
import com.day.cq.wcm.tags.ContentResourceBundle;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.jstl.core.Config;
import javax.servlet.jsp.jstl.fmt.LocalizationContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.jsp.util.TagUtil;

public class SetContentBundleTag
extends TagSupport {
    private static final long serialVersionUID = -3437648502705143816L;
    private Source source = null;
    private Locale language = null;
    private String basename = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doEndTag() {
        try {
            SlingHttpServletRequest request = TagUtil.getRequest(this.pageContext);
            Resource content = request.getResource();
            ResourceBundle requestBundle = this.getResourceBundle(request);
            ValueMap values = content.adaptTo(ValueMap.class);
            ResourceBundle bundle = values != null ? new ContentResourceBundle(values, requestBundle) : requestBundle;
            Config.set(this.pageContext, "javax.servlet.jsp.jstl.fmt.localizationContext", new LocalizationContext(bundle, this.getLocale(request)), 1);
            int n = 6;
            return n;
        }
        finally {
            this.language = null;
        }
    }

    public void setSource(String source) throws JspException {
        try {
            this.source = Source.valueOf(source.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new JspException("setContentBundle: 'source' must be one of " + Arrays.toString((Object[])Source.values()) + " (upper or lowercase)", e);
        }
    }

    public String getSource() {
        return this.source.toString();
    }

    public String getLanguage() {
        return this.language.getLanguage();
    }

    public void setLanguage(String language) {
        this.language = LanguageUtil.getLocale(language);
    }

    public String getBasename() {
        return this.basename;
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    private ResourceBundle getResourceBundle(SlingHttpServletRequest request) {
        return request.getResourceBundle(this.basename, this.getLocale(request));
    }

    private Locale getLocale(SlingHttpServletRequest request) {
        Source source = this.source;
        if (source == null) {
            Source source2 = source = this.language != null ? Source.STATIC : Source.AUTO;
        }
        if (source == Source.STATIC) {
            return this.language != null ? this.language : Locale.getDefault();
        }
        if (source == Source.PAGE) {
            Locale locale = this.getPageLocale(request.getResource());
            if (locale != null) {
                return locale;
            }
            return this.language != null ? this.language : Locale.getDefault();
        }
        if (source == Source.REQUEST) {
            return request.getLocale();
        }
        Locale locale = this.getPageLocale(request.getResource());
        if (locale != null) {
            return locale;
        }
        return request.getLocale();
    }

    private Locale getPageLocale(Resource resource) {
        SlingBindings bindings = (SlingBindings)this.pageContext.getRequest().getAttribute(SlingBindings.class.getName());
        SlingScriptHelper scriptHelper = bindings.getSling();
        LanguageManager langMgr = scriptHelper.getService(LanguageManager.class);
        if (langMgr == null) {
            return null;
        }
        return langMgr.getLanguage(resource);
    }

    private static enum Source {
        STATIC,
        PAGE,
        REQUEST,
        AUTO;

    }
}

