/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.resource.details;

import com.day.cq.commons.LabeledResource;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.AssetReferenceResolver;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.dam.commons.util.UIHelper;
import com.day.cq.wcm.commons.ReferenceSearch;
import com.day.cq.wcm.resource.details.ResourceDetails;
import com.day.text.Text;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONObject;

public class AssetDetails
implements ResourceDetails {
    final String ASSET_PROPERTY_METADATA = "jcr:content/metadata";
    final String ASSET_PROPERTY_COMMENTS = "jcr:content/comments";
    private Resource resource;
    private Asset asset;
    private Node assetNode;

    public AssetDetails(Resource resource) {
        if (resource == null) {
            throw new IllegalArgumentException("Resource may not be null!");
        }
        this.resource = resource;
        this.assetNode = resource.adaptTo(Node.class);
        this.asset = resource.adaptTo(Asset.class);
    }

    public Node getAssetNode() {
        return this.assetNode;
    }

    public Asset getAsset() {
        return this.asset;
    }

    @Override
    public String getName() throws RepositoryException {
        return this.asset.getName();
    }

    @Override
    public long getLastModified() throws RepositoryException {
        long assetLastModification = this.asset.getLastModified();
        ValueMap vm = this.resource.adaptTo(ValueMap.class);
        if (assetLastModification == 0L) {
            Calendar created = (Calendar)((Object)vm.get("jcr:created", Calendar.class));
            assetLastModification = null != created ? created.getTimeInMillis() : 0L;
        }
        return assetLastModification;
    }

    public String getMimeType() {
        return this.asset.getMimeType() != null ? this.asset.getMimeType() : null;
    }

    @Override
    public int getReferencesSize(AssetReferenceResolver customResolver) throws RepositoryException {
        int assetReferencesCount = 0;
        Collection<ReferenceSearch.Info> resultSet = new ReferenceSearch().search(this.resource.getResourceResolver(), this.assetNode.getPath()).values();
        if (resultSet != null) {
            Iterator<ReferenceSearch.Info> it = resultSet.iterator();
            while (it.hasNext()) {
                ReferenceSearch.Info infoItem = it.next();
                Resource contentRes = infoItem.getPage().getContentResource();
                if (contentRes == null || !contentRes.getResourceType().equals("mac/components/boardpage")) continue;
                it.remove();
            }
            assetReferencesCount = resultSet.size();
        }
        if (customResolver != null) {
            HashMap referencesInfo = new HashMap();
            assetReferencesCount += customResolver.getReferences(this.assetNode.getPath(), this.resource.getResourceResolver()).size();
        }
        return assetReferencesCount;
    }

    @Override
    public int getCommentsSize() throws RepositoryException {
        int commentsCount = 0;
        if (this.assetNode.hasNode("jcr:content/comments")) {
            Node commentsNode = this.assetNode.getNode("jcr:content/comments");
            NodeIterator it = commentsNode.getNodes();
            while (it.hasNext()) {
                ++commentsCount;
                it.next();
            }
        }
        return commentsCount;
    }

    public String getThumbnailUrl() {
        String thumbnailUrl = "";
        Rendition thumbnailRendition = UIHelper.getBestfitRendition(this.asset, 319);
        thumbnailUrl = this.getMimeType() != null && this.getMimeType().startsWith("Multipart/Related") && !this.getMimeType().contains("application/x-CarouselSet") ? this.asset.getPath() + ".folderthumbnail.jpg" : (thumbnailRendition != null ? thumbnailRendition.getPath() : this.asset.getPath() + ".thumb.319.319.png");
        thumbnailUrl = Text.escapePath(thumbnailUrl);
        return thumbnailUrl;
    }

    public long getWidth() throws RepositoryException {
        long width = 0L;
        if (this.assetNode.hasNode("jcr:content/metadata")) {
            Node metadataNode = this.assetNode.getNode("jcr:content/metadata");
            try {
                width = Long.valueOf(DamUtil.getValue(metadataNode, "tiff:ImageWidth", DamUtil.getValue(metadataNode, "exif:PixelXDimension", "")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return width;
    }

    public long getHeight() throws RepositoryException {
        long height = 0L;
        if (this.assetNode.hasNode("jcr:content/metadata")) {
            Node metadataNode = this.assetNode.getNode("jcr:content/metadata");
            try {
                height = Long.valueOf(DamUtil.getValue(metadataNode, "tiff:ImageLength", DamUtil.getValue(metadataNode, "exif:PixelYDimension", "")));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return height;
    }

    public String getSize() {
        return this.asset.getOriginal() != null ? UIHelper.getSizeLabel(this.asset.getOriginal().getSize()) : "0.0 B";
    }

    public String getResolution() throws RepositoryException {
        long width = this.getWidth();
        long height = this.getHeight();
        return width != 0L && height != 0L ? width + " x " + height : "";
    }

    public String getDescription() throws RepositoryException {
        Asset asset = this.resource.adaptTo(Asset.class);
        if (asset != null) {
            Node metadataNode = this.assetNode.getNode("jcr:content/metadata");
            return DamUtil.getValue(metadataNode, "dc:description", this.resource.getName());
        }
        LabeledResource lr = this.resource.adaptTo(LabeledResource.class);
        if (lr != null) {
            return lr.getDescription() != null ? lr.getDescription() : "";
        }
        return this.resource.getName();
    }

    public String getParamJSON() throws RepositoryException {
        JSONObject param = new JSONObject();
        if (this.assetNode.hasNode("jcr:content/metadata")) {
            Node metadataNode = this.assetNode.getNode("jcr:content/metadata");
            try {
                String imageMap = DamUtil.getValue(metadataNode, "imageMap", "");
                if (StringUtils.isEmpty(imageMap)) {
                    param.put("./imageMap@Delete", "");
                } else {
                    param.put("./imageMap", imageMap);
                }
                param.put("./imageCrop@Delete", "");
                param.put("./imageRotate@Delete", "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return param.toString();
    }
}

