/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.msm.commons;

import com.day.cq.wcm.msm.api.RolloutManager;
import com.day.cq.wcm.msm.commons.BaseAction;
import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;

public class ItemFilterImpl {
    private final Set<Pattern> nodeTypePattern;
    private final Set<Pattern> nodePattern;
    private final Set<Pattern> propPattern;
    private final RolloutManager rolloutManager;
    private final ItemFilterImpl defaultFilter;

    private ItemFilterImpl(RolloutManager rolloutManager) {
        this(null, null, null, rolloutManager, null);
    }

    ItemFilterImpl(Set<Pattern> nodeTypePattern, Set<Pattern> nodePattern, Set<Pattern> propPattern, RolloutManager rolloutManager) {
        this(nodeTypePattern, nodePattern, propPattern, rolloutManager, new RolloutManagerFilter(rolloutManager));
    }

    ItemFilterImpl(Set<Pattern> nodeTypePattern, Set<Pattern> nodePattern, Set<Pattern> propPattern, RolloutManager rolloutManager, ItemFilterImpl defaultFilter) {
        this.nodeTypePattern = nodeTypePattern;
        this.nodePattern = nodePattern;
        this.propPattern = propPattern;
        this.rolloutManager = rolloutManager;
        this.defaultFilter = defaultFilter;
    }

    public boolean excludes(Property property) throws RepositoryException {
        PropertyDefinition pd = property.getDefinition();
        if (pd.isProtected() || pd.isAutoCreated()) {
            return true;
        }
        if (this.propPattern.isEmpty()) {
            return this.defaultFilter.excludes(property);
        }
        String name = property.getName();
        return this.excludes(property.getParent()) || this.rolloutManager.isReservedProperty(name) || this.matchName(name, this.propPattern);
    }

    public boolean excludes(Node node) throws RepositoryException {
        boolean excludes;
        String name = node.getName();
        boolean bl = excludes = node.getDefinition().isProtected() || this.rolloutManager.isReservedProperty(name) || this.excludesNodeType(node.getPrimaryNodeType()) || this.excludesNodeType(node.getMixinNodeTypes());
        if (!excludes) {
            Set<Pattern> pattern = this.nodePattern == null ? this.defaultFilter.getNodeNamePattern() : this.nodePattern;
            excludes = this.matchName(name, pattern);
        }
        return excludes;
    }

    public boolean excludesNodeType(String nodeTypeName) {
        if (this.nodeTypePattern.isEmpty()) {
            return this.defaultFilter.excludesNodeType(nodeTypeName);
        }
        return this.matchName(nodeTypeName, this.nodeTypePattern);
    }

    public Set<Pattern> getNodeTypePattern() {
        return Collections.unmodifiableSet(this.nodeTypePattern);
    }

    public Set<Pattern> getNodeNamePattern() {
        return Collections.unmodifiableSet(this.nodePattern);
    }

    public Set<Pattern> getPropertyNamePattern() {
        return Collections.unmodifiableSet(this.propPattern);
    }

    private boolean excludesNodeType(NodeType ... nodeTypes) {
        boolean excludes = false;
        for (int i = 0; !excludes && i < nodeTypes.length; ++i) {
            NodeType nodeType = nodeTypes[i];
            excludes = this.excludesNodeType(nodeType.getName()) || this.excludesNodeType(nodeType.getSupertypes());
        }
        return excludes;
    }

    private boolean matchName(String name, Set<Pattern> patterns) {
        if (patterns != null) {
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(name).matches()) continue;
                return true;
            }
        }
        return false;
    }

    private static final class RolloutManagerFilter
    extends ItemFilterImpl {
        private final RolloutManager rolloutManager;

        private RolloutManagerFilter(RolloutManager rolloutManager) {
            super(rolloutManager);
            this.rolloutManager = rolloutManager;
        }

        @Override
        public boolean excludes(Property property) throws RepositoryException {
            return this.rolloutManager.isReservedProperty(property.getName()) || this.rolloutManager.isExcludedProperty(BaseAction.isPage(property.getParent()), property.getName());
        }

        @Override
        public boolean excludes(Node node) throws RepositoryException {
            return this.rolloutManager.isExcludedNode(node) || !BaseAction.isPage(node) && this.rolloutManager.isExcludedParagraphProperty(node.getName());
        }

        @Override
        public boolean excludesNodeType(String nodeTypeName) {
            return this.rolloutManager.isExcludedNodeType(nodeTypeName);
        }
    }
}

