/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.utils.CharsetUtils;

public class StreamUtil {
    private static final Pattern HTTP_EQUIV_PATTERN = Pattern.compile("(?is)<meta\\s+http-equiv\\s*=\\s*['\\\"]\\s*Content-Type['\\\"]\\s+content\\s*=\\s*['\\\"]([^'\\\"]+)['\\\"]");
    private static final Pattern META_CHARSET_PATTERN = Pattern.compile("(?is)<meta\\s+charset\\s*=\\s*['\\\\\"]([^'\\\\\"]+)['\\\\\"]");
    private static final Pattern XHTML_ENCODING_PATTERN = Pattern.compile("(?is)<\\?xml.*encoding=\"([^\"]*)\".*\\?>");
    private static final int META_TAG_BUFFER_SIZE = 8192;

    public static String getEncoding(InputStream stream) throws IOException {
        stream.mark(8192);
        char[] buffer = new char[8192];
        InputStreamReader isr = new InputStreamReader(stream, "us-ascii");
        int bufferSize = isr.read(buffer);
        stream.reset();
        if (bufferSize != -1) {
            String charset;
            String metaString = new String(buffer, 0, bufferSize);
            Matcher m = HTTP_EQUIV_PATTERN.matcher(metaString);
            if (m.find()) {
                String[] attrs;
                for (String attr : attrs = m.group(1).split(";")) {
                    String charset2;
                    String[] keyValue = attr.trim().split("=");
                    if (keyValue.length != 2 || !keyValue[0].equalsIgnoreCase("charset") || !CharsetUtils.isSupported(charset2 = CharsetUtils.clean(keyValue[1]))) continue;
                    return charset2;
                }
            }
            if ((m = META_CHARSET_PATTERN.matcher(metaString)).find() && CharsetUtils.isSupported(charset = m.group(1))) {
                return charset;
            }
            m = XHTML_ENCODING_PATTERN.matcher(metaString);
            if (m.find() && CharsetUtils.isSupported(charset = m.group(1))) {
                return charset;
            }
        }
        return "UTF-8";
    }
}

