/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.parser.taghandlers;

import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.DesignImporterContext;
import com.day.cq.wcm.designimporter.UnsupportedTagContentException;
import com.day.cq.wcm.designimporter.api.EntryTagHandler;
import com.day.cq.wcm.designimporter.api.HTMLContentProvider;
import com.day.cq.wcm.designimporter.api.TagHandler;
import com.day.cq.wcm.designimporter.api.TagHandlerProvider;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import javax.jcr.RepositoryException;
import org.xml.sax.Attributes;

public class LinkTagHandler
implements TagHandler,
EntryTagHandler,
HTMLContentProvider {
    private String cssPath;
    private Boolean isAbsoluteStylesheet = false;
    private DesignImporterContext designImporterContext;

    @Override
    public void beginHandling(String uri, String localName, String qName, Attributes atts) {
        String relation = atts.getValue("rel");
        if ("stylesheet".equalsIgnoreCase(relation) && this.isSupportedMedia(atts) && (this.cssPath = atts.getValue("href")) != null) {
            if (this.isValidURL(this.cssPath)) {
                this.isAbsoluteStylesheet = true;
            } else {
                this.cssPath = this.cssPath.replaceAll("([^?]*)?.*", "$1");
                try {
                    if (!this.designImporterContext.designNode.hasNode(this.cssPath)) {
                        this.designImporterContext.importWarnings.add("Could not locate the referenced stylesheet '" + this.cssPath + "' in the design package");
                    }
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
            }
        }
    }

    private boolean isSupportedMedia(Attributes atts) {
        String media = atts.getValue("media");
        if (media == null || media.length() == 0) {
            return true;
        }
        return media.matches("(all|screen)");
    }

    private boolean isValidURL(String cssPath) {
        try {
            new URL(cssPath);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws DesignImportException {
        if (new String(ch, start, length).trim().length() > 0) {
            throw new UnsupportedTagContentException("047");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws DesignImportException {
        throw new UnsupportedTagContentException();
    }

    @Override
    public void endHandling(String uri, String localName, String qName) {
    }

    @Override
    public Object getContent(HTMLContentType htmlContentType) {
        if (htmlContentType == HTMLContentType.STYLESHEET_INCLUDE) {
            if (this.cssPath != null && this.cssPath.trim().length() > 0) {
                return Arrays.asList(this.cssPath);
            }
        } else if (htmlContentType == HTMLContentType.MARKUP) {
            return "<link rel='stylesheet' type='text/css' href='" + this.cssPath + "' />";
        }
        return null;
    }

    @Override
    public void setDesignImporterContext(DesignImporterContext designImporterContext) {
        this.designImporterContext = designImporterContext;
    }

    @Override
    public void setTagHandlerProvider(TagHandlerProvider tagHandlerProvider) {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        throw new UnsupportedTagContentException();
    }

    @Override
    public boolean supportsContent(HTMLContentType htmlContentType) {
        if (htmlContentType == HTMLContentType.STYLESHEET_INCLUDE) {
            return this.isAbsoluteStylesheet == false;
        }
        if (htmlContentType == HTMLContentType.MARKUP) {
            return this.isAbsoluteStylesheet;
        }
        return false;
    }
}

