/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.designimporter.parser.taghandlers;

import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.DesignImporterContext;
import com.day.cq.wcm.designimporter.UnsupportedTagContentException;
import com.day.cq.wcm.designimporter.api.EntryTagHandler;
import com.day.cq.wcm.designimporter.api.HTMLContentProvider;
import com.day.cq.wcm.designimporter.api.TagHandler;
import com.day.cq.wcm.designimporter.api.TagHandlerProvider;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;
import org.xml.sax.Attributes;

public class InlineScriptTagHandler
implements TagHandler,
EntryTagHandler,
HTMLContentProvider {
    private boolean isScriptPositionSpecific = false;
    private StringBuffer scriptBuffer = new StringBuffer();

    @Override
    public void beginHandling(String uri, String localName, String qName, Attributes atts) {
        String posSpecific = atts.getValue("data-cq-inline");
        if (posSpecific != null && posSpecific.equalsIgnoreCase("true")) {
            this.isScriptPositionSpecific = true;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws DesignImportException {
        String chars = new String(ch).substring(start, start + length);
        if (chars.length() > 0) {
            this.scriptBuffer.append(chars);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws DesignImportException {
        throw new UnsupportedTagContentException();
    }

    @Override
    public void endHandling(String uri, String localName, String qName) {
    }

    @Override
    public Object getContent(HTMLContentType htmlContentType) {
        if (htmlContentType == HTMLContentType.SCRIPT_INLINE) {
            return this.scriptBuffer.toString();
        }
        if (htmlContentType == HTMLContentType.MARKUP) {
            return "<script type='text/javascript'>" + this.scriptBuffer.toString() + "</script>";
        }
        return null;
    }

    @Override
    public void setDesignImporterContext(DesignImporterContext designImporterContext) {
    }

    @Override
    public void setTagHandlerProvider(TagHandlerProvider tagHandlerProvider) {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        throw new UnsupportedTagContentException();
    }

    @Override
    public boolean supportsContent(HTMLContentType htmlContentType) {
        if (htmlContentType == HTMLContentType.SCRIPT_INLINE) {
            return !this.isScriptPositionSpecific;
        }
        if (htmlContentType == HTMLContentType.MARKUP) {
            return this.isScriptPositionSpecific;
        }
        return false;
    }
}

