/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.commons;

import com.adobe.granite.toggle.api.ToggleRouter;
import com.day.cq.commons.predicate.AbstractResourcePredicate;
import com.day.cq.commons.predicates.ResourcePredicate;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import com.day.cq.wcm.commons.ReferenceSearch;
import com.day.cq.wcm.commons.UGCUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceSearchV1 {
    private static final String HREF_REGEX = "(href\\s*=\\s*)([\"']/*[^\"']*[\"'])";
    private static final String XF_PATH = "/experience-fragments";
    private static final String DAM_PATH = "/dam";
    private static final String DAM_PREFIX = "dam";
    private static final String XF_PREFIX = "experience-fragments";
    private static final String ASSETS_REGEX_PATTERN = ".*\\.(mp3|wav|ogg|flac|aac|m4a|wma|mp4|avi|mkv|mov|webm|flv|wmv|mpeg|mpg|3gp|amr|ogg|opus|jpg|jpeg|png|gif|bmp|tiff|svg|txt|doc|docx|pdf|xls|xlsx|csv)$";
    private static final String CT_SITES_26735 = "CT_SITES-26735";
    private static final String CT_SITES_26711 = "CT_SITES-26711";
    private static final String CT_SITES_25976 = "CT_SITES-25976";
    private static final String FT_FIX_BROKEN_CHILD_REFERENCES = "FT_SITES-29789";
    private ToggleRouter toggleRouter = this.getToggleRouter();
    private SlingRepository repository;
    private boolean isValidatePage = false;
    private static final Logger log = LoggerFactory.getLogger(ReferenceSearchV1.class);
    private String searchRoot = "/";
    private boolean exact = false;
    private boolean hollow = false;
    private int maxReferencesPerPage = -1;
    private ResourcePredicate resourcePredicate = null;
    private AbstractResourcePredicate oldResourcePredicate = null;
    private static final int DEFAULT_LIMIT = 100;
    private static final int DEFAULT_START_OFFSET = 0;
    static final String DEFAULT_SITES_INDEX_TAG = "wcmReferenceSearch";

    BundleContext getBundleContext() {
        return FrameworkUtil.getBundle(this.getClass()).getBundleContext();
    }

    private ToggleRouter getToggleRouter() {
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext == null) {
            return null;
        }
        ServiceReference ref = bundleContext.getServiceReference(ToggleRouter.class);
        return (ToggleRouter)bundleContext.getService(ref);
    }

    public ReferenceSearchV1 setRepository(SlingRepository repository) {
        this.repository = repository;
        return this;
    }

    public String getSearchRoot() {
        return this.searchRoot;
    }

    public ReferenceSearchV1 setSearchRoot(String searchRoot) {
        this.searchRoot = searchRoot == null || searchRoot.equals("") ? "/" : searchRoot;
        return this;
    }

    public boolean isExact() {
        return this.exact;
    }

    public ReferenceSearchV1 setExact(boolean exact) {
        this.exact = exact;
        return this;
    }

    public boolean isHollow() {
        return this.hollow;
    }

    public ReferenceSearchV1 setHollow(boolean hollow) {
        this.hollow = hollow;
        return this;
    }

    public int getMaxReferencesPerPage() {
        return this.maxReferencesPerPage;
    }

    public ReferenceSearchV1 setMaxReferencesPerPage(int maxReferencesPerPage) {
        this.maxReferencesPerPage = maxReferencesPerPage;
        return this;
    }

    public ReferenceSearchV1 setPredicate(ResourcePredicate resourcePredicate) {
        this.resourcePredicate = resourcePredicate;
        return this;
    }

    @Deprecated
    public ReferenceSearchV1 setPredicate(AbstractResourcePredicate resourcePredicate) {
        this.oldResourcePredicate = resourcePredicate;
        return this;
    }

    private Iterator<Resource> buildQueryAndFetchResults(ResourceResolver resolver, String root, List<String> pathList, int offset, int limit, String nodeType) {
        QueryBuilder queryBuilder = resolver.adaptTo(QueryBuilder.class);
        HashMap<String, String> map = new HashMap<String, String>();
        if (offset < 0) {
            offset = 0;
        }
        if (limit <= 0) {
            limit = 100;
        }
        if (!root.trim().isEmpty()) {
            map.put("path", root);
        }
        if (nodeType != null && !nodeType.trim().isEmpty()) {
            map.put("type", "cq:Page");
        }
        map.put("p.guessTotal", "true");
        map.put("p.offset", String.valueOf(offset));
        map.put("p.limit", String.valueOf(limit));
        map.put("p.indexTag", DEFAULT_SITES_INDEX_TAG);
        int index = 1;
        for (String resourcePath : pathList) {
            if (resourcePath.trim().isEmpty()) continue;
            String predicateKey = String.format("group.%s_fulltext", index);
            map.put(predicateKey, resourcePath);
            ++index;
        }
        map.put("group.p.or", "true");
        Query query = queryBuilder.createQuery(PredicateGroup.create(map), resolver.adaptTo(Session.class));
        SearchResult result = query.getResult();
        return result.getResources();
    }

    public List<Page> findPageReferencesForResource(ResourceResolver resolver, String path, int limit, int offset) {
        if (path == null) {
            return Collections.emptyList();
        }
        ArrayList<Page> pageReferences = new ArrayList<Page>();
        String root = this.searchRoot.equals("/") ? "" : this.searchRoot;
        PageManager manager = resolver.adaptTo(PageManager.class);
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        ArrayList<String> pathList = new ArrayList<String>();
        this.prepareQueryInputs(patternList, pathList, path);
        Iterator<Resource> resources = this.buildQueryAndFetchResults(resolver, root, pathList, offset, limit, "cq:Page");
        resources.forEachRemaining(res -> {
            Page page = manager.getContainingPage((Resource)res);
            pageReferences.add(page);
            if (this.resourcePredicate != null && !this.resourcePredicate.test(res)) {
                pageReferences.remove(page);
            } else if (this.oldResourcePredicate != null && !this.oldResourcePredicate.evaluate((Resource)res)) {
                pageReferences.remove(page);
            }
        });
        return pageReferences;
    }

    public Map<String, ReferenceSearch.Info> search(ResourceResolver resolver, String path, int limit, int offset) {
        if (path == null) {
            return Collections.emptyMap();
        }
        String root = this.searchRoot.equals("/") ? "" : this.searchRoot;
        PageManager manager = resolver.adaptTo(PageManager.class);
        HashMap<String, ReferenceSearch.Info> infos = new HashMap<String, ReferenceSearch.Info>();
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        ArrayList<String> pathList = new ArrayList<String>();
        this.prepareQueryInputs(patternList, pathList, path);
        Iterator<Resource> resources = this.buildQueryAndFetchResults(resolver, root, pathList, offset, limit, null);
        this.processResultset(resources, manager, infos, patternList);
        return infos;
    }

    private void prepareQueryInputs(List<Pattern> patternList, List<String> pathList, String path) {
        Pattern pattern = this.getSearchPattern(path);
        String qPath = ReferenceSearchV1.escapeIllegalXpathSearchChars(path);
        patternList.add(pattern);
        pathList.add(qPath);
        String escPath = Text.escapePath(path);
        if (!escPath.equals(path)) {
            Pattern escPattern = this.getSearchPattern(escPath);
            String qEscPath = ReferenceSearchV1.escapeIllegalXpathSearchChars(escPath);
            patternList.add(escPattern);
            pathList.add(qEscPath);
            escPath = this.escapePathUsingUpperCaseHex(path);
            Pattern escUppercasePattern = this.getSearchPattern(escPath);
            String qEscUppercasePath = ReferenceSearchV1.escapeIllegalXpathSearchChars(escPath);
            patternList.add(escUppercasePattern);
            pathList.add(qEscUppercasePath);
            if (escPath.contains("%26")) {
                escPath = escPath.replaceAll("%26", "&amp;");
                Pattern htmlEncodedescPattern = this.getSearchPattern(escPath);
                String qHtmlEncodeescPath = ReferenceSearchV1.escapeIllegalXpathSearchChars(escPath);
                patternList.add(htmlEncodedescPattern);
                pathList.add(qHtmlEncodeescPath);
            }
        }
    }

    public Map<String, ReferenceSearch.Info> search(ResourceResolver resolver, String path) {
        if (path == null) {
            return Collections.emptyMap();
        }
        String root = this.searchRoot.equals("/") ? "" : this.searchRoot;
        PageManager manager = resolver.adaptTo(PageManager.class);
        HashMap<String, ReferenceSearch.Info> infos = new HashMap<String, ReferenceSearch.Info>();
        Pattern pattern = this.getSearchPattern(path);
        String qPath = ReferenceSearchV1.escapeIllegalXpathSearchChars(path);
        String query = String.format("%s//*[jcr:contains(., '\"%s\"')]", root, qPath);
        this.search(resolver, manager, infos, pattern, query);
        String escPath = Text.escapePath(path);
        if (!escPath.equals(path)) {
            Pattern escPattern = this.getSearchPattern(escPath);
            String qEscPath = ReferenceSearchV1.escapeIllegalXpathSearchChars(escPath);
            query = String.format("%s//*[jcr:contains(., '%s')]", root, qEscPath);
            this.search(resolver, manager, infos, escPattern, query);
            escPath = this.escapePathUsingUpperCaseHex(path);
            escPattern = this.getSearchPattern(escPath);
            qEscPath = ReferenceSearchV1.escapeIllegalXpathSearchChars(escPath);
            query = String.format("%s//*[jcr:contains(., '%s')]", root, qEscPath);
            this.search(resolver, manager, infos, escPattern, query);
            if (escPath.contains("%26")) {
                escPath = escPath.replaceAll("%26", "&amp;");
                escPattern = this.getSearchPattern(escPath);
                qEscPath = ReferenceSearchV1.escapeIllegalXpathSearchChars(escPath);
                query = String.format("%s//*[jcr:contains(., '%s')]", root, qEscPath);
                this.search(resolver, manager, infos, escPattern, query);
            }
        }
        return infos;
    }

    private void filterResultset(Map<String, ReferenceSearch.Info> infos) {
        Iterator<Map.Entry<String, ReferenceSearch.Info>> entries = infos.entrySet().iterator();
        while (entries.hasNext()) {
            Resource pageResource;
            Map.Entry<String, ReferenceSearch.Info> entry = entries.next();
            if (entry.getValue().getProperties().isEmpty()) {
                entries.remove();
                continue;
            }
            if (this.resourcePredicate == null && this.oldResourcePredicate == null || entry.getValue().page == null || (pageResource = entry.getValue().page.adaptTo(Resource.class)) == null) continue;
            if (this.resourcePredicate != null && !this.resourcePredicate.test(pageResource)) {
                entries.remove();
                continue;
            }
            if (this.oldResourcePredicate == null || this.oldResourcePredicate.evaluate(pageResource)) continue;
            entries.remove();
        }
    }

    private String escapePathUsingUpperCaseHex(String string) {
        try {
            BitSet validChars = Text.URISaveEx;
            int escape = 37;
            char[] hexTable = "0123456789ABCDEF".toCharArray();
            byte[] bytes = string.getBytes("utf-8");
            StringBuilder out = new StringBuilder(bytes.length);
            for (byte aByte : bytes) {
                int c = aByte & 0xFF;
                if (validChars.get(c) && c != escape) {
                    out.append((char)c);
                    continue;
                }
                out.append((char)escape);
                out.append(hexTable[c >> 4 & 0xF]);
                out.append(hexTable[c & 0xF]);
            }
            return out.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError(e.toString());
        }
    }

    private void search(ResourceResolver resolver, PageManager manager, Map<String, ReferenceSearch.Info> infos, Pattern pattern, String query) {
        query = query.concat(" option(index tag wcmReferenceSearch)");
        log.debug("Searching for references using: {}", (Object)query);
        Iterator<Resource> iter = null;
        try {
            iter = resolver.findResources(query, "xpath");
        }
        catch (SlingException e) {
            log.warn("error finding resources", e);
            return;
        }
        ArrayList<Pattern> patternList = new ArrayList<Pattern>();
        patternList.add(pattern);
        this.processResultset(iter, manager, infos, patternList);
    }

    private void processResultset(Iterator<Resource> iter, PageManager manager, Map<String, ReferenceSearch.Info> infos, List<Pattern> patternList) {
        log.debug("processing the search results and building the result set");
        while (iter.hasNext()) {
            Resource res = iter.next();
            Page page = manager.getContainingPage(res);
            if (page == null) continue;
            ReferenceSearch.Info info = infos.get(page.getPath());
            if (info == null) {
                info = new ReferenceSearch.Info(page, this.hollow);
                infos.put(page.getPath(), info);
            }
            try {
                Node node = res.adaptTo(Node.class);
                PropertyIterator pIter = node.getProperties();
                block3: while (pIter.hasNext() && (this.getMaxReferencesPerPage() < 0 || info.getProperties().size() < this.getMaxReferencesPerPage())) {
                    Property p = pIter.nextProperty();
                    if (p.getType() != 1 && p.getType() != 7) continue;
                    if (p.isMultiple()) {
                        for (Value v : p.getValues()) {
                            String value = v.getString();
                            if (!this.isPatternMatched(patternList, value)) continue;
                            info.addProperty(p.getPath());
                            continue block3;
                        }
                        continue;
                    }
                    String value = p.getString();
                    if (!this.isPatternMatched(patternList, value)) continue;
                    info.addProperty(p.getPath());
                }
            }
            catch (RepositoryException e) {
                log.error("Error while accessing " + res.getPath(), e);
            }
        }
        this.filterResultset(infos);
    }

    private boolean isPatternMatched(List<Pattern> patternList, String value) {
        boolean isPatternMatched = false;
        for (Pattern pattern : patternList) {
            isPatternMatched = pattern.matcher(value).find();
            if (!isPatternMatched) continue;
            return isPatternMatched;
        }
        return isPatternMatched;
    }

    public Collection<String> adjustReferences(ResourceResolver resolver, String path, String destination, String[] refPaths) {
        if (refPaths == null) {
            return Collections.emptyList();
        }
        HashSet<String> adjusted = new HashSet<String>();
        for (String p : refPaths) {
            Resource content;
            Resource r = resolver.getResource(p);
            if (r == null) {
                log.warn("Given path does not address a resource: {}", (Object)p);
                continue;
            }
            Page page = r.adaptTo(Page.class);
            if (page == null) {
                log.warn("Given path does not address a page: {}", (Object)p);
            }
            Resource resource = content = page != null ? page.getContentResource() : null;
            if (content == null) {
                log.warn("Given page does not have content: {}", (Object)p);
            }
            try {
                Node node = content != null ? content.adaptTo(Node.class) : r.adaptTo(Node.class);
                adjusted.addAll(this.adjustReferences(node, path, destination));
            }
            catch (RepositoryException e) {
                log.error("Error while adjusting references on " + r.getPath(), e);
            }
            try {
                String adjustedUGCPath = this.adjustUserGeneratedContentReference(r, path, destination);
                if (adjustedUGCPath == null) continue;
                adjusted.add(adjustedUGCPath);
                log.info("Adjusted user generated content path {}.", (Object)adjustedUGCPath);
            }
            catch (Exception e) {
                log.error("Error while adjusting user generated references on " + r.getPath(), e);
            }
        }
        PageManager pm = resolver.adaptTo(PageManager.class);
        for (String pathOfAdjusted : adjusted) {
            Resource adjustedResource = resolver.getResource(pathOfAdjusted);
            if (null == adjustedResource) continue;
            Page adjustedPage = pm.getContainingPage(adjustedResource);
            if (null != adjustedPage) {
                try {
                    pm.touch(adjustedPage.adaptTo(Node.class), true, Calendar.getInstance(), false);
                }
                catch (WCMException e) {
                    log.error("could not update last modified on adjusted page [{}]: ", (Object)adjustedPage.getPath(), (Object)e);
                }
            }
            this.touchIfContentFragmentReference(pathOfAdjusted, resolver);
        }
        try {
            resolver.commit();
        }
        catch (PersistenceException e) {
            log.error("Error while adjusting references.", e);
        }
        return adjusted;
    }

    private void touchIfContentFragmentReference(String adjustedPath, ResourceResolver resolver) {
        Resource contentRes;
        int lastIndexOfDelimiter = adjustedPath.lastIndexOf(this.searchRoot);
        String possibleCFRefPath = adjustedPath.substring(0, lastIndexOfDelimiter);
        Resource adjustedResource = resolver.getResource(possibleCFRefPath);
        if (adjustedResource != null && adjustedResource.getParent() != null && adjustedResource.getParent().getName().equals("data") && (contentRes = adjustedResource.getParent().getParent()) != null && contentRes.getName().equals("jcr:content")) {
            Boolean isContentFragment = (Boolean)((Object)contentRes.getValueMap().get("contentFragment", Boolean.class));
            this.touchCFLastModified(resolver, contentRes, isContentFragment);
        }
    }

    private void touchCFLastModified(ResourceResolver resolver, Resource contentRes, Boolean isContentFragment) {
        if (isContentFragment != null && isContentFragment.booleanValue()) {
            ModifiableValueMap properties = contentRes.adaptTo(ModifiableValueMap.class);
            if (properties != null) {
                properties.put("jcr:lastModified", Calendar.getInstance());
                properties.put("jcr:lastModifiedBy", resolver.getUserID());
                properties.put("lastFragmentSave", Calendar.getInstance());
            } else {
                log.warn("Cannot adapt " + contentRes.getPath() + " to ModifiableValueMap.");
                throw new IllegalStateException("properties should not be null, check logs for further investigation");
            }
        }
    }

    public Collection<String> adjustReferences(Node node, String path, String destination) throws RepositoryException {
        return this.adjustReferences(node, path, destination, false, Collections.emptySet(), null, false);
    }

    public Collection<String> adjustReferences(Node node, String path, String destination, boolean shallow, Set<String> excludedProperties) throws RepositoryException {
        return this.adjustReferences(node, path, destination, shallow, excludedProperties, null, false);
    }

    public Collection<String> adjustReferences(Node node, String path, String destination, boolean withoutChildNodes, ResourceResolver resolver) throws RepositoryException {
        return this.adjustReferences(node, path, destination, false, Collections.emptySet(), resolver, withoutChildNodes);
    }

    public Collection<String> adjustReferences(Node node, String path, String destination, boolean shallow, Set<String> excludedProperties, ResourceResolver resolver, boolean withoutChildNodes) throws RepositoryException {
        String escDest;
        Pattern pattern;
        HashSet<String> adjusted = new HashSet<String>();
        if (this.toggleRouter != null && (this.toggleRouter.isEnabled(CT_SITES_26711) || this.toggleRouter.isEnabled(CT_SITES_25976))) {
            pattern = this.getReplacementPatternGeneric(path, destination);
            escDest = this.getGenericPath(Text.escapePath(destination), path);
        } else {
            pattern = this.getReplacementPattern(path);
            escDest = Text.escapePath(destination);
        }
        RangeIterator iter = node.getProperties();
        while (iter.hasNext()) {
            String value;
            Property p = iter.nextProperty();
            if ((excludedProperties.contains(p.getName()) || p.getType() != 1) && p.getType() != 7 && p.getType() != 8) continue;
            if (p.isMultiple()) {
                Value[] values = p.getValues();
                boolean modified = false;
                for (int i = 0; i < values.length; ++i) {
                    String value2 = this.rewrite(values[i].getString(), path, pattern, destination, escDest, resolver, withoutChildNodes);
                    if (value2 == null) continue;
                    values[i] = node.getSession().getValueFactory().createValue(value2, p.getType());
                    modified = true;
                }
                if (!modified) continue;
                p.setValue(values);
                adjusted.add(p.getPath());
                log.info("Adjusted property {}.", (Object)p.getPath());
                continue;
            }
            if (this.toggleRouter != null && this.toggleRouter.isEnabled(CT_SITES_25976)) {
                if (this.toggleRouter.isEnabled(CT_SITES_26735)) {
                    String alternativeValue;
                    value = this.rewriteWithGenericPattern(p.getString(), path, pattern, destination, escDest, resolver, withoutChildNodes);
                    if (!Objects.equals(value, alternativeValue = this.rewrite(p.getString(), path, pattern, destination, escDest, resolver, withoutChildNodes))) {
                        log.debug("CT_SITES-25976 and CT_SITES-26735 enabled different value: new algorithm: {} old algorithm: {}.", (Object)value, (Object)alternativeValue);
                    }
                } else if (p.getString().matches(ASSETS_REGEX_PATTERN)) {
                    value = this.rewrite(p.getString(), path, pattern, destination, escDest, resolver, withoutChildNodes);
                } else {
                    String alternativeValue;
                    value = this.rewriteWithGenericPattern(p.getString(), path, pattern, destination, escDest, resolver, withoutChildNodes);
                    if (!Objects.equals(value, alternativeValue = this.rewrite(p.getString(), path, pattern, destination, escDest, resolver, withoutChildNodes))) {
                        log.debug("CT_SITES-25976 enabled CT_SITES-26735 disabled different value: new algorithm: {} old algorithm: {}.", (Object)value, (Object)alternativeValue);
                    }
                }
            } else {
                value = this.rewrite(p.getString(), path, pattern, destination, escDest, resolver, withoutChildNodes);
            }
            if (value == null) continue;
            p.setValue(value);
            adjusted.add(p.getPath());
            log.info("Adjusted property {}.", (Object)p.getPath());
        }
        if (!shallow) {
            iter = node.getNodes();
            while (iter.hasNext()) {
                adjusted.addAll(this.adjustReferences(iter.nextNode(), path, destination, shallow, excludedProperties, resolver, withoutChildNodes));
            }
        }
        return adjusted;
    }

    private String adjustUserGeneratedContentReference(Resource resource, String path, String destination) throws RepositoryException, WCMException {
        String ugcPath = resource.getPath();
        if (ugcPath.startsWith("/content/usergenerated" + path)) {
            String newUgcPath = ugcPath.replaceFirst(path, destination);
            ResourceResolver resolver = resource.getResourceResolver();
            Resource newUgcResource = resolver.resolve(newUgcPath);
            if (ResourceUtil.isNonExistingResource(newUgcResource)) {
                PageManager pageManager = resolver.adaptTo(PageManager.class);
                String newUgcParentPath = Text.getRelativeParent(UGCUtil.UGCToResourcePath(newUgcResource), 1);
                UGCUtil.prepareUserGeneratedContent(resolver, newUgcParentPath);
                pageManager.move(resource, newUgcPath, Text.getName(resource.getPath()), true, true, new String[0]);
                return newUgcPath;
            }
        }
        return null;
    }

    protected Pattern getSearchPattern(String path) {
        if (this.exact) {
            return Pattern.compile("([\"']|^)(" + Pattern.quote(path) + ")([;.?#\"']|$)");
        }
        return Pattern.compile("([\"']|^)(" + Pattern.quote(path) + ")([;.?#\"'/](.*)|$)");
    }

    protected Pattern getReplacementPattern(String path) {
        String escPath = Text.escapePath(path);
        String literal = Pattern.quote(path);
        if (!escPath.equals(path)) {
            literal = literal + "|" + Pattern.quote(escPath);
            escPath = this.escapePathUsingUpperCaseHex(path);
            literal = literal + "|" + Pattern.quote(escPath);
            if (escPath.contains("%26")) {
                literal = literal + "|" + Pattern.quote(escPath.replaceAll("%26", "&amp;"));
            }
        }
        if (this.exact) {
            return Pattern.compile("([\"'])(" + literal + ")([;.?#\"'])");
        }
        return Pattern.compile("([\"'])(" + literal + ")([;.?#\"'/])");
    }

    Pattern getReplacementPatternGeneric(String path, String destination) {
        String genericPath = this.getGenericPath(path, destination);
        String escPath = Text.escapePath(genericPath);
        String literal = Pattern.quote(genericPath);
        if (!escPath.equals(genericPath)) {
            literal = literal + "|" + Pattern.quote(escPath);
            escPath = this.escapePathUsingUpperCaseHex(genericPath);
            literal = literal + "|" + Pattern.quote(escPath);
            if (escPath.contains("%26")) {
                literal = literal + "|" + Pattern.quote(escPath.replaceAll("%26", "&amp;"));
            }
        }
        if (this.exact) {
            return Pattern.compile("([\"'])(" + literal + ")([;.?#\"'])");
        }
        return Pattern.compile("([\"'])(" + literal + ")([;.?#\"'/])");
    }

    String getGenericPath(String path, String destination) {
        String contentSitePath = this.replaceXFAndCFFolderName(path);
        String contentSiteDestination = this.replaceXFAndCFFolderName(destination);
        String[] splitPath = contentSitePath.split("/");
        int lastIndexOfDifferent = ReferenceSearchV1.getLastIndexOfDifferent(contentSiteDestination, splitPath);
        String exactUrlPart = "/" + splitPath[lastIndexOfDifferent];
        if (lastIndexOfDifferent != splitPath.length - 1) {
            exactUrlPart = "/" + splitPath[lastIndexOfDifferent] + "/";
        }
        return String.join((CharSequence)"/", Arrays.copyOfRange(splitPath, 0, lastIndexOfDifferent + 1));
    }

    private static int getLastIndexOfDifferent(String contentSiteDestination, String[] splitPath) {
        String[] splitDestination = contentSiteDestination.split("/");
        int lastIndexOfDifferent = 0;
        int splitDestinationIndex = splitDestination.length - 1;
        int lengthDifferent = Math.max(splitPath.length, splitDestination.length) - Math.min(splitPath.length, splitDestination.length);
        for (int i = splitPath.length - 1; i >= 0; --i) {
            if (!splitPath[i].equals(splitDestination[splitDestinationIndex])) {
                lastIndexOfDifferent = i;
                break;
            }
            --splitDestinationIndex;
        }
        if (lengthDifferent > 0) {
            lastIndexOfDifferent = lastIndexOfDifferent + lengthDifferent >= splitPath.length ? splitPath.length - 1 : (lastIndexOfDifferent += lengthDifferent);
        }
        return lastIndexOfDifferent;
    }

    String replaceXFAndCFFolderName(String path) {
        if (path.contains(XF_PATH)) {
            path = path.replace(XF_PATH, "");
        }
        if (path.contains(DAM_PATH)) {
            path = path.replace(DAM_PATH, "");
        }
        return path;
    }

    String rewriteWithGenericPattern(String value, String from, Pattern p, String to, String escTo, ResourceResolver resolver, boolean withoutChildNodes) {
        boolean isAssetOrXF;
        if (value == null) {
            return null;
        }
        String genericFrom = from;
        if (from != null && to != null) {
            genericFrom = this.getGenericPath(from, to);
        }
        Pattern effectivePattern = this.getReplacementPatternGeneric(genericFrom, to);
        String safeTo = to != null ? Matcher.quoteReplacement(to) : null;
        String safeEscTo = escTo != null ? Matcher.quoteReplacement(escTo) : null;
        String[] parts = value.split("/");
        String escapeItem = null;
        int indexOfEscape = -1;
        for (int i = 0; i < parts.length; ++i) {
            if (!DAM_PREFIX.equals(parts[i]) && !XF_PREFIX.equals(parts[i])) continue;
            escapeItem = parts[i];
            indexOfEscape = i;
            break;
        }
        boolean bl = isAssetOrXF = indexOfEscape > 0;
        if (isAssetOrXF) {
            String replacement;
            String stripped = value.replaceFirst("/" + Pattern.quote(escapeItem), "");
            String rewritten = this.rewrite(stripped, genericFrom, effectivePattern, replacement = safeEscTo != null ? safeEscTo : safeTo, safeEscTo, resolver, withoutChildNodes);
            if (rewritten == null) {
                return value;
            }
            String[] rewriteArray = rewritten.split("/");
            StringBuilder resultSB = new StringBuilder();
            for (int i = 0; i < rewriteArray.length; ++i) {
                if (i == indexOfEscape) {
                    resultSB.append("/").append(escapeItem);
                }
                if (i != 0) {
                    resultSB.append("/");
                }
                resultSB.append(rewriteArray[i]);
            }
            return resultSB.toString();
        }
        boolean useGenericReplacement = genericFrom != null && !genericFrom.equals(from);
        String replacement = useGenericReplacement ? safeEscTo : safeTo;
        return this.rewrite(value, genericFrom, effectivePattern, replacement, safeEscTo, resolver, withoutChildNodes);
    }

    protected String rewrite(String value, String from, Pattern p, String to, String escTo) {
        return this.rewrite(value, from, p, to, escTo, null, false);
    }

    protected String rewrite(String value, String from, Pattern p, String to, String escTo, ResourceResolver resolver, boolean withoutChildNodes) {
        if (value.equals(from)) {
            return to;
        }
        if (value.startsWith(from + "#") || value.startsWith(from + ".html")) {
            return to + value.substring(from.length());
        }
        if (!this.exact && value.startsWith(from + "/")) {
            String newPath = to + value.substring(from.length());
            if (this.toggleRouter != null && this.toggleRouter.isEnabled(FT_FIX_BROKEN_CHILD_REFERENCES)) {
                if (!withoutChildNodes) {
                    return newPath;
                }
                return value;
            }
            return newPath;
        }
        if (resolver != null && this.isValidatePage) {
            return ReferenceSearchV1.replaceEscapedReferencesRTEWithValidHref(value, p, escTo, resolver, withoutChildNodes);
        }
        return ReferenceSearchV1.replaceEscapedReferencesRTE(value, p, escTo);
    }

    private static String replaceEscapedReferencesRTE(String value, Pattern p, String escTo) {
        Matcher m = p.matcher(value);
        StringBuffer ret = null;
        String repl = "$1" + escTo + "$3";
        while (m.find()) {
            if (ret == null) {
                ret = new StringBuffer();
            }
            m.appendReplacement(ret, repl);
        }
        if (ret == null) {
            return null;
        }
        m.appendTail(ret);
        return ret.toString();
    }

    private static String replaceEscapedReferencesRTEWithValidHref(String value, Pattern p, String escTo, ResourceResolver resolver, boolean withoutChildNodes) {
        HashMap<String, String> adjusted = new HashMap<String, String>();
        StringBuffer ret = null;
        Pattern pattern = Pattern.compile(HREF_REGEX);
        Matcher matcher = pattern.matcher(value);
        while (matcher.find()) {
            String href;
            if (ret == null) {
                ret = new StringBuffer();
            }
            if (!adjusted.containsKey(href = matcher.group(2))) {
                ReferenceSearchV1.updateAdjusted(p, escTo, resolver, withoutChildNodes, adjusted, href);
            }
            matcher.appendReplacement(ret, "$1" + Matcher.quoteReplacement((String)adjusted.get(href)));
        }
        if (ret == null) {
            return null;
        }
        matcher.appendTail(ret);
        return ret.toString();
    }

    private static void updateAdjusted(Pattern p, String escTo, ResourceResolver resolver, boolean withoutChildNodes, Map<String, String> adjusted, String href) {
        String newHref = ReferenceSearchV1.replaceEscapedReferencesRTE(href, p, escTo);
        if (newHref == null) {
            newHref = href;
        }
        if (href.equals(newHref)) {
            adjusted.put(href, href);
            return;
        }
        if (!withoutChildNodes) {
            adjusted.put(href, newHref);
            return;
        }
        Resource resource = resolver.resolve(newHref.replaceAll("^\"|\"$", ""));
        if (resource.getResourceType().equals("sling:nonexisting")) {
            adjusted.put(href, href);
        } else {
            adjusted.put(href, newHref);
        }
    }

    public static String escapeIllegalXpathSearchChars(String s) {
        StringBuffer sb = new StringBuffer();
        for (char c : s.toCharArray()) {
            if (c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '{' || c == '}' || c == '?' || c == '\"' || c == '\\' || c == ' ' || c == '~') {
                sb.append('\\');
            } else if (c == '\'') {
                sb.append(c);
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public ReferenceSearchV1 setValidatePage(boolean validatePage) {
        this.isValidatePage = validatePage;
        return this;
    }
}

