/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.commons;

import com.adobe.granite.toggle.api.ToggleRouter;
import com.day.cq.commons.predicate.AbstractResourcePredicate;
import com.day.cq.commons.predicates.ResourcePredicate;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.commons.ReferenceSearchV1;
import com.day.cq.wcm.commons.ReferenceSearchV2;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceSearch {
    private static final Logger log = LoggerFactory.getLogger(ReferenceSearch.class);
    public static final String DEFAULT_SITES_INDEX_TAG = "wcmReferenceSearch";
    private static final String FT_OPTIMIZED_REFERENCE_SEARCH = "FT_SITES-19306";
    private final ReferenceSearchV1 v1;
    private final ReferenceSearchV2 v2;
    private final ToggleRouter toggleRouter;

    public ReferenceSearch() {
        this(new ReferenceSearchV1(), new ReferenceSearchV2());
    }

    protected ReferenceSearch(ReferenceSearchV1 v1, ReferenceSearchV2 v2) {
        this.v1 = v1;
        this.v2 = v2;
        this.toggleRouter = this.getToggleRouter();
    }

    BundleContext getBundleContext() {
        try {
            return FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        }
        catch (Exception e) {
            log.warn("Could not get bundle context.", e);
            return null;
        }
    }

    private ToggleRouter getToggleRouter() {
        BundleContext bundleContext = this.getBundleContext();
        if (bundleContext == null) {
            log.warn("BundleContext is null, cannot get ToggleRouter service.");
            return null;
        }
        ServiceReference ref = bundleContext.getServiceReference(ToggleRouter.class);
        if (ref != null) {
            return (ToggleRouter)bundleContext.getService(ref);
        }
        log.warn("Could not get service reference for ToggleRouter.");
        return null;
    }

    private boolean useV2() {
        return this.toggleRouter != null && this.toggleRouter.isEnabled(FT_OPTIMIZED_REFERENCE_SEARCH);
    }

    @Deprecated
    public ReferenceSearch setRepository(SlingRepository repository) {
        this.v1.setRepository(repository);
        return this;
    }

    public String getSearchRoot() {
        return this.useV2() ? this.v2.getSearchRoot() : this.v1.getSearchRoot();
    }

    public ReferenceSearch setSearchRoot(String searchRoot) {
        this.v1.setSearchRoot(searchRoot);
        this.v2.setSearchRoot(searchRoot);
        return this;
    }

    public boolean isExact() {
        return this.useV2() ? this.v2.isExact() : this.v1.isExact();
    }

    public ReferenceSearch setExact(boolean exact) {
        this.v1.setExact(exact);
        this.v2.setExact(exact);
        return this;
    }

    public boolean isHollow() {
        return this.useV2() ? this.v2.isHollow() : this.v1.isHollow();
    }

    public ReferenceSearch setHollow(boolean hollow) {
        this.v1.setHollow(hollow);
        this.v2.setHollow(hollow);
        return this;
    }

    public int getMaxReferencesPerPage() {
        return this.useV2() ? this.v2.getMaxReferencesPerPage() : this.v1.getMaxReferencesPerPage();
    }

    public ReferenceSearch setMaxReferencesPerPage(int maxReferencesPerPage) {
        this.v1.setMaxReferencesPerPage(maxReferencesPerPage);
        this.v2.setMaxReferencesPerPage(maxReferencesPerPage);
        return this;
    }

    public ReferenceSearch setPredicate(ResourcePredicate resourcePredicate) {
        this.v1.setPredicate(resourcePredicate);
        this.v2.setPredicate(resourcePredicate);
        return this;
    }

    @Deprecated
    public ReferenceSearch setPredicate(AbstractResourcePredicate resourcePredicate) {
        this.v1.setPredicate(resourcePredicate);
        this.v2.setPredicate(resourcePredicate);
        return this;
    }

    public List<Page> findPageReferencesForResource(ResourceResolver resolver, String path, int limit, int offset) {
        if (this.useV2()) {
            log.debug("Using the method findPageReferencesForResource from ReferenceSearchV2");
            return this.v2.findPageReferencesForResource(resolver, path, limit, offset);
        }
        log.debug("Using the method findPageReferencesForResource from ReferenceSearchV1");
        return this.v1.findPageReferencesForResource(resolver, path, limit, offset);
    }

    public List<Page> findPageReferencesForResource(ResourceResolver resolver, String path, int limit, String cursor) {
        if (this.useV2()) {
            log.debug("Using the method findPageReferencesForResource with cursor from ReferenceSearchV2");
            return this.v2.findPageReferencesForResource(resolver, path, limit, cursor);
        }
        log.debug("Cursor-based pagination not supported in ReferenceSearchV1");
        throw new UnsupportedOperationException("Cursor-based pagination is not supported in ReferenceSearchV1 implementation");
    }

    public Map<String, Info> search(ResourceResolver resolver, String path, int limit, int offset) {
        if (this.useV2()) {
            log.debug("Using the search method with limit and offset from ReferenceSearchV2");
            return this.v2.search(resolver, path, limit, offset);
        }
        log.debug("Using the search method with limit and offset from ReferenceSearchV1");
        return this.v1.search(resolver, path, limit, offset);
    }

    @Deprecated
    public Map<String, Info> search(ResourceResolver resolver, String path) {
        if (this.useV2()) {
            log.debug("Using the search method from ReferenceSearchV2");
            return this.v2.search(resolver, path);
        }
        log.debug("Using the search method from ReferenceSearchV1");
        return this.v1.search(resolver, path);
    }

    public Collection<String> adjustReferences(ResourceResolver resolver, String path, String destination, String[] refPaths) {
        return this.v1.adjustReferences(resolver, path, destination, refPaths);
    }

    public Collection<String> adjustReferences(Node node, String path, String destination) throws RepositoryException {
        return this.v1.adjustReferences(node, path, destination);
    }

    public Collection<String> adjustReferences(Node node, String path, String destination, boolean shallow, Set<String> excludedProperties) throws RepositoryException {
        return this.v1.adjustReferences(node, path, destination, shallow, excludedProperties);
    }

    public Collection<String> adjustReferences(Node node, String path, String destination, boolean withoutChildNodes, ResourceResolver resolver) throws RepositoryException {
        return this.v1.adjustReferences(node, path, destination, withoutChildNodes, resolver);
    }

    public Collection<String> adjustReferences(Node node, String path, String destination, boolean shallow, Set<String> excludedProperties, ResourceResolver resolver, boolean withoutChildNodes) throws RepositoryException {
        return this.v1.adjustReferences(node, path, destination, shallow, excludedProperties, resolver, withoutChildNodes);
    }

    public ReferenceSearch setValidatePage(boolean validatePage) {
        this.v1.setValidatePage(validatePage);
        return this;
    }

    public static String escapeIllegalXpathSearchChars(String s) {
        return ReferenceSearchV1.escapeIllegalXpathSearchChars(s);
    }

    protected Pattern getSearchPattern(String path) {
        if (this.v1 == null) {
            throw new IllegalStateException("ReferenceSearchV1 not initialized");
        }
        return this.v1.getSearchPattern(path);
    }

    protected Pattern getReplacementPattern(String path) {
        if (this.v1 == null) {
            throw new IllegalStateException("ReferenceSearchV1 not initialized");
        }
        return this.v1.getReplacementPattern(path);
    }

    protected String rewrite(String value, String from, Pattern p, String to, String escTo) {
        if (this.v1 == null) {
            throw new IllegalStateException("ReferenceSearchV1 not initialized");
        }
        return this.v1.rewrite(value, from, p, to, escTo);
    }

    protected String rewrite(String value, String from, Pattern p, String to, String escTo, ResourceResolver resolver, boolean withoutChildNodes) {
        if (this.v1 == null) {
            throw new IllegalStateException("ReferenceSearchV1 not initialized");
        }
        return this.v1.rewrite(value, from, p, to, escTo, resolver, withoutChildNodes);
    }

    Pattern getReplacementPatternGeneric(String path, String destination) {
        if (this.v1 == null) {
            throw new IllegalStateException("ReferenceSearchV1 not initialized");
        }
        return this.v1.getReplacementPatternGeneric(path, destination);
    }

    String getGenericPath(String path, String destination) {
        if (this.v1 == null) {
            throw new IllegalStateException("ReferenceSearchV1 not initialized");
        }
        return this.v1.getGenericPath(path, destination);
    }

    String rewriteWithGenericPattern(String value, String from, Pattern p, String to, String escTo, ResourceResolver resolver, boolean withoutChildNodes) {
        if (this.v1 == null) {
            throw new IllegalStateException("ReferenceSearchV1 not initialized");
        }
        return this.v1.rewriteWithGenericPattern(value, from, p, to, escTo, resolver, withoutChildNodes);
    }

    public static final class Info {
        protected final Page page;
        private final String pageTitle;
        private final String pagePath;
        private final Set<String> properties = new HashSet<String>();

        public Info(Page page) {
            this.page = page;
            this.pageTitle = page != null ? page.getTitle() : null;
            this.pagePath = page != null ? page.getPath() : null;
        }

        public Info(Page page, boolean hollow) {
            this.page = !hollow && page != null ? page : null;
            this.pageTitle = page != null ? page.getTitle() : null;
            this.pagePath = page != null ? page.getPath() : null;
        }

        public void addProperty(String path) {
            if (path != null) {
                this.properties.add(path);
            }
        }

        public Page getPage() {
            return this.page;
        }

        public Set<String> getProperties() {
            return this.properties;
        }

        public String getPageTitle() {
            return this.pageTitle;
        }

        public String getPagePath() {
            return this.pagePath;
        }
    }
}

