/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.api;

import com.day.cq.wcm.api.PageModification;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.osgi.service.event.Event;

public final class PageEvent
implements Serializable {
    public static final String EVENT_TOPIC = "com/day/cq/wcm/core/page";
    private static final String PROPERTY_MODIFICATIONS = "modifications";
    private static final String PROPERTY_APPLICATION = "event.application";
    private static final String PROPERTY_DISTRIBUTE = "event.distribute";
    private final boolean isLocal;
    private final List<PageModification> modifications;

    public PageEvent(PageModification mod) {
        this(Collections.singletonList(mod), true);
    }

    public PageEvent(List<PageModification> mods) {
        this(mods, true);
    }

    public PageEvent(List<PageModification> mods, boolean isLocal) {
        this.modifications = mods;
        this.isLocal = isLocal;
    }

    public Iterator<PageModification> getModifications() {
        return this.modifications.iterator();
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public static PageEvent fromEvent(Event evt) {
        if (!evt.getTopic().equals(EVENT_TOPIC)) {
            return null;
        }
        ArrayList<PageModification> mods = new ArrayList<PageModification>();
        List modProps = (List)evt.getProperty(PROPERTY_MODIFICATIONS);
        if (modProps != null) {
            for (Map modProp : modProps) {
                mods.add(PageModification.fromEventProperties(modProp));
            }
        }
        return new PageEvent(mods, evt.getProperty(PROPERTY_APPLICATION) == null);
    }

    protected Dictionary<String, Object> getEventProperties() {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ArrayList<Map<String, Object>> modProps = new ArrayList<Map<String, Object>>();
        Iterator<PageModification> i = this.getModifications();
        while (i.hasNext()) {
            modProps.add(i.next().getEventProperties());
        }
        ((Dictionary)properties).put(PROPERTY_MODIFICATIONS, modProps);
        if (!this.isLocal) {
            ((Dictionary)properties).put(PROPERTY_APPLICATION, "unknown");
        }
        return properties;
    }

    public Event toEvent() {
        Dictionary<String, Object> props = this.getEventProperties();
        props.put(PROPERTY_DISTRIBUTE, "");
        return new Event(EVENT_TOPIC, props);
    }

    public Event toNonDistributableEvent() {
        return new Event(EVENT_TOPIC, this.getEventProperties());
    }
}

