/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.search.eval;

import com.day.cq.search.Predicate;
import com.day.cq.search.eval.EvaluationContext;
import com.day.cq.search.eval.RangePropertyPredicateEvaluator;
import com.day.cq.search.facets.FacetExtractor;
import com.day.cq.search.facets.buckets.ValueRangeBucket;
import com.day.cq.search.facets.extractors.PredefinedBucketsFacetExtractor;
import com.day.cq.search.impl.util.DateUtil;
import com.day.cq.search.impl.util.InvalidDateException;
import java.util.Calendar;
import java.util.TimeZone;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.propertytypes.ServiceVendor;

@ServiceVendor(value="Adobe Systems Incorporated")
@Component(factory="com.day.cq.search.eval.PredicateEvaluator/daterange")
public class DateRangePredicateEvaluator
extends RangePropertyPredicateEvaluator {
    public static final String TIME_ZONE = "timeZone";
    public static final String TODAY = "Today";
    public static final String THIS_WEEK = "This Week";
    public static final String THIS_MONTH = "This Month";
    public static final String LAST_THREE_MONTHS = "Last three months";
    public static final String THIS_YEAR = "This Year";
    public static final String LAST_YEAR = "Last Year";
    public static final String EARLIER_THAN_LAST_YEAR = "Earlier than last year";

    @Override
    public String getXPathExpression(Predicate p, EvaluationContext context) {
        return super.getXPathExpression(p.get("property"), DateRangePredicateEvaluator.parseDateString(p.get("lowerBound"), p.get(TIME_ZONE), context.getSession()), p.get("lowerOperation"), DateRangePredicateEvaluator.parseDateString(p.get("upperBound"), p.get(TIME_ZONE), context.getSession()), p.get("upperOperation"));
    }

    @Override
    public boolean canFilter(Predicate p, EvaluationContext context) {
        return false;
    }

    @Override
    public boolean canXpath(Predicate p, EvaluationContext context) {
        return true;
    }

    public static String parseDateString(String dateString, String timeZoneID, Session session) {
        if (dateString == null || dateString.length() == 0) {
            return null;
        }
        TimeZone timeZone = null;
        if (timeZoneID != null && timeZoneID.length() > 0) {
            timeZone = TimeZone.getTimeZone(timeZoneID);
        }
        try {
            Calendar date;
            ValueFactory vf = session.getValueFactory();
            try {
                long msec = Long.parseLong(dateString);
                date = vf.createValue(msec).getDate();
            }
            catch (NumberFormatException e) {
                try {
                    date = DateUtil.parseISO8601((String)dateString, (TimeZone)timeZone);
                }
                catch (InvalidDateException e1) {
                    return "";
                }
            }
            return "xs:dateTime('" + vf.createValue(date).getString() + "')";
        }
        catch (RepositoryException e) {
            return "";
        }
    }

    @Override
    public FacetExtractor getFacetExtractor(Predicate p, EvaluationContext context) {
        if (!p.hasNonEmptyValue("property")) {
            return null;
        }
        PredefinedBucketsFacetExtractor extractor = new PredefinedBucketsFacetExtractor(p.get("property"));
        DateUtil dates = new DateUtil();
        Calendar endOfToday = dates.getToday();
        endOfToday.add(10, 24);
        Predicate predicate = p.clone();
        predicate.set("lowerBound", DateUtil.getISO8601DateNoTime((Calendar)dates.getToday()));
        predicate.set("lowerOperation", ">=");
        predicate.set("upperBound", DateUtil.getISO8601DateNoTime((Calendar)endOfToday));
        predicate.set("upperOperation", "<=");
        extractor.addPredefinedBucket(new ValueRangeBucket(TODAY, Long.valueOf(dates.getToday().getTimeInMillis()), true, Long.valueOf(endOfToday.getTimeInMillis()), true, predicate));
        predicate = p.clone();
        predicate.set("lowerBound", DateUtil.getISO8601DateNoTime((Calendar)dates.getWeekStart()));
        predicate.set("lowerOperation", ">=");
        predicate.set("upperBound", DateUtil.getISO8601DateNoTime((Calendar)endOfToday));
        predicate.set("upperOperation", "<=");
        extractor.addPredefinedBucket(new ValueRangeBucket(THIS_WEEK, Long.valueOf(dates.getWeekStart().getTimeInMillis()), true, Long.valueOf(endOfToday.getTimeInMillis()), true, predicate));
        predicate = p.clone();
        predicate.set("lowerBound", DateUtil.getISO8601DateNoTime((Calendar)dates.getMonthStart()));
        predicate.set("lowerOperation", ">=");
        predicate.set("upperBound", DateUtil.getISO8601DateNoTime((Calendar)endOfToday));
        predicate.set("upperOperation", "<=");
        extractor.addPredefinedBucket(new ValueRangeBucket(THIS_MONTH, Long.valueOf(dates.getMonthStart().getTimeInMillis()), true, Long.valueOf(endOfToday.getTimeInMillis()), true, predicate));
        predicate = p.clone();
        predicate.set("lowerBound", DateUtil.getISO8601DateNoTime((Calendar)dates.getThreeMonthsAgo()));
        predicate.set("lowerOperation", ">=");
        predicate.set("upperBound", DateUtil.getISO8601DateNoTime((Calendar)endOfToday));
        predicate.set("upperOperation", "<=");
        extractor.addPredefinedBucket(new ValueRangeBucket(LAST_THREE_MONTHS, Long.valueOf(dates.getThreeMonthsAgo().getTimeInMillis()), true, Long.valueOf(endOfToday.getTimeInMillis()), true, predicate));
        predicate = p.clone();
        predicate.set("lowerBound", DateUtil.getISO8601DateNoTime((Calendar)dates.getYearStart()));
        predicate.set("lowerOperation", ">=");
        predicate.set("upperBound", DateUtil.getISO8601DateNoTime((Calendar)endOfToday));
        predicate.set("upperOperation", "<=");
        extractor.addPredefinedBucket(new ValueRangeBucket(THIS_YEAR, Long.valueOf(dates.getYearStart().getTimeInMillis()), true, Long.valueOf(endOfToday.getTimeInMillis()), true, predicate));
        predicate = p.clone();
        predicate.set("lowerBound", DateUtil.getISO8601DateNoTime((Calendar)dates.getLastYearStart()));
        predicate.set("lowerOperation", ">=");
        predicate.set("upperBound", DateUtil.getISO8601DateNoTime((Calendar)dates.getYearStart()));
        predicate.set("upperOperation", "<=");
        extractor.addPredefinedBucket(new ValueRangeBucket(LAST_YEAR, Long.valueOf(dates.getLastYearStart().getTimeInMillis()), true, Long.valueOf(dates.getYearStart().getTimeInMillis()), true, predicate));
        predicate = p.clone();
        predicate.set("lowerBound", null);
        predicate.set("upperBound", DateUtil.getISO8601DateNoTime((Calendar)dates.getLastYearStart()));
        predicate.set("upperOperation", "<");
        extractor.addPredefinedBucket(new ValueRangeBucket(EARLIER_THAN_LAST_YEAR, null, true, Long.valueOf(dates.getLastYearStart().getTimeInMillis()), false, predicate));
        return extractor;
    }
}

