/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.personalization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Segment {
    public static final String NAME_PERCENTILE = "percentile";
    private final String name;
    private final String operator;
    private final List<String> values;
    private final Kind kind;
    private final List<Segment> children = new ArrayList<Segment>();

    public static Segment newLogicSegment(Kind kind) {
        if (kind == Kind.Direct) {
            throw new IllegalArgumentException("Segment kind " + (Object)((Object)kind) + " is invalid for a logic segment.");
        }
        return new Segment(null, null, Collections.emptyList(), kind);
    }

    public static Segment newDirectSegment(String name, String operator2, String value) {
        return new Segment(name, operator2, Collections.singletonList(value), Kind.Direct);
    }

    public static Segment newDirectSegment(String name, String operator2, List<String> values) {
        return new Segment(name, operator2, values, Kind.Direct);
    }

    public static Segment newExternalReferenceSegment(String name, String operator2, String externalId) {
        return new Segment(name, operator2, Collections.singletonList(externalId), Kind.ExternalReference);
    }

    public static Segment newByPathSegment(String path) {
        return new Segment(null, null, Collections.singletonList(path), Kind.ClientOnly);
    }

    private Segment(String name, String operator2, List<String> values, Kind kind) {
        this.name = name;
        this.operator = operator2;
        this.values = values;
        this.kind = kind;
    }

    public Kind getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getOperator() {
        return this.operator;
    }

    public List<String> getValue() {
        return this.values;
    }

    public List<Segment> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(Segment resolvedSegment) {
        this.children.add(resolvedSegment);
    }

    public String toString() {
        return "[" + Segment.class.getSimpleName() + "# name : " + this.name + ", operator: " + this.operator + ", values: " + this.values + " kind: " + (Object)((Object)this.kind) + ", children.size(): " + this.children.size() + "]";
    }

    public static enum Kind {
        And,
        Or,
        Direct,
        ExternalReference,
        ClientOnly;

    }
}

