/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.commons.util;

import com.adobe.granite.toggle.api.ToggleRouter;
import com.day.cq.dam.asset.api.AssetsConfigurationsResolver;
import com.day.cq.dam.commons.util.UIHelper;
import java.util.Collections;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SmartTagEnhancementConfiguration.class}, immediate=true)
public class SmartTagEnhancementConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(SmartTagEnhancementConfiguration.class);
    private static final String SERVICE_USER = "dam-config-reader-service";
    private static final String SMART_TAG_CONFIGURATION_FT = "FT_ASSETS-48786";
    @Reference
    private ResourceResolverFactory resolverFactory;
    @Reference
    private AssetsConfigurationsResolver assetsConfigurationsResolver;
    @Reference
    private ToggleRouter toggleRouter;
    private ResourceResolver resourceResolver;

    public String determineTitle(String autogenTitle, String dcTitle) {
        TitleSourceOption option = TitleSourceOption.valueOf(this.getTitleSource());
        switch (option) {
            case AIGEN_TITLE: {
                return autogenTitle;
            }
            case AIGEN_IF_DC_MISSING: {
                return StringUtils.isNotEmpty(dcTitle) ? dcTitle : autogenTitle;
            }
        }
        return dcTitle;
    }

    @Activate
    protected void activate() throws LoginException {
        this.resourceResolver = this.resolverFactory.getServiceResourceResolver(Collections.singletonMap("sling.service.subservice", SERVICE_USER));
    }

    @Deactivate
    public void deactivate() {
        if (this.resourceResolver != null && this.resourceResolver.isLive()) {
            this.resourceResolver.close();
        }
        this.resourceResolver = null;
    }

    private String getTitleSource() {
        ValueMap assetsConfig = this.assetsConfigurationsResolver.getAssetConfigurationValues(this.resourceResolver, SmartTagEnhancementConfiguration.class.getName());
        return assetsConfig != null ? assetsConfig.get("titleSource", TitleSourceOption.DC_TITLE.name()) : TitleSourceOption.DC_TITLE.name();
    }

    public String getTitle(@NotNull Resource resource) {
        boolean aiTitleAvailable;
        Resource metadataResource = resource.getChild("jcr:content/metadata");
        if (metadataResource == null) {
            return null;
        }
        ValueMap metadataProperties = metadataResource.getValueMap();
        String dcTitle = (String)((Object)metadataProperties.get("dc:title", String.class));
        String autogenTitle = (String)((Object)metadataProperties.get(UIHelper.AUTOGEN_TITLE, String.class));
        boolean bl = aiTitleAvailable = this.toggleRouter.isEnabled(SMART_TAG_CONFIGURATION_FT) && StringUtils.isNotEmpty(autogenTitle) && metadataProperties.containsKey(UIHelper.AUTOGEN_LAST_MODIFIED);
        if (!aiTitleAvailable) {
            return dcTitle;
        }
        return this.determineTitle(autogenTitle, dcTitle);
    }

    public static enum TitleSourceOption {
        DC_TITLE,
        AIGEN_TITLE,
        AIGEN_IF_DC_MISSING;

    }
}

