/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.predicates.servlets;

import com.day.cq.commons.predicates.servlets.AbstractPredicateServlet;
import java.io.IOException;
import java.util.function.Predicate;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class}, property={"sling.servlet.selectors=aemOverlay", "sling.servlet.methods=GET", "sling.servlet.resourceTypes=sling/servlet/default"})
public class OverlayServlet
extends AbstractPredicateServlet {
    public static final String AEM_OVERLAY = "aemOverlay";

    @Override
    protected void doGet(SlingHttpServletRequest req, SlingHttpServletResponse resp, Predicate predicate) throws ServletException, IOException {
        String path = req.getResource().getPath();
        path = path.substring(path.indexOf("/", 1) + 1);
        Resource r = null;
        RequestPathInfo info = req.getRequestPathInfo();
        String suffix = info.getSuffix();
        if (suffix != null) {
            String name = path.substring(path.lastIndexOf("/") + 1);
            String basePath = path.substring(0, path.lastIndexOf("/"));
            String s = suffix;
            if (s.lastIndexOf(".") > s.lastIndexOf("/")) {
                s = s.substring(0, s.lastIndexOf("."));
            }
            while (s.indexOf("/") != -1 && (r = req.getResourceResolver().getResource(basePath + s + "/" + name)) == null) {
                s = s.substring(0, s.lastIndexOf("/"));
            }
        }
        if (r == null) {
            r = req.getResourceResolver().getResource(path);
        }
        if (r != null) {
            String sel = info.getSelectorString();
            sel = sel.equals(AEM_OVERLAY) ? "" : "." + sel.substring(sel.indexOf(".") + 1);
            String ext = info.getExtension();
            ext = ext == null ? "" : "." + ext;
            String url = r.getPath() + sel + ext;
            req.getRequestDispatcher(url).forward(req, resp);
        }
    }
}

