/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons.jcr;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrRecursiveRemove {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    public static final int DEFAULT_SAVE_EVERY_HOW_MANY = 1000;

    public int removeRecursive(Node n, int saveEveryHowManyNodes) throws RepositoryException {
        if (saveEveryHowManyNodes < 1) {
            saveEveryHowManyNodes = 1000;
        }
        String path = n.getPath();
        int result = this.remove(n, n.getPath(), saveEveryHowManyNodes, 0);
        this.log.info("removeRecursive({}) done: {} nodes deleted, saving...", (Object)path, (Object)result);
        n.getSession().save();
        this.onSave();
        return result;
    }

    private int remove(Node n, String startPath, int saveEvery, int deletedCount) throws RepositoryException {
        if (!this.canContinue()) {
            this.log.info("canContinue() returns false, aborting recursive delete");
            return deletedCount;
        }
        NodeIterator ni = n.getNodes();
        while (ni.hasNext()) {
            deletedCount = this.remove(ni.nextNode(), startPath, saveEvery, deletedCount);
        }
        NodeDefinition def = n.getDefinition();
        if (!def.isProtected() && !def.isMandatory()) {
            n.remove();
            ++deletedCount;
        }
        if (deletedCount % saveEvery == 0) {
            this.log.info("removeRecursive({}) in progress: {} nodes deleted, saving...", (Object)startPath, (Object)deletedCount);
            n.getSession().save();
            this.onSave();
        }
        return deletedCount;
    }

    protected void onSave() {
    }

    protected boolean canContinue() {
        return true;
    }
}

