/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons;

import com.adobe.granite.toggle.api.ToggleRouter;
import com.day.cq.commons.LanguageUtil;
import java.util.Locale;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Language {
    private static final Logger log;
    private final Locale locale;
    private final String language;
    private final String country;
    private String script = "";
    private static ToggleRouter toggleRouter;

    public Language(Locale locale) {
        if (toggleRouter != null && !toggleRouter.isEnabled("FT_CQ-4332753")) {
            this.locale = locale;
            this.language = locale.getLanguage();
            this.country = locale.getCountry();
        } else {
            this.locale = locale;
            this.language = locale.getLanguage();
            this.country = locale.getCountry();
            this.script = locale.getScript();
        }
    }

    public Language(String code) {
        code = code.replaceAll("-", "_");
        int idx = code.indexOf(95);
        if (toggleRouter != null && !toggleRouter.isEnabled("FT_CQ-4332753")) {
            if (idx < 0) {
                this.language = code;
                this.country = "";
                this.locale = new Locale(this.language);
            } else {
                this.language = code.substring(0, idx);
                this.country = code.substring(idx + 1);
                this.locale = new Locale(this.language, this.country);
            }
        } else if (idx < 0) {
            this.language = code;
            this.country = "";
            this.script = "";
            this.locale = new Locale(this.language);
        } else {
            this.language = code.substring(0, idx);
            String secondHalf = code.substring(idx + 1);
            idx = secondHalf.indexOf(95);
            String tempScript = "";
            String tempCountry = "";
            Locale tempLocale = null;
            if (idx < 0) {
                if (LanguageUtil.isScriptTag(secondHalf) && LanguageUtil.isLanguageCode(this.language)) {
                    tempScript = secondHalf;
                    try {
                        tempLocale = new Locale.Builder().setLanguage(this.language).setScript(secondHalf).build();
                    }
                    catch (IllegalArgumentException e) {
                        log.debug("Failed to create Locale with code: {}", (Object)code, (Object)e);
                        tempScript = "";
                        tempCountry = secondHalf;
                        tempLocale = new Locale(this.language, tempCountry);
                    }
                } else {
                    tempCountry = secondHalf;
                    tempLocale = new Locale(this.language, tempCountry);
                }
                this.script = tempScript;
                this.country = tempCountry;
                this.locale = tempLocale;
            } else {
                String middlePart = secondHalf.substring(0, idx);
                String lastPart = secondHalf.substring(idx + 1);
                if (LanguageUtil.isScriptTag(middlePart) && LanguageUtil.isLanguageCode(this.language) && LanguageUtil.isCountryCode(lastPart)) {
                    tempScript = middlePart;
                    tempCountry = lastPart;
                    try {
                        tempLocale = new Locale.Builder().setLanguage(this.language).setRegion(tempCountry).setScript(tempScript).build();
                    }
                    catch (IllegalArgumentException e) {
                        log.debug("Failed to create Locale with code: {}", (Object)code, (Object)e);
                        tempScript = "";
                        tempCountry = secondHalf;
                        tempLocale = new Locale(this.language, tempCountry);
                    }
                } else {
                    tempCountry = secondHalf;
                    tempLocale = new Locale(this.language, tempCountry);
                }
                this.script = tempScript;
                this.country = tempCountry;
                this.locale = tempLocale;
            }
        }
    }

    public Language(Locale locale, String language, String country) {
        if (toggleRouter != null && !toggleRouter.isEnabled("FT_CQ-4332753")) {
            this.locale = locale;
            this.language = language;
            this.country = country;
        } else {
            this.locale = locale;
            this.language = language;
            this.country = country;
            this.script = "";
        }
    }

    public Language(String language, String country) {
        if (toggleRouter != null && !toggleRouter.isEnabled("FT_CQ-4332753")) {
            this.language = language;
            this.country = country;
            this.locale = new Locale(language, country);
        } else {
            this.language = language;
            this.country = country;
            this.script = "";
            this.locale = new Locale(language, country);
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getLanguageCode() {
        return this.language;
    }

    public String getCountryCode() {
        return this.country;
    }

    String getScriptCode() {
        return this.script;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.language);
        if (this.script != null && this.script.length() > 0) {
            sb.append("_").append(this.script);
        }
        if (this.country.length() > 0) {
            sb.append("_").append(this.country);
        }
        return sb.toString();
    }

    public static Locale getLocale(String code) {
        if (code == null) {
            return null;
        }
        code = code.replaceAll("-", "_");
        int idx = code.indexOf(95);
        if (toggleRouter != null && !toggleRouter.isEnabled("FT_CQ-4332753")) {
            if (idx < 0) {
                return new Locale(code);
            }
            String language = code.substring(0, idx);
            String country = code.substring(idx + 1);
            if ((idx = country.indexOf(95)) < 0) {
                return new Locale(language, country);
            }
            return new Locale(language, country.substring(0, idx), country.substring(idx + 1));
        }
        if (idx < 0) {
            return new Locale(code);
        }
        String language = code.substring(0, idx);
        String secondHalf = code.substring(idx + 1);
        String country = "";
        String script = "";
        String variant = "";
        idx = secondHalf.indexOf(95);
        if (idx < 0) {
            if (LanguageUtil.isScriptTag(secondHalf) && LanguageUtil.isLanguageCode(language)) {
                script = secondHalf;
                try {
                    return new Locale.Builder().setLanguage(language).setRegion(country).setVariant(variant).setScript(script).build();
                }
                catch (IllegalArgumentException e) {
                    log.debug("Failed to create Locale with code: {}", (Object)code, (Object)e);
                }
            }
            country = secondHalf;
            return new Locale(language, country);
        }
        String middlePart = secondHalf.substring(0, idx);
        String lastPart = secondHalf.substring(idx + 1);
        if ((idx = lastPart.indexOf(95)) < 0) {
            if (LanguageUtil.isScriptTag(middlePart) && LanguageUtil.isLanguageCode(language) && LanguageUtil.isCountryCode(lastPart)) {
                script = middlePart;
                country = lastPart;
                try {
                    return new Locale.Builder().setLanguage(language).setRegion(country).setVariant(variant).setScript(script).build();
                }
                catch (IllegalArgumentException e) {
                    log.debug("Failed to create Locale with code: {}", (Object)code, (Object)e);
                }
            }
            country = middlePart;
            variant = lastPart;
            return new Locale(language, country, variant);
        }
        script = middlePart;
        country = lastPart.substring(0, idx);
        variant = lastPart.substring(idx + 1);
        if (LanguageUtil.isScriptTag(middlePart) && LanguageUtil.isLanguageCode(language) && LanguageUtil.isCountryCode(country)) {
            try {
                return new Locale.Builder().setLanguage(language).setRegion(country).setVariant(variant).setScript(script).build();
            }
            catch (IllegalArgumentException e) {
                log.debug("Failed to create Locale with code: {}", (Object)code, (Object)e);
            }
        }
        country = middlePart;
        variant = lastPart;
        return new Locale(language, country, variant);
    }

    static {
        ServiceReference serviceReference;
        BundleContext bundleContext;
        log = LoggerFactory.getLogger(Language.class);
        Bundle bundle = FrameworkUtil.getBundle(Language.class);
        if (bundle != null && (bundleContext = bundle.getBundleContext()) != null && (serviceReference = bundleContext.getServiceReference(ToggleRouter.class.getName())) != null) {
            toggleRouter = (ToggleRouter)bundleContext.getService(serviceReference);
        }
    }
}

