/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.commons;

import com.day.cq.commons.Console;
import com.day.cq.commons.SlingRepositoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ConsoleUtil
implements EventListener {
    private static final String NT_CONSOLE = "cq:Console";
    private static final String PR_CONSOLE_TITLE = "consoleTitle";
    private static final String PR_CONSOLE_DESCRIPTION = "consoleDescription";
    private static final String PR_VANITY_PATH = "sling:vanityPath";
    private static final String QUERY_BASE = "SELECT * FROM ";
    private static final String QUERY_CONSOLE = "SELECT * FROM cq:Console";
    private static final String CLAUSE_ORDER = " ORDER BY sling:vanityOrder DESC";
    private final QueryManager queryManager;
    private final String[] queries;
    private Collection<Console> consoles;
    private static final Logger log = LoggerFactory.getLogger(ConsoleUtil.class);

    public ConsoleUtil(QueryManager queryManager, ObservationManager observationManger, String[] searchPath) {
        this.queryManager = queryManager;
        this.queries = new String[searchPath.length];
        if (searchPath.length > 0) {
            for (int i = 0; i < searchPath.length; ++i) {
                StringBuffer whereClaus = new StringBuffer(" WHERE ");
                String path = searchPath[i];
                whereClaus.append(" jcr:path LIKE '").append(path);
                if (!path.endsWith("/")) {
                    whereClaus.append("/");
                }
                whereClaus.append("%'");
                this.queries[i] = QUERY_CONSOLE + whereClaus.toString() + CLAUSE_ORDER;
            }
        }
    }

    @Deprecated
    public void dispose() {
    }

    public Collection<Console> getPaths() {
        if (this.consoles == null) {
            try {
                this.consoles = this.collectConsoles();
            }
            catch (RepositoryException e) {
                log.error("Failed to build paths to Console: {}", e);
                throw new SlingRepositoryException(e.getMessage(), e);
            }
        }
        return Collections.unmodifiableCollection(this.consoles);
    }

    @Override
    public void onEvent(EventIterator eventIterator) {
    }

    private Collection<Console> collectConsoles() throws RepositoryException {
        ArrayList<String> relativePaths = new ArrayList<String>();
        ArrayList<Console> consoles = new ArrayList<Console>();
        for (String query : this.queries) {
            Query q = this.queryManager.createQuery(query, "sql");
            NodeIterator itr = q.execute().getNodes();
            while (itr.hasNext()) {
                Node node = itr.nextNode();
                String path = node.getPath();
                String appName = null;
                if (node.hasProperty(PR_CONSOLE_TITLE)) {
                    appName = node.getProperty(PR_CONSOLE_TITLE).getString();
                }
                if (appName == null && node.hasProperty("jcr:title")) {
                    appName = node.getProperty("jcr:title").getString();
                }
                if (appName == null) {
                    appName = node.getName();
                }
                String appDescription = null;
                if (node.hasProperty(PR_CONSOLE_DESCRIPTION)) {
                    appDescription = node.getProperty(PR_CONSOLE_DESCRIPTION).getString();
                }
                if (appDescription == null && node.hasProperty("jcr:description")) {
                    appDescription = node.getProperty("jcr:description").getString();
                }
                if (appDescription == null) {
                    appDescription = "";
                }
                String iconClass = null;
                if (node.hasProperty("iconClass")) {
                    iconClass = node.getProperty("iconClass").getString();
                }
                String vanityPath = null;
                if (node.hasProperty(PR_VANITY_PATH)) {
                    vanityPath = node.getProperty(PR_VANITY_PATH).getString();
                }
                String relativePath = path.substring(1);
                if (relativePaths.contains(relativePath = relativePath.substring(relativePath.indexOf("/") + 1))) continue;
                consoles.add(new Console(appName, appDescription, iconClass, path, vanityPath));
                relativePaths.add(relativePath);
            }
        }
        return consoles;
    }
}

