/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.wsdl;

import com.adobe.xfa.Element;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.wsdl.WSDLDocument;
import com.adobe.xfa.wsdl.WSDLExten;
import com.adobe.xfa.wsdl.WSDLNode;
import com.adobe.xfa.wsdl.WSDLOperation;

public class WSDLBindingOperation
extends WSDLNode {
    public static final int SOAP_STYLE_RPC = 0;
    public static final int SOAP_STYLE_DOC = 1;
    public static final int SOAP_USE_ENCODED = 0;
    public static final int SOAP_USE_LITERAL = 1;
    private WSDLOperation mpOperation;
    private WSDLExten moSoapOperation;
    private WSDLExten moSoapBinding;
    private WSDLExten moInputSoapBody;
    private WSDLExten moOutputSoapBody;

    public WSDLBindingOperation(WSDLDocument poDocument, Element oSrc) {
        super(poDocument, oSrc, 9);
    }

    public WSDLOperation getOperation() {
        return this.mpOperation;
    }

    void setOperation(WSDLOperation operation) {
        this.mpOperation = operation;
    }

    public WSDLExten getSoapOperation() {
        if (this.moSoapOperation == null) {
            this.moSoapOperation = this.findChildByExtenType(3);
        }
        return this.moSoapOperation;
    }

    public WSDLExten getSoapBinding() {
        if (this.moSoapBinding == null) {
            this.moSoapBinding = WSDLBindingOperation.findChildByExtenType(this.getWSDLParentNode(), 2);
        }
        return this.moSoapBinding;
    }

    public SoapStyle getSoapStyle() {
        WSDLExten soapBinding;
        int outStyle = 1;
        int outInputUse = 1;
        int outOutputUse = 1;
        String sStyle = null;
        WSDLExten soapOperation = this.getSoapOperation();
        if (soapOperation != null) {
            sStyle = soapOperation.getExtenAttribute(0);
        }
        if (StringUtils.isEmpty(sStyle) && (soapBinding = this.getSoapBinding()) != null) {
            sStyle = soapBinding.getExtenAttribute(0);
        }
        if (sStyle == "rpc") {
            outStyle = 0;
        } else if (StringUtils.isEmpty(sStyle) || StringUtils.equalsWithNull(sStyle, "document")) {
            outStyle = 1;
        }
        String sInputUse = null;
        WSDLExten inputSoapBody = this.getInputSoapBody();
        if (inputSoapBody != null) {
            sInputUse = inputSoapBody.getExtenAttribute(5);
        }
        String sOutputUse = null;
        WSDLExten outputSoapBody = this.getOutputSoapBody();
        if (outputSoapBody != null) {
            sOutputUse = outputSoapBody.getExtenAttribute(5);
        }
        if (sInputUse == "encoded") {
            outInputUse = 0;
        } else if (StringUtils.isEmpty(sInputUse) || StringUtils.equalsWithNull(sInputUse, "literal")) {
            outInputUse = 1;
        }
        if (sOutputUse == "encoded") {
            outOutputUse = 0;
        } else if (StringUtils.isEmpty(sOutputUse) || StringUtils.equalsWithNull(sOutputUse, "literal")) {
            outOutputUse = 1;
        }
        return new SoapStyle(outStyle, outInputUse, outOutputUse);
    }

    public boolean usesHTTPTransport() {
        String sTransport = null;
        WSDLExten soapBinding = this.getSoapBinding();
        if (soapBinding != null) {
            sTransport = soapBinding.getExtenAttribute(1);
        }
        return sTransport == "http://schemas.xmlsoap.org/soap/http";
    }

    public WSDLExten getInputSoapBody() {
        if (this.moInputSoapBody == null) {
            this.moInputSoapBody = this.getSoapBody(11);
        }
        return this.moInputSoapBody;
    }

    public WSDLExten getOutputSoapBody() {
        if (this.moOutputSoapBody == null) {
            this.moOutputSoapBody = this.getSoapBody(12);
        }
        return this.moOutputSoapBody;
    }

    private WSDLExten getSoapBody(int inNodeType) {
        WSDLNode childNode = this.getFirstWSDLNode(inNodeType);
        if (childNode == null) {
            return null;
        }
        return WSDLBindingOperation.findChildByExtenType(childNode, 4);
    }

    private final WSDLExten findChildByExtenType(int type) {
        return WSDLBindingOperation.findChildByExtenType(this, type);
    }

    private static final WSDLExten findChildByExtenType(WSDLNode parent, int type) {
        for (WSDLNode node = parent.getFirstWSDLNode(15); node != null; node = node.getNextWSDLNode(15)) {
            WSDLExten exten;
            if (!(node instanceof WSDLExten) || (exten = (WSDLExten)node).getExtenType() != type) continue;
            return exten;
        }
        return null;
    }

    public static final class SoapStyle {
        public final int mOutStyle;
        public final int mOutInputUse;
        public final int mOutOutputUse;

        SoapStyle(int outStyle, int outInputUse, int outOutputUse) {
            this.mOutStyle = outStyle;
            this.mOutInputUse = outInputUse;
            this.mOutOutputUse = outOutputUse;
        }
    }
}

