/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.ut;

import java.util.UUID;

public final class UuidFactory {
    private static boolean gbTestMode = false;
    private static ThreadLocal<Long> timeLowCounter = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return 65518L;
        }
    };
    private static ThreadLocal<Long> timeMidCounter = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return 45232L;
        }
    };
    private static ThreadLocal<Long> timeHighCounter = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return 41120L;
        }
    };

    private static long incr(ThreadLocal<Long> oCounter) {
        long lVal = oCounter.get();
        oCounter.set(lVal + 1L);
        return lVal;
    }

    private UuidFactory() {
    }

    public static void setTestMode(boolean bTestMode) {
        gbTestMode = bTestMode;
    }

    public static String getUuid() {
        UUID uuid;
        if (gbTestMode) {
            long low = UuidFactory.incr(timeLowCounter);
            long mid = UuidFactory.incr(timeMidCounter);
            long time_hi_and_ver = UuidFactory.incr(timeHighCounter);
            uuid = new UUID(low << 32 | mid << 16 | time_hi_and_ver, 0L);
        } else {
            uuid = UUID.randomUUID();
        }
        return uuid.toString();
    }
}

