/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.text;

import com.adobe.xfa.font.FontInstance;
import com.adobe.xfa.font.FontService;
import com.adobe.xfa.text.TextAttr;
import com.adobe.xfa.text.TextBaselineShift;
import com.adobe.xfa.text.TextGfxAttr;
import com.adobe.xfa.text.TextMeasurement;
import com.adobe.xfa.text.TextStream;
import com.adobe.xfa.text.TextTabList;

class AttrCopy {
    static final int COPY_ALL = 0;
    static final int OVERRIDE_ONLY = 1;
    static final int ADD_DISABLED = 2;
    private final TextAttr mpoSource;
    private final int meCopy;
    private TextAttr mpoAttr;
    private long mnMask;
    private TextAttr mpoDiffs;
    private long mnDiffMask;

    AttrCopy(TextAttr poSource, int eCopy) {
        this.mpoSource = poSource;
        this.meCopy = eCopy;
    }

    void copy(TextAttr poDest) {
        this.copy(poDest, null);
    }

    void copy(TextAttr poDest, TextAttr poDiffs) {
        boolean bEnable;
        TextAttr poEnableSource;
        this.mpoAttr = poDest;
        this.mnMask = 0L;
        this.mpoDiffs = poDiffs;
        this.mnDiffMask = 0L;
        if (this.meCopy == 2) {
            poEnableSource = poDest;
            bEnable = false;
        } else {
            poEnableSource = this.mpoSource;
            bEnable = true;
        }
        FontService poNewFontService = this.mpoSource.fontService();
        boolean bPendingFontServiceChange = false;
        if (poNewFontService != null && poNewFontService != poDest.fontService()) {
            bPendingFontServiceChange = true;
        }
        if (this.mpoSource.fontEnable() && poEnableSource.fontEnable() == bEnable && poEnableSource.anyFontEnable() == bEnable) {
            if (bPendingFontServiceChange) {
                poDest.fontService(poNewFontService, true);
            }
            this.fontInstance(this.mpoSource.fontInstance(), "");
        } else {
            TextAttr.FontDesc oFontDesc = new TextAttr.FontDesc();
            if (this.mpoSource.typefaceEnable() && poEnableSource.typefaceEnable() == bEnable) {
                oFontDesc.setTypeface(this.mpoSource.typeface());
            }
            if (!this.mpoSource.encodingEnable() || poEnableSource.encodingEnable() == bEnable) {
                // empty if block
            }
            if (this.mpoSource.sizeEnable() && poEnableSource.sizeEnable() == bEnable) {
                oFontDesc.setSize(this.mpoSource.size());
            }
            if (this.mpoSource.weightEnable() && poEnableSource.weightEnable() == bEnable) {
                oFontDesc.setWeight(this.mpoSource.weight());
            }
            if (this.mpoSource.italicEnable() && poEnableSource.italicEnable() == bEnable) {
                oFontDesc.setItalic(this.mpoSource.italic());
            }
            if (this.mpoSource.horizontalScaleEnable() && poEnableSource.horizontalScaleEnable() == bEnable) {
                oFontDesc.setHorizontalScale(this.mpoSource.horizontalScale());
            }
            if (this.mpoSource.verticalScaleEnable() && poEnableSource.verticalScaleEnable() == bEnable) {
                oFontDesc.setVerticalScale(this.mpoSource.verticalScale());
            }
            if (!oFontDesc.isEmpty()) {
                this.font(oFontDesc);
            }
        }
        TextGfxAttr oTextGfxAttr = new TextGfxAttr();
        if (this.mpoSource.underlineEnable() && poEnableSource.underlineEnable() == bEnable) {
            oTextGfxAttr.underline(this.mpoSource.underline());
        }
        if (this.mpoSource.overlineEnable() && poEnableSource.overlineEnable() == bEnable) {
            oTextGfxAttr.overline(this.mpoSource.overline());
        }
        if (this.mpoSource.strikeoutEnable() && poEnableSource.strikeoutEnable() == bEnable) {
            oTextGfxAttr.strikeout(this.mpoSource.strikeout());
        }
        if (this.mpoSource.textContextEnable() && poEnableSource.textContextEnable() == bEnable) {
            oTextGfxAttr.textContext(this.mpoSource.textContext());
        }
        if (this.mpoSource.graphicContextEnable() && poEnableSource.graphicContextEnable() == bEnable) {
            oTextGfxAttr.graphicContext(this.mpoSource.graphicContext());
        }
        if (this.mpoSource.colourEnable() && poEnableSource.colourEnable() == bEnable) {
            oTextGfxAttr.colour(this.mpoSource.colour());
        }
        if (this.mpoSource.colourBgEnable() && poEnableSource.colourBgEnable() == bEnable) {
            oTextGfxAttr.colourBg(this.mpoSource.colourBg());
        }
        if (this.mpoSource.styleEnable() && poEnableSource.styleEnable() == bEnable) {
            oTextGfxAttr.style(this.mpoSource.style());
        }
        if (this.mpoSource.shadeEnable() && poEnableSource.shadeEnable() == bEnable) {
            oTextGfxAttr.shade(this.mpoSource.shade());
        }
        if (this.mpoSource.shadeScaleEnable() && poEnableSource.shadeScaleEnable() == bEnable) {
            oTextGfxAttr.shadeScale(this.mpoSource.shadeScale());
        }
        this.gfxAttr(oTextGfxAttr);
        if (this.mpoSource.transparentEnable() && poEnableSource.transparentEnable() == bEnable) {
            this.transparent(this.mpoSource.transparent());
        }
        if (this.mpoSource.spacingEnable() && poEnableSource.spacingEnable() == bEnable) {
            this.spacing(this.mpoSource.spacing());
        }
        if (this.mpoSource.marginLEnable() && poEnableSource.marginLEnable() == bEnable) {
            this.marginL(this.mpoSource.marginL());
        }
        if (this.mpoSource.marginREnable() && poEnableSource.marginREnable() == bEnable) {
            this.marginR(this.mpoSource.marginR());
        }
        if (this.mpoSource.justifyVEnable() && poEnableSource.justifyVEnable() == bEnable) {
            this.justifyV(this.mpoSource.justifyV());
        }
        if (this.mpoSource.justifyHEnable() && poEnableSource.justifyHEnable() == bEnable) {
            this.justifyH(this.mpoSource.justifyH());
        }
        if (this.mpoSource.radixOffsetEnable() && poEnableSource.radixOffsetEnable() == bEnable) {
            this.radixOffset(this.mpoSource.radixOffset());
        }
        if (this.mpoSource.radixPosEnable() && poEnableSource.radixPosEnable() == bEnable) {
            this.radixPos(this.mpoSource.radixPos());
        }
        if (this.mpoSource.tabsEnable() && poEnableSource.tabsEnable() == bEnable) {
            this.tabs(this.mpoSource.tabs());
        }
        if (this.mpoSource.specialEnable() && poEnableSource.specialEnable() == bEnable) {
            this.special(this.mpoSource.special());
        }
        if (this.mpoSource.spaceBeforeEnable() && poEnableSource.spaceBeforeEnable() == bEnable) {
            this.spaceBefore(this.mpoSource.spaceBefore());
        }
        if (this.mpoSource.spaceAfterEnable() && poEnableSource.spaceAfterEnable() == bEnable) {
            this.spaceAfter(this.mpoSource.spaceAfter());
        }
        if (this.mpoSource.invisibleEnable() && poEnableSource.invisibleEnable() == bEnable) {
            this.invisible(this.mpoSource.invisible());
        }
        if (this.mpoSource.invisCharEnable() && poEnableSource.invisCharEnable() == bEnable) {
            this.InvisChar(this.mpoSource.invisChar());
        }
        if (this.mpoSource.baselineShiftEnable() && poEnableSource.baselineShiftEnable() == bEnable) {
            this.baselineShift(this.mpoSource.baselineShift());
        }
        if (this.mpoSource.localeEnable() && poEnableSource.localeEnable() == bEnable) {
            this.locale(this.mpoSource.locale());
        }
        if (this.mpoSource.digitsEnable() && poEnableSource.digitsEnable() == bEnable) {
            this.digits(this.mpoSource.digits());
        }
        if (this.mpoSource.directionEnable() && poEnableSource.directionEnable() == bEnable) {
            this.direction(this.mpoSource.direction());
        }
        if (this.mpoSource.paraDirectionEnable() && poEnableSource.paraDirectionEnable() == bEnable) {
            this.paraDirection(this.mpoSource.paraDirection());
        }
        if (this.mpoSource.layoutOrientationEnable() && poEnableSource.layoutOrientationEnable() == bEnable) {
            this.layoutOrientation(this.mpoSource.layoutOrientation());
        }
        if (this.mpoSource.ligatureEnable() && poEnableSource.ligatureEnable() == bEnable) {
            this.ligature(this.mpoSource.ligature());
        }
        if (this.mpoSource.charSpacingEnable() && poEnableSource.charSpacingEnable() == bEnable) {
            this.charSpacing(this.mpoSource.charSpacing());
        }
        if (this.mpoSource.wordSpacingEnable() && poEnableSource.wordSpacingEnable() == bEnable) {
            this.wordSpacing(this.mpoSource.wordSpacing());
        }
        if (this.mpoSource.kerningEnable() && poEnableSource.kerningEnable() == bEnable) {
            this.kerning(this.mpoSource.kerning());
        }
        if (this.mpoSource.hyphLevelEnable() && poEnableSource.hyphLevelEnable() == bEnable) {
            this.hyphLevel(this.mpoSource.hyphLevel());
        }
        if (this.mpoSource.hyphMinWordEnable() && poEnableSource.hyphMinWordEnable() == bEnable) {
            this.hyphMinWord(this.mpoSource.hyphMinWord());
        }
        if (this.mpoSource.hyphMinPrefixEnable() && poEnableSource.hyphMinPrefixEnable() == bEnable) {
            this.hyphMinPrefix(this.mpoSource.hyphMinPrefix());
        }
        if (this.mpoSource.hyphMinSuffixEnable() && poEnableSource.hyphMinSuffixEnable() == bEnable) {
            this.hyphMinSuffix(this.mpoSource.hyphMinSuffix());
        }
        if (this.mpoSource.hyphMaxLinesEnable() && poEnableSource.hyphMaxLinesEnable() == bEnable) {
            this.hyphMaxLines(this.mpoSource.hyphMaxLines());
        }
        if (this.mpoSource.hyphSuppressNamesEnable() && poEnableSource.hyphSuppressNamesEnable() == bEnable) {
            this.hyphSuppressNames(this.mpoSource.hyphSuppressNames());
        }
        if (this.mpoSource.hyphSuppressAcronymsEnable() && poEnableSource.hyphSuppressAcronymsEnable() == bEnable) {
            this.hyphSuppressAcronyms(this.mpoSource.hyphSuppressAcronyms());
        }
        if (this.mpoSource.leaderPatternEnable() && poEnableSource.leaderPatternEnable() == bEnable) {
            this.leaderPattern(this.mpoSource.leaderPattern());
        }
        if (this.mpoSource.leaderPatternWidthEnable() && poEnableSource.leaderPatternWidthEnable() == bEnable) {
            this.leaderPatternWidth(this.mpoSource.leaderPatternWidth());
        }
        if (this.mpoSource.leaderAlignEnable() && poEnableSource.leaderAlignEnable() == bEnable) {
            this.leaderAlign(this.mpoSource.leaderAlign());
        }
        if (this.mpoSource.leaderContentEnable() && poEnableSource.leaderContentEnable() == bEnable) {
            this.leaderContent(this.mpoSource.leaderContent());
        }
        if (this.mpoSource.ruleStyleEnable() && poEnableSource.ruleStyleEnable() == bEnable) {
            this.ruleStyle(this.mpoSource.ruleStyle());
        }
        if (this.mpoSource.ruleThicknessEnable() && poEnableSource.ruleThicknessEnable() == bEnable) {
            this.ruleThickness(this.mpoSource.ruleThickness());
        }
        if (this.meCopy == 0) {
            this.disableNotPresent();
        }
        this.disableNotPresentDiffs();
    }

    protected void font(TextAttr.FontDesc oNewFontDesc) {
        TextAttr.FontDesc oFontDesc = new TextAttr.FontDesc();
        long nMask = 0L;
        if (oNewFontDesc.hasTypeface() != 0) {
            if (!oNewFontDesc.getTypeface().equals(this.mpoAttr.typeface())) {
                oFontDesc.setTypeface(oNewFontDesc.getTypeface());
                nMask |= 2L;
            }
            this.mnMask |= 2L;
        }
        if (oNewFontDesc.hasSize() != 0) {
            if (!oNewFontDesc.getSize().equals(this.mpoAttr.size())) {
                oFontDesc.setSize(oNewFontDesc.getSize());
                nMask |= 4L;
            }
            this.mnMask |= 4L;
        }
        if (oNewFontDesc.hasWeight() != 0) {
            if (oNewFontDesc.getWeight() != this.mpoAttr.weight()) {
                oFontDesc.setWeight(oNewFontDesc.getWeight());
                nMask |= 8L;
            }
            this.mnMask |= 8L;
        }
        if (oNewFontDesc.hasItalic() != 0) {
            if (!this.mpoAttr.italicEnable() || oNewFontDesc.getItalic() != this.mpoAttr.italic()) {
                oFontDesc.setItalic(oNewFontDesc.getItalic());
                nMask |= 0x10L;
            }
            this.mnMask |= 0x10L;
        }
        if (oNewFontDesc.hasHorizontalScale() != 0) {
            if (!this.mpoAttr.horizontalScaleEnable() || oNewFontDesc.getHorizontalScale() != this.mpoAttr.horizontalScale()) {
                oFontDesc.setHorizontalScale(oNewFontDesc.getHorizontalScale());
                nMask |= 0x20L;
            }
            this.mnMask |= 0x20L;
        }
        if (oNewFontDesc.hasVerticalScale() != 0) {
            if (!this.mpoAttr.verticalScaleEnable() || oNewFontDesc.getVerticalScale() != this.mpoAttr.verticalScale()) {
                oFontDesc.setVerticalScale(oNewFontDesc.getVerticalScale());
                nMask |= 0x40L;
            }
            this.mnMask |= 0x40L;
        }
        if (nMask != 0L) {
            this.mpoAttr.updateFont(oFontDesc);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.updateFont(oFontDesc);
                this.mnDiffMask |= nMask;
                if ((this.mnDiffMask & 0x1EL) == 30L) {
                    this.mnDiffMask |= 1L;
                }
            }
        }
        if ((this.mnMask & 0x1EL) == 30L) {
            this.mnMask |= 1L;
        }
    }

    private void fontInstance(FontInstance oNewFont, String sOriginalTypeface) {
        if (oNewFont != this.mpoAttr.fontInstance()) {
            this.mpoAttr.fontInstance(oNewFont, sOriginalTypeface);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.fontInstance(oNewFont, sOriginalTypeface);
                this.mnDiffMask |= 0x7FL;
            }
        }
        this.mnMask |= 0x7FL;
    }

    protected void gfxAttr(TextGfxAttr oNewAttr) {
        long nMask = 0L;
        if (oNewAttr.underlineEnable()) {
            if (oNewAttr.underline() != this.mpoAttr.underline()) {
                nMask |= 0x80L;
            } else {
                oNewAttr.underlineEnable(false);
            }
            this.mnMask |= 0x80L;
        }
        if (oNewAttr.overlineEnable()) {
            if (oNewAttr.overline() != this.mpoAttr.overline()) {
                nMask |= 0x2000L;
            } else {
                oNewAttr.overlineEnable(false);
            }
            this.mnMask |= 0x2000L;
        }
        if (oNewAttr.strikeoutEnable()) {
            if (oNewAttr.strikeout() != this.mpoAttr.strikeout()) {
                nMask |= 0x4000L;
            } else {
                oNewAttr.strikeoutEnable(false);
            }
            this.mnMask |= 0x4000L;
        }
        if (oNewAttr.textContextEnable()) {
            if (!this.mpoAttr.textContextEnable() || oNewAttr.textContext() != this.mpoAttr.textContext()) {
                nMask |= 0x10000L;
            } else {
                oNewAttr.textContextEnable(false);
            }
            this.mnMask |= 0x10000L;
        }
        if (oNewAttr.graphicContextEnable()) {
            if (!this.mpoAttr.graphicContextEnable() || oNewAttr.graphicContext() != this.mpoAttr.graphicContext()) {
                nMask |= 0x8000L;
            } else {
                oNewAttr.graphicContextEnable(false);
            }
            this.mnMask |= 0x8000L;
        }
        if (oNewAttr.colourEnable()) {
            if (!this.mpoAttr.colourEnable() || oNewAttr.colour() != this.mpoAttr.colour()) {
                nMask |= 0x100L;
            } else {
                oNewAttr.colourEnable(false);
            }
            this.mnMask |= 0x100L;
        }
        if (oNewAttr.colourBgEnable()) {
            if (!this.mpoAttr.colourBgEnable() || oNewAttr.colourBg() != this.mpoAttr.colourBg()) {
                nMask |= 0x200L;
            } else {
                oNewAttr.colourBgEnable(false);
            }
            this.mnMask |= 0x200L;
        }
        if (oNewAttr.styleEnable()) {
            if (oNewAttr.style() != this.mpoAttr.style()) {
                nMask |= 0x400L;
            } else {
                oNewAttr.styleEnable(false);
            }
            this.mnMask |= 0x400L;
        }
        if (oNewAttr.shadeEnable()) {
            if (!this.mpoAttr.shadeEnable() || oNewAttr.shade() != this.mpoAttr.shade()) {
                nMask |= 0x800L;
            } else {
                oNewAttr.shadeEnable(false);
            }
            this.mnMask |= 0x800L;
        }
        if (oNewAttr.shadeScaleEnable()) {
            if (!this.mpoAttr.shadeScaleEnable() || oNewAttr.shadeScale() != this.mpoAttr.shadeScale()) {
                nMask |= 0x1000L;
            } else {
                oNewAttr.shadeScaleEnable(false);
            }
            this.mnMask |= 0x1000L;
        }
        if (nMask != 0L) {
            this.mpoAttr.applyGfxTextAttrs(oNewAttr);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.applyGfxTextAttrs(oNewAttr);
                this.mnDiffMask |= nMask;
            }
        }
    }

    private void transparent(boolean bNewTransparent) {
        if (!this.mpoAttr.transparentEnable() || bNewTransparent != this.mpoAttr.transparent()) {
            this.mpoAttr.transparent(bNewTransparent);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.transparent(bNewTransparent);
                this.mnDiffMask |= 0x10000000L;
            }
        }
        this.mnMask |= 0x10000000L;
    }

    private void spacing(TextMeasurement oNewSpacing) {
        if (!this.mpoAttr.spacingEnable() || !oNewSpacing.equals(this.mpoAttr.spacing())) {
            this.mpoAttr.spacing(oNewSpacing);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.spacing(oNewSpacing);
                this.mnDiffMask |= 0x200000L;
            }
        }
        this.mnMask |= 0x200000L;
    }

    private void marginL(TextMeasurement oNewMarginL) {
        if (!this.mpoAttr.marginLEnable() || !oNewMarginL.equals(this.mpoAttr.marginL())) {
            this.mpoAttr.marginL(oNewMarginL);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.marginL(oNewMarginL);
                this.mnDiffMask |= 0x1000000L;
            }
        }
        this.mnMask |= 0x1000000L;
    }

    private void marginR(TextMeasurement oNewMarginR) {
        if (!this.mpoAttr.marginREnable() || !oNewMarginR.equals(this.mpoAttr.marginR())) {
            this.mpoAttr.marginR(oNewMarginR);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.marginR(oNewMarginR);
                this.mnDiffMask |= 0x2000000L;
            }
        }
        this.mnMask |= 0x2000000L;
    }

    private void justifyV(int eNewJustifyV) {
        if (!this.mpoAttr.justifyVEnable() || eNewJustifyV != this.mpoAttr.justifyV()) {
            this.mpoAttr.justifyV(eNewJustifyV);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.justifyV(eNewJustifyV);
                this.mnDiffMask |= 0x20000L;
            }
        }
        this.mnMask |= 0x20000L;
    }

    private void justifyH(int eNewJustifyH) {
        if (!this.mpoAttr.justifyHEnable() || eNewJustifyH != this.mpoAttr.justifyH()) {
            this.mpoAttr.justifyH(eNewJustifyH);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.justifyH(eNewJustifyH);
                this.mnDiffMask |= 0x40000L;
            }
        }
        this.mnMask |= 0x40000L;
    }

    private void radixOffset(TextMeasurement oNewRadixOffset) {
        if (!this.mpoAttr.radixOffsetEnable() || !oNewRadixOffset.equals(this.mpoAttr.radixOffset())) {
            this.mpoAttr.radixOffset(oNewRadixOffset);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.radixOffset(oNewRadixOffset);
                this.mnDiffMask |= 0x80000L;
            }
        }
        this.mnMask |= 0x80000L;
    }

    private void radixPos(int nNewRadixPos) {
        if (!this.mpoAttr.radixPosEnable() || nNewRadixPos != this.mpoAttr.radixPos()) {
            this.mpoAttr.radixPos(nNewRadixPos);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.radixPos(nNewRadixPos);
                this.mnDiffMask |= 0x100000L;
            }
        }
        this.mnMask |= 0x100000L;
    }

    private void tabs(TextTabList oNewTabs) {
        this.mnMask |= 0x8000000L;
        if (this.mpoAttr.tabsEnable() && (oNewTabs == this.mpoAttr.tabs() || oNewTabs.equals(this.mpoAttr.tabs()))) {
            return;
        }
        this.mpoAttr.tabs(oNewTabs);
        if (this.mpoDiffs != null) {
            this.mpoDiffs.tabs(oNewTabs);
            this.mnDiffMask |= 0x8000000L;
        }
    }

    private void special(TextMeasurement oNewSpecial) {
        if (!this.mpoAttr.specialEnable() || !oNewSpecial.equals(this.mpoAttr.special())) {
            this.mpoAttr.special(oNewSpecial);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.special(oNewSpecial);
                this.mnDiffMask |= 0x4000000L;
            }
        }
        this.mnMask |= 0x4000000L;
    }

    private void spaceBefore(TextMeasurement oNewSpaceBefore) {
        if (!this.mpoAttr.spaceBeforeEnable() || !oNewSpaceBefore.equals(this.mpoAttr.spaceBefore())) {
            this.mpoAttr.spaceBefore(oNewSpaceBefore);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.spaceBefore(oNewSpaceBefore);
                this.mnDiffMask |= 0x400000L;
            }
        }
        this.mnMask |= 0x400000L;
    }

    private void spaceAfter(TextMeasurement oNewSpaceAfter) {
        if (!this.mpoAttr.spaceAfterEnable() || !oNewSpaceAfter.equals(this.mpoAttr.spaceAfter())) {
            this.mpoAttr.spaceAfter(oNewSpaceAfter);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.spaceAfter(oNewSpaceAfter);
                this.mnDiffMask |= 0x800000L;
            }
        }
        this.mnMask |= 0x800000L;
    }

    private void invisible(boolean bNewInvisible) {
        if (!this.mpoAttr.invisibleEnable() || bNewInvisible != this.mpoAttr.invisible()) {
            this.mpoAttr.invisible(bNewInvisible);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.invisible(bNewInvisible);
                this.mnDiffMask |= 0x20000000L;
            }
        }
        this.mnMask |= 0x20000000L;
    }

    private void InvisChar(char cNewInvisChar) {
        if (!this.mpoAttr.invisCharEnable() || cNewInvisChar != this.mpoAttr.invisChar()) {
            this.mpoAttr.invisChar(cNewInvisChar);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.invisChar(cNewInvisChar);
                this.mnDiffMask |= 0x40000000L;
            }
        }
        this.mnMask |= 0x40000000L;
    }

    private void baselineShift(TextBaselineShift oShift) {
        if (!this.mpoAttr.baselineShiftEnable() || !oShift.equals(this.mpoAttr.baselineShift())) {
            this.mpoAttr.baselineShift(oShift);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.baselineShift(oShift);
                this.mnDiffMask |= 0x2000000000L;
            }
        }
        this.mnMask |= 0x2000000000L;
    }

    private void locale(String sLocale) {
        if (!this.mpoAttr.localeEnable() || !sLocale.equals(this.mpoAttr.locale())) {
            this.mpoAttr.locale(sLocale);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.locale(sLocale);
                this.mnDiffMask |= 0x80000000L;
            }
        }
        this.mnMask |= 0x80000000L;
    }

    private void digits(int eDigits) {
        if (!this.mpoAttr.digitsEnable() || eDigits != this.mpoAttr.digits()) {
            this.mpoAttr.digits(eDigits);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.digits(eDigits);
                this.mnDiffMask |= 0x100000000L;
            }
        }
        this.mnMask |= 0x100000000L;
    }

    private void direction(int eDirection) {
        if (!this.mpoAttr.directionEnable() || eDirection != this.mpoAttr.direction()) {
            this.mpoAttr.direction(eDirection);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.direction(eDirection);
                this.mnDiffMask |= 0x200000000L;
            }
        }
        this.mnMask |= 0x200000000L;
    }

    private void paraDirection(int eParaDirection) {
        if (!this.mpoAttr.paraDirectionEnable() || eParaDirection != this.mpoAttr.paraDirection()) {
            this.mpoAttr.paraDirection(eParaDirection);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.paraDirection(eParaDirection);
                this.mnDiffMask |= 0x400000000L;
            }
        }
        this.mnMask |= 0x400000000L;
    }

    protected void layoutOrientation(int eLayoutOrientation) {
        if (!this.mpoAttr.layoutOrientationEnable() || eLayoutOrientation != this.mpoAttr.layoutOrientation()) {
            this.mpoAttr.layoutOrientation(eLayoutOrientation);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.layoutOrientation(eLayoutOrientation);
                this.mnDiffMask |= 0x800000000L;
            }
        }
        this.mnMask |= 0x800000000L;
    }

    private void ligature(int eLigature) {
        if (!this.mpoAttr.ligatureEnable() || eLigature != this.mpoAttr.ligature()) {
            this.mpoAttr.ligature(eLigature);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.ligature(eLigature);
                this.mnDiffMask |= 0x1000000000L;
            }
        }
        this.mnMask |= 0x1000000000L;
    }

    protected void charSpacing(TextMeasurement nCharSpacing) {
        if (!this.mpoAttr.charSpacingEnable() || nCharSpacing != this.mpoAttr.charSpacing()) {
            this.mpoAttr.charSpacing(nCharSpacing);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.charSpacing(nCharSpacing);
                this.mnDiffMask |= 0x4000000000L;
            }
        }
        this.mnMask |= 0x4000000000L;
    }

    protected void wordSpacing(TextMeasurement nWordSpacing) {
        if (!this.mpoAttr.wordSpacingEnable() || nWordSpacing != this.mpoAttr.wordSpacing()) {
            this.mpoAttr.wordSpacing(nWordSpacing);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.wordSpacing(nWordSpacing);
                this.mnDiffMask |= 0x8000000000L;
            }
        }
        this.mnMask |= 0x8000000000L;
    }

    protected void kerning(boolean bNewKerning) {
        if (!this.mpoAttr.kerningEnable() || bNewKerning != this.mpoAttr.kerning()) {
            this.mpoAttr.kerning(bNewKerning);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.kerning(bNewKerning);
                this.mnDiffMask |= 0x10000000000L;
            }
        }
        this.mnMask |= 0x10000000000L;
    }

    protected void hyphLevel(int eNewHyphLevel) {
        if (!this.mpoAttr.hyphLevelEnable() || eNewHyphLevel != this.mpoAttr.hyphLevel()) {
            this.mpoAttr.hyphLevel(eNewHyphLevel);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.hyphLevel(eNewHyphLevel);
                this.mnDiffMask |= 0x20000000000L;
            }
        }
        this.mnMask |= 0x20000000000L;
    }

    protected void hyphMinWord(int nNewHyphMinWord) {
        if (!this.mpoAttr.hyphMinWordEnable() || nNewHyphMinWord != this.mpoAttr.hyphMinWord()) {
            this.mpoAttr.hyphMinWord(nNewHyphMinWord);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.hyphMinWord(nNewHyphMinWord);
                this.mnDiffMask |= 0x40000000000L;
            }
        }
        this.mnMask |= 0x40000000000L;
    }

    protected void hyphMinPrefix(int nNewHyphMinPrefix) {
        if (!this.mpoAttr.hyphMinPrefixEnable() || nNewHyphMinPrefix != this.mpoAttr.hyphMinPrefix()) {
            this.mpoAttr.hyphMinPrefix(nNewHyphMinPrefix);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.hyphMinPrefix(nNewHyphMinPrefix);
                this.mnDiffMask |= 0x80000000000L;
            }
        }
        this.mnMask |= 0x80000000000L;
    }

    protected void hyphMinSuffix(int nNewHyphMinSuffix) {
        if (!this.mpoAttr.hyphMinSuffixEnable() || nNewHyphMinSuffix != this.mpoAttr.hyphMinSuffix()) {
            this.mpoAttr.hyphMinSuffix(nNewHyphMinSuffix);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.hyphMinSuffix(nNewHyphMinSuffix);
                this.mnDiffMask |= 0x100000000000L;
            }
        }
        this.mnMask |= 0x100000000000L;
    }

    protected void hyphMaxLines(int nNewHyphMaxLines) {
        if (!this.mpoAttr.hyphMaxLinesEnable() || nNewHyphMaxLines != this.mpoAttr.hyphMaxLines()) {
            this.mpoAttr.hyphMaxLines(nNewHyphMaxLines);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.hyphMaxLines(nNewHyphMaxLines);
                this.mnDiffMask |= 0x200000000000L;
            }
        }
        this.mnMask |= 0x200000000000L;
    }

    protected void hyphSuppressNames(boolean bNewHyphSuppressNames) {
        if (!this.mpoAttr.hyphSuppressNamesEnable() || bNewHyphSuppressNames != this.mpoAttr.hyphSuppressNames()) {
            this.mpoAttr.hyphSuppressNames(bNewHyphSuppressNames);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.hyphSuppressNames(bNewHyphSuppressNames);
                this.mnDiffMask |= 0x400000000000L;
            }
        }
        this.mnMask |= 0x400000000000L;
    }

    protected void hyphSuppressAcronyms(boolean bNewHyphSuppressAcronyms) {
        if (!this.mpoAttr.hyphSuppressAcronymsEnable() || bNewHyphSuppressAcronyms != this.mpoAttr.hyphSuppressAcronyms()) {
            this.mpoAttr.hyphSuppressAcronyms(bNewHyphSuppressAcronyms);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.hyphSuppressAcronyms(bNewHyphSuppressAcronyms);
                this.mnDiffMask |= 0x800000000000L;
            }
        }
        this.mnMask |= 0x800000000000L;
    }

    protected void leaderPattern(int eNewLeaderPattern) {
        if (!this.mpoAttr.leaderPatternEnable() || eNewLeaderPattern != this.mpoAttr.leaderPattern()) {
            this.mpoAttr.leaderPattern(eNewLeaderPattern);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.leaderPattern(eNewLeaderPattern);
                this.mnDiffMask |= 0x1000000000000L;
            }
        }
        this.mnMask |= 0x1000000000000L;
    }

    protected void leaderPatternWidth(TextMeasurement oNewLeaderPatternWidth) {
        if (!this.mpoAttr.leaderPatternWidthEnable() || oNewLeaderPatternWidth != this.mpoAttr.leaderPatternWidth()) {
            this.mpoAttr.leaderPatternWidth(oNewLeaderPatternWidth);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.leaderPatternWidth(oNewLeaderPatternWidth);
                this.mnDiffMask |= 0x2000000000000L;
            }
        }
        this.mnMask |= 0x2000000000000L;
    }

    protected void leaderAlign(int eNewLeaderAlign) {
        if (!this.mpoAttr.leaderAlignEnable() || eNewLeaderAlign != this.mpoAttr.leaderAlign()) {
            this.mpoAttr.leaderAlign(eNewLeaderAlign);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.leaderAlign(eNewLeaderAlign);
                this.mnDiffMask |= 0x4000000000000L;
            }
        }
        this.mnMask |= 0x4000000000000L;
    }

    protected void leaderContent(TextStream oNewLeaderContent) {
        if (!this.mpoAttr.leaderContentEnable() || oNewLeaderContent != this.mpoAttr.leaderContent()) {
            this.mpoAttr.leaderContent(oNewLeaderContent);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.leaderContent(oNewLeaderContent);
                this.mnDiffMask |= 0x8000000000000L;
            }
        }
        this.mnMask |= 0x8000000000000L;
    }

    protected void ruleStyle(int eNewRuleStyle) {
        if (!this.mpoAttr.ruleStyleEnable() || eNewRuleStyle != this.mpoAttr.ruleStyle()) {
            this.mpoAttr.ruleStyle(eNewRuleStyle);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.ruleStyle(eNewRuleStyle);
                this.mnDiffMask |= 0x10000000000000L;
            }
        }
        this.mnMask |= 0x10000000000000L;
    }

    protected void ruleThickness(TextMeasurement oNewRuleThickness) {
        if (!this.mpoAttr.ruleThicknessEnable() || oNewRuleThickness != this.mpoAttr.ruleThickness()) {
            this.mpoAttr.ruleThickness(oNewRuleThickness);
            if (this.mpoDiffs != null) {
                this.mpoDiffs.ruleThickness(oNewRuleThickness);
                this.mnDiffMask |= 0x20000000000000L;
            }
        }
        this.mnMask |= 0x20000000000000L;
    }

    private void disableNotPresent() {
        this.disableNotPresent(this.mpoAttr, this.mnMask);
    }

    private void disableNotPresentDiffs() {
        if (this.mpoDiffs != null) {
            this.disableNotPresent(this.mpoDiffs, this.mnDiffMask);
        }
    }

    private void disableNotPresent(TextAttr poAttr, long nMask) {
        if ((nMask & 1L) == 0L) {
            poAttr.fontEnable(false);
        }
        if ((nMask & 2L) == 0L) {
            poAttr.typefaceEnable(false);
        }
        if ((nMask & 4L) == 0L) {
            poAttr.sizeEnable(false);
        }
        if ((nMask & 8L) == 0L) {
            poAttr.weightEnable(false);
        }
        if ((nMask & 0x10L) == 0L) {
            poAttr.italicEnable(false);
        }
        if ((nMask & 0x80L) == 0L) {
            poAttr.underlineEnable(false);
        }
        if ((nMask & 0x2000L) == 0L) {
            poAttr.overlineEnable(false);
        }
        if ((nMask & 0x4000L) == 0L) {
            poAttr.strikeoutEnable(false);
        }
        if ((nMask & 0x10000L) == 0L) {
            poAttr.textContextEnable(false);
        }
        if ((nMask & 0x100L) == 0L) {
            poAttr.colourEnable(false);
        }
        if ((nMask & 0x200L) == 0L) {
            poAttr.colourBgEnable(false);
        }
        if ((nMask & 0x400L) == 0L) {
            poAttr.styleEnable(false);
        }
        if ((nMask & 0x800L) == 0L) {
            poAttr.shadeEnable(false);
        }
        if ((nMask & 0x1000L) == 0L) {
            poAttr.shadeScaleEnable(false);
        }
        if ((nMask & 0x8000L) == 0L) {
            poAttr.graphicContextEnable(false);
        }
        if ((nMask & 0x10000000L) == 0L) {
            poAttr.transparentEnable(false);
        }
        if ((nMask & 0x200000L) == 0L) {
            poAttr.spacingEnable(false);
        }
        if ((nMask & 0x1000000L) == 0L) {
            poAttr.marginLEnable(false);
        }
        if ((nMask & 0x2000000L) == 0L) {
            poAttr.marginREnable(false);
        }
        if ((nMask & 0x20000L) == 0L) {
            poAttr.justifyVEnable(false);
        }
        if ((nMask & 0x40000L) == 0L) {
            poAttr.justifyHEnable(false);
        }
        if ((nMask & 0x80000L) == 0L) {
            poAttr.radixOffsetEnable(false);
        }
        if ((nMask & 0x100000L) == 0L) {
            poAttr.radixPosEnable(false);
        }
        if ((nMask & 0x8000000L) == 0L) {
            poAttr.tabsEnable(false);
        }
        if ((nMask & 0x4000000L) == 0L) {
            poAttr.specialEnable(false);
        }
        if ((nMask & 0x400000L) == 0L) {
            poAttr.spaceBeforeEnable(false);
        }
        if ((nMask & 0x800000L) == 0L) {
            poAttr.spaceAfterEnable(false);
        }
        if ((nMask & 0x20000000L) == 0L) {
            poAttr.invisibleEnable(false);
        }
        if ((nMask & 0x40000000L) == 0L) {
            poAttr.invisCharEnable(false);
        }
        if ((nMask & 0x2000000000L) == 0L) {
            poAttr.baselineShiftEnable(false);
        }
        if ((nMask & 0x80000000L) == 0L) {
            poAttr.localeEnable(false);
        }
        if ((nMask & 0x100000000L) == 0L) {
            poAttr.digitsEnable(false);
        }
        if ((nMask & 0x200000000L) == 0L) {
            poAttr.directionEnable(false);
        }
        if ((nMask & 0x400000000L) == 0L) {
            poAttr.paraDirectionEnable(false);
        }
        if ((nMask & 0x800000000L) == 0L) {
            poAttr.layoutOrientationEnable(false);
        }
        if ((nMask & 0x1000000000L) == 0L) {
            poAttr.ligatureEnable(false);
        }
        if ((nMask & 0x4000000000L) == 0L) {
            poAttr.charSpacingEnable(false);
        }
        if ((nMask & 0x8000000000L) == 0L) {
            poAttr.wordSpacingEnable(false);
        }
        if ((nMask & 0x10000000000L) == 0L) {
            poAttr.kerningEnable(false);
        }
        if ((nMask & 0x20000000000L) == 0L) {
            poAttr.hyphLevelEnable(false);
        }
        if ((nMask & 0x40000000000L) == 0L) {
            poAttr.hyphMinWordEnable(false);
        }
        if ((nMask & 0x80000000000L) == 0L) {
            poAttr.hyphMinPrefixEnable(false);
        }
        if ((nMask & 0x100000000000L) == 0L) {
            poAttr.hyphMinSuffixEnable(false);
        }
        if ((nMask & 0x200000000000L) == 0L) {
            poAttr.hyphMaxLinesEnable(false);
        }
        if ((nMask & 0x400000000000L) == 0L) {
            poAttr.hyphSuppressNamesEnable(false);
        }
        if ((nMask & 0x800000000000L) == 0L) {
            poAttr.hyphSuppressAcronymsEnable(false);
        }
        if ((nMask & 0x1000000000000L) == 0L) {
            poAttr.leaderPatternEnable(false);
        }
        if ((nMask & 0x2000000000000L) == 0L) {
            poAttr.leaderPatternWidthEnable(false);
        }
        if ((nMask & 0x4000000000000L) == 0L) {
            poAttr.leaderAlignEnable(false);
        }
        if ((nMask & 0x8000000000000L) == 0L) {
            poAttr.leaderContentEnable(false);
        }
        if ((nMask & 0x10000000000000L) == 0L) {
            poAttr.ruleStyleEnable(false);
        }
        if ((nMask & 0x20000000000000L) == 0L) {
            poAttr.ruleThicknessEnable(false);
        }
    }
}

