/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.service.storage;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Model;
import com.adobe.xfa.ModelFactory;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeList;
import com.adobe.xfa.Option;
import com.adobe.xfa.ProcessingInstruction;
import com.adobe.xfa.data.DataModel;
import com.adobe.xfa.service.storage.PacketHandler;
import com.adobe.xfa.service.storage.StorageService;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import com.adobe.xfa.ut.Version;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;

public final class XMLStorage
extends StorageService {
    private static final String gsAttrQChar = "attributeQuoteChar";
    private static final String gsCharArg = "'|\"";
    private static final String gsEntityChars = "entityChars";
    private static final String gsFormatArg = "raw|simple|pretty";
    private static final String gsIncrementalLoadArg = "none|forwardOnly";
    private static final String gsIndentLevel = "indentLevel";
    private static final String gsMaxEntityCharRange = "maxEntityCharRange";
    private static final String gsMinEntityCharRange = "minEntityCharRange";
    private static final String gsModel = "Model";
    private static final String gsPercentD = "%d";
    private static final String gsProcessXSL = "processXSL";
    private static final String gssetPI = "setPI";
    private static final String gsXFAOption = "XFAOption";
    private static final String gsXSL = "XSL";
    private static final String gsXSLFile = "XSLFile";
    private final Option mGeneratorOption;
    private final Option mAPIVersionOption;
    private final Option mProcessXSLOption;
    private final Option mXSLOption;
    private final Option mIncrementalOption;
    private final Option mModelOption;
    private final Option mSetPIOption;
    private final Option mXFAPIOption;
    private final Option mFormatOption;
    private final Option mEncodingOption;
    private final Option mIndentLevelOption;
    private final Option mAttributeQuoteCharOption;
    private final Option mEntityCharsOption;
    private final Option mMaxEntityCharRangeOption;
    private final Option mMinEntityCharRangeOption;
    private final Option mXSLFileOption;
    private final File moFileName;
    private final URL mUrl;

    static String compactPIs(String piName, Document doc) {
        assert (piName != null);
        ProcessingInstruction firstPI = null;
        Node oChild = doc.getFirstXMLChild();
        while (oChild != null) {
            Node oNext = oChild.getNextXMLSibling();
            if (oChild instanceof ProcessingInstruction && oChild.getName().equals(piName)) {
                if (firstPI == null) {
                    firstPI = (ProcessingInstruction)oChild;
                } else {
                    String sData = firstPI.getData() + ' ' + ((ProcessingInstruction)oChild).getData();
                    firstPI.setData(sData);
                    doc.removeChild(oNext);
                }
            }
            if (oChild instanceof Element) break;
            oChild = oNext;
        }
        if (firstPI == null) {
            return "";
        }
        return firstPI.getData();
    }

    public void setGenerator(String newGeneratorTag) {
    }

    static void updateProcessingInstruction(Document doc, String piName, String piValue) {
        assert (piName != null);
        boolean bValueReplaced = false;
        for (Node oChild = doc.getFirstXMLChild(); oChild != null; oChild = oChild.getNextXMLSibling()) {
            if (oChild instanceof ProcessingInstruction && oChild.getName().equals(piName)) {
                ((ProcessingInstruction)oChild).setData(piValue);
                bValueReplaced = true;
                break;
            }
            if (oChild instanceof Element) break;
        }
        if (!bValueReplaced) {
            ProcessingInstruction generatorNode = new ProcessingInstruction(null, piName, piValue);
            doc.insertChild(generatorNode, doc.getFirstXMLChild(), false);
        }
    }

    static String updateValue(String nodeValue, String optionName, String optionValue) {
        StringBuilder sNodeValue = new StringBuilder(nodeValue);
        boolean bValueReplaced = false;
        char cDoubleQuote = '\"';
        char cSingleQuote = '\'';
        String namePrefix = optionName + "=";
        int nFoundAt = nodeValue.indexOf(namePrefix);
        if (nFoundAt >= 0) {
            int nValueStart = nFoundAt + namePrefix.length() + 1;
            int cQuote = 32;
            if (nodeValue.charAt(nValueStart - 1) == cDoubleQuote) {
                cQuote = cDoubleQuote;
            } else if (nodeValue.charAt(nValueStart - 1) == cSingleQuote) {
                cQuote = cSingleQuote;
            }
            if (cQuote != 32) {
                int nValueEnd = nodeValue.indexOf(cQuote, nValueStart);
                if (nValueEnd < 0) {
                    nValueEnd = nodeValue.length() - 1;
                }
                sNodeValue.replace(nValueStart, --nValueEnd + 1, optionValue);
                bValueReplaced = true;
            }
        }
        if (!bValueReplaced) {
            if (sNodeValue.length() > 0) {
                sNodeValue.append(' ');
            }
            sNodeValue.append(namePrefix);
            sNodeValue.append(cDoubleQuote);
            sNodeValue.append(optionValue);
            sNodeValue.append(cDoubleQuote);
        }
        return sNodeValue.toString();
    }

    public XMLStorage() {
        this(null, null);
    }

    public XMLStorage(File xmlFile) {
        this(xmlFile, null);
    }

    public XMLStorage(URL url) {
        this(null, url);
    }

    private XMLStorage(File xmlFile, URL url) {
        this.moFileName = xmlFile;
        this.mUrl = url;
        this.mGeneratorOption = new Option("generator", "%s");
        this.mAPIVersionOption = new Option("APIVersion", "%s");
        this.mProcessXSLOption = new Option(gsProcessXSL, "%b");
        this.mXSLOption = new Option(gsXSL, "%s");
        this.mModelOption = new Option(gsModel, "%s");
        this.mIncrementalOption = new Option("incrementalLoad", gsIncrementalLoadArg);
        this.mSetPIOption = new Option(gssetPI, "%s");
        this.mXFAPIOption = new Option(gsXFAOption, "%s");
        this.mFormatOption = new Option("format", gsFormatArg);
        this.mEncodingOption = new Option("encoding", "%s");
        this.mIndentLevelOption = new Option(gsIndentLevel, gsPercentD);
        this.mAttributeQuoteCharOption = new Option(gsAttrQChar, gsCharArg);
        this.mEntityCharsOption = new Option(gsEntityChars, "%s");
        this.mMinEntityCharRangeOption = new Option(gsMinEntityCharRange, gsPercentD);
        this.mMaxEntityCharRangeOption = new Option(gsMaxEntityCharRange, gsPercentD);
        this.mXSLFileOption = new Option(gsXSLFile, "%s");
    }

    public String getAPIVersion() {
        if (!this.mAPIVersionOption.isSet()) {
            return "";
        }
        return this.mAPIVersionOption.getString();
    }

    public String getGenerator() {
        if (!this.mGeneratorOption.isSet()) {
            return "";
        }
        return this.mGeneratorOption.getString();
    }

    public Node loadModel(AppModel model, InputStream inputStream, String loadOptions, String saveXSLFile) {
        return this.loadModel(model, inputStream, null, null, loadOptions, saveXSLFile);
    }

    public Node loadModel(AppModel model, InputStream inputStream, String source, String loadOptions, String saveXSLFile) {
        return this.loadModel(model, inputStream, source, null, loadOptions, saveXSLFile);
    }

    public Node loadModel(AppModel model, File file, String loadOptions, String saveXSLFile) {
        return this.loadModel(model, null, null, file, loadOptions, saveXSLFile);
    }

    private Node loadModel(AppModel appModel, InputStream is, String source, File file, String loadOptions, String saveXSLFile) {
        this.setOptions(loadOptions, appModel);
        appModel.getErrorList();
        if (!StringUtils.isEmpty(saveXSLFile)) {
            FileOutputStream oStreamFile = null;
            try {
                oStreamFile = new FileOutputStream(saveXSLFile);
                String sContents = "<?xml version=\"1.0\" encoding=\"UTF-8\"\n?><xfa:xsltDebug xmlns:xfa=\"http://www.xfa.org/schema/xfa-xslt-debug/1.0/\"\n></xfa:xsltDebug\n>";
                oStreamFile.write(sContents.getBytes("UTF-8"));
            }
            catch (IOException e) {
                throw new ExFull(e);
            }
            finally {
                if (oStreamFile != null) {
                    try {
                        oStreamFile.close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }
        Document doc = appModel.getDocument().isDefaultDocument() ? appModel.getDocument() : Document.createDocument(appModel);
        boolean bLazyLoading = false;
        if (this.mIncrementalOption.isSet()) {
            if (this.mIncrementalOption.getMatchingIndex() == 0) {
                bLazyLoading = false;
            } else if (this.mIncrementalOption.getMatchingIndex() == 1) {
                bLazyLoading = true;
            }
        }
        if (!bLazyLoading && (this.mXSLOption.isSet() || this.mXSLFileOption.isSet())) {
            throw new ExFull(ResId.UNSUPPORTED_OPERATION, "XMLStorage#loadModel - XSL");
        }
        if (bLazyLoading) {
            throw new ExFull(ResId.UNSUPPORTED_OPERATION);
        }
        try {
            if (file != null) {
                doc.load(file);
            } else {
                doc.load(is, source, null, false);
            }
        }
        catch (ExFull e) {
            appModel.addErrorList(e, 3, appModel);
        }
        Element startNode = null;
        for (Node child = doc.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
            if (child instanceof ProcessingInstruction && child.getName() == "xfa") {
                this.setOptions(((ProcessingInstruction)child).getData(), appModel);
            }
            if (!(child instanceof Element)) continue;
            startNode = (Element)child;
            break;
        }
        if (startNode != null && this.mModelOption.isSet()) {
            String sModelName = this.mModelOption.getString();
            Node domPacket = startNode.getFirstXMLChild();
            while (domPacket != null) {
                String aPacketName = domPacket.getName();
                Node nextSibling = domPacket.getNextXMLSibling();
                List<ModelFactory> factories = appModel.factories();
                for (int i = 0; i < factories.size(); ++i) {
                    ModelFactory factory = factories.get(i);
                    if (!factory.isRootName(aPacketName)) continue;
                    if (factory.isRootName(sModelName)) break;
                    domPacket.getXMLParent().removeChild(domPacket);
                    break;
                }
                domPacket = nextSibling;
            }
        }
        doc.isDefaultDocument(false);
        appModel.cleanDirtyFlags();
        return appModel;
    }

    public Node loadModel(AppModel model, String loadOptions, String saveXSLFile) {
        Node node;
        if (this.moFileName != null) {
            node = this.loadModel(model, null, null, this.moFileName, loadOptions, saveXSLFile);
        } else {
            if (this.mUrl != null) {
                InputStream is = null;
                try {
                    is = this.mUrl.openStream();
                    node = this.loadModel(model, is, this.mUrl.toString(), null, loadOptions, saveXSLFile);
                }
                catch (IOException ex) {
                    throw new ExFull(ex);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ignored) {}
                    }
                }
            }
            throw new IllegalStateException();
        }
        return node;
    }

    public boolean loadXDP(AppModel appModel, InputStream file, PacketHandler handler, Object handlerData, boolean bProcessXFAOnly) {
        Document doc = appModel.getDocument();
        appModel.setPacketHandler(handler, handlerData);
        doc.load(file, null, false);
        return this.loadXDP(appModel, doc, null, null, bProcessXFAOnly);
    }

    public boolean loadXDP(AppModel oAppModel, Document oDoc, PacketHandler handler, Object handlerData, boolean bProcessXFAOnly) {
        Node startNode = null;
        for (Node oChild = oDoc.getFirstXMLChild(); oChild != null; oChild = oChild.getNextXMLSibling()) {
            if (oChild instanceof ProcessingInstruction && ((ProcessingInstruction)oChild).getName() == "xfa") {
                this.setOptions(((ProcessingInstruction)oChild).getData(), oAppModel);
                continue;
            }
            if (!(oChild instanceof Element)) continue;
            startNode = oChild;
            break;
        }
        String uri = "";
        String qname = "";
        if (startNode instanceof Element) {
            uri = ((Element)startNode).getNS();
            qname = ((Element)startNode).getXMLName();
        }
        if (startNode == null || bProcessXFAOnly && !oAppModel.isXFANode(uri, startNode.getName(), qname)) {
            return false;
        }
        if (handler != null) {
            if (oAppModel.isXFANode(uri, startNode.getName(), qname)) {
                Node oDomPacket = startNode.getFirstXMLChild();
                while (oDomPacket != null) {
                    Node oNextSibling = oDomPacket.getNextXMLSibling();
                    if (oDomPacket instanceof Element) {
                        Element oPacket = (Element)oDomPacket;
                        handler.filterPackets(oPacket, handlerData);
                    }
                    oDomPacket = oNextSibling;
                }
            } else {
                handler.filterPackets(startNode, handlerData);
            }
        }
        return true;
    }

    public void processXSL(boolean process) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "XMLStorage#processXSL");
    }

    public void saveAggregate(String sRoot, OutputStream outStream, NodeList oNodes, String saveOptions) {
        this.setOptions(saveOptions, null);
        this.mGeneratorOption.setValue(this.getGenerator(), false);
        DOMSaveOptions oOptions = new DOMSaveOptions();
        try {
            AppModel oAppModel;
            Model oModel;
            if (oNodes.length() > 0 && !oOptions.getExcludePreamble()) {
                oModel = ((Node)oNodes.item(0)).getModel();
                oAppModel = null;
                if (oModel != null) {
                    oAppModel = oModel.getAppModel();
                }
                if (oAppModel != null) {
                    Document doc = oAppModel.getDocument();
                    this.updateOptions(doc, oOptions);
                    doc.savePreamble(outStream, oOptions);
                    String xfaValue = XMLStorage.compactPIs("xfa", doc);
                    if (!StringUtils.isEmpty(xfaValue)) {
                        outStream.write(Document.MarkupPIStart);
                        outStream.write("xfa".getBytes("UTF-8"));
                        outStream.write(Document.MarkupSpace);
                        outStream.write(xfaValue.getBytes("UTF-8"));
                        outStream.write(Document.MarkupPIEnd);
                        outStream.write(Document.MarkupReturn);
                    }
                }
            }
            oOptions.setExcludePreamble(true);
            if (StringUtils.isEmpty(sRoot)) {
                outStream.write("<xdp:xdp xmlns:xdp=\"http://ns.adobe.com/xdp/\"".getBytes("UTF-8"));
                if (oNodes.length() > 0) {
                    oModel = ((Node)oNodes.item(0)).getModel();
                    oAppModel = null;
                    if (oModel != null) {
                        oAppModel = oModel.getAppModel();
                    }
                    if (oAppModel != null) {
                        String sAttrVal = oAppModel.getAttribute(400).toString();
                        if (sAttrVal.length() > 0) {
                            outStream.write(Document.MarkupSpace);
                            outStream.write("timeStamp".getBytes("UTF-8"));
                            outStream.write(Document.MarkupAttrMiddle);
                            outStream.write(sAttrVal.getBytes("UTF-8"));
                            outStream.write(Document.MarkupDQuoteString);
                        }
                        if ((sAttrVal = oAppModel.getAttribute(699).toString()).length() > 0) {
                            outStream.write(Document.MarkupSpace);
                            outStream.write("uuid".getBytes("UTF-8"));
                            outStream.write(Document.MarkupAttrMiddle);
                            outStream.write(sAttrVal.getBytes("UTF-8"));
                            outStream.write(Document.MarkupDQuoteString);
                        }
                    }
                }
                outStream.write(Document.MarkupEndTag);
                outStream.write(Document.MarkupReturn);
            } else {
                outStream.write(Document.MarkupStartTag);
                outStream.write(sRoot.getBytes("UTF-8"));
                outStream.write(Document.MarkupEndTag);
                outStream.write(Document.MarkupReturn);
            }
            for (int i = 0; i < oNodes.length(); ++i) {
                Node oNode = (Node)oNodes.item(i);
                Document oDoc = oNode.getOwnerDocument();
                if (oNode instanceof Element) {
                    ((Element)oNode).preSave(false);
                }
                if (oNode.getPreviousXMLSibling() == null) {
                    outStream.write(Document.MarkupReturn);
                }
                if (oDoc != null) {
                    oDoc.saveAs(outStream, oNode, oOptions);
                }
                if (!(oNode instanceof Model)) continue;
                ((Model)oNode).postSave();
            }
            if (StringUtils.isEmpty(sRoot)) {
                outStream.write(Document.MarkupCloseTag);
                outStream.write("xdp:xdp".getBytes("UTF-8"));
                outStream.write(Document.MarkupEndTag);
                outStream.write(Document.MarkupReturn);
            } else {
                outStream.write(Document.MarkupCloseTag);
                outStream.write(sRoot.getBytes("UTF-8"));
                outStream.write(Document.MarkupEndTag);
                outStream.write(Document.MarkupReturn);
            }
        }
        catch (IOException e) {
            throw new ExFull(e);
        }
    }

    public void saveModel(Model model, String saveOptions) {
        try {
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(this.moFileName));
            this.saveModelAs(model, outputStream, saveOptions);
            outputStream.close();
        }
        catch (IOException ex) {
            throw new ExFull(ex);
        }
    }

    public void saveModelAs(Model model, OutputStream file, String saveOptions) {
        this.setOptions(saveOptions, model);
        Document doc = model.getDocument();
        DOMSaveOptions options = new DOMSaveOptions();
        this.updateOptions(doc, options);
        model.preSave(false);
        doc.saveAs(file, null, options);
        model.postSave();
    }

    private void setOptions(String optionString, Model model) {
        String s = optionString.trim();
        int cEquals = 61;
        int cDoubleQuote = 34;
        int cSingleQuote = 39;
        int nOffset = 0;
        while (true) {
            int nSecondQuoteFoundAt;
            int nFirstQuoteFoundAt;
            int nFoundAt;
            if ((nFoundAt = s.indexOf(cEquals, nOffset)) == -1) {
                if (nOffset == s.length()) break;
                throw new ExFull(new MsgFormat(ResId.MalformedOptionException, optionString.substring(nOffset)));
            }
            String sName = s.substring(nOffset, nFoundAt).trim();
            if (s.charAt(nFoundAt + 1) == '\"' || s.charAt(nFoundAt + 1) == '\'') {
                nFirstQuoteFoundAt = nFoundAt + 1;
                nSecondQuoteFoundAt = s.charAt(nFoundAt + 1) == '\"' ? s.indexOf(cDoubleQuote, nFirstQuoteFoundAt + 1) : s.indexOf(cSingleQuote, nFirstQuoteFoundAt + 1);
                if (nSecondQuoteFoundAt == -1) {
                    throw new ExFull(new MsgFormat(ResId.MalformedOptionException, sName));
                }
            } else {
                throw new ExFull(new MsgFormat(ResId.MalformedOptionException, sName));
            }
            String sValue = s.substring(nFirstQuoteFoundAt + 1, nSecondQuoteFoundAt);
            nOffset = nSecondQuoteFoundAt + 1;
            String sPackage = "xfd";
            int nUnderscore = sName.indexOf(95);
            if (nUnderscore != -1) {
                sPackage = sName.substring(0, nUnderscore);
            }
            if (!sPackage.equals("xfd")) {
                throw new ExFull(new MsgFormat(ResId.InvalidOptionException, sName));
            }
            this.setOption(sName, sValue, false);
            if (this.mSetPIOption.isSet()) {
                String optionValue = this.mSetPIOption.getString();
                String[] options = optionValue.split(" ");
                String optionName = options[0].intern();
                Document doc = ((AppModel)model).getDocument();
                XMLStorage.updateProcessingInstruction(doc, optionName, optionValue);
                this.mSetPIOption.reset();
            }
            if (!this.mXFAPIOption.isSet()) continue;
            Document doc = ((AppModel)model).getDocument();
            StringBuilder xfaValue = new StringBuilder(XMLStorage.compactPIs("xfa", doc));
            if (xfaValue.length() > 0) {
                xfaValue.append(' ');
            }
            xfaValue.append(this.mXFAPIOption.getString());
            XMLStorage.updateProcessingInstruction(doc, "xfa", xfaValue.toString());
            this.mXFAPIOption.reset();
        }
    }

    @Override
    public void setOption(String optionName, String optionValue, boolean bCritical) {
        Option[] optionArray = new Option[]{this.mGeneratorOption, this.mAPIVersionOption, this.mProcessXSLOption, this.mXSLOption, this.mModelOption, this.mIncrementalOption, this.mSetPIOption, this.mXFAPIOption, this.mFormatOption, this.mEncodingOption, this.mIndentLevelOption, this.mAttributeQuoteCharOption, this.mEntityCharsOption, this.mMinEntityCharRangeOption, this.mMaxEntityCharRangeOption, this.mXSLFileOption, null};
        Option.setOptionByArray("xfd", optionArray, optionName, optionValue, bCritical);
    }

    private void updateOptions(Document doc, DOMSaveOptions oOptions) {
        String generatorTag = "XFA2_4";
        if (doc != null) {
            Node node = doc.getDocumentElement();
            if (node instanceof DataModel) {
                node = ((DataModel)node).getDataRoot();
                node = node.getFirstXMLChild();
            }
            if (node instanceof Element && node.getXMLName() == "jfxpf:XPF") {
                generatorTag = "ff99v250_01";
            }
            this.mGeneratorOption.setValue(generatorTag, false);
            String xfaValue = XMLStorage.compactPIs("xfa", doc);
            xfaValue = XMLStorage.updateValue(xfaValue, "generator", generatorTag);
            xfaValue = XMLStorage.updateValue(xfaValue, "APIVersion", Version.getImplementation());
            XMLStorage.updateProcessingInstruction(doc, "xfa", xfaValue);
        }
        if (this.mFormatOption.isSet()) {
            if (this.mFormatOption.getMatchingIndex() == 0) {
                oOptions.setDisplayFormat(0);
            } else if (this.mFormatOption.getMatchingIndex() == 2) {
                oOptions.setDisplayFormat(2);
            }
        }
        if (this.mIndentLevelOption.isSet()) {
            oOptions.setIndentLevel(this.mIndentLevelOption.getInteger());
        }
        if (this.mAttributeQuoteCharOption.isSet() && this.mAttributeQuoteCharOption.getMatchingIndex() == 0) {
            oOptions.setUseSingleQuoteAttr(true);
        }
        if (this.mEntityCharsOption.isSet()) {
            oOptions.setEntityChars(this.mEntityCharsOption.getString());
        }
        if (this.mMinEntityCharRangeOption.isSet()) {
            oOptions.setRangeMin((char)this.mMinEntityCharRangeOption.getInteger());
        }
        if (this.mMaxEntityCharRangeOption.isSet()) {
            oOptions.setRangeMax((char)this.mMaxEntityCharRangeOption.getInteger());
        }
    }

    public void XFAModelLoader(Model model, Node configKey, InputStream oStreamFile) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "XMLStorage#XFAModelLoader");
    }
}

