/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.protocol;

import com.adobe.xfa.Node;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.protocol.Protocol;
import com.adobe.xfa.ut.Resolver;
import com.adobe.xfa.ut.StringHolder;
import com.adobe.xfa.ut.StringUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.SecureRandom;

public final class ProtocolUtils {
    private static final byte[] CRLF = ProtocolUtils.asciiBytes("\r\n");
    private static final byte[] DASH_DASH = ProtocolUtils.asciiBytes("--");
    private static final byte[] CONTENT_DISPOSITION_FORM_DATA = ProtocolUtils.asciiBytes("Content-Disposition: form-data; ");
    private static final byte[] NAME_EQUALS_QUOTE = ProtocolUtils.asciiBytes("name=\"");
    private static final byte[] QUOTE = ProtocolUtils.asciiBytes("\"");
    private static final byte[] SEMICOLON_SPACE = ProtocolUtils.asciiBytes("; ");
    private static final byte[] FILENAME_EQUALS_QUOTE = ProtocolUtils.asciiBytes("filename=\"");
    private static final byte[] CONTENT_TYPE = ProtocolUtils.asciiBytes("nContent-Type: ");
    private static final byte[] CONTENT_TRANSFER_ENCODING_BINARY = ProtocolUtils.asciiBytes("Content-Transfer-Encoding: binary");
    private static final byte[] IMAGE_GIF = ProtocolUtils.asciiBytes("image/gif");
    private static final byte[] IMAGE_JPG = ProtocolUtils.asciiBytes("image/jpeg");
    private static final byte[] TEXT_PLAIN = ProtocolUtils.asciiBytes("text/plain");
    private static final byte[] FILE_NOT_FOUND = ProtocolUtils.asciiBytes("[File not found]");
    private static final int BOUNDARYSIZE = 32;
    private static final char[] hexdigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final byte[] urlsafe = new byte[]{0, 1, 0, 0, 1, 0, 0, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
    private static final byte[] base64 = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    private ProtocolUtils() {
    }

    private static byte[] asciiBytes(String s) {
        byte[] bytes = new byte[s.length()];
        for (int i = 0; i < s.length(); ++i) {
            bytes[i] = (byte)s.charAt(i);
        }
        return bytes;
    }

    public static int read(InputStream is, byte[] b) throws IOException {
        int n;
        int offset = 0;
        while ((n = is.read(b, offset, b.length - offset)) != -1 && (offset += n) < b.length) {
        }
        if (offset == 0) {
            return -1;
        }
        return offset;
    }

    public static InputStream checkUrl(String sBaseUrl, String sPath, boolean bTrusted, StringHolder sRealUrl) {
        StringBuilder sBase;
        if (sRealUrl != null) {
            sRealUrl.value = null;
        }
        if ((sBase = new StringBuilder(sBaseUrl)).length() > 0 && sBase.charAt(sBase.length() - 1) != '/') {
            sBase.append('/');
        }
        sPath = sPath.replace('\\', '/');
        URI uri = null;
        if (!ProtocolUtils.isAbsolute(sPath)) {
            if (!StringUtils.isEmpty(sBaseUrl)) {
                URI baseURI = ProtocolUtils.getUriForString(sBase.toString());
                uri = baseURI.resolve(sPath);
            } else if (bTrusted) {
                uri = ProtocolUtils.getUriForString(sPath);
            }
        } else if (bTrusted) {
            uri = ProtocolUtils.getUriForString(sPath);
        }
        if (uri == null) {
            return null;
        }
        URL url = null;
        String sScheme = uri.getScheme();
        Protocol protocol = Resolver.getProtocol(sScheme);
        URLStreamHandler streamHandler = null;
        if (protocol != null) {
            streamHandler = protocol.getURLStreamHandler();
        }
        try {
            url = streamHandler != null ? new URL(null, uri.toString(), streamHandler) : uri.toURL();
        }
        catch (MalformedURLException ex) {
            return null;
        }
        InputStream resolved = null;
        try {
            resolved = url.openStream();
        }
        catch (IOException ex) {
            return null;
        }
        if (sRealUrl != null) {
            sRealUrl.value = url.toString();
        }
        return resolved;
    }

    private static URI getUriForString(String sPath) {
        try {
            URI uri = new URI(sPath);
            if (uri.getScheme() != null && uri.getScheme().length() > 1) {
                return uri;
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        File oPath = new File(sPath);
        return oPath.toURI();
    }

    public static boolean isAbsolute(String sPath) {
        try {
            URI uri = new URI(sPath);
            if (uri.getScheme() != null && uri.getScheme().length() > 1) {
                return uri.isAbsolute();
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        File oPath = new File(sPath);
        return oPath.isAbsolute();
    }

    public static String normalizeBaseUrl(String sBaseUrl) {
        if (StringUtils.isEmpty(sBaseUrl)) {
            return sBaseUrl;
        }
        char cSep = ProtocolUtils.getFileOrUriSeparator(sBaseUrl);
        int nLen = sBaseUrl.length();
        if (sBaseUrl.charAt(nLen - 1) != cSep) {
            sBaseUrl = sBaseUrl + cSep;
        }
        URI uri = null;
        try {
            uri = new URI(sBaseUrl);
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        if (uri != null && uri.isOpaque()) {
            String sScheme = uri.getScheme();
            String sSchemeSpecificPart = uri.getSchemeSpecificPart();
            if (sScheme != null && sSchemeSpecificPart != null) {
                sBaseUrl = sScheme + ":/" + sSchemeSpecificPart;
            }
        }
        return sBaseUrl;
    }

    public static InputStream openUrl(String sUrl) {
        return ProtocolUtils.checkUrl("", sUrl, true, null);
    }

    public static byte[] mimeBoundary(String prefix) {
        byte[] res = new byte[31];
        int n = 0;
        if (prefix != null) {
            byte[] prefixBytes = null;
            try {
                prefixBytes = prefix.getBytes("US-ASCII");
            }
            catch (UnsupportedEncodingException ignored) {
                // empty catch block
            }
            n = prefixBytes.length;
            if (n > 8) {
                n = 8;
            }
            System.arraycopy(prefixBytes, 0, res, 0, n);
        }
        byte[] seed = new byte[8];
        long currentTime = System.currentTimeMillis();
        for (int i = 0; i < 8; ++i) {
            seed[i] = (byte)(currentTime >> i & 0xFFL);
        }
        SecureRandom randomizer = new SecureRandom(seed);
        for (int i = n; i < 31; ++i) {
            res[n++] = base64[randomizer.nextInt(base64.length)];
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] mimeSection(byte[] boundary, byte[] name, byte[] file, byte[] type, byte[] value) {
        ByteArrayOutputStream sArena;
        block36: {
            sArena = new ByteArrayOutputStream();
            assert (boundary != null);
            assert (name != null || file != null);
            try {
                sArena.write(CRLF);
                sArena.write(DASH_DASH);
                sArena.write(boundary);
                sArena.write(CRLF);
                sArena.write(CONTENT_DISPOSITION_FORM_DATA);
                if (name != null) {
                    sArena.write(NAME_EQUALS_QUOTE);
                    sArena.write(name);
                    sArena.write(QUOTE);
                }
                String fileName = null;
                if (file != null) {
                    fileName = new String(file, "US-ASCII");
                    if (name != null) {
                        sArena.write(SEMICOLON_SPACE);
                    }
                    sArena.write(FILENAME_EQUALS_QUOTE);
                    sArena.write(file);
                    sArena.write(QUOTE);
                }
                byte[] contentType = null;
                if (type != null) {
                    contentType = type;
                } else if (file != null) {
                    contentType = ProtocolUtils.mimeType(fileName);
                }
                if (contentType != null) {
                    sArena.write(CRLF);
                    sArena.write(CONTENT_TYPE);
                    sArena.write(contentType);
                    if (!new String(contentType, "US-ASCII").startsWith("text/")) {
                        sArena.write(CRLF);
                        sArena.write(CONTENT_TRANSFER_ENCODING_BINARY);
                    }
                }
                sArena.write(CRLF);
                sArena.write(CRLF);
                if (file != null) {
                    File fp = new File(fileName);
                    if (!fp.exists()) {
                        sArena.write(FILE_NOT_FOUND);
                        break block36;
                    }
                    InputStream is = null;
                    try {
                        int nBytesRead;
                        is = new BufferedInputStream(new FileInputStream(fileName));
                        byte[] buffer = new byte[4096];
                        while ((nBytesRead = is.read(buffer)) > 0) {
                            sArena.write(buffer, 0, nBytesRead);
                        }
                        break block36;
                    }
                    catch (FileNotFoundException e) {
                        sArena.write(FILE_NOT_FOUND);
                        break block36;
                    }
                    catch (UnsupportedEncodingException e) {
                        sArena.write(FILE_NOT_FOUND);
                        break block36;
                    }
                    catch (IOException e) {
                        sArena.write(FILE_NOT_FOUND);
                        break block36;
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException ignored) {}
                        }
                    }
                }
                if (value != null) {
                    sArena.write(value);
                }
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        return sArena.toByteArray();
    }

    public static byte[] mimeTrailer(byte[] boundary) {
        assert (boundary != null);
        byte[] result = new byte[CRLF.length + DASH_DASH.length + boundary.length + DASH_DASH.length];
        System.arraycopy(CRLF, 0, result, 0, CRLF.length);
        System.arraycopy(DASH_DASH, 0, result, CRLF.length, DASH_DASH.length);
        System.arraycopy(boundary, 0, result, CRLF.length + DASH_DASH.length, boundary.length);
        System.arraycopy(DASH_DASH, 0, result, CRLF.length + DASH_DASH.length + boundary.length, DASH_DASH.length);
        return result;
    }

    private static byte[] mimeType(String file) {
        assert (file != null);
        if (file.endsWith(".gif")) {
            return IMAGE_GIF;
        }
        if (file.endsWith(".jpg") || file.endsWith(".jpeg)")) {
            return IMAGE_JPG;
        }
        return TEXT_PLAIN;
    }

    public static String urlEncode(String src) {
        int n = src.length();
        int needs_encoding = 0;
        for (int i = 0; i < n; ++i) {
            char chr = src.charAt(i);
            if (chr >= ' ' && '\u007f' >= chr && urlsafe[chr - 32] != 0) continue;
            ++needs_encoding;
        }
        if (needs_encoding == 0) {
            return src;
        }
        StringBuilder dst = new StringBuilder(n + needs_encoding * 2);
        for (int i = 0; i < n; ++i) {
            char chr = src.charAt(i);
            if (chr < ' ' || '\u007f' < chr || urlsafe[chr - 32] == 0) {
                dst.append('%');
                char nUCS2 = chr;
                dst.append(hexdigit[nUCS2 >> 4 & 0xF]);
                dst.append(hexdigit[nUCS2 & 0xF]);
                continue;
            }
            dst.append(chr);
        }
        return dst.toString();
    }

    public static String urlDecode(String src) {
        assert (src != null);
        StringBuilder res = new StringBuilder();
        boolean needsDecoding = false;
        int n = src.length();
        for (int i = 0; i < n; ++i) {
            char chr = src.charAt(i);
            if (chr == '+') {
                res.append(' ');
                needsDecoding = true;
                continue;
            }
            if (chr == '%') {
                if (i + 1 < n) {
                    chr = '0' <= (chr = src.charAt(++i)) && chr <= '9' ? (char)(chr - 48) : ('A' <= chr && chr <= 'F' ? (char)(chr - 55) : (char)(chr - 87));
                    int hex = chr * 16;
                    if (i + 1 < n) {
                        chr = '0' <= (chr = src.charAt(++i)) && chr <= '9' ? (char)(chr - 48) : ('A' <= chr && chr <= 'F' ? (char)(chr - 55) : (char)(chr - 87));
                        res.append((char)(hex += chr));
                    }
                }
                needsDecoding = true;
                continue;
            }
            res.append(chr);
        }
        return needsDecoding ? res.toString() : src;
    }

    public static String getTemplateBasePathFromConfig(Node contextNode) {
        Node tree;
        String sBasePath = null;
        if (contextNode != null && (tree = contextNode.resolveNode("template.base")) != null && tree.getXFAChildCount() == 1) {
            TextNode textNode = (TextNode)tree.getFirstXFAChild();
            sBasePath = textNode.getValue();
        }
        return sBasePath;
    }

    public static String getTemplateUriPathFromConfig(Node contextNode) {
        char cSep;
        int nSlash;
        TextNode textNode;
        Node tree;
        String sUriPath = null;
        if (contextNode != null && (tree = contextNode.resolveNode("template.uri")) != null && tree.getXFAChildCount() == 1 && (sUriPath = (textNode = (TextNode)tree.getFirstXFAChild()).getValue()).length() > 0 && (nSlash = sUriPath.lastIndexOf(cSep = ProtocolUtils.getFileOrUriSeparator(sUriPath))) != sUriPath.length() - 1) {
            sUriPath = sUriPath.substring(0, nSlash - 1);
        }
        return sUriPath;
    }

    private static char getFileOrUriSeparator(String uri) {
        return uri.indexOf(92) >= 0 ? (char)'\\' : '/';
    }
}

