/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.pmp.adobepdf417pmp;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

class PDF417ImageBuilder {
    PDF417ImageBuilder() {
    }

    private static Color getColor(int color) {
        if (color == 0) {
            return Color.BLACK;
        }
        return Color.WHITE;
    }

    public static BufferedImage buildCentered(String xseq, int x, int y, int xShave, int yShave, int dataCols, int dataRows, int imageCols, int imageRows) {
        int offsetCols = (imageCols - (dataCols * 17 + 17 + 17 + 17 + 18 + 4) * x) / 2;
        int offsetRows = (imageRows - dataRows * y - 4 * x) / 2;
        BufferedImage pImage = new BufferedImage(imageCols, imageRows, 10);
        Graphics2D graphicsBarcodeImage = pImage.createGraphics();
        graphicsBarcodeImage.setColor(Color.WHITE);
        graphicsBarcodeImage.fillRect(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE);
        graphicsBarcodeImage.clipRect(0, 0, imageCols - offsetCols - 2 * x, imageRows - offsetRows - 2 * x);
        int col = 2 * x + offsetCols;
        int row = 2 * x + offsetRows;
        int color = 0;
        int size = xseq.length();
        for (int idx = 0; idx < size; ++idx) {
            char c = xseq.charAt(idx);
            if (c != '\n') {
                int w = x * (c - 48);
                Color currentColor = PDF417ImageBuilder.getColor(color);
                graphicsBarcodeImage.setColor(currentColor);
                graphicsBarcodeImage.fillRect(col + xShave, row + yShave, col + w - xShave, row + y - yShave);
                col += w;
                color ^= 0xFF;
                continue;
            }
            row += y;
            col = 2 * x + offsetCols;
            color = 0;
        }
        return pImage;
    }
}

