/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.formcalc;

import com.adobe.xfa.formcalc.CalcParser;
import com.adobe.xfa.formcalc.CalcSymbol;
import com.adobe.xfa.formcalc.ScopeTable;
import java.util.List;

public final class SymbolTable {
    static final int SIZE = 509;
    private CalcSymbol[] moTableBase;
    private int mnTableSize;

    SymbolTable() {
    }

    int create(int nTableSize) {
        this.mnTableSize = nTableSize;
        this.moTableBase = new CalcSymbol[nTableSize];
        return 1;
    }

    int getTableSize() {
        return this.mnTableSize;
    }

    /*
     * Unable to fully structure code
     */
    void init(CalcParser oParser) {
        for (i = 0; i < this.mnTableSize; ++i) {
            prev = null;
            next = null;
            p = this.moTableBase[i];
            while (p != null) {
                block16: {
                    block17: {
                        block14: {
                            block15: {
                                next = p.getNext();
                                store = p.getStore();
                                if ((store & 16) != 16) break block14;
                                if (!oParser.mbSyntaxErrorSeen) break block15;
                                if (p == this.moTableBase[i]) {
                                    prev = this.moTableBase[i] = next;
                                } else {
                                    prev.setNext(next);
                                }
                                break block16;
                            }
                            p.setStore(store &= -17);
                        }
                        type = p.getType();
                        if (p.getStore() != 2 && type != 8) break block17;
                        if (oParser.mbWasInSaveMode) ** GOTO lbl-1000
                        if (p == this.moTableBase[i]) {
                            prev = this.moTableBase[i] = next;
                        } else {
                            prev.setNext(next);
                        }
                        break block16;
                    }
                    if (type != 5 && type != 6) ** GOTO lbl-1000
                    if (p.getScope() > 1) {
                        if (p == this.moTableBase[i]) {
                            prev = this.moTableBase[i] = next;
                        } else {
                            prev.setNext(next);
                        }
                    } else if (!oParser.mbWasInSaveMode) {
                        if (p == this.moTableBase[i]) {
                            prev = this.moTableBase[i] = next;
                        } else {
                            prev.setNext(next);
                        }
                    } else lbl-1000:
                    // 3 sources

                    {
                        prev = p;
                    }
                }
                p = next;
            }
        }
    }

    CalcSymbol lookup(String sName) {
        assert (sName != null);
        CalcSymbol q = null;
        int h = this.hash(sName);
        for (CalcSymbol p = this.moTableBase[h]; p != null; p = p.getNext()) {
            if (!sName.equals(p.getName())) continue;
            int type = p.getType();
            if (type == 8) {
                return p;
            }
            if (type == 4) {
                return p;
            }
            if (type != 7) continue;
            return p;
        }
        return q;
    }

    CalcSymbol lookup(String sName, ScopeTable oScope) {
        assert (sName != null);
        CalcSymbol q = null;
        int h = this.hash(sName);
        for (CalcSymbol p = this.moTableBase[h]; p != null; p = p.getNext()) {
            if (!sName.equals(p.getName())) continue;
            int type = p.getType();
            if ((type == 5 || type == 6) && oScope.isActive(p.getScope())) {
                if (q == null) {
                    q = p;
                    continue;
                }
                if (p.getScope() <= q.getScope()) continue;
                q = p;
                continue;
            }
            if (p.getType() != 7) continue;
            q = p;
        }
        return q;
    }

    CalcSymbol lookup(CalcSymbol oSym) {
        assert (oSym != null);
        CalcSymbol q = null;
        int h = this.hash(oSym.getName());
        for (CalcSymbol p = this.moTableBase[h]; p != null; p = p.getNext()) {
            int type;
            String sName = p.getName();
            if (sName == null || !sName.equals(oSym.getName()) || (type = p.getType()) != 5 && type != 6 || p.getScope() != oSym.getScope()) continue;
            q = p;
        }
        return q;
    }

    CalcSymbol install(String sName) {
        assert (sName != null);
        int h = this.hash(sName);
        CalcSymbol p = new CalcSymbol();
        p.setName(sName);
        p.setNext(this.moTableBase[h]);
        this.moTableBase[h] = p;
        return p;
    }

    public void enumerate(ScopeTable oScope, List<CalcSymbol> oSymbols) {
        for (int h = 0; h < this.mnTableSize; ++h) {
            for (CalcSymbol p = this.moTableBase[h]; p != null; p = p.getNext()) {
                boolean bAdd = false;
                int type = p.getType();
                if ((type == 5 || type == 6) && oScope.isActive(p.getScope())) {
                    bAdd = true;
                } else if (p.getType() == 7) {
                    bAdd = true;
                }
                if (!bAdd) continue;
                oSymbols.add(p);
            }
        }
    }

    private int hash(String sName) {
        assert (sName != null);
        int h = 0;
        int n = sName.length();
        for (int i = 0; i < n; ++i) {
            h = h << 1 ^ sName.charAt(i);
        }
        if ((h %= this.mnTableSize) < 0) {
            h = -h;
        }
        return h;
    }
}

