/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa.formcalc;

import com.adobe.xfa.formcalc.BuiltinMisc;
import com.adobe.xfa.formcalc.BuiltinUrl;
import com.adobe.xfa.formcalc.Builtins;
import com.adobe.xfa.formcalc.CalcException;
import com.adobe.xfa.formcalc.CalcParserConstants;
import com.adobe.xfa.formcalc.CalcParserTokenManager;
import com.adobe.xfa.formcalc.CalcSymbol;
import com.adobe.xfa.formcalc.DebugHost;
import com.adobe.xfa.formcalc.DisplayHost;
import com.adobe.xfa.formcalc.FormCalcUtil;
import com.adobe.xfa.formcalc.FrameTable;
import com.adobe.xfa.formcalc.Instruction;
import com.adobe.xfa.formcalc.ParseException;
import com.adobe.xfa.formcalc.ProtocolHost;
import com.adobe.xfa.formcalc.ScopeTable;
import com.adobe.xfa.formcalc.ScriptHost;
import com.adobe.xfa.formcalc.SimpleCharStream;
import com.adobe.xfa.formcalc.Stack;
import com.adobe.xfa.formcalc.SymbolTable;
import com.adobe.xfa.formcalc.Token;
import com.adobe.xfa.formcalc.TokenMgrError;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.LcLocale;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class CalcParser
implements Cloneable,
CalcParserConstants {
    public static final int CODESIZE = 512;
    public static final int DATASIZE = 509;
    public Instruction moCode;
    public SymbolTable moData;
    public ScopeTable moScope;
    public FrameTable moFrame;
    public Stack mStack;
    SymbolTable mBuiltin;
    String msLocaleName;
    ScriptHost moScriptHost;
    DisplayHost moDisplayHost;
    ProtocolHost moProtocolHost;
    DebugHost moDebugHost;
    int mnLoopOffset;
    int mnSavedDecl;
    int mnScriptID;
    boolean mbCancelStatus;
    boolean mbWasInSaveMode;
    boolean mbInSaveMode;
    boolean mbInSyntaxCheckMode;
    boolean mbInDowntoLoop;
    boolean mbInVarDeclaration;
    boolean mbInFuncDeclaration;
    boolean mbInFuncParameters;
    boolean mbInLoopDeclaration;
    boolean mbInForeachLoop;
    boolean mbInThrow;
    boolean mbInBreak;
    boolean mbInContinue;
    boolean mbDeleteOk;
    boolean mbSyntaxErrorSeen;
    boolean mbInUse;
    boolean mbAllowDups;
    boolean mbDebugEnabled;
    boolean mbInterrupted;
    EnumSet<LegacyVersion> moLegacyScripting;
    private CalcSymbol moResult;
    private String msFunc;
    public CalcParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[43];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[9];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public CalcParser() {
        this(512, 509);
    }

    CalcParser(int nCodeSize, int nDataSize) {
        this(System.in);
        this.create(nCodeSize, nDataSize);
    }

    public Object clone() {
        CalcParser oParser = null;
        try {
            oParser = (CalcParser)super.clone();
            oParser.create(this.moCode.getCodeSize(), this.moData.getTableSize());
            oParser.setDisplayHost(this.moDisplayHost);
            oParser.setScriptHost(this.moScriptHost);
            oParser.setProtocolHost(this.moProtocolHost);
            oParser.setDebugHost(this.moDebugHost);
            oParser.setLocale(this.msLocaleName);
            oParser.setDupsMode(this.mbAllowDups);
            oParser.setLegacyScripting(this.moLegacyScripting);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return oParser;
    }

    boolean create(int nCodeSize, int nDataSize) {
        this.moCode = new Instruction();
        if (this.moCode.create(nCodeSize) == 0) {
            return false;
        }
        this.moData = new SymbolTable();
        if (this.moData.create(nDataSize) == 0) {
            return false;
        }
        this.moScope = new ScopeTable();
        if (this.moScope.create(128) == 0) {
            return false;
        }
        this.moFrame = new FrameTable();
        if (this.moFrame.create(128) == 0) {
            return false;
        }
        this.mStack = new Stack();
        if (this.mStack.create(64) == 0) {
            return false;
        }
        this.mBuiltin = new SymbolTable();
        if (this.mBuiltin.create(97) == 0) {
            return false;
        }
        Builtins.init(this.mBuiltin);
        this.moDisplayHost = null;
        this.moScriptHost = null;
        this.moProtocolHost = null;
        this.moDebugHost = null;
        this.mnScriptID = -1;
        LcLocale oLocale = new LcLocale(LcLocale.getLocale());
        if (!oLocale.isValid()) {
            oLocale = new LcLocale("en_US");
        }
        this.msLocaleName = oLocale.getIsoName();
        this.mbWasInSaveMode = false;
        this.mbInSaveMode = false;
        this.mbInSyntaxCheckMode = false;
        this.mbInUse = false;
        this.mbAllowDups = true;
        this.mbSyntaxErrorSeen = false;
        this.mbDebugEnabled = false;
        this.mbInterrupted = false;
        this.moLegacyScripting = EnumSet.of(LegacyVersion.CUR_SCRIPTING);
        this.mnSavedDecl = 0;
        this.moResult = null;
        return true;
    }

    void yyError(int nResId) {
        if (!this.mbSyntaxErrorSeen) {
            this.yyError(nResId, this.token.image);
        }
    }

    void yyError(int nResId, String sToken) {
        if (!this.mbSyntaxErrorSeen) {
            this.mbInThrow = true;
            Token t = this.token;
            if (t.next != null && t.next.image.length() > 0) {
                t = t.next;
            }
            MsgFormatPos oErr = new MsgFormatPos(nResId);
            oErr.format(sToken);
            String sLineNo = Integer.toString(t.beginLine);
            oErr.format(sLineNo);
            String sColNo = Integer.toString(t.beginColumn);
            oErr.format(sColNo);
            CalcSymbol oSym = new CalcSymbol(oErr.toString(), true, t.beginLine, nResId);
            this.mStack.push(oSym);
            this.mbSyntaxErrorSeen = true;
            throw new RuntimeException();
        }
    }

    boolean yyParse() {
        if (this.mbInUse) {
            this.mbInThrow = true;
            MsgFormatPos sErr = new MsgFormatPos(ResId.FC_SYS_ERR_REENT);
            CalcSymbol oSym = new CalcSymbol(sErr.toString(), true, 0, 0);
            this.mStack.push(oSym);
            this.setCalcResult(oSym);
            return false;
        }
        this.mbInUse = true;
        this.moCode.init(this);
        this.moData.init(this);
        this.moScope.init(this);
        this.mStack.init();
        this.moFrame.init();
        this.mbWasInSaveMode = this.mbInSaveMode;
        this.mbInDowntoLoop = false;
        this.mbInVarDeclaration = false;
        this.mbInFuncDeclaration = false;
        this.mbInFuncParameters = false;
        this.mbInLoopDeclaration = false;
        this.mbInForeachLoop = false;
        this.mbInThrow = false;
        this.mbInBreak = false;
        this.mbInContinue = false;
        this.mbDeleteOk = false;
        this.mbSyntaxErrorSeen = false;
        this.mbCancelStatus = false;
        this.mnLoopOffset = 0;
        try {
            this.FormCalculation();
        }
        catch (RuntimeException e) {
            if (!this.mbSyntaxErrorSeen) {
                CalcSymbol oSym = new CalcSymbol(e.toString(), true, 0, 0);
                this.mStack.push(oSym);
            }
        }
        catch (ParseException e) {
            Token t = e.currentToken;
            if (t.next != null && t.next.image.length() > 0) {
                t = t.next;
            }
            MsgFormatPos oErr = new MsgFormatPos(ResId.FC_ERR_SYNTAX);
            oErr.format(t.image);
            String sLineNo = Integer.toString(t.beginLine);
            oErr.format(sLineNo);
            String sColNo = Integer.toString(t.beginColumn);
            oErr.format(sColNo);
            CalcSymbol oSym = new CalcSymbol(oErr.toString(), true, t.beginLine, 0);
            this.mStack.push(oSym);
            this.mbSyntaxErrorSeen = true;
        }
        catch (TokenMgrError e) {
            CalcSymbol oSym = new CalcSymbol(e.toString(), true, 0, 0);
            this.mStack.push(oSym);
            this.mbSyntaxErrorSeen = true;
        }
        this.generate(Instruction.gStop);
        if (this.mbSyntaxErrorSeen) {
            this.setCalcResult(this.mStack.pop());
            this.cleanCode();
        } else {
            this.moResult = null;
        }
        this.mbInUse = false;
        return !this.mbSyntaxErrorSeen;
    }

    void yyTrace(String s) {
    }

    void execute() {
        if (this.mbInUse) {
            this.mbInThrow = true;
            MsgFormatPos sErr = new MsgFormatPos(ResId.FC_SYS_ERR_REENT);
            CalcSymbol oSym = new CalcSymbol(sErr.toString(), true, 0, 0);
            this.mStack.push(oSym);
            this.setCalcResult(oSym);
        }
        if (this.mbSyntaxErrorSeen) {
            return;
        }
        this.mbInUse = true;
        this.moCode.execute(this, this.moCode.getCodeStart());
        this.setCalcResult(this.mStack.pop());
        this.cleanCode();
        this.mbInUse = false;
    }

    void cleanCode() {
        this.mbDeleteOk = true;
        if (this.mbSyntaxErrorSeen) {
            this.moCode.release(this, this.moCode.getProgStart());
        } else if (this.mbInSaveMode) {
            this.moCode.relocate(this);
        } else {
            this.moCode.release(this, this.moCode.getCodeStart());
        }
    }

    void setSaveMode(boolean bSaveMode) {
        this.mbInSaveMode = bSaveMode;
    }

    public void setDisplayHost(DisplayHost oDisplayHost) {
        this.moDisplayHost = oDisplayHost;
        if (this.moDisplayHost != null) {
            Builtins.add(this.mBuiltin, "MessageBox", BuiltinMisc.class);
        }
    }

    public void setScriptHost(ScriptHost oScriptHost) {
        this.moScriptHost = oScriptHost;
    }

    public void setLegacyScripting(EnumSet oLegacyScripting) {
        this.moLegacyScripting = EnumSet.copyOf(oLegacyScripting);
    }

    public void setProtocolHost(ProtocolHost oProtocolHost) {
        this.moProtocolHost = oProtocolHost;
        if (this.moProtocolHost != null) {
            Builtins.add(this.mBuiltin, "Get", BuiltinUrl.class);
            Builtins.add(this.mBuiltin, "Put", BuiltinUrl.class);
            Builtins.add(this.mBuiltin, "Post", BuiltinUrl.class);
        }
    }

    public void setDebugHost(DebugHost oDebugHost) {
        this.moDebugHost = oDebugHost;
    }

    public void setScriptID(int nScriptID) {
        this.mnScriptID = nScriptID;
    }

    public void debugEnable(boolean bEnableDebug) {
        this.mbDebugEnabled = bEnableDebug;
    }

    CalcSymbol getOneValue(CalcSymbol oSymIn) {
        CalcSymbol oSym = new CalcSymbol(oSymIn);
        block6: while (true) {
            switch (oSym.getType()) {
                case 9: {
                    try {
                        CalcSymbol[] oSyms = this.moScriptHost.getItemValue(oSym.getName(), oSym.getObjValues());
                        oSym = oSyms[0];
                    }
                    catch (CalcException e) {
                        oSym = e.getSymbol();
                    }
                    continue block6;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 10: {
                    break block6;
                }
                default: {
                    assert (false);
                    break block6;
                }
            }
            break;
        }
        CalcSymbol oRetSym = new CalcSymbol(oSym);
        return oRetSym;
    }

    CalcSymbol getRefValue(CalcSymbol oSymIn) {
        CalcSymbol oSym = new CalcSymbol(oSymIn);
        switch (oSym.getType()) {
            case 6: {
                try {
                    if (oSym.getObjValue() != null) {
                        CalcSymbol[] oSyms = this.moScriptHost.getItemValue("#0", oSym.getObjValues());
                        oSym = oSyms[0];
                        break;
                    }
                    if (oSym.getName() != null && oSym.getName().length() > 0) {
                        this.mbInThrow = true;
                        MsgFormatPos sFmt = new MsgFormatPos(ResId.FC_ERR_REF_NULL);
                        sFmt.format(oSym.getName());
                        oSym = new CalcSymbol(sFmt.toString(), true, 0, 0);
                        break;
                    }
                    oSym = new CalcSymbol();
                }
                catch (CalcException e) {
                    oSym = e.getSymbol();
                }
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        CalcSymbol oRetSym = new CalcSymbol(oSym);
        return oRetSym;
    }

    double getNumeric(CalcSymbol oSymIn) {
        double nRetVal = Double.MAX_VALUE;
        block9: while (true) {
            CalcSymbol oSym = null;
            switch (oSymIn.getType()) {
                case 9: {
                    oSym = this.getOneValue(oSymIn);
                    if (oSym.getType() != 0 && oSymIn.getName().indexOf(42) >= 0) {
                        this.mbInThrow = true;
                        throw new CalcException();
                    }
                    oSymIn = oSym;
                    continue block9;
                }
                case 6: {
                    oSymIn = oSym = this.getRefValue(oSymIn);
                    continue block9;
                }
                case 3: {
                    nRetVal = oSymIn.getNumericValue();
                    break block9;
                }
                case 2: {
                    nRetVal = FormCalcUtil.strToDbl(oSymIn.getStringValue(), false);
                    break block9;
                }
                case 5: {
                    String sVal = oSymIn.getStringValue();
                    if (sVal != null) {
                        nRetVal = FormCalcUtil.strToDbl(sVal, false);
                        break block9;
                    }
                    nRetVal = 0.0;
                    break block9;
                }
                case 1: 
                case 8: {
                    nRetVal = 0.0;
                    break block9;
                }
                case 0: 
                case 10: {
                    this.mbInThrow = true;
                    throw new CalcException(oSymIn);
                }
                default: {
                    assert (false);
                    break block9;
                }
            }
            break;
        }
        return nRetVal;
    }

    CalcSymbol getActualType(CalcSymbol oSymIn) {
        CalcSymbol cRetVal = null;
        block5: while (true) {
            CalcSymbol oSym = null;
            cRetVal = new CalcSymbol(oSymIn);
            switch (oSymIn.getType()) {
                case 9: {
                    oSymIn = oSym = this.getOneValue(oSymIn);
                    continue block5;
                }
                case 6: {
                    oSymIn = oSym = this.getRefValue(oSymIn);
                    continue block5;
                }
                case 5: {
                    String sVal = oSymIn.getStringValue();
                    if (null != sVal) break block5;
                    cRetVal = new CalcSymbol();
                    break block5;
                }
            }
            break;
        }
        return cRetVal;
    }

    boolean getCancelStatus() {
        return this.mbCancelStatus;
    }

    void setCancelStatus(boolean bStatus) {
        this.mbCancelStatus = bStatus;
    }

    String getString(CalcSymbol oSymIn) {
        String sRetVal = "E Pluribus Unix";
        block9: while (true) {
            CalcSymbol oSym = null;
            switch (oSymIn.getType()) {
                case 9: {
                    oSym = this.getOneValue(oSymIn);
                    if (oSym.getType() != 0 && oSymIn.getName().indexOf(42) >= 0) {
                        this.mbInThrow = true;
                        throw new CalcException();
                    }
                    oSymIn = oSym;
                    continue block9;
                }
                case 6: {
                    oSymIn = oSym = this.getRefValue(oSymIn);
                    continue block9;
                }
                case 3: {
                    oSymIn.setTypeToString();
                    sRetVal = oSymIn.getStringValue();
                    break block9;
                }
                case 2: {
                    sRetVal = oSymIn.getStringValue();
                    break block9;
                }
                case 5: {
                    sRetVal = oSymIn.getStringValue();
                    if (sRetVal != null) break block9;
                    sRetVal = "";
                    break block9;
                }
                case 1: 
                case 8: {
                    sRetVal = "";
                    break block9;
                }
                case 0: 
                case 10: {
                    this.mbInThrow = true;
                    throw new CalcException(oSymIn);
                }
                default: {
                    assert (false);
                    break block9;
                }
            }
            break;
        }
        return sRetVal;
    }

    void getExceptions(CalcSymbol oSymIn) {
        block5: while (true) {
            CalcSymbol oSym = null;
            switch (oSymIn.getType()) {
                case 9: {
                    if (this.mbInBreak || this.mbInContinue) break block5;
                    oSym = this.getOneValue(oSymIn);
                    if (oSym.getType() != 0 && oSymIn.getName().indexOf(42) >= 0) {
                        this.mbInThrow = true;
                        throw new CalcException();
                    }
                    oSymIn = oSym;
                    continue block5;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
                case 8: {
                    break block5;
                }
                case 0: 
                case 10: {
                    this.mbInThrow = true;
                    throw new CalcException(oSymIn);
                }
            }
            break;
        }
    }

    void setCalcResult(CalcSymbol oSymIn) {
        try {
            block8: while (true) {
                CalcSymbol oSym = null;
                switch (oSymIn.getType()) {
                    case 9: {
                        oSym = this.getOneValue(oSymIn);
                        oSymIn.assign(oSym);
                        continue block8;
                    }
                    case 6: {
                        oSym = this.getRefValue(oSymIn);
                        oSymIn.assign(oSym);
                        break block8;
                    }
                    case 3: {
                        oSymIn.setTypeToString();
                        break block8;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 5: 
                    case 10: {
                        break block8;
                    }
                    default: {
                        assert (false);
                        break block8;
                    }
                }
                break;
            }
            this.moResult = new CalcSymbol(oSymIn);
        }
        catch (CalcException e) {
            this.moResult = e.getSymbol();
        }
        if (this.moResult.getType() == 5) {
            this.moResult.setType(this.moResult.getStringValue() != null ? 2 : 1);
        }
    }

    private CalcSymbol varExists(String sName, ScopeTable oScope) {
        CalcSymbol oSym = this.moData.lookup(sName, oScope);
        if (oSym != null) {
            if (oSym.getType() == 5) {
                return oSym.getScope() == oScope.getScope() ? oSym : null;
            }
            if (oSym.getType() == 7) {
                return oSym;
            }
        }
        return null;
    }

    private int generate(Object oInstruction) {
        if (this.mbDebugEnabled) {
            Method oMethod;
            if (oInstruction instanceof Method && ((oMethod = (Method)oInstruction) == Instruction.gEnter || oMethod == Instruction.gExit)) {
                this.setLine();
            }
            throw new ExFull(ResId.UNSUPPORTED_OPERATION, "CalcParser#generate");
        }
        return this.moCode.generate(oInstruction);
    }

    private void setLine() {
        Token t = this.token;
        if (t.next != null) {
            t = t.next;
        }
    }

    public void putScript(String sCalc) {
        this.ReInit(new StringReader(sCalc));
    }

    public void setLocale(String sLocale) {
        if (!StringUtils.isEmpty(sLocale)) {
            this.msLocaleName = sLocale;
        }
    }

    public boolean getDupsMode() {
        return this.mbAllowDups;
    }

    public void setDupsMode(boolean bAllowDups) {
        this.mbAllowDups = bAllowDups;
    }

    public void setSyntaxCheckMode(boolean bSyntaxCheckMode) {
        this.mbInSyntaxCheckMode = bSyntaxCheckMode;
    }

    public boolean compile(boolean bSaveDeclarations, boolean bSaveAllCode, boolean bSyntaxCheckOnly) {
        this.setSaveMode(bSaveDeclarations);
        this.setSyntaxCheckMode(bSyntaxCheckOnly);
        if (!this.yyParse()) {
            return false;
        }
        if (!bSaveAllCode) {
            this.cleanCode();
        }
        return true;
    }

    public boolean evaluate(boolean bSaveDeclarations, boolean bExecSavedCode) {
        this.setSaveMode(bSaveDeclarations);
        this.setSyntaxCheckMode(false);
        if (!bExecSavedCode && !this.yyParse()) {
            return false;
        }
        this.execute();
        return true;
    }

    public boolean inUse() {
        return this.mbInUse;
    }

    public CalcSymbol getCalcResult() {
        return this.moResult;
    }

    public final void FormCalculation() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 0: {
                this.jj_consume_token(0);
                MsgFormatPos sErr = new MsgFormatPos(ResId.FC_ERR_NO_EXPR);
                CalcSymbol oSym = new CalcSymbol(sErr.toString(), true, 0, 0);
                this.mStack.push(oSym);
                break;
            }
            case 75: {
                this.jj_consume_token(75);
                this.yyError(ResId.FC_ERR_SYNTAX);
                break;
            }
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 25: 
            case 29: 
            case 31: 
            case 37: 
            case 38: 
            case 56: 
            case 57: 
            case 58: 
            case 67: 
            case 71: 
            case 72: {
                if (!this.mbInSaveMode || this.mnSavedDecl == 0) {
                    this.generate(Instruction.gEnter);
                    this.generate(1);
                }
                this.moScope.setActive(1);
                this.setLine();
                this.ExpressionList();
                this.yyTrace("FormCalculation: ExpressionList");
                this.generate(Instruction.gExit);
                this.generate(this.moScope.exit());
                this.generate(Instruction.gStop);
                this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final int ExpressionList() throws ParseException {
        int $$ = this.Expression();
        this.yyTrace("ExpressionList: Expression");
        while (this.jj_2_1(Integer.MAX_VALUE)) {
            this.generate(Instruction.gDeref);
            this.setLine();
            $$ = this.Expression();
            this.yyTrace("ExpressionList: ExpressionList Expression");
            this.generate(Instruction.gList);
        }
        return $$;
    }

    public final int Var() throws ParseException {
        int $$ = this.moCode.generate();
        this.jj_consume_token(22);
        if (this.mbInVarDeclaration) {
            this.yyError(ResId.FC_ERR_SYNTAX);
        }
        this.mbInVarDeclaration = true;
        if (this.moScope.isGlobal()) {
            $$ = this.generate(Instruction.gGbl);
            this.generate(Instruction.gStop);
        }
        return $$;
    }

    public final CalcSymbol Variable() throws ParseException {
        String $1 = this.Identifier();
        this.yyTrace("Variable: Identifier");
        this.setLine();
        CalcSymbol oSym = null;
        String sParam = this.msFunc;
        sParam = sParam + $1;
        oSym = this.varExists($1, this.moScope);
        if (oSym != null) {
            if (!this.moScope.isGlobal() || !this.mbAllowDups) {
                this.yyError(ResId.FC_ERR_VAR_DUP);
            } else {
                this.generate(Instruction.gLoad);
                this.generate(oSym);
            }
        } else if (this.mbInFuncParameters) {
            oSym = this.moData.install(sParam);
            oSym.setType(7);
            oSym.setStore(18);
        } else if (this.mbInFuncDeclaration && (oSym = this.varExists(sParam, this.moScope)) != null) {
            if (!this.moScope.isGlobal() || !this.mbAllowDups) {
                this.yyError(ResId.FC_ERR_VAR_DUP);
            } else {
                this.generate(Instruction.gLoad);
                this.generate(oSym);
            }
        } else if (this.mbInForeachLoop || this.mbInLoopDeclaration || this.mbInVarDeclaration) {
            oSym = this.moData.install($1);
            oSym.setType(5);
            oSym.setScope(this.moScope.getScope());
            oSym.setStringValue("");
            if (this.mbInFuncDeclaration) {
                oSym.setStore(18);
            } else {
                oSym.setStore(17);
            }
            this.generate(Instruction.gLoad);
            this.generate(oSym);
        }
        return oSym;
    }

    public final int EndVar() throws ParseException {
        this.mbInVarDeclaration = false;
        return this.moCode.generate();
    }

    public final int Func() throws ParseException {
        this.jj_consume_token(25);
        if (this.mbInFuncDeclaration) {
            this.yyError(ResId.FC_ERR_SYNTAX);
        }
        if (!this.moScope.isGlobal()) {
            this.yyError(ResId.FC_ERR_FUNC_DECL);
        }
        this.mbInFuncDeclaration = true;
        this.msFunc = "";
        int $$ = this.generate(Instruction.gFunc);
        this.generate(Instruction.gStop);
        this.generate(Instruction.gStop);
        return $$;
    }

    public final CalcSymbol Function() throws ParseException {
        String $1 = this.Identifier();
        this.yyTrace("Function: Identifier");
        StringBuilder sFunction = new StringBuilder($1);
        for (int i = 0; i < sFunction.length(); ++i) {
            char c = sFunction.charAt(i);
            if ('a' > c || c > 'z') continue;
            sFunction.setCharAt(i, (char)(c & 0xFFFFFFDF));
        }
        CalcSymbol oSym = this.mBuiltin.lookup(sFunction.toString());
        if (oSym == null) {
            oSym = this.moData.lookup($1);
        }
        if (oSym != null) {
            if (oSym.getType() == 4) {
                this.yyError(ResId.FC_ERR_FUNC_USED);
            }
            if (oSym.getType() == 8 && !this.mbAllowDups) {
                this.yyError(ResId.FC_ERR_FUNC_DUP);
            }
            this.msFunc = oSym.getName();
        } else {
            this.msFunc = $1;
            oSym = this.moData.install($1);
            oSym.setType(8);
            oSym.setStore(18);
            oSym.setAddr(0);
            oSym.setCntValue(0);
        }
        this.msFunc = this.msFunc + '`';
        CalcSymbol $$ = oSym;
        this.generate(Instruction.gEnter);
        this.generate(this.moScope.enter());
        return $$;
    }

    public final int Parameters() throws ParseException {
        int $$;
        this.jj_consume_token(67);
        this.mbInFuncParameters = true;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 71: 
            case 72: {
                $$ = this.ParameterList();
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.yyTrace("ParameterList:");
                $$ = 0;
            }
        }
        this.jj_consume_token(68);
        this.mbInFuncParameters = false;
        return $$;
    }

    public final int ParameterList() throws ParseException {
        CalcSymbol $1 = this.Variable();
        this.yyTrace("ParameterList: Variable");
        int $$ = 1;
        if ($1 != null) {
            $1.setIdxValue($$);
        }
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 66: {
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(66);
            CalcSymbol $3 = this.Variable();
            this.yyTrace("ParameterList: ParameterList , Variable");
            ++$$;
            if ($3 == null) continue;
            $3.setIdxValue($$);
        }
        return $$;
    }

    public final int EndFunc() throws ParseException {
        this.jj_consume_token(36);
        this.mbInFuncDeclaration = false;
        this.msFunc = "";
        this.generate(Instruction.gExit);
        this.generate(this.moScope.exit());
        int $$ = this.generate(Instruction.gRet);
        return $$;
    }

    public final int Expression() throws ParseException {
        int $$;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: 
            case 25: {
                $$ = this.DeclarationExpression();
                this.yyTrace("Expression: DeclarationExpression");
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                if (this.jj_2_2(Integer.MAX_VALUE)) {
                    $$ = this.AssignmentExpression();
                    this.yyTrace("Expression: AssignmentSimpleExpression");
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        $$ = this.BreakExpression();
                        this.yyTrace("Expression: ContinueExpression");
                        break block0;
                    }
                    case 38: {
                        $$ = this.ContinueExpression();
                        this.yyTrace("Expression: ContinueExpression");
                        break block0;
                    }
                    case 17: {
                        $$ = this.BlockExpression();
                        this.yyTrace("Expression: BlockExpression");
                        break block0;
                    }
                    case 37: {
                        $$ = this.ForeachExpression();
                        this.yyTrace("Expression: ForeachExpression");
                        break block0;
                    }
                    case 21: {
                        $$ = this.ForExpression();
                        this.yyTrace("Expression: ForExpression");
                        break block0;
                    }
                    case 31: {
                        $$ = this.WhileExpression();
                        this.yyTrace("Expression: WhileExpression");
                        break block0;
                    }
                }
                this.jj_la1[4] = this.jj_gen;
                if (this.jj_2_3(Integer.MAX_VALUE)) {
                    $$ = this.IfExpression();
                    this.yyTrace("Expression: IfExpression");
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 9: 
                    case 10: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 18: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 67: 
                    case 71: 
                    case 72: {
                        $$ = this.SimpleExpression();
                        this.yyTrace("Expression: SimpleExpression");
                        break block0;
                    }
                }
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return $$;
    }

    public final int DeclarationExpression() throws ParseException {
        if (this.jj_2_4(3)) {
            int $1 = this.Var();
            this.Variable();
            this.jj_consume_token(61);
            this.SimpleExpression();
            this.EndVar();
            this.yyTrace("DeclarationExpression: Var Variable = SimpleExpression");
            this.generate(Instruction.gAsgn);
            if (this.moScope.isGlobal()) {
                int $5 = this.moCode.generate();
                int nDecl = this.moCode.getCodeStart() + $1;
                this.moCode.moCodeBase[nDecl + 1] = $5 - $1;
            }
            int $$ = $1;
            return $$;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                int $1 = this.Var();
                this.Variable();
                this.EndVar();
                this.yyTrace("DeclarationExpression: Var Variable");
                CalcSymbol oSym = new CalcSymbol("");
                oSym.setStore(1);
                this.generate(Instruction.gLoad);
                this.generate(oSym);
                this.generate(Instruction.gAsgn);
                if (this.moScope.isGlobal()) {
                    int $3 = this.moCode.generate();
                    int nDecl = this.moCode.getCodeStart() + $1;
                    this.moCode.moCodeBase[nDecl + 1] = $3 - $1;
                }
                int $$ = $1;
                return $$;
            }
            case 25: {
                int $1 = this.Func();
                CalcSymbol $2 = this.Function();
                int $5 = this.Parameters();
                this.jj_consume_token(17);
                this.ExpressionList();
                int $10 = this.EndFunc();
                this.yyTrace("DeclarationExpression: Func Function ( ParameterList ) Do EndFunc");
                int nDecl = this.moCode.getCodeStart() + $1;
                this.moCode.moCodeBase[nDecl + 1] = $2;
                this.moCode.moCodeBase[nDecl + 2] = $10 - $1 + 1;
                if ($2.getType() == 8) {
                    $2.setAddr($1);
                    $2.setCntValue($5);
                }
                int $$ = $1;
                return $$;
            }
        }
        this.jj_la1[6] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int AssignmentExpression() throws ParseException {
        int $1 = this.Accessor();
        this.jj_consume_token(61);
        this.SimpleExpression();
        this.yyTrace("AssignmentExpression: Accessor = SimpleExpression");
        this.generate(Instruction.gAsgn);
        int $$ = $1;
        return $$;
    }

    public final int BlockExpression() throws ParseException {
        this.jj_consume_token(17);
        int $$ = this.generate(Instruction.gEnter);
        this.generate(this.moScope.enter());
        this.ExpressionList();
        this.jj_consume_token(20);
        this.yyTrace("BlockExpression: Do ExpressionList End");
        $$ = this.generate(Instruction.gExit);
        this.generate(this.moScope.exit());
        return $$;
    }

    public final int Foreach() throws ParseException {
        this.jj_consume_token(37);
        int $$ = this.mnLoopOffset = this.generate(Instruction.gForeach);
        this.generate(Instruction.gStop);
        this.generate(Instruction.gStop);
        this.generate(Instruction.gStop);
        this.generate(Instruction.gStop);
        this.generate(Instruction.gEnter);
        this.generate(this.moScope.enter());
        this.mbInForeachLoop = true;
        this.Variable();
        this.generate(Instruction.gAsgn2);
        this.generate(Instruction.gStop);
        return $$;
    }

    public final int In() throws ParseException {
        this.jj_consume_token(19);
        return this.moCode.generate();
    }

    public final int Arguments() throws ParseException {
        int $$;
        this.jj_consume_token(67);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 56: 
            case 57: 
            case 58: 
            case 67: 
            case 71: 
            case 72: {
                $$ = this.ArgumentList();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.yyTrace("ArgumentList:");
                if (this.mbInForeachLoop) {
                    this.yyError(ResId.FC_ERR_LOOP_ARGS);
                }
                $$ = 0;
            }
        }
        this.jj_consume_token(68);
        return $$;
    }

    public final int ArgumentList() throws ParseException {
        this.SimpleExpression();
        this.yyTrace("ArgumentList: SimpleExpression");
        this.generate(Instruction.gNoop);
        int $$ = 1;
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 66: {
                    break;
                }
                default: {
                    this.jj_la1[8] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(66);
            this.SimpleExpression();
            this.yyTrace("ArgumentList: ArgumentList , SimpleExpression");
            ++$$;
        }
        return $$;
    }

    public final int Do() throws ParseException {
        this.jj_consume_token(17);
        int $$ = this.generate(Instruction.gStop);
        if (!this.mbInLoopDeclaration && !this.mbInForeachLoop) {
            this.generate(Instruction.gEnter);
            this.generate(this.moScope.enter());
        }
        return $$;
    }

    public final int EndFor() throws ParseException {
        this.jj_consume_token(34);
        this.generate(Instruction.gStop);
        int $$ = this.generate(Instruction.gExit);
        this.generate(this.moScope.exit());
        return $$;
    }

    public final int ForeachExpression() throws ParseException {
        int $1 = this.Foreach();
        int $2 = this.In();
        int $4 = this.Arguments();
        if ($4 == 0 && this.mbInForeachLoop) {
            this.yyError(ResId.FC_ERR_LOOP_ARGS);
        }
        int $6 = this.Do();
        this.mbInForeachLoop = false;
        this.ExpressionList();
        int $9 = this.EndFor();
        this.yyTrace("ForeachExpression: Foreach Do EndFor");
        int nFor = this.moCode.getCodeStart() + $1;
        this.moCode.moCodeBase[nFor + 1] = $4;
        this.moCode.moCodeBase[nFor + 2] = $2 - $1;
        this.moCode.moCodeBase[nFor + 3] = $6 - $1 + 1;
        this.moCode.moCodeBase[nFor + 4] = $9 - $1;
        int $$ = $1;
        return $$;
    }

    public final int For() throws ParseException {
        this.jj_consume_token(21);
        int $2 = this.mnLoopOffset = this.generate(Instruction.gFor);
        this.generate(Instruction.gStop);
        this.generate(Instruction.gStop);
        this.generate(Instruction.gStop);
        this.generate(Instruction.gStop);
        this.generate(Instruction.gEnter);
        this.generate(this.moScope.enter());
        this.mbInLoopDeclaration = true;
        this.Variable();
        this.jj_consume_token(61);
        this.SimpleExpression();
        this.generate(Instruction.gAsgn);
        this.generate(Instruction.gStop);
        int $$ = $2;
        return $$;
    }

    public final int To() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 28: {
                this.jj_consume_token(28);
                this.mbInDowntoLoop = false;
                int $2 = this.moCode.generate();
                this.SimpleExpression();
                this.generate(Instruction.gLe);
                this.generate(Instruction.gStop);
                int $$ = $2;
                return $$;
            }
            case 32: {
                this.jj_consume_token(32);
                this.mbInDowntoLoop = true;
                int $2 = this.moCode.generate();
                this.SimpleExpression();
                this.generate(Instruction.gGe);
                this.generate(Instruction.gStop);
                int $$ = $2;
                return $$;
            }
        }
        this.jj_la1[9] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int Step() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                this.jj_consume_token(26);
                int nForVar = this.moCode.getCodeStart() + this.mnLoopOffset + 8;
                int $2 = this.generate(Instruction.gLoad);
                this.generate(this.moCode.moCodeBase[nForVar]);
                this.generate(Instruction.gLoad);
                this.generate(this.moCode.moCodeBase[nForVar]);
                this.SimpleExpression();
                if (this.mbInDowntoLoop) {
                    this.generate(Instruction.gSub);
                } else {
                    this.generate(Instruction.gAdd);
                }
                this.generate(Instruction.gAsgn);
                int $$ = $2;
                return $$;
            }
        }
        this.jj_la1[10] = this.jj_gen;
        int nForVar = this.moCode.getCodeStart() + this.mnLoopOffset + 8;
        int $$ = this.generate(Instruction.gLoad);
        this.generate(this.moCode.moCodeBase[nForVar]);
        this.generate(Instruction.gLoad);
        this.generate(this.moCode.moCodeBase[nForVar]);
        CalcSymbol oSym = new CalcSymbol(1);
        oSym.setStore(1);
        this.generate(Instruction.gLoad);
        this.generate(oSym);
        if (this.mbInDowntoLoop) {
            this.generate(Instruction.gSub);
        } else {
            this.generate(Instruction.gAdd);
        }
        this.generate(Instruction.gAsgn);
        return $$;
    }

    public final int ForExpression() throws ParseException {
        int $1 = this.For();
        int $2 = this.To();
        int $3 = this.Step();
        int $4 = this.Do();
        this.mbInLoopDeclaration = false;
        this.ExpressionList();
        int $7 = this.EndFor();
        this.yyTrace("ForExpression: For Do EndFor");
        int nFor = this.moCode.getCodeStart() + $1;
        this.moCode.moCodeBase[nFor + 1] = $2 - $1;
        this.moCode.moCodeBase[nFor + 2] = $3 - $1;
        this.moCode.moCodeBase[nFor + 3] = $4 - $1 + 1;
        this.moCode.moCodeBase[nFor + 4] = $7 - $1;
        int $$ = $1;
        return $$;
    }

    public final int While() throws ParseException {
        this.jj_consume_token(31);
        int $$ = this.mnLoopOffset = this.generate(Instruction.gWhile);
        this.generate(Instruction.gStop);
        this.generate(Instruction.gStop);
        return $$;
    }

    public final int Condition() throws ParseException {
        this.jj_consume_token(67);
        int $2 = this.SimpleExpression();
        this.jj_consume_token(68);
        this.yyTrace("Condition: ( SimpleExpression )");
        int $$ = $2;
        return $$;
    }

    public final int EndWhile() throws ParseException {
        this.jj_consume_token(39);
        int $$ = this.generate(Instruction.gStop);
        this.generate(Instruction.gExit);
        this.generate(this.moScope.exit());
        return $$;
    }

    public final int WhileExpression() throws ParseException {
        int $1 = this.While();
        this.Condition();
        int $3 = this.Do();
        this.ExpressionList();
        int $5 = this.EndWhile();
        this.yyTrace("WhileExpression: While Do EndWhile");
        int nWhile = this.moCode.getCodeStart() + $1;
        this.moCode.moCodeBase[nWhile + 1] = $3 - $1 + 1;
        this.moCode.moCodeBase[nWhile + 2] = $5 - $1 + 1;
        int $$ = $1;
        return $$;
    }

    public final int If() throws ParseException {
        this.jj_consume_token(18);
        int $$ = this.generate(Instruction.gIf);
        this.generate(Instruction.gStop);
        this.generate(Instruction.gStop);
        this.generate(Instruction.gStop);
        return $$;
    }

    public final int Then() throws ParseException {
        this.jj_consume_token(27);
        int $$ = this.generate(Instruction.gStop);
        this.generate(Instruction.gEnter);
        this.generate(this.moScope.enter());
        this.setLine();
        return $$;
    }

    public final int Elif() throws ParseException {
        this.jj_consume_token(33);
        this.generate(Instruction.gExit);
        this.generate(this.moScope.exit());
        int $$ = this.generate(Instruction.gStop);
        this.generate(Instruction.gIf);
        this.generate(Instruction.gStop);
        this.generate(Instruction.gStop);
        this.generate(Instruction.gStop);
        return $$;
    }

    public final int Else() throws ParseException {
        this.jj_consume_token(23);
        this.generate(Instruction.gExit);
        this.generate(this.moScope.exit());
        int $$ = this.generate(Instruction.gStop);
        this.generate(Instruction.gEnter);
        this.generate(this.moScope.enter());
        return $$;
    }

    public final int EndIf() throws ParseException {
        this.jj_consume_token(30);
        this.generate(Instruction.gExit);
        this.generate(this.moScope.exit());
        int $$ = this.generate(Instruction.gStop);
        return $$;
    }

    public final int IfExpression() throws ParseException {
        int $5 = -1;
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            int $1 = this.If();
            this.Condition();
            int $3 = this.Then();
            this.ExpressionList();
            $5 = this.ElifExpression();
            this.yyTrace("IfExpression: If Then ElseIf");
            int nIf = this.moCode.getCodeStart() + $1;
            int nElif = this.moCode.getCodeStart() + $5 + 1;
            assert (this.moCode.moCodeBase[nElif + 3] instanceof Integer);
            nElif = (Integer)this.moCode.moCodeBase[nElif + 3];
            this.moCode.moCodeBase[nIf + 1] = $3 - $1 + 1;
            this.moCode.moCodeBase[nIf + 2] = $5 - $1 + 1;
            this.moCode.moCodeBase[nIf + 3] = nElif + $5 - $1 + 2;
            return $1;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 18: {
                int $1 = this.If();
                this.Condition();
                int $3 = this.Then();
                this.ExpressionList();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        $5 = this.Else();
                        this.ExpressionList();
                        break;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                    }
                }
                int $7 = this.EndIf();
                this.yyTrace("IfExpression: If Then Else Endif");
                int nIf = this.moCode.getCodeStart() + $1;
                this.moCode.moCodeBase[nIf + 1] = $3 - $1 + 1;
                if ($5 >= 0) {
                    this.moCode.moCodeBase[nIf + 2] = $5 - $1 + 1;
                }
                this.moCode.moCodeBase[nIf + 3] = $7 - $1 + 1;
                return $1;
            }
        }
        this.jj_la1[12] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int ElifExpression() throws ParseException {
        int $5 = -1;
        if (this.jj_2_6(Integer.MAX_VALUE)) {
            int $1 = this.Elif();
            this.Condition();
            int $3 = this.Then();
            this.ExpressionList();
            $5 = this.ElifExpression();
            this.yyTrace("ElifExpression: Elseif Then Elseif");
            int nIf = this.moCode.getCodeStart() + $1 + 1;
            int nElif = this.moCode.getCodeStart() + $5 + 1;
            assert (this.moCode.moCodeBase[nElif + 3] instanceof Integer);
            nElif = (Integer)this.moCode.moCodeBase[nElif + 3];
            this.moCode.moCodeBase[nIf + 1] = $3 - $1;
            this.moCode.moCodeBase[nIf + 2] = $5 - $1;
            this.moCode.moCodeBase[nIf + 3] = nElif + $5 - $1;
            return $1;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 33: {
                int $1 = this.Elif();
                this.Condition();
                int $3 = this.Then();
                this.ExpressionList();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        $5 = this.Else();
                        this.ExpressionList();
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                    }
                }
                int $7 = this.EndIf();
                this.yyTrace("ElifExpression: Elseif Then Else EndIf");
                int nIf = this.moCode.getCodeStart() + $1 + 1;
                this.moCode.moCodeBase[nIf + 1] = $3 - $1;
                if ($5 >= 0) {
                    this.moCode.moCodeBase[nIf + 2] = $5 - $1;
                }
                this.moCode.moCodeBase[nIf + 3] = $7 - $1;
                this.generate(Instruction.gStop);
                return $1;
            }
        }
        this.jj_la1[14] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int BreakExpression() throws ParseException {
        this.jj_consume_token(29);
        this.yyTrace("BreakExpression: Break");
        if (this.mnLoopOffset == 0) {
            this.yyError(ResId.FC_ERR_LOOP);
        }
        return this.generate(Instruction.gBreak);
    }

    public final int ContinueExpression() throws ParseException {
        this.jj_consume_token(38);
        this.yyTrace("ContinueExpression: Continue");
        if (this.mnLoopOffset == 0) {
            this.yyError(ResId.FC_ERR_LOOP);
        }
        return this.generate(Instruction.gCont);
    }

    public final int SimpleExpression() throws ParseException {
        int $$ = this.LogicalOrExpression();
        this.yyTrace("LogicalOrExpression: LogicalOrExpression");
        return $$;
    }

    public final int LogicalOrExpression() throws ParseException {
        int $$ = this.LogicalAndExpression();
        this.yyTrace("LogicalOrExpression: LogicalAndExpression");
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: 
                case 54: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            this.Or();
            $$ = this.LogicalAndExpression();
            this.yyTrace("LogicalOrExpression: LogicalOrExpression | LogicalAndExpression");
            this.generate(Instruction.gOr);
        }
        return $$;
    }

    public final int LogicalAndExpression() throws ParseException {
        int $$ = this.EqualityExpression();
        this.yyTrace("LogicalAndExpression: EqualityExpression");
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 43: 
                case 55: {
                    break;
                }
                default: {
                    this.jj_la1[16] = this.jj_gen;
                    break block3;
                }
            }
            this.And();
            $$ = this.EqualityExpression();
            this.yyTrace("LogicalAndExpression: LogicalAndExpression & EqualityExpression");
            this.generate(Instruction.gAnd);
        }
        return $$;
    }

    public final int EqualityExpression() throws ParseException {
        int $$;
        block8: {
            $$ = this.RelationalExpression();
            this.yyTrace("EqualityExpression: RelationalExpression");
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 45: 
                    case 46: 
                    case 48: 
                    case 53: {
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 46: 
                    case 48: {
                        this.Eq();
                        $$ = this.RelationalExpression();
                        this.yyTrace("EqualityExpression: EqualityExpression == RelationalExpression");
                        this.generate(Instruction.gEq);
                        continue block7;
                    }
                    case 45: 
                    case 53: {
                        this.Ne();
                        $$ = this.RelationalExpression();
                        this.yyTrace("EqualityExpression: EqualityExpression <> RelationalExpression");
                        this.generate(Instruction.gNe);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[18] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return $$;
    }

    public final int RelationalExpression() throws ParseException {
        int $$;
        block10: {
            $$ = this.AdditiveExpression();
            this.yyTrace("RelationalExpression: AdditiveExpression");
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 40: 
                    case 41: 
                    case 44: 
                    case 47: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: {
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                        break block10;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 41: 
                    case 50: {
                        this.Gt();
                        $$ = this.AdditiveExpression();
                        this.yyTrace("RelationalExpression: RelationalExpression > AdditiveExpression");
                        this.generate(Instruction.gGt);
                        continue block9;
                    }
                    case 47: 
                    case 49: {
                        this.Ge();
                        $$ = this.AdditiveExpression();
                        this.yyTrace("RelationalExpression: RelationalExpression >= AdditiveExpression");
                        this.generate(Instruction.gGe);
                        continue block9;
                    }
                    case 40: 
                    case 52: {
                        this.Lt();
                        $$ = this.AdditiveExpression();
                        this.yyTrace("RelationalExpression: RelationalExpression < AdditiveExpression");
                        this.generate(Instruction.gLt);
                        continue block9;
                    }
                    case 44: 
                    case 51: {
                        this.Le();
                        $$ = this.AdditiveExpression();
                        this.yyTrace("RelationalExpression: RelationalExpression <= AdditiveExpression");
                        this.generate(Instruction.gLe);
                        continue block9;
                    }
                }
                break;
            }
            this.jj_la1[20] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return $$;
    }

    public final int AdditiveExpression() throws ParseException {
        int $$ = this.MultiplicativeExpression();
        this.yyTrace("AdditiveExpression: MultiplicativeExpression");
        while (this.jj_2_7(Integer.MAX_VALUE)) {
            Token $1;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 57: {
                    $1 = this.jj_consume_token(57);
                    break;
                }
                case 58: {
                    $1 = this.jj_consume_token(58);
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            $$ = this.MultiplicativeExpression();
            this.yyTrace("AdditiveExpression: AdditiveExpression - MultiplicativeExpression");
            this.generate($1.kind == 57 ? Instruction.gAdd : Instruction.gSub);
        }
        return $$;
    }

    public final int MultiplicativeExpression() throws ParseException {
        int $$;
        block8: {
            $$ = this.UnaryExpression();
            this.yyTrace("MultiplicativeExpression: UnaryExpression");
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 59: 
                    case 60: {
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 59: {
                        this.jj_consume_token(59);
                        $$ = this.UnaryExpression();
                        this.yyTrace("MultiplicativeExpression: MultiplicativeExpression * UnaryExpression");
                        this.generate(Instruction.gMul);
                        continue block7;
                    }
                    case 60: {
                        this.jj_consume_token(60);
                        $$ = this.UnaryExpression();
                        this.yyTrace("MultiplicativeExpression: MultiplicativeExpression / UnaryExpression");
                        this.generate(Instruction.gDiv);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[23] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return $$;
    }

    public final int UnaryExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 67: 
            case 71: 
            case 72: {
                int $1 = this.PrimaryExpression();
                this.yyTrace("UnaryExpression: PrimaryExpression");
                int $$ = $1;
                return $$;
            }
            case 57: {
                this.jj_consume_token(57);
                int $2 = this.UnaryExpression();
                this.yyTrace("UnaryExpression: + UnaryExpression");
                this.generate(Instruction.gUplus);
                int $$ = $2;
                return $$;
            }
            case 58: {
                this.jj_consume_token(58);
                int $2 = this.UnaryExpression();
                this.yyTrace("UnaryExpression: - UnaryExpression");
                this.generate(Instruction.gUminus);
                int $$ = $2;
                return $$;
            }
            case 56: {
                this.jj_consume_token(56);
                int $2 = this.UnaryExpression();
                this.yyTrace("UnaryExpression: not UnaryExpression");
                this.generate(Instruction.gNot);
                int $$ = $2;
                return $$;
            }
        }
        this.jj_la1[24] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int PrimaryExpression() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: 
            case 16: {
                this.Null();
                this.yyTrace("PrimaryExpression: NULL");
                this.setLine();
                CalcSymbol oSym = new CalcSymbol();
                oSym.setStore(1);
                int $$ = this.generate(Instruction.gLoad);
                this.generate(oSym);
                return $$;
            }
            case 14: {
                Token string = this.jj_consume_token(14);
                this.yyTrace("PrimaryExpression: STRING");
                this.setLine();
                String s = FormCalcUtil.interpolate(string.image);
                if (s == null) {
                    this.yyError(ResId.FC_ERR_SURROGATE);
                }
                CalcSymbol oSym = new CalcSymbol(s);
                oSym.setStore(1);
                int $$ = this.generate(Instruction.gLoad);
                this.generate(oSym);
                return $$;
            }
            case 9: 
            case 10: {
                double value = this.Number();
                this.yyTrace("PrimaryExpression: Number");
                this.setLine();
                CalcSymbol oSym = new CalcSymbol(value);
                oSym.setStore(1);
                int $$ = this.generate(Instruction.gLoad);
                this.generate(oSym);
                return $$;
            }
        }
        this.jj_la1[25] = this.jj_gen;
        if (this.jj_2_8(Integer.MAX_VALUE)) {
            int $$ = this.FunctionCall();
            this.yyTrace("PrimaryExpression: FunctionCall");
            return $$;
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 71: 
            case 72: {
                int $$ = this.Accessor();
                this.yyTrace("PrimaryExpression: Accessor");
                return $$;
            }
            case 67: {
                this.jj_consume_token(67);
                int $$ = this.SimpleExpression();
                this.jj_consume_token(68);
                return $$;
            }
        }
        this.jj_la1[26] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final double Number() throws ParseException {
        double $$;
        Token $1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                $1 = this.jj_consume_token(9);
                this.yyTrace("Number: INTEGER");
                break;
            }
            case 10: {
                $1 = this.jj_consume_token(10);
                this.yyTrace("Number: REAL");
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        try {
            $$ = Double.parseDouble($1.image);
        }
        catch (NumberFormatException e) {
            $$ = Double.NaN;
        }
        return $$;
    }

    public final int FunctionCall() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 71: 
            case 72: {
                String $1 = this.Identifier();
                this.setLine();
                int $2 = this.moCode.generate();
                int $4 = this.Arguments();
                this.yyTrace("FunctionCall: Identifier ( ArgumentList )");
                StringBuilder sFunction = new StringBuilder($1);
                for (int i = 0; i < sFunction.length(); ++i) {
                    char c = sFunction.charAt(i);
                    if ('a' > c || c > 'z') continue;
                    sFunction.setCharAt(i, (char)(c & 0xFFFFFFDF));
                }
                CalcSymbol oFuncSym = this.mBuiltin.lookup(sFunction.toString());
                if (oFuncSym == null) {
                    oFuncSym = this.moData.lookup($1);
                }
                if (oFuncSym == null && !this.mbInSyntaxCheckMode) {
                    this.yyError(ResId.FC_ERR_FUNC_UNKN, $1);
                } else {
                    this.generate(Instruction.gCall);
                    this.generate($1);
                    this.generate($4);
                }
                return $2;
            }
            case 18: {
                int $$ = this.If();
                int $3 = this.Arguments();
                this.yyTrace("FunctionCall: If ( ArgumentList )");
                this.setLine();
                int nStopOffset = this.generate(Instruction.gStop);
                int nIf = this.moCode.getCodeStart() + $$;
                this.moCode.moCodeBase[nIf + 0] = Instruction.gIfFunc;
                this.moCode.moCodeBase[nIf + 1] = $3;
                this.moCode.moCodeBase[nIf + 3] = nStopOffset - $$ + 1;
                return $$;
            }
        }
        this.jj_la1[28] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int Accessor() throws ParseException {
        int $$;
        block17: {
            String $1 = this.Identifier();
            this.yyTrace("Accessor: Identifier");
            CalcSymbol oSym = null;
            if (this.mbInFuncDeclaration) {
                oSym = this.moData.lookup(this.msFunc + $1);
            }
            if (oSym == null) {
                oSym = this.moData.lookup($1, this.moScope);
            }
            if (oSym == null) {
                oSym = new CalcSymbol();
                oSym.setName($1);
                oSym.setType(9);
                oSym.setStore(1);
            }
            $$ = this.generate(Instruction.gLoad);
            this.generate(oSym);
            block12: while (true) {
                String $3;
                Method $2;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 62: 
                    case 63: 
                    case 64: 
                    case 65: 
                    case 69: {
                        break;
                    }
                    default: {
                        this.jj_la1[29] = this.jj_gen;
                        break block17;
                    }
                }
                if (this.jj_2_9(Integer.MAX_VALUE)) {
                    $2 = this.DotOp();
                    $3 = this.Identifier();
                    int $5 = this.Arguments();
                    this.yyTrace("Accessor: Accessor DotOp Identifier ( ArgumentList )");
                    this.generate(Instruction.gForm);
                    this.generate($3);
                    this.generate($5);
                    $$ = this.generate($2);
                    continue;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 62: 
                    case 63: 
                    case 64: {
                        $2 = this.DotOp();
                        $3 = this.Identifier();
                        this.yyTrace("Accessor: Accessor DotOp Identifier");
                        oSym = new CalcSymbol();
                        oSym.setName($3);
                        oSym.setType(9);
                        oSym.setStore(1);
                        this.generate(Instruction.gLoad);
                        this.generate(oSym);
                        $$ = this.generate($2);
                        continue block12;
                    }
                    case 65: {
                        this.jj_consume_token(65);
                        this.yyTrace("Accessor: Accessor .* ");
                        $$ = this.generate(Instruction.gDotstar);
                        continue block12;
                    }
                    case 69: {
                        this.jj_consume_token(69);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 59: {
                                this.jj_consume_token(59);
                                this.yyTrace("Accessor: Accessor [ * ]");
                                oSym = new CalcSymbol();
                                oSym.setName("*");
                                oSym.setType(9);
                                oSym.setStore(1);
                                this.generate(Instruction.gLoad);
                                this.generate(oSym);
                                $$ = this.generate(Instruction.gIndex);
                                break;
                            }
                            case 9: 
                            case 10: 
                            case 14: 
                            case 15: 
                            case 16: 
                            case 18: 
                            case 56: 
                            case 57: 
                            case 58: 
                            case 67: 
                            case 71: 
                            case 72: {
                                this.SimpleExpression();
                                this.yyTrace("Accessor: Accessor [ SimpleExpression ]");
                                $$ = this.generate(Instruction.gIndex);
                                break;
                            }
                            default: {
                                this.jj_la1[30] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        this.jj_consume_token(70);
                        continue block12;
                    }
                }
                break;
            }
            this.jj_la1[31] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return $$;
    }

    public final Method DotOp() throws ParseException {
        Method $$;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 63: {
                this.jj_consume_token(63);
                $$ = Instruction.gDotdot;
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                $$ = Instruction.gDothash;
                break;
            }
            case 62: {
                this.jj_consume_token(62);
                $$ = Instruction.gDot;
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return $$;
    }

    public final String Identifier() throws ParseException {
        Token $1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 71: {
                $1 = this.jj_consume_token(71);
                break;
            }
            case 72: {
                $1 = this.jj_consume_token(72);
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return $1.image;
    }

    public final void Or() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: {
                this.jj_consume_token(42);
                break;
            }
            case 54: {
                this.jj_consume_token(54);
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void And() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 43: {
                this.jj_consume_token(43);
                break;
            }
            case 55: {
                this.jj_consume_token(55);
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Eq() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 46: {
                this.jj_consume_token(46);
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Ne() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 45: {
                this.jj_consume_token(45);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Le() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 44: {
                this.jj_consume_token(44);
                break;
            }
            case 51: {
                this.jj_consume_token(51);
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Lt() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                this.jj_consume_token(40);
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Ge() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 47: {
                this.jj_consume_token(47);
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                break;
            }
            default: {
                this.jj_la1[40] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Gt() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 41: {
                this.jj_consume_token(41);
                break;
            }
            case 50: {
                this.jj_consume_token(50);
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Null() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            default: {
                this.jj_la1[42] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    private boolean jj_3R_63() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_3R_15()) {
            return true;
        }
        return this.jj_3R_82();
    }

    private boolean jj_3R_114() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(45)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(53)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_108() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(57)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(58)) {
                return true;
            }
        }
        return this.jj_3R_107();
    }

    private boolean jj_3R_113() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(46)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(48)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_102() {
        Token xsp;
        if (this.jj_3R_107()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_108());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_55() {
        if (this.jj_3R_69()) {
            return true;
        }
        if (this.jj_3R_70()) {
            return true;
        }
        if (this.jj_3R_71()) {
            return true;
        }
        if (this.jj_3R_67()) {
            return true;
        }
        if (this.jj_3R_19()) {
            return true;
        }
        return this.jj_3R_68();
    }

    private boolean jj_3R_100() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(43)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(55)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_50() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_63()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_64()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_4() {
        if (this.jj_3R_14()) {
            return true;
        }
        if (this.jj_3R_15()) {
            return true;
        }
        if (this.jj_scan_token(61)) {
            return true;
        }
        if (this.jj_3R_37()) {
            return true;
        }
        return this.jj_3R_82();
    }

    private boolean jj_3R_112() {
        if (this.jj_3R_120()) {
            return true;
        }
        return this.jj_3R_102();
    }

    private boolean jj_3_3() {
        return this.jj_3R_13();
    }

    private boolean jj_3R_95() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(42)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(54)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_111() {
        if (this.jj_3R_119()) {
            return true;
        }
        return this.jj_3R_102();
    }

    private boolean jj_3R_110() {
        if (this.jj_3R_118()) {
            return true;
        }
        return this.jj_3R_102();
    }

    private boolean jj_3R_35() {
        return this.jj_3R_37();
    }

    private boolean jj_3R_24() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(71)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(72)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_34() {
        return this.jj_3R_13();
    }

    private boolean jj_3R_103() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_109()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_110()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_111()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_112()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_109() {
        if (this.jj_3R_117()) {
            return true;
        }
        return this.jj_3R_102();
    }

    private boolean jj_3R_33() {
        return this.jj_3R_56();
    }

    private boolean jj_3R_32() {
        return this.jj_3R_55();
    }

    private boolean jj_3R_47() {
        return this.jj_scan_token(62);
    }

    private boolean jj_3R_31() {
        return this.jj_3R_54();
    }

    private boolean jj_3R_98() {
        Token xsp;
        if (this.jj_3R_102()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_103());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_46() {
        return this.jj_scan_token(64);
    }

    private boolean jj_3_2() {
        return this.jj_3R_12();
    }

    private boolean jj_3R_30() {
        return this.jj_3R_53();
    }

    private boolean jj_3R_90() {
        return false;
    }

    private boolean jj_3R_45() {
        return this.jj_scan_token(63);
    }

    private boolean jj_3R_29() {
        return this.jj_3R_52();
    }

    private boolean jj_3R_105() {
        if (this.jj_3R_114()) {
            return true;
        }
        return this.jj_3R_98();
    }

    private boolean jj_3R_28() {
        return this.jj_3R_51();
    }

    private boolean jj_3R_23() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_45()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_46()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_47()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3R_27() {
        return this.jj_3R_12();
    }

    private boolean jj_3R_92() {
        return this.jj_3R_37();
    }

    private boolean jj_3R_99() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_104()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_105()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_104() {
        if (this.jj_3R_113()) {
            return true;
        }
        return this.jj_3R_98();
    }

    private boolean jj_3R_26() {
        return this.jj_3R_50();
    }

    private boolean jj_3R_11() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_26()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_27()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_28()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_29()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_30()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_31()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_32()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_33()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_34()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_35()) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_93() {
        Token xsp;
        if (this.jj_3R_98()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_99());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_71() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_89()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_90()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_89() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        return this.jj_3R_37();
    }

    private boolean jj_3R_94() {
        if (this.jj_3R_100()) {
            return true;
        }
        return this.jj_3R_93();
    }

    private boolean jj_3R_91() {
        return this.jj_scan_token(59);
    }

    private boolean jj_3R_77() {
        if (this.jj_scan_token(69)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_91()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_92()) {
                return true;
            }
        }
        return this.jj_scan_token(70);
    }

    private boolean jj_3R_76() {
        return this.jj_scan_token(65);
    }

    private boolean jj_3R_78() {
        Token xsp;
        if (this.jj_3R_93()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_94());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_86() {
        return this.jj_scan_token(36);
    }

    private boolean jj_3R_88() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        return this.jj_3R_37();
    }

    private boolean jj_3R_79() {
        if (this.jj_3R_95()) {
            return true;
        }
        return this.jj_3R_78();
    }

    private boolean jj_3R_106() {
        if (this.jj_scan_token(66)) {
            return true;
        }
        return this.jj_3R_15();
    }

    private boolean jj_3R_58() {
        Token xsp;
        if (this.jj_3R_78()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_79());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_75() {
        if (this.jj_3R_23()) {
            return true;
        }
        return this.jj_3R_24();
    }

    private boolean jj_3R_61() {
        if (this.jj_3R_80()) {
            return true;
        }
        return this.jj_3R_19();
    }

    private boolean jj_3R_70() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_87()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_88()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_87() {
        if (this.jj_scan_token(28)) {
            return true;
        }
        return this.jj_3R_37();
    }

    private boolean jj_3_9() {
        if (this.jj_3R_23()) {
            return true;
        }
        if (this.jj_3R_24()) {
            return true;
        }
        return this.jj_3R_25();
    }

    private boolean jj_3R_37() {
        return this.jj_3R_58();
    }

    private boolean jj_3R_101() {
        Token xsp;
        if (this.jj_3R_15()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_106());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_74() {
        if (this.jj_3R_23()) {
            return true;
        }
        if (this.jj_3R_24()) {
            return true;
        }
        return this.jj_3R_25();
    }

    private boolean jj_3R_57() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_74()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_75()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_76()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_77()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_97() {
        return false;
    }

    private boolean jj_3R_52() {
        return this.jj_scan_token(38);
    }

    private boolean jj_3R_96() {
        return this.jj_3R_101();
    }

    private boolean jj_3R_85() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_96()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_97()) {
                return true;
            }
        }
        return this.jj_scan_token(68);
    }

    private boolean jj_3R_59() {
        if (this.jj_3R_80()) {
            return true;
        }
        return this.jj_3R_19();
    }

    private boolean jj_3R_51() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3R_69() {
        if (this.jj_scan_token(21)) {
            return true;
        }
        if (this.jj_3R_15()) {
            return true;
        }
        if (this.jj_scan_token(61)) {
            return true;
        }
        return this.jj_3R_37();
    }

    private boolean jj_3R_42() {
        if (this.jj_3R_21()) {
            return true;
        }
        if (this.jj_3R_17()) {
            return true;
        }
        if (this.jj_3R_18()) {
            return true;
        }
        if (this.jj_3R_19()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_61()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_60();
    }

    private boolean jj_3R_36() {
        Token xsp;
        if (this.jj_3R_24()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_57());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_6() {
        if (this.jj_3R_21()) {
            return true;
        }
        if (this.jj_3R_17()) {
            return true;
        }
        if (this.jj_3R_18()) {
            return true;
        }
        if (this.jj_3R_19()) {
            return true;
        }
        return this.jj_3R_20();
    }

    private boolean jj_3R_54() {
        if (this.jj_3R_65()) {
            return true;
        }
        if (this.jj_3R_66()) {
            return true;
        }
        if (this.jj_3R_25()) {
            return true;
        }
        if (this.jj_3R_67()) {
            return true;
        }
        if (this.jj_3R_19()) {
            return true;
        }
        return this.jj_3R_68();
    }

    private boolean jj_3R_41() {
        if (this.jj_3R_21()) {
            return true;
        }
        if (this.jj_3R_17()) {
            return true;
        }
        if (this.jj_3R_18()) {
            return true;
        }
        if (this.jj_3R_19()) {
            return true;
        }
        return this.jj_3R_20();
    }

    private boolean jj_3R_20() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_41()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_42()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_68() {
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_39() {
        if (this.jj_3R_16()) {
            return true;
        }
        if (this.jj_3R_17()) {
            return true;
        }
        if (this.jj_3R_18()) {
            return true;
        }
        if (this.jj_3R_19()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_59()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_60();
    }

    private boolean jj_3R_44() {
        if (this.jj_3R_16()) {
            return true;
        }
        return this.jj_3R_25();
    }

    private boolean jj_3R_84() {
        return this.jj_3R_24();
    }

    private boolean jj_3_5() {
        if (this.jj_3R_16()) {
            return true;
        }
        if (this.jj_3R_17()) {
            return true;
        }
        if (this.jj_3R_18()) {
            return true;
        }
        if (this.jj_3R_19()) {
            return true;
        }
        return this.jj_3R_20();
    }

    private boolean jj_3R_38() {
        if (this.jj_3R_16()) {
            return true;
        }
        if (this.jj_3R_17()) {
            return true;
        }
        if (this.jj_3R_18()) {
            return true;
        }
        if (this.jj_3R_19()) {
            return true;
        }
        return this.jj_3R_20();
    }

    private boolean jj_3R_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_38()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_39()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_67() {
        return this.jj_scan_token(17);
    }

    private boolean jj_3R_83() {
        return this.jj_scan_token(25);
    }

    private boolean jj_3R_81() {
        if (this.jj_scan_token(66)) {
            return true;
        }
        return this.jj_3R_37();
    }

    private boolean jj_3R_60() {
        return this.jj_scan_token(30);
    }

    private boolean jj_3R_82() {
        return false;
    }

    private boolean jj_3R_62() {
        Token xsp;
        if (this.jj_3R_37()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_81());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_43() {
        if (this.jj_3R_24()) {
            return true;
        }
        return this.jj_3R_25();
    }

    private boolean jj_3R_22() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_43()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_44()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_49() {
        return false;
    }

    private boolean jj_3R_48() {
        return this.jj_3R_62();
    }

    private boolean jj_3R_137() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3R_25() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_48()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_49()) {
                return true;
            }
        }
        return this.jj_scan_token(68);
    }

    private boolean jj_3R_80() {
        return this.jj_scan_token(23);
    }

    private boolean jj_3R_136() {
        return this.jj_scan_token(9);
    }

    private boolean jj_3R_135() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_136()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_137()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_66() {
        return this.jj_scan_token(19);
    }

    private boolean jj_3_8() {
        return this.jj_3R_22();
    }

    private boolean jj_3R_133() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        if (this.jj_3R_37()) {
            return true;
        }
        return this.jj_scan_token(68);
    }

    private boolean jj_3R_132() {
        return this.jj_3R_36();
    }

    private boolean jj_3R_131() {
        return this.jj_3R_22();
    }

    private boolean jj_3R_21() {
        return this.jj_scan_token(33);
    }

    private boolean jj_3R_130() {
        return this.jj_3R_135();
    }

    private boolean jj_3R_65() {
        if (this.jj_scan_token(37)) {
            return true;
        }
        return this.jj_3R_15();
    }

    private boolean jj_3R_15() {
        return this.jj_3R_24();
    }

    private boolean jj_3R_18() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3R_129() {
        return this.jj_scan_token(14);
    }

    private boolean jj_3R_16() {
        return this.jj_scan_token(18);
    }

    private boolean jj_3R_53() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_3R_19()) {
            return true;
        }
        return this.jj_scan_token(20);
    }

    private boolean jj_3R_14() {
        return this.jj_scan_token(22);
    }

    private boolean jj_3_1() {
        return this.jj_3R_11();
    }

    private boolean jj_3R_128() {
        return this.jj_3R_134();
    }

    private boolean jj_3R_127() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_128()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_129()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_130()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_131()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_132()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_133()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_12() {
        if (this.jj_3R_36()) {
            return true;
        }
        if (this.jj_scan_token(61)) {
            return true;
        }
        return this.jj_3R_37();
    }

    private boolean jj_3R_56() {
        if (this.jj_3R_72()) {
            return true;
        }
        if (this.jj_3R_17()) {
            return true;
        }
        if (this.jj_3R_67()) {
            return true;
        }
        if (this.jj_3R_19()) {
            return true;
        }
        return this.jj_3R_73();
    }

    private boolean jj_3R_40() {
        return this.jj_3R_11();
    }

    private boolean jj_3R_124() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        return this.jj_3R_115();
    }

    private boolean jj_3R_19() {
        Token xsp;
        if (this.jj_3R_11()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_40());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_123() {
        if (this.jj_scan_token(58)) {
            return true;
        }
        return this.jj_3R_115();
    }

    private boolean jj_3R_73() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_122() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        return this.jj_3R_115();
    }

    private boolean jj_3R_115() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_121()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_122()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_123()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_124()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_121() {
        return this.jj_3R_127();
    }

    private boolean jj_3R_134() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(15)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(16)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_64() {
        if (this.jj_3R_83()) {
            return true;
        }
        if (this.jj_3R_84()) {
            return true;
        }
        if (this.jj_3R_85()) {
            return true;
        }
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_3R_19()) {
            return true;
        }
        return this.jj_3R_86();
    }

    private boolean jj_3R_17() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        if (this.jj_3R_37()) {
            return true;
        }
        return this.jj_scan_token(68);
    }

    private boolean jj_3R_117() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(41)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(50)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_126() {
        if (this.jj_scan_token(60)) {
            return true;
        }
        return this.jj_3R_115();
    }

    private boolean jj_3R_118() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(47)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(49)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_116() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_125()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_126()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_125() {
        if (this.jj_scan_token(59)) {
            return true;
        }
        return this.jj_3R_115();
    }

    private boolean jj_3R_119() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(40)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(52)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_72() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3R_107() {
        Token xsp;
        if (this.jj_3R_115()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_116());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(57)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(58)) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_120() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(44)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(51)) {
                return true;
            }
        }
        return false;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{-1570257407, 0, 0, 0x2400000, -1608384512, 378368, 0x2400000, 378368, 0, 0x10000000, 0x4000000, 0x800000, 262144, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 378368, 116224, 0, 1536, 262144, 0, 378368, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 98304};
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[]{0x7000060, 0, 0, 0, 96, 0x7000000, 0, 0x7000000, 0, 1, 0, 0, 0, 0, 2, 0x400400, 0x800800, 2187264, 2187264, 2003712, 2003712, 0x6000000, 0x18000000, 0x18000000, 0x7000000, 0, 0, 0, 0, -1073741824, 0xF000000, -1073741824, -1073741824, 0, 0x400400, 0x800800, 81920, 0x202000, 528384, 0x100100, 163840, 262656, 0};
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[]{2440, 384, 4, 0, 0, 392, 0, 392, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 392, 0, 392, 0, 384, 35, 392, 35, 1, 384, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    public CalcParser(InputStream stream) {
        this(stream, null);
    }

    public CalcParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new CalcParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 43; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 43; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CalcParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new CalcParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 43; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 43; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CalcParser(CalcParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 43; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CalcParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 43; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[76];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 43; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 76; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 9; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        CalcParser.jj_la1_init_0();
        CalcParser.jj_la1_init_1();
        CalcParser.jj_la1_init_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    public static enum LegacyVersion {
        CUR_SCRIPTING(0),
        V30_SCRIPTING(1),
        V32_SCRIPTING(2);

        private final int value;

        private LegacyVersion(int nValue) {
            this.value = nValue;
        }

        final int getValue() {
            return this.value;
        }
    }
}

