/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.AppSchema;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.AttributeInfo;
import com.adobe.xfa.ChildReln;
import com.adobe.xfa.ChildRelnInfo;
import com.adobe.xfa.DSigData;
import com.adobe.xfa.Element;
import com.adobe.xfa.EnumValue;
import com.adobe.xfa.GenericNode;
import com.adobe.xfa.GenericTextContainer;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.NodeSchema;
import com.adobe.xfa.RichTextNode;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.XFA;
import com.adobe.xfa.XMLMultiSelectNode;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormat;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;

public abstract class Schema {
    private static final NodeSchema gNullSchema = new NodeSchema(0, 0, 0, 0);
    public static final int XFAAVAILABILITY_ALL = 63;
    public static final int XFAAVAILABILITY_CORE = 1;
    public static final int XFAAVAILABILITY_DEPRECATED = 0;
    public static final int XFAAVAILABILITY_DYNAMIC = 16;
    public static final int XFAAVAILABILITY_PLUGIN = 8;
    public static final int XFAAVAILABILITY_XFAF = 4;
    public static final int XFAAVAILABILITY_XFASUBSET = 2;
    public static final int XFAAVAILABILITY_XFADESIGNER = 32;
    public static final int XFAVERSION_10 = 10;
    public static final int XFAVERSION_21 = 21;
    public static final int XFAVERSION_22 = 22;
    public static final int XFAVERSION_23 = 23;
    public static final int XFAVERSION_24 = 24;
    public static final int XFAVERSION_25 = 25;
    public static final int XFAVERSION_26 = 26;
    public static final int XFAVERSION_27 = 27;
    public static final int XFAVERSION_28 = 28;
    public static final int XFAVERSION_29 = 29;
    public static final int XFAVERSION_30 = 30;
    public static final int XFAVERSION_31 = 31;
    public static final int XFAVERSION_32 = 32;
    public static final int XFAVERSION_33 = 33;
    public static final int XFAVERSION_34 = 34;
    public static final int XFAVERSION_35 = 35;
    public static final int XFAVERSION_HEAD = 35;
    public static final int XFAVERSION_LOCALESETHEAD = 27;
    public static final int XFAVERSION_SOURCESETHEAD = 28;
    public static final int XFAVERSION_CONNECTIONSETHEAD = 28;
    public static final int XFAVERSION_CONFIGURATIONHEAD = 35;
    public static final int XFAVERSION_OBS = 10;
    private boolean mbInitiated;
    private boolean mbSchemaUsesProtos;
    private Schema mForeignSchemas;
    protected final int mnAttributeMax;
    protected final int mnAttributeMin;
    protected final int mnElementMax;
    protected final int mnElementMin;
    private final NodeSchema[] mNodeSchemas = new NodeSchema[407];
    private final String mSchemaNS;

    public static final NodeSchema nullSchema() {
        return gNullSchema;
    }

    protected Schema(String sNS, int nAttributeMin, int nAttributeMax, int nElementMin, int nElementMax) {
        this.mnAttributeMin = nAttributeMin;
        this.mnAttributeMax = nAttributeMax;
        this.mnElementMin = nElementMin;
        this.mnElementMax = nElementMax;
        this.mbSchemaUsesProtos = true;
        this.mSchemaNS = sNS;
    }

    public void addForeignSchema(Schema schema) {
        assert (this.mForeignSchemas == null || this.mForeignSchemas == schema);
        this.mForeignSchemas = schema;
    }

    static void checkVersion(int eClassTag, Model model, Element parent) {
        ChildRelnInfo info;
        if (parent != null && model != null && (info = parent.getNodeSchema().getChildRelnInfo(eClassTag)) != null) {
            if (!model.validateUsage(info.getVersionIntroduced(), info.getAvailability(), true)) {
                MsgFormatPos reason = new MsgFormatPos(ResId.InvalidChildVersionException);
                reason.format(XFA.getAtom(eClassTag));
                reason.format(parent.getClassAtom());
                if (model.validateUsageFailedIsFatal(info.getVersionIntroduced(), info.getAvailability())) {
                    throw new ExFull(reason);
                }
                model.addErrorList(new ExFull(reason), 3, parent);
            }
            int nTargetVer = model.getCurrentVersion();
            if (info.getVersionDeprecated() != 0 && info.getVersionDeprecated() <= nTargetVer) {
                MsgFormatPos reason = new MsgFormatPos(ResId.DeprecatedChildException);
                reason.format(XFA.getAtom(eClassTag));
                reason.format(parent.getClassAtom());
                if (model.isLoading()) {
                    model.addXMLLoadErrorContext(parent, new ExFull(reason));
                }
            }
        }
    }

    public Attribute defaultAttribute(int attrName, int eClassTag) {
        AttributeInfo attrInfo;
        Schema schema = this.findSchema(eClassTag);
        if (schema == null) {
            throw new ExFull(ResId.InvalidNodeTypeException, "");
        }
        if (schema != this) {
            return schema.defaultAttribute(attrName, eClassTag);
        }
        Attribute attr = null;
        NodeSchema nodeSchema = this.mNodeSchemas[eClassTag - this.mnElementMin];
        if (nodeSchema != null && (attrInfo = nodeSchema.getAttributeInfo(attrName)) != null) {
            attr = attrInfo.getDefault();
        }
        if (attr == null) {
            throw new ExFull(ResId.InvalidAttributeException, " (" + XFA.getString(attrName) + ")");
        }
        return attr;
    }

    private final int ELEMENT_COUNT() {
        return this.mnElementMax - this.mnElementMin + 1;
    }

    protected Schema findForeignSchema(String aNS, int eTag) {
        if (this.mForeignSchemas != null && this.mForeignSchemas.getNS() == aNS) {
            return this.mForeignSchemas;
        }
        return null;
    }

    private Schema findSchema(int classTag) {
        if (this.validTag(classTag)) {
            return this;
        }
        if (this.mForeignSchemas != null && this.mForeignSchemas.validTag(classTag)) {
            return this.mForeignSchemas;
        }
        return null;
    }

    public String getAtom(int classTag) {
        Schema schema = this.findSchema(classTag);
        if (schema == null) {
            throw new ExFull(new MsgFormat(ResId.InvalidNodeTypeException, ""));
        }
        if (schema == this) {
            return XFA.getAtom(classTag);
        }
        return schema.getAtom(classTag);
    }

    public int getAttributeTag(String aNS, String aAttrName) {
        if (this.mForeignSchemas != null && aNS == this.mForeignSchemas.getNS()) {
            return this.mForeignSchemas.getAttributeTag(aNS, aAttrName);
        }
        return XFA.getTagImpl(aAttrName, Boolean.FALSE);
    }

    public int getElementTag(String aNS, String aNodeName) {
        if (this.mForeignSchemas != null && aNS == this.mForeignSchemas.getNS()) {
            return this.mForeignSchemas.getElementTag(aNS, aNodeName);
        }
        return XFA.getTagImpl(aNodeName, Boolean.TRUE);
    }

    protected int getElementTag(Element parent) {
        return -1;
    }

    public final Element getInstance(int eTag, Model model, Element parent, Node prevSibling, boolean bDoVersionCheck) {
        boolean bValidate;
        assert (eTag >= 0);
        assert (model != null);
        Schema schema = this.findSchema(eTag);
        if (schema == null) {
            throw new ExFull(ResId.InvalidNodeTypeException, "");
        }
        Element element = null;
        if (schema != this) {
            return schema.getInstance(eTag, model, parent, prevSibling, bDoVersionCheck);
        }
        NodeSchema nodeSchema = null;
        if (eTag >= this.mnElementMin && eTag <= this.mnElementMax) {
            nodeSchema = this.mNodeSchemas[eTag - this.mnElementMin];
        }
        if (nodeSchema == null) {
            String className = this.getAtom(eTag);
            throw new ExFull(ResId.InvalidNodeTypeException, className);
        }
        boolean bl = bValidate = !(schema instanceof AppSchema);
        if (parent != null && bValidate) {
            ChildRelnInfo info = parent.getNodeSchema().getChildRelnInfo(eTag);
            if (info != null) {
                if (bDoVersionCheck) {
                    Schema.checkVersion(eTag, model, parent);
                }
            } else if (schema.getElementTag(parent) == -1) {
                MsgFormatPos message = new MsgFormatPos(ResId.InvalidChildAppendException, parent.getClassAtom());
                message.format(XFA.getAtom(eTag));
                throw new ExFull(message);
            }
        }
        String className = this.getAtom(eTag);
        if (this.mNodeSchemas[eTag] == null) {
            throw new ExFull(ResId.InvalidNodeTypeException, className);
        }
        element = this.newElement(eTag, parent, prevSibling);
        if (element == null) {
            if (this.mbSchemaUsesProtos) {
                switch (eTag) {
                    case 1: {
                        element = new RichTextNode(parent, prevSibling);
                        break;
                    }
                    case 2: {
                        element = new XMLMultiSelectNode(parent, prevSibling);
                        break;
                    }
                    case 76: {
                        element = new DSigData(parent, prevSibling);
                    }
                }
            }
            if (element == null) {
                throw new ExFull(ResId.InvalidNodeTypeException, className);
            }
        }
        element.setLocalName(className);
        element.setQName(className);
        element.setNS(model);
        if (element instanceof GenericNode || element instanceof GenericTextContainer) {
            element.setClass(className, eTag);
        }
        if (parent == null) {
            element.setModel(model);
            element.setDocument(model.getDocument());
        }
        return element;
    }

    public final NodeSchema getNodeSchema(int eClassTag) {
        Schema schema = this.findSchema(eClassTag);
        if (schema == null) {
            return gNullSchema;
        }
        NodeSchema nodeSchema = schema.mNodeSchemas[eClassTag - schema.mnElementMin];
        if (nodeSchema != null) {
            return nodeSchema;
        }
        return gNullSchema;
    }

    public String getNS() {
        return this.mSchemaNS;
    }

    protected int getTextTag() {
        return 0;
    }

    protected void importSchema(Schema sourceSchema) {
        this.mForeignSchemas = sourceSchema.mForeignSchemas;
        int srcCount = sourceSchema.mnElementMax - sourceSchema.mnElementMin;
        for (int nPos = 0; nPos < srcCount; ++nPos) {
            NodeSchema src = sourceSchema.mNodeSchemas[nPos];
            NodeSchema dest = src == null ? null : new NodeSchema(src, this.mnAttributeMin, this.mnAttributeMax, this.mnElementMin, this.mnElementMax);
            this.mNodeSchemas[nPos] = dest;
        }
        this.mbInitiated = true;
    }

    protected void initSchema() {
        if (this.mbInitiated) {
            return;
        }
        this.mbInitiated = true;
        if (this.mbSchemaUsesProtos) {
            this.mNodeSchemas[1 - this.mnElementMin] = new NodeSchema(this.mnAttributeMin, this.mnAttributeMax, this.mnElementMin, this.mnElementMax);
            this.mNodeSchemas[2 - this.mnElementMin] = new NodeSchema(this.mnAttributeMin, this.mnAttributeMax, this.mnElementMin, this.mnElementMax);
            this.mNodeSchemas[76 - this.mnElementMin] = new NodeSchema(this.mnAttributeMin, this.mnAttributeMax, this.mnElementMin, this.mnElementMax);
            this.putAttribute(76, 521, null, 10, 63, 0);
        }
    }

    public Attribute newAttribute(int attrName, String value, int eClassTag) {
        AttributeInfo attrInfo;
        Schema schema = this.findSchema(eClassTag);
        if (schema == null) {
            throw new ExFull(ResId.InvalidNodeTypeException, "");
        }
        if (schema != this) {
            return schema.newAttribute(attrName, value, eClassTag);
        }
        Attribute attr = null;
        NodeSchema nodeSchema = this.mNodeSchemas[eClassTag - this.mnElementMin];
        if (nodeSchema != null && (attrInfo = nodeSchema.getAttributeInfo(attrName)) != null) {
            attr = attrInfo.getDefault();
        }
        if (attr == null) {
            throw new ExFull(ResId.InvalidAttributeException, " (" + XFA.getString(attrName) + "=" + value + ")");
        }
        return attr.newAttribute(value);
    }

    protected abstract Element newElement(int var1, Element var2, Node var3);

    protected void putAttribute(int eParent, EnumValue value, int nVersionIntro, int nAvailability, int nVersionDep) {
        this.putAttribute(eParent, value.getAttrTag(), value, nVersionIntro, nAvailability, nVersionDep);
    }

    protected void putAttribute(int eParent, int eAttr, Attribute defaultValue, int nVersionIntro, int nAvailability, int nVersionDep) {
        assert (eAttr >= 362);
        NodeSchema nodeSchema = this.mNodeSchemas[eParent - this.mnElementMin];
        if (nodeSchema == null) {
            this.mNodeSchemas[eParent - this.mnElementMin] = nodeSchema = new NodeSchema(this.mnAttributeMin, this.mnAttributeMax, this.mnElementMin, this.mnElementMax);
        }
        nodeSchema.addAttr(eAttr, defaultValue == null ? new StringAttr("", "") : defaultValue, nVersionIntro, nVersionDep, nAvailability, 0);
    }

    protected void putChildAttrs(int eTag) {
        this.putAttribute(eTag, 574, null, 10, 7, 0);
        this.putAttribute(eTag, 521, null, 10, 7, 0);
        this.putAttribute(eTag, 697, null, 10, 3, 0);
        this.putAttribute(eTag, 698, null, 26, 3, 0);
    }

    protected void putElement(int eParent, int eChild, ChildReln oRelation, int nVersionIntro, int nAvailability, int nVersionDep) {
        assert (eChild - this.mnElementMin < this.ELEMENT_COUNT());
        NodeSchema nodeSchema = this.mNodeSchemas[eParent - this.mnElementMin];
        if (nodeSchema == null) {
            this.mNodeSchemas[eParent - this.mnElementMin] = nodeSchema = new NodeSchema(this.mnAttributeMin, this.mnAttributeMax, this.mnElementMin, this.mnElementMax);
        }
        nodeSchema.addChild(eChild, oRelation, nVersionIntro, nVersionDep, nAvailability, 0);
        if (this.mbSchemaUsesProtos) {
            NodeSchema protoNodeSchema = this.mNodeSchemas[251 - this.mnElementMin];
            if (protoNodeSchema == null) {
                this.mNodeSchemas[251 - this.mnElementMin] = protoNodeSchema = new NodeSchema(this.mnAttributeMin, this.mnAttributeMax, this.mnElementMin, this.mnElementMax);
            }
            if (eChild != 251 && eChild != 0 && eChild != 1 && eChild != 2) {
                protoNodeSchema.addChild(eChild, ChildReln.getZeroOrMore(), nVersionIntro, nVersionDep, nAvailability, 0);
            }
        }
    }

    public void putForeignElement(int eParent, int eChild, ChildReln relation, Schema foreignSchema, int nVersionIntro, int nAvailability, int nVersionDep) {
        assert (foreignSchema.validTag(eChild));
        NodeSchema nodeSchema = this.mNodeSchemas[eParent - this.mnElementMin];
        if (nodeSchema == null) {
            this.mNodeSchemas[eParent - this.mnElementMin] = nodeSchema = new NodeSchema(this.mnAttributeMin, this.mnAttributeMax, this.mnElementMin, this.mnElementMax);
        }
        nodeSchema.addForeignChild(eChild, relation, nVersionIntro, nVersionDep, nAvailability, 0);
    }

    protected void putPropAttrs(int eTag) {
        this.putAttribute(eTag, 521, null, 10, 3, 0);
        this.putAttribute(eTag, 697, null, 10, 3, 0);
        this.putAttribute(eTag, 698, null, 26, 3, 0);
    }

    protected final void schemaUsesProtos(boolean bUseProto) {
        this.mbSchemaUsesProtos = bUseProto;
    }

    private boolean validTag(int classTag) {
        return classTag >= this.mnElementMin && classTag <= this.mnAttributeMax;
    }
}

