/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.CDataNode;
import com.adobe.xfa.Chars;
import com.adobe.xfa.ChildReln;
import com.adobe.xfa.Comment;
import com.adobe.xfa.Document;
import com.adobe.xfa.Element;
import com.adobe.xfa.Generator;
import com.adobe.xfa.Model;
import com.adobe.xfa.ModelPeer;
import com.adobe.xfa.Node;
import com.adobe.xfa.Packet;
import com.adobe.xfa.ProcessingInstruction;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.TextNode;
import com.adobe.xfa.content.ExDataValue;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public final class SaxHandler
implements ContentHandler,
LexicalHandler,
ErrorHandler {
    private final Document mDoc;
    private final String mFileName;
    private final AppModel mAppModel;
    private Model mCurrentModel;
    private Element[] mParentStack = new Element[16];
    private int mParentDepth;
    private Node mPreviousSibling;
    private Element mStartingParent;
    private boolean mbIgnoreNextElement;
    private Locator mLocator;
    private Generator mGenerator;
    private char[] mCharBuffer = new char[128];
    private int mCharCount;
    private final List<Element> mLoadedModelsAndPackets = new ArrayList<Element>();
    private static String[] whitespaceCache = new String[32];

    SaxHandler(Document d) {
        this.mDoc = d;
        this.mFileName = d.getParseFileName();
        this.mAppModel = d.getAppModel();
    }

    void setContext(Model startingModel, Element startingParent, boolean bIgnoreAggregating) {
        assert (startingParent != null);
        this.mCurrentModel = startingModel;
        this.mStartingParent = startingParent;
        this.mbIgnoreNextElement = bIgnoreAggregating;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.mLocator = locator;
    }

    @Override
    public void startDocument() {
        this.pushParent(this.mDoc);
        this.mDoc.setWillDirty(false);
    }

    @Override
    public void endDocument() {
        if (this.mAppModel != null) {
            this.mAppModel.postLoad();
        }
        for (int i = 0; i < this.mLoadedModelsAndPackets.size(); ++i) {
            Element element = this.mLoadedModelsAndPackets.get(i);
            if (element instanceof Model) {
                Model model = (Model)element;
                model.disposeSymbolTable();
                boolean stripWhiteSpace = true;
                Model node = model instanceof Model.DualDomModel ? (Element)model.getXmlPeer() : model;
                for (Node child = model.getFirstXMLChild(); child != null; child = child.getNextXMLSibling()) {
                    if (!(child instanceof Chars) || ((Chars)child).isXMLSpace()) continue;
                    stripWhiteSpace = false;
                    break;
                }
                if (stripWhiteSpace) {
                    node.removeWhiteSpace();
                }
                this.mDoc.declareXFAId(model.getNSInternal(), "id");
                this.mDoc.indexSubtree(model, false);
                this.mDoc.setWillDirty(true);
                model.postLoad();
                this.mDoc.setWillDirty(false);
                continue;
            }
            this.mDoc.declareXFAId(element.getNSInternal(), "id");
            this.mDoc.indexSubtree(element, false);
        }
        this.mDoc.setWillDirty(true);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        Element e;
        Element parent;
        this.flushCharacters();
        if (this.mStartingParent != null) {
            this.pushParent(this.mStartingParent);
            parent = this.mStartingParent;
            this.mPreviousSibling = this.mStartingParent.getLastXMLChild();
            this.mStartingParent = null;
            if (this.mCurrentModel != null) {
                this.mLoadedModelsAndPackets.add(this.mCurrentModel);
            }
            if (this.mbIgnoreNextElement) {
                this.mbIgnoreNextElement = false;
                return;
            }
        } else {
            parent = this.peekParent();
        }
        int nLineNumber = this.mLocator.getLineNumber();
        this.validateIdUniqueness(uri, localName, attributes);
        if (this.mCurrentModel == null) {
            if (this.mParentDepth == 1) {
                if (this.mAppModel.isXFANode(uri, localName, qName)) {
                    e = new ModelPeer(this.mDoc, this.mPreviousSibling, uri, localName, qName, attributes, this.mAppModel);
                    if (this.mAppModel.getOwnerDocument().isDefaultDocument()) {
                        this.mAppModel.setXmlPeer(e);
                        this.mAppModel.setDocument(this.mDoc);
                    } else {
                        int index = e.findAttr("", "uuid");
                        if (index != -1) {
                            this.mAppModel.setAttribute(new StringAttr("uuid", e.getAttrVal(index)), 699);
                        }
                        if ((index = e.findAttr("", "timeStamp")) != -1) {
                            this.mAppModel.setAttribute(new StringAttr("timeStamp", e.getAttrVal(index)), 400);
                        }
                    }
                } else {
                    try {
                        this.mAppModel.setAllowThirdPartyXml(true);
                        e = this.createModelOrPacket(parent, uri, localName, qName, attributes, nLineNumber);
                    }
                    finally {
                        this.mAppModel.setAllowThirdPartyXml(false);
                    }
                }
            } else if (this.mParentDepth == 2 && parent instanceof ModelPeer) {
                e = this.createModelOrPacket(parent, uri, localName, qName, attributes, nLineNumber);
            } else {
                assert (parent.getClassTag() == -1 || parent.getClassTag() == 220);
                e = new Element(parent, this.mPreviousSibling, uri, localName, qName, attributes, -1, "");
            }
            e.setLineNumber(nLineNumber);
        } else if (parent instanceof ExDataValue) {
            e = new Element(parent, this.mPreviousSibling, uri, localName, qName, attributes, -1, "");
            e.setLineNumber(nLineNumber);
        } else {
            e = this.mCurrentModel.createElement(parent, this.mPreviousSibling, uri, localName, qName, attributes, nLineNumber, this.mFileName);
        }
        e.setDocument(this.mDoc);
        this.pushParent(e);
        this.mPreviousSibling = null;
    }

    private void validateIdUniqueness(String aElementNameSpaceURI, String aElementLocalName, Attributes attributes) {
        if (this.mDoc.uniquifyIDsOnParse()) {
            return;
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            if (!this.mDoc.isId(aElementNameSpaceURI, aElementLocalName, attributes.getURI(i), attributes.getLocalName(i)) || !this.mDoc.idValueInUse(attributes.getValue(i))) continue;
            throw new ExFull(ResId.DOM_DUPLICATE_ID_ERR);
        }
    }

    private Element createModelOrPacket(Element xmlParent, String uri, String localName, String qName, Attributes attributes, int nLineNumber) {
        Element e = this.mAppModel.createElement(this.mAppModel, null, uri, localName, qName, attributes, nLineNumber, this.mFileName);
        Element xmlPeer = (Element)((Element.DualDomNode)((Object)e)).getXmlPeer();
        e.setDocument(this.mDoc);
        xmlPeer.setDocument(this.mDoc);
        if (e instanceof Model) {
            this.mCurrentModel = (Model)e;
            this.mLoadedModelsAndPackets.add(this.mCurrentModel);
            this.mCurrentModel.isLoading(true);
            this.mCurrentModel.initializeSymbolTable();
            this.mCurrentModel.setGenerator(this.mGenerator);
        } else assert (e instanceof Packet);
        if (e instanceof Model.DualDomModel) {
            xmlParent.appendChild(xmlPeer);
            xmlPeer.setModel((Model)e);
            e = xmlPeer;
        } else if (xmlPeer.getXMLParent() != null && xmlPeer.getXMLParent() != xmlParent) {
            xmlParent.appendChild(xmlPeer);
        }
        return e;
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.flushCharacters();
        this.mPreviousSibling = this.popParent();
        if (this.mPreviousSibling instanceof Model || this.mPreviousSibling instanceof ModelPeer) {
            Model model = this.mPreviousSibling.getModel();
            model.isLoading(false);
            this.mPreviousSibling = model.getXmlPeer();
            this.mCurrentModel = null;
        } else if (this.mPreviousSibling instanceof Packet) {
            this.mPreviousSibling = ((Packet)this.mPreviousSibling).getXmlPeer();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.mbIgnoreNextElement) {
            return;
        }
        if (length == 0) {
            return;
        }
        if (length > this.mCharBuffer.length - this.mCharCount) {
            int requiredLength = this.mCharCount + length;
            int newCapacity = this.mCharBuffer.length;
            do {
                if ((newCapacity *= 2) >= 0) continue;
                newCapacity = Integer.MAX_VALUE;
            } while (newCapacity < requiredLength);
            char[] newCharBuffer = new char[newCapacity];
            System.arraycopy(this.mCharBuffer, 0, newCharBuffer, 0, this.mCharCount);
            this.mCharBuffer = newCharBuffer;
        }
        System.arraycopy(ch, start, this.mCharBuffer, this.mCharCount, length);
        this.mCharCount += length;
    }

    private void flushCharacters() {
        TextNode t;
        if (this.mCharCount == 0) {
            return;
        }
        Element parent = this.peekParent();
        if (parent instanceof AppModel) {
            this.mPreviousSibling = new Chars(parent, this.mPreviousSibling, this.mCharBuffer, 0, this.mCharCount);
            this.mCharCount = 0;
            return;
        }
        if (this.mCurrentModel != null && parent != null && parent.processTextChildrenDuringParse()) {
            ChildReln childReln = parent.getChildReln(0);
            if (childReln == null && Chars.isXMLSpace(0, this.mCharCount, this.mCharBuffer)) {
                this.mCharCount = 0;
                return;
            }
            if (childReln != null && childReln.getMax() == 1) {
                for (Node child = parent.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    if (!(child instanceof TextNode)) continue;
                    TextNode firstTextNode = (TextNode)child;
                    StringBuilder sText = new StringBuilder(firstTextNode.getText());
                    sText.append(this.mCharBuffer, 0, this.mCharCount);
                    firstTextNode.setText(sText.toString());
                    this.mCharCount = 0;
                    return;
                }
            }
            try {
                if (!parent.isValidChild(0, ResId.InvalidChildAppendException, true, false)) {
                    this.mCharCount = 0;
                    return;
                }
            }
            catch (ExFull ex) {
                this.mCurrentModel.addErrorList(ex, 5, parent);
                this.mCharCount = 0;
                return;
            }
            t = this.mCurrentModel.createTextNode(parent, this.mPreviousSibling, this.mCharBuffer, 0, this.mCharCount);
        } else {
            t = new TextNode(parent, this.mPreviousSibling, this.getTextNodeStringFromCharBuffer());
        }
        this.mCharCount = 0;
        this.mPreviousSibling = t;
    }

    private String getTextNodeStringFromCharBuffer() {
        assert (this.mCharCount > 0);
        if (this.isCacheableWhitespace()) {
            String result;
            if (this.mCharCount >= whitespaceCache.length) {
                String[] newCache = new String[whitespaceCache.length * 2];
                System.arraycopy(whitespaceCache, 0, newCache, 0, whitespaceCache.length);
                whitespaceCache = newCache;
            }
            if ((result = whitespaceCache[this.mCharCount]) == null) {
                SaxHandler.whitespaceCache[this.mCharCount] = result = new String(this.mCharBuffer, 0, this.mCharCount);
            }
            return result;
        }
        return new String(this.mCharBuffer, 0, this.mCharCount);
    }

    private boolean isCacheableWhitespace() {
        char[] buffer = this.mCharBuffer;
        if (buffer[0] != '\n') {
            return false;
        }
        for (int i = this.mCharCount - 1; i > 0; --i) {
            if (buffer[i] == ' ') continue;
            return false;
        }
        return true;
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void processingInstruction(String target, String data) {
        this.flushCharacters();
        Element parent = this.peekParent();
        ProcessingInstruction pi = new ProcessingInstruction(parent, this.mPreviousSibling, target, data);
        if (pi.getName() == "xfa") {
            this.mGenerator = new Generator(pi);
        }
        if (this.mCurrentModel != null) {
            this.mCurrentModel.preLoadNode(parent, pi, this.mGenerator);
        }
        this.mPreviousSibling = pi;
    }

    @Override
    public void skippedEntity(String name) {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) {
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void startEntity(String name) {
    }

    @Override
    public void endEntity(String name) {
    }

    @Override
    public void startCDATA() {
        if (this.mCharCount > 0) {
            this.flushCharacters();
            this.mCharCount = 0;
        }
    }

    @Override
    public void endCDATA() {
        Element parent;
        if (this.mStartingParent != null) {
            this.pushParent(this.mStartingParent);
            parent = this.mStartingParent;
            this.mPreviousSibling = this.mStartingParent.getLastXMLChild();
            this.mStartingParent = null;
            if (this.mCurrentModel != null) {
                this.mLoadedModelsAndPackets.add(this.mCurrentModel);
            }
            if (this.mbIgnoreNextElement) {
                this.mbIgnoreNextElement = false;
                return;
            }
        } else {
            parent = this.peekParent();
        }
        CDataNode cdNode = new CDataNode(parent, this.mPreviousSibling, this.mCharBuffer, 0, this.mCharCount);
        this.mPreviousSibling = cdNode;
        this.mCharCount = 0;
    }

    @Override
    public void comment(char[] ch, int start, int length) {
        this.flushCharacters();
        Element parent = this.peekParent();
        String data = new String(ch, start, length);
        Comment c = new Comment(parent, this.mPreviousSibling, data);
        if (this.mCurrentModel != null) {
            this.mCurrentModel.preLoadNode(parent, c, this.mGenerator);
        }
        this.mPreviousSibling = c;
    }

    @Override
    public void warning(SAXParseException exception) {
        throw SaxHandler.createXFAException(exception);
    }

    @Override
    public void error(SAXParseException exception) {
        throw SaxHandler.createXFAException(exception);
    }

    @Override
    public void fatalError(SAXParseException exception) {
        throw SaxHandler.createXFAException(exception);
    }

    private void pushParent(Element e) {
        if (this.mParentDepth == this.mParentStack.length) {
            Element[] newStack = new Element[this.mParentStack.length * 2];
            System.arraycopy(this.mParentStack, 0, newStack, 0, this.mParentDepth);
            this.mParentStack = newStack;
        }
        this.mParentStack[this.mParentDepth++] = e;
    }

    private Element peekParent() {
        if (this.mParentDepth == 0) {
            return null;
        }
        return this.mParentStack[this.mParentDepth - 1];
    }

    private Element popParent() {
        Element e = this.mParentStack[this.mParentDepth - 1];
        this.mParentStack[this.mParentDepth - 1] = null;
        --this.mParentDepth;
        return e;
    }

    private static ExFull createXFAException(SAXParseException inException) {
        return new ExFull(ResId.EXPAT_ERROR, inException.getMessage());
    }
}

