/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.xfa;

import com.adobe.xfa.Arg;
import com.adobe.xfa.DOMSaveOptions;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.ResId;
import com.adobe.xfa.ut.StringUtils;
import java.io.IOException;
import java.io.OutputStream;

public class Chars
extends Node {
    private String mText;

    public Chars(Element parent, Node prevSibling, char[] text, int start, int length) {
        super(parent, prevSibling);
        this.mText = text == null ? "" : new String(text, start, length);
    }

    public Chars(Element parent, Node prevSibling, String text) {
        super(parent, prevSibling);
        this.mText = text;
    }

    @Override
    public Node clone(Element parent) {
        return new Chars(parent, parent.getLastXMLChild(), this.mText);
    }

    @Override
    public String getData() {
        return this.mText;
    }

    @Override
    public String getName() {
        return "";
    }

    public String getText() {
        return this.mText;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public boolean isXMLSpace() {
        for (int i = 0; i < this.mText.length(); ++i) {
            if (Chars.isXMLSpace(this.mText.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isXMLSpace(int offset, int length, char[] chars) {
        for (int i = offset; i < length; ++i) {
            if (Chars.isXMLSpace(chars[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean isXMLSpace(char c) {
        return c <= ' ';
    }

    @Override
    public void postSave() {
    }

    @Override
    public void preSave(boolean bSaveXMLScript) {
    }

    @Override
    public void serialize(OutputStream sOutFile, DOMSaveOptions options, int level, Node prevSibling) throws IOException {
        if (!options.canBeSaved(false, this.isDefault(false), this.isTransient())) {
            return;
        }
        if (options.getDisplayFormat() == 2 && this.isXMLSpace() && (this.getNextXMLSibling() != null || prevSibling != null)) {
            return;
        }
        String content = StringUtils.toXML(this.mText, false);
        sOutFile.write(content.getBytes("UTF-8"));
    }

    public void setScriptProperty(String sPropertyName, Arg propertyValue) {
        throw new ExFull(ResId.UNSUPPORTED_OPERATION, "Chars#setScriptProperty");
    }

    public void setText(String text) {
        this.mText = text;
        this.setDirty();
    }
}

