/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.reef.siren;

import java.util.Arrays;
import org.json.JSONException;
import org.json.JSONObject;

public final class Link {
    private String[] rel;
    private String href;
    private String title;
    private String type;

    public Link(String[] rel, String href) throws IllegalArgumentException {
        if (rel == null || rel.length == 0 || href == null || href.isEmpty()) {
            throw new IllegalArgumentException("rel and href can not be null or empty");
        }
        this.rel = rel;
        this.href = href;
    }

    public String[] getRel() {
        return this.rel;
    }

    public void setRel(String[] rel) {
        this.rel = rel;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        if (href == null || href.isEmpty()) {
            throw new IllegalArgumentException("href can not be null or empty.");
        }
        this.href = href;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String toString() {
        try {
            JSONObject link = new JSONObject();
            link.put("rel", this.rel);
            link.put("href", this.href);
            if (this.title != null) {
                link.put("title", this.title);
            }
            if (this.type != null) {
                link.put("type", this.type);
            }
            return link.toString();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.href == null ? 0 : this.href.hashCode());
        result = 31 * result + Arrays.hashCode(this.rel);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Link other = (Link)obj;
        if (this.href == null ? other.href != null : !this.href.equals(other.href)) {
            return false;
        }
        return Arrays.equals(this.rel, other.rel);
    }
}

