/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.util;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import java.io.IOException;

public final class ParseOps {
    private static final int DEFAULT_CHUNK_SIZE = 512;
    private static ThreadLocal<byte[]> tlBuffer = new ThreadLocal<byte[]>(){

        @Override
        protected synchronized byte[] initialValue() {
            return new byte[512];
        }
    };

    private ParseOps() {
    }

    public static byte[] readHex(InputByteStream buf) throws IOException, PDFParseException {
        byte b = (byte)buf.read();
        int begin = (int)buf.getPosition() - 1;
        int whiteSpaceCount = 0;
        while (b != 62) {
            if (!ByteOps.isHexDigit(b)) {
                if (!ByteOps.isWhitespace(b)) {
                    throw new PDFParseException("Expected Hex Digit" + Long.toString(buf.getPosition() - 1L));
                }
                ++whiteSpaceCount;
            }
            b = (byte)buf.read();
        }
        int end = (int)buf.getPosition() - 1;
        return ParseOps.hexToByteArray(buf, begin, end, whiteSpaceCount);
    }

    public static void skipHex(InputByteStream buf) throws IOException, PDFParseException {
        byte b = (byte)buf.read();
        while (b != 62) {
            if (!ByteOps.isHexDigit(b) && !ByteOps.isWhitespace(b)) {
                throw new PDFParseException("Expected Hex Digit" + Long.toString(buf.getPosition() - 1L));
            }
            b = (byte)buf.read();
        }
    }

    public static void skipLiteral(InputByteStream inBuf) throws IOException {
        int level = 1;
        do {
            byte cur;
            if ((cur = (byte)inBuf.read()) == 40) {
                ++level;
                continue;
            }
            if (cur == 41) {
                --level;
                continue;
            }
            if (cur != 92 || (cur = (byte)inBuf.read()) == 13 || cur < 48 || cur > 55) continue;
            cur = (byte)(cur - 48);
            byte c = (byte)inBuf.read();
            if (c >= 48 && c <= 55) {
                c = (byte)(c - 48);
                byte d = (byte)inBuf.read();
                if (d >= 48 && d <= 55) {
                    inBuf.read();
                }
            }
            inBuf.unget();
        } while (level != 0 && !inBuf.eof());
    }

    public static byte[] readLiteral(InputByteStream inBuf) throws IOException, PDFParseException {
        byte[] dest = new byte[16];
        int destIndex = 0;
        int level = 1;
        do {
            int a;
            if ((a = inBuf.read()) == -1) {
                throw new PDFParseException("EOF occured while reading a literal from content stream.");
            }
            int cur = a;
            if (cur == 40) {
                ++level;
            } else if (cur == 41) {
                --level;
            } else if (cur == 92) {
                cur = (byte)inBuf.read();
                if (cur == 10) continue;
                if (cur == 13) {
                    cur = (byte)inBuf.read();
                    if (cur == 10) continue;
                    inBuf.unget();
                    continue;
                }
                if (cur >= 48 && cur <= 55) {
                    cur = (byte)(cur - 48);
                    byte c = (byte)inBuf.read();
                    if (c >= 48 && c <= 55) {
                        c = (byte)(c - 48);
                        byte d = (byte)inBuf.read();
                        if (d >= 48 && d <= 55) {
                            d = (byte)(d - 48);
                            cur = (byte)(cur * 64 + c * 8 + d);
                            inBuf.read();
                        } else {
                            cur = (byte)(cur * 8 + c);
                        }
                    }
                    inBuf.unget();
                } else if (cur == 110) {
                    cur = 10;
                } else if (cur == 114) {
                    cur = 13;
                } else if (cur == 116) {
                    cur = 9;
                } else if (cur == 98) {
                    cur = 8;
                } else if (cur == 102) {
                    cur = 12;
                } else if (cur == 40) {
                    cur = 40;
                } else if (cur == 41) {
                    cur = 41;
                } else if (cur == 92) {
                    cur = 92;
                }
            }
            if (destIndex == dest.length) {
                byte[] newDest = new byte[dest.length * 2];
                System.arraycopy(dest, 0, newDest, 0, dest.length);
                dest = newDest;
            }
            dest[destIndex++] = cur;
        } while (level != 0);
        byte[] asStr = new byte[destIndex - 1];
        for (int i = 0; i < destIndex - 1; ++i) {
            asStr[i] = dest[i];
        }
        return asStr;
    }

    static byte readHexDigit(InputByteStream buf) throws IOException, PDFParseException {
        return ByteOps.getHex((byte)buf.read());
    }

    public static ASName readName(InputByteStream buf) throws IOException, PDFParseException {
        byte[] tmp = tlBuffer.get();
        int end = 0;
        int cur = buf.read();
        while (ByteOps.isRegular((byte)cur)) {
            if (cur == 35) {
                cur = ParseOps.readHexDigit(buf) * 16 + ParseOps.readHexDigit(buf);
            }
            tmp[end++] = (byte)cur;
            if (end >= tmp.length || buf.eof()) break;
            cur = buf.read();
        }
        if (!ByteOps.isRegular((byte)cur)) {
            buf.unget();
        }
        return ASName.getName(tmp, 0, end);
    }

    public static void skipName(InputByteStream buf) throws IOException, PDFParseException {
        int cur = buf.read();
        while (ByteOps.isRegular((byte)cur)) {
            if (cur == 35) {
                buf.read();
                buf.read();
            }
            if (buf.eof()) break;
            cur = buf.read();
        }
        if (!ByteOps.isRegular((byte)cur)) {
            buf.unget();
        }
    }

    public static ASNumber readNumber(byte first, InputByteStream buf) throws PDFParseException, IOException {
        boolean decimalPointEncountered = false;
        int end = 0;
        byte[] tmp = new byte[512];
        byte b = first;
        if (b == 45 || b == 43) {
            tmp[end++] = b;
            b = (byte)buf.read();
        }
        while (ByteOps.isDigit(b)) {
            tmp[end++] = b;
            if (end >= tmp.length || buf.eof()) break;
            b = (byte)buf.read();
        }
        if (b == 46) {
            decimalPointEncountered = true;
            tmp[end++] = b;
            if (!buf.eof()) {
                b = (byte)buf.read();
                while (ByteOps.isDigit(b)) {
                    tmp[end++] = b;
                    if (buf.eof()) break;
                    b = (byte)buf.read();
                }
            }
        }
        if (ByteOps.isRegular(b) && !ByteOps.isDigit(b)) {
            if (!decimalPointEncountered || b != 45) {
                throw new PDFParseException("Expected a number at position - " + Long.toString(buf.getPosition() - 1L));
            }
            while (!ByteOps.isWhitespace(b) && !buf.eof()) {
                b = (byte)buf.read();
            }
        }
        byte[] strBuf = new byte[end];
        for (int i = 0; i < strBuf.length; ++i) {
            strBuf[i] = tmp[i];
        }
        ASString strVal = new ASString(strBuf);
        ASNumber number = new ASNumber(strVal);
        if (!ByteOps.isRegular(b)) {
            buf.unget();
        }
        return number;
    }

    public static void skipNumber(byte first, InputByteStream buf) throws PDFParseException, IOException {
        byte b = first;
        if (b == 45 || b == 43) {
            b = (byte)buf.read();
        }
        while (ByteOps.isDigit(b) && !buf.eof()) {
            b = (byte)buf.read();
        }
        if (b == 46 && !buf.eof()) {
            b = (byte)buf.read();
            while (ByteOps.isDigit(b) && !buf.eof()) {
                b = (byte)buf.read();
            }
        }
        if (!ByteOps.isRegular(b)) {
            buf.unget();
        }
    }

    public static byte skipWhitespace(InputByteStream buf) throws IOException {
        int b = 32;
        while (ByteOps.isWhitespace((byte)b) && !buf.eof()) {
            b = (byte)buf.read();
            if (b != 37) continue;
            while (b != 13 && b != 10 && !buf.eof()) {
                b = (byte)buf.read();
            }
            if (!buf.eof()) continue;
            b = 32;
        }
        return (byte)b;
    }

    static byte[] hexToByteArray(InputByteStream buf, int begin, int end, int whiteSpaceCount) throws IOException, PDFParseException {
        byte[] rslt = new byte[(end - begin - whiteSpaceCount + 1) / 2];
        int idx = 0;
        buf.seek(begin);
        int i = begin;
        while (i < end) {
            byte bH;
            while (!ByteOps.isHexDigit(bH = (byte)buf.read()) && ++i < end) {
            }
            if (!ByteOps.isHexDigit(bH)) continue;
            byte h = ByteOps.getHex(bH);
            int l = 0;
            if (i < end) {
                byte bL;
                while (!ByteOps.isHexDigit(bL = (byte)buf.read()) && ++i < end) {
                }
                if (ByteOps.isHexDigit(bL)) {
                    l = ByteOps.getHex(bL);
                }
            }
            rslt[idx++] = (byte)(h * 16 + l);
        }
        buf.seek(buf.getPosition() + 1L);
        if (idx < rslt.length) {
            byte[] shortRslt = new byte[idx];
            for (int i2 = 0; i2 < idx; ++i2) {
                shortRslt[i2] = rslt[i2];
            }
            return shortRslt;
        }
        return rslt;
    }

    static void skipHexToByteArray(InputByteStream buf, int begin, int end, int whiteSpaceCount) throws IOException, PDFParseException {
        buf.seek(begin);
        int i = begin;
        while (i < end) {
            byte bL;
            byte bH;
            while (!ByteOps.isHexDigit(bH = (byte)buf.read()) && ++i < end) {
            }
            if (!ByteOps.isHexDigit(bH) || i >= end) continue;
            while (!ByteOps.isHexDigit(bL = (byte)buf.read()) && ++i < end) {
            }
        }
        buf.seek(buf.getPosition() + 1L);
    }

    public static long getEndObjPos(InputByteStream mBuf) throws IOException {
        int b = mBuf.read();
        while (b != -1) {
            if (b == 101) {
                b = mBuf.read();
                if (b != 110 || (b = mBuf.read()) != 100 || (b = mBuf.read()) != 111 || (b = mBuf.read()) != 98 || (b = mBuf.read()) != 106) continue;
                return mBuf.getPosition() - 6L;
            }
            b = mBuf.read();
        }
        return -1L;
    }
}

