/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectInfo;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.cos.CosToken;
import com.adobe.internal.pdftoolkit.core.cos.DoubleToStringFormatter;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosNumberParseRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.util.BooleanHolder;
import com.adobe.internal.pdftoolkit.core.util.StringOps;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Locale;

public class CosNumeric
extends CosScalar {
    private static final DoubleToStringFormatter customFormatter = new DoubleToStringFormatter(6, '.', '-', false);
    private static final int NCACHEDINTEGERS = 4096;
    private static Integer[] mCachedIntegers = new Integer[4096];
    private static final DecimalFormat mPDFDecimalFormat;
    private byte[] mInputRep;
    private Number mValue;

    CosNumeric(CosDocument doc, Number value, CosObjectInfo info) {
        super(doc, info);
        int val;
        if (value instanceof Integer && (val = value.intValue()) >= 0 && val < 4096) {
            if (mCachedIntegers[val] == null) {
                CosNumeric.mCachedIntegers[val] = (Integer)value;
            }
            value = mCachedIntegers[val];
        }
        this.mInputRep = null;
        this.mValue = value;
    }

    CosNumeric(CosDocument doc, byte[] inputRep, CosObjectInfo info) throws PDFCosParseException {
        super(doc, info);
        if (inputRep != null) {
            int count;
            for (count = 0; count < inputRep.length && inputRep[count] != 0; ++count) {
            }
            if (count < inputRep.length) {
                byte[] copy = new byte[count];
                System.arraycopy(inputRep, 0, copy, 0, count);
                inputRep = copy;
            }
        }
        this.mInputRep = inputRep;
    }

    private void generateNumberValue() {
        Number value;
        block7: {
            if (this.mValue != null) {
                return;
            }
            value = null;
            try {
                BooleanHolder wasRepaired = this.getDocument().getOptions().getRepairEnabled() ? new BooleanHolder(false) : null;
                value = CosToken.readNumber(this.mInputRep, wasRepaired);
                if (wasRepaired != null && wasRepaired.getValue()) {
                    this.setRepaired(true);
                }
            }
            catch (PDFCosParseException e) {
                if (!e.hasErrorType(PDFCosParseException.CosParseErrorType.NumberParseError)) break block7;
                throw new PDFCosNumberParseRuntimeException(e);
            }
        }
        if (value instanceof Integer) {
            int val = value.intValue();
            if (val >= 0 && val < 4096) {
                if (mCachedIntegers[val] == null) {
                    CosNumeric.mCachedIntegers[val] = (Integer)value;
                }
                value = mCachedIntegers[val];
            }
            this.mInputRep = null;
        }
        this.mValue = value;
    }

    CosNumeric(CosDocument doc, CosNumeric source) throws PDFCosParseException, IOException, PDFIOException, PDFSecurityException {
        super(doc, null);
        if (source.isIndirect()) {
            CosObjectInfo info = doc.newObjectInfo();
            this.setInfo(info);
            info.setObject(this);
            info.markDirty();
        }
        this.mInputRep = source.mInputRep;
        this.mValue = source.mValue;
    }

    @Override
    public int getType() {
        return 1;
    }

    @Override
    public int intValue() {
        this.generateNumberValue();
        return this.mValue.intValue();
    }

    public int fixedValue() throws PDFCosParseException {
        this.generateNumberValue();
        if (this.mValue instanceof Integer || this.mValue instanceof Long) {
            long value = this.mValue.longValue();
            if (value > 32767L || value < -32768L) {
                throw new PDFCosParseException("Fixed value out of range");
            }
            return (int)(value << 16);
        }
        double value = this.mValue.doubleValue();
        if (value == 32768.0) {
            return Integer.MAX_VALUE;
        }
        if (value > 32767.0 || value < -32768.0) {
            throw new PDFCosParseException("Fixed value out of range");
        }
        value = (value *= 65536.0) >= 0.0 ? (value += 0.5) : (value -= 0.5);
        return (int)value;
    }

    @Override
    public long longValue() {
        this.generateNumberValue();
        return this.mValue.longValue();
    }

    @Override
    public double doubleValue() {
        this.generateNumberValue();
        return this.mValue.doubleValue();
    }

    @Override
    public Number numberValue() {
        this.generateNumberValue();
        return this.mValue;
    }

    @Override
    public Object getValue() {
        this.generateNumberValue();
        return this.numberValue();
    }

    @Override
    void writeOut(OutputByteStream outStream, boolean inString, boolean inDebugMode) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        if (this.mInputRep != null) {
            outStream.write(this.mInputRep);
        } else if (this.mValue instanceof Double || this.mValue instanceof Float) {
            String raw = customFormatter.appendFormatted(this.mValue.doubleValue());
            if (raw != null) {
                outStream.write(StringOps.toByteArray(raw));
            } else {
                int count;
                raw = mPDFDecimalFormat.format(this.mValue);
                int length = raw.length();
                boolean sign = false;
                boolean expSign = false;
                boolean expSeen = false;
                int digitPos = 0;
                int exponent = 0;
                int numDigits = 0;
                for (count = 0; count < length; ++count) {
                    char curChar = raw.charAt(count);
                    if (curChar == '-') {
                        if (expSeen) {
                            expSign = true;
                            continue;
                        }
                        sign = true;
                        continue;
                    }
                    if (curChar == 'E') {
                        expSeen = true;
                        continue;
                    }
                    if (curChar < '0' || curChar > '9') continue;
                    if (expSeen) {
                        exponent *= 10;
                        exponent += curChar - 48;
                        continue;
                    }
                    if (digitPos == 0) {
                        digitPos = count;
                    }
                    ++numDigits;
                }
                if (numDigits == 0 || !expSeen) {
                    outStream.write(48);
                } else {
                    if (sign) {
                        outStream.write(45);
                    }
                    if (expSign) {
                        outStream.write(48);
                        outStream.write(46);
                        for (count = 0; count < exponent; ++count) {
                            outStream.write(48);
                        }
                        for (count = 0; count < numDigits; ++count) {
                            outStream.write(raw.charAt(digitPos + count));
                        }
                    } else if (exponent >= numDigits) {
                        for (count = 0; count < numDigits; ++count) {
                            outStream.write(raw.charAt(digitPos + count));
                        }
                        for (count = numDigits; count < exponent; ++count) {
                            outStream.write(48);
                        }
                    } else {
                        if (exponent == 0) {
                            outStream.write(48);
                        }
                        for (count = 0; count < exponent; ++count) {
                            outStream.write(raw.charAt(digitPos + count));
                        }
                        if (numDigits != exponent + 1 || raw.charAt(digitPos + exponent) != '0') {
                            outStream.write(46);
                            for (count = exponent; count < numDigits; ++count) {
                                outStream.write(raw.charAt(digitPos + count));
                            }
                        }
                    }
                }
            }
        } else {
            outStream.write(StringOps.toByteArray(String.valueOf(this.mValue.longValue())));
        }
    }

    @Override
    public boolean equals(CosObject value) {
        if (!(value instanceof CosNumeric) || value.getDocument() != this.getDocument()) {
            return false;
        }
        if (value == this) {
            return true;
        }
        CosNumeric numericValue = (CosNumeric)value;
        byte[] numericValueBytes1 = numericValue.mInputRep;
        byte[] numericValueBytes2 = this.mInputRep;
        if (numericValueBytes1 != null && numericValueBytes2 != null) {
            return Arrays.equals(numericValueBytes1, numericValueBytes2);
        }
        this.generateNumberValue();
        ((CosNumeric)value).generateNumberValue();
        return numericValue.mValue.equals(this.mValue);
    }

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
        dfs.setZeroDigit('0');
        dfs.setDecimalSeparator('.');
        dfs.setMinusSign('-');
        mPDFDecimalFormat = new DecimalFormat(".######E0", dfs);
        mPDFDecimalFormat.setGroupingUsed(false);
    }
}

