/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosContainer;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectInfo;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectStream;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityAuthorizationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.securityframework.DecryptedState;
import com.adobe.internal.pdftoolkit.core.securityframework.EncryptionHandler;
import com.adobe.internal.pdftoolkit.core.securityframework.EncryptionHandlerState;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityHandler;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityManager;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.EnableEncryption;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CosEncryption {
    private EnableEncryption mEncryptionHandle = null;
    private CosDictionary mDecryptDictionary = null;
    private CosDocument mDoc;
    private SecurityManager mEncryptionManager = null;
    private Map mEncryptionMap = null;
    private Map mDecryptionStateHandlers = null;
    private Map mEncryptionStateHandlers = null;
    private boolean mNeedsDecryption;
    private boolean mNeedsEncryption = false;
    private boolean mDoDecryption;
    private boolean mIsNewEncryption = false;
    private boolean mInSave = false;
    private static final String ENCRYPT_IMPL = "com.adobe.internal.pdftoolkit.core.encryption.EncryptionImpl";
    private static final String ENCRYPT_METADATA = ASName.k_EncryptMetadata.asString(true);
    private static final String STMF = ASName.k_StmF.asString(true);
    private static final String CF = ASName.k_CF.asString(true);
    private static final String V = ASName.k_V.asString(true);

    public CosEncryption(CosDocument doc) {
        this.mDoc = doc;
        if (doc == null) {
            this.mNeedsDecryption = false;
            this.mDoDecryption = false;
        }
    }

    public void setupDecryption() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (this.mDoc != null) {
            CosDictionary trailer;
            this.mNeedsDecryption = this.mDoc.isEncrypted();
            if (this.mNeedsDecryption && (trailer = this.mDoc.getTrailer()) != null) {
                this.mDecryptDictionary = trailer.containsKey(ASName.k_Encrypt) ? trailer.getCosDictionary(ASName.k_Encrypt) : null;
            }
        }
        this.mDoDecryption = true;
    }

    public boolean needsDecryption() {
        return this.mNeedsDecryption;
    }

    public boolean setNeedsDecryption(boolean decrypt) {
        boolean old = this.mNeedsDecryption;
        this.mNeedsDecryption = decrypt;
        return old;
    }

    public boolean needsEncryption() {
        return this.mNeedsEncryption;
    }

    public CosDictionary getEncryption() {
        return this.mDecryptDictionary;
    }

    public Map getDecryptionMap() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return (Map)this.mDecryptDictionary.getValue();
    }

    public Map getEncryptionMap() throws PDFSecurityAuthorizationException {
        return this.getEncryptionImpl().getEncryptionParameters();
    }

    public SecurityHandler getDefaultDecryptionHandler() throws PDFCosParseException, PDFSecurityException {
        if (this.mEncryptionHandle == null) {
            throw new PDFSecurityConfigurationException("Security Manager is not set");
        }
        return this.getDefaultHandler(this.mEncryptionHandle.getDecryptionParameters(), this.mEncryptionHandle.getDecryptionSecurityManager());
    }

    private SecurityHandler getDefaultHandler(Map encryptParams, SecurityManager secMgr) throws PDFCosParseException, PDFSecurityException {
        if (this.mEncryptionHandle == null || secMgr == null) {
            throw new PDFSecurityConfigurationException("Security Manager is not set");
        }
        SecurityHandler handler = null;
        String handlerName = (String)encryptParams.get("Filter");
        if (handlerName != null) {
            handler = secMgr.getSecurityHandler(handlerName, encryptParams);
        }
        if (handler != null) {
            return handler;
        }
        throw new PDFCosParseException("Invalid /Encrypt dictionary");
    }

    public EnableEncryption getEncryptionImpl() throws PDFUnsupportedFeatureException {
        if (this.mEncryptionHandle == null) {
            try {
                this.mEncryptionHandle = (EnableEncryption)Class.forName(ENCRYPT_IMPL).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exp) {
                throw new PDFUnsupportedFeatureException("Encryption is not supported", exp);
            }
        }
        return this.mEncryptionHandle;
    }

    private boolean shouldEncryptMetadata1(CosStream stream, ASName cryptFilter, boolean encrypting) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        String cryptName;
        Map cryptDict;
        Map cfDict;
        Map encryptParams;
        Boolean toEncrypt = null;
        if (stream.containsKey(ASName.k_Type) && stream.getName(ASName.k_Type).equals(ASName.k_Metadata) && (toEncrypt = (Boolean)(encryptParams = encrypting ? this.getEncryptionMap() : this.getDecryptionMap()).get(ENCRYPT_METADATA)) == null && (cfDict = (Map)encryptParams.get(ASName.k_CF.asString(true))) != null && (cryptDict = (Map)cfDict.get(cryptName = cryptFilter == null ? (String)encryptParams.get(STMF) : cryptFilter.asString(true))) != null) {
            toEncrypt = (Boolean)cryptDict.get(ENCRYPT_METADATA);
        }
        return toEncrypt == null || toEncrypt != false;
    }

    private boolean shouldEncryptMetadata(ASName type, ASName cryptFilter, boolean encrypting) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        String cryptName;
        Map cryptDict;
        Map cfDict;
        Map encryptParams;
        Boolean toEncrypt = null;
        if (ASName.k_Metadata.equals(type) && (toEncrypt = (Boolean)(encryptParams = encrypting ? this.getEncryptionMap() : this.getDecryptionMap()).get(ENCRYPT_METADATA)) == null && (cfDict = (Map)encryptParams.get(ASName.k_CF.asString(true))) != null && (cryptDict = (Map)cfDict.get(cryptName = cryptFilter == null ? (String)encryptParams.get(STMF) : cryptFilter.asString(true))) != null) {
            toEncrypt = (Boolean)cryptDict.get(ENCRYPT_METADATA);
        }
        return toEncrypt == null || toEncrypt != false;
    }

    boolean shouldDecryptOrEncrypt1(CosStream stream, ASName cryptFilter, boolean encrypting) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        boolean encryptMetadata = this.shouldEncryptMetadata1(stream, cryptFilter, encrypting);
        if (!this.mInSave) {
            return encryptMetadata;
        }
        if (!encryptMetadata) {
            return false;
        }
        if (this.mIsNewEncryption) {
            return true;
        }
        if (stream.isDirty()) {
            return true;
        }
        return stream instanceof CosObjectStream || stream.getCryptFilter() == null && stream.getDocument().getLinearization() != null;
    }

    int shouldDecryptOrEncrypt(ASName type, ASName cryptFilter, boolean encrypting) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        int retVal = 0;
        boolean encryptMetadata = this.shouldEncryptMetadata(type, cryptFilter, encrypting);
        if (!this.mInSave) {
            retVal = encryptMetadata ? 1 : -1;
        } else if (!encryptMetadata) {
            retVal = -1;
        } else if (this.mIsNewEncryption) {
            retVal = 1;
        }
        return retVal;
    }

    public SecurityManager getDecryptionSecurityManager() {
        return this.mEncryptionHandle != null ? this.mEncryptionHandle.getDecryptionSecurityManager() : null;
    }

    public boolean authenticateDecryption(DecryptedState decryptedState) throws PDFSecurityException {
        SecurityHandler secHandler;
        try {
            secHandler = this.getDefaultDecryptionHandler();
        }
        catch (PDFCosParseException excp) {
            throw new PDFSecurityAuthorizationException("Authentication failed", excp);
        }
        return this.mEncryptionHandle.authenticateSecurity(secHandler, decryptedState);
    }

    public void setDecryptionSecurityManager(SecurityManager securityMgr) throws PDFSecurityException, PDFCosParseException, PDFIOException {
        try {
            this.setDecryptionSecurityManager(securityMgr, this.getDecryptionMap());
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    void setDecryptionSecurityManager(SecurityManager securityMgr, Map encryptParams) throws PDFSecurityException, PDFCosParseException, PDFIOException, IOException {
        if (this.mEncryptionHandle == null) {
            this.getEncryptionImpl();
        }
        if (this.mEncryptionHandle.getDecryptionSecurityManager() == null) {
            this.setupDecryption();
            this.mEncryptionHandle.setDecryptionSecurityManager(securityMgr, encryptParams, this.getIDForEncryption());
            if (this.mEncryptionHandle.getEncryptionSecurityManager() == null) {
                this.setEncryptionSecurityManager(securityMgr, encryptParams);
                this.mEncryptionHandle.setEncryptionSecurityManager(securityMgr, encryptParams, this.getIDForEncryption());
                this.mIsNewEncryption = false;
            }
        } else {
            throw new PDFSecurityAuthorizationException("Cannot unlock again already unlocked document");
        }
    }

    public SecurityManager getEncryptionSecurityManager() {
        return this.mEncryptionHandle != null ? this.mEncryptionHandle.getEncryptionSecurityManager() : null;
    }

    public void setEncryptionSecurityManager(SecurityManager securityMgr, Map encryptParams) {
        this.getEncryptionImpl();
        this.mNeedsEncryption = true;
        this.mIsNewEncryption = true;
        this.mEncryptionManager = securityMgr;
        this.mEncryptionMap = encryptParams;
    }

    public void setDecryptionAsEncryption() throws PDFSecurityException, PDFCosParseException, PDFIOException {
        try {
            if (this.mDoc.isEncrypted()) {
                SecurityManager encryptionMgr = this.getEncryptionSecurityManager();
                Map encryptionMap = this.getEncryptionMap();
                this.resetDecryptionSecurityManager();
                if (encryptionMgr != null) {
                    this.setDecryptionSecurityManager(encryptionMgr, encryptionMap);
                }
            } else {
                this.resetDecryptionSecurityManager();
            }
            this.mIsNewEncryption = false;
            this.mInSave = false;
            this.setupDecryption();
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public void setupEncryption() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            this.mInSave = true;
            if (!this.mNeedsEncryption) {
                return;
            }
            this.getEncryptionImpl();
            this.mEncryptionHandle.setEncryptionSecurityManager(this.mEncryptionManager, this.mEncryptionMap, this.getIDForEncryption());
            if (this.mIsNewEncryption) {
                SecurityHandler defaultHandler = this.getDefaultHandler(this.mEncryptionMap, this.mEncryptionManager);
                this.mEncryptionHandle.authenticateSecurity(this.mEncryptionMap, this.getIDForEncryption(), defaultHandler, null);
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public void resetEncryptionSecurityManager() {
        if (this.mEncryptionHandle != null) {
            this.mEncryptionHandle.resetEncryptionSecurityManager();
        }
        this.mNeedsEncryption = false;
        this.mEncryptionManager = null;
        this.mIsNewEncryption = true;
    }

    public void resetDecryptionSecurityManager() {
        if (this.mEncryptionHandle != null) {
            this.mEncryptionHandle.resetDecryptionSecurityManager();
        }
    }

    private int getEncryptVersion() {
        Integer versionObj;
        int version = 0;
        if (this.mEncryptionMap != null && (versionObj = (Integer)this.mEncryptionMap.get(V)) != null) {
            version = versionObj;
        }
        return version;
    }

    private int getDecryptVersion() throws PDFSecurityException {
        int version = 0;
        if (this.mDecryptDictionary != null && this.mDecryptDictionary.containsKey(ASName.k_V)) {
            try {
                version = this.mDecryptDictionary.getInt(ASName.k_V);
            }
            catch (PDFCosParseException e) {
                throw new PDFSecurityException("PDFCosParseException while reading /Encrypt/V ", e);
            }
            catch (PDFIOException e) {
                throw new PDFSecurityException("PDFIOException while reading /Encrypt/V ", e);
            }
        }
        return version;
    }

    public byte[] encryptString(CosString strObj, byte[] content) throws PDFSecurityException {
        if (this.needsEncryption(strObj)) {
            byte[] addKey = this.getEncryptVersion() < 5 ? strObj.getObjectEncryptionKey(true) : null;
            return this.getEncryptionImpl().encryptString(content, addKey);
        }
        return content;
    }

    public byte[] decryptString(CosString strObj, byte[] content) throws PDFSecurityException {
        if (this.needsDecryption(strObj)) {
            byte[] addKey = this.getDecryptVersion() < 5 ? strObj.getObjectEncryptionKey(false) : null;
            return this.getEncryptionImpl().decryptString(content, addKey);
        }
        return content;
    }

    public InputByteStream decryptStream(ASName cryptFilter, CosStream strObj, InputByteStream content) throws PDFIOException, PDFSecurityException, PDFCosParseException {
        try {
            this.getEncryptionImpl();
            OutputByteStream dest = strObj.getStreamManager().getOutputByteStreamEncryptedDocument(ByteWriterFactory.Fixed.GROWABLE, content.length());
            this.mEncryptionHandle.decryptStream(cryptFilter != null ? cryptFilter.asString(true) : null, content, dest, this.getStreamEncryptionKey(strObj, false));
            return dest.closeAndConvert();
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    byte[] getStreamEncryptionKey(CosStream stream, boolean write) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        byte[] addKey = null;
        if (stream.getCryptFilter() == null) {
            int version;
            int n = version = write ? this.getEncryptVersion() : this.getDecryptVersion();
            if (version < 5) {
                addKey = stream.getObjectEncryptionKey(write);
            }
        }
        return addKey;
    }

    public InputByteStream encryptStream(ASName cryptFilter, CosStream strObj, InputByteStream content) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            this.getEncryptionImpl();
            OutputByteStream dest = strObj.getStreamManager().getOutputByteStreamEncryptedDocument(ByteWriterFactory.Fixed.GROWABLE, content.length());
            content.seek(0L);
            this.mEncryptionHandle.encryptStream(cryptFilter != null ? cryptFilter.asString(true) : null, content, dest, this.getStreamEncryptionKey(strObj, true));
            return dest.closeAndConvert();
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public boolean setEncryptionState(boolean doIt) {
        boolean old = this.getEncryptionState();
        this.mDoDecryption = doIt;
        return old;
    }

    public boolean getEncryptionState() {
        return this.mDoDecryption;
    }

    private byte[] getIDForEncryption() throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        CosObject idStr;
        byte[] id = null;
        CosDictionary trailer = this.mDoc.getTrailer();
        if (trailer != null && (idStr = trailer.get(ASName.k_ID)) != null && idStr.getType() == 5) {
            id = ((CosString)((CosArray)idStr).get(0)).byteArrayValue();
        }
        return id;
    }

    private boolean hasEFF() throws PDFSecurityAuthorizationException {
        Map encryptionParams;
        boolean result = false;
        if (this.needsEncryption() && (encryptionParams = this.getEncryptionMap()) != null && encryptionParams.containsKey("EFF")) {
            result = true;
        }
        return result;
    }

    private boolean needsEncryption(CosString stringObj) {
        if (!this.needsEncryption()) {
            return false;
        }
        CosObjectInfo strInfo = stringObj.getInfo();
        if (strInfo == null) {
            CosContainer parent = stringObj.getParentObj();
            if (parent == null) {
                return true;
            }
            strInfo = parent.getInfo();
        }
        if (strInfo == null) {
            return true;
        }
        return this.mDoDecryption && !strInfo.isWriteCompressed();
    }

    private boolean needsDecryption(CosString stringObj) {
        if (!this.needsDecryption()) {
            return false;
        }
        CosObjectInfo strInfo = stringObj.getInfo();
        if (strInfo == null) {
            CosContainer parent = stringObj.getParentObj();
            if (parent == null) {
                return true;
            }
            strInfo = parent.getInfo();
        }
        if (strInfo == null) {
            return true;
        }
        return this.mDoDecryption && !strInfo.isCompressed();
    }

    CosArray checkEFFOutputFilter(CosStream stmObj) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray outputFilters = stmObj.getOutputFiltersList();
        if (outputFilters == null && this.hasEFF() && stmObj.isDirty() && (outputFilters = stmObj.getInputFiltersList()) != null) {
            this.removeCryptFilter(outputFilters);
        }
        return outputFilters;
    }

    CosArray checkMetadataStream(CosStream stmObj) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        CosArray outputFilters = stmObj.getOutputFiltersList();
        CosObject type = stmObj.get(ASName.k_Type);
        if (type != null && this.needsEncryption() && ASName.k_Metadata.equals(type.nameValue())) {
            Map encryptParams;
            if (outputFilters == null) {
                outputFilters = stmObj.getInputFiltersList();
            }
            if ((encryptParams = this.getEncryptionMap()) != null) {
                this.removeCryptFilter(outputFilters);
                if (encryptParams.containsKey(CF) && !this.shouldEncryptMetadata(type.nameValue(), null, true)) {
                    CosArray cryptFilter = this.mDoc.createCosArray();
                    cryptFilter.add(this.mDoc.createCosName(ASName.k_Crypt));
                    cryptFilter.add(this.mDoc.createCosNull());
                    outputFilters.add(0, cryptFilter);
                }
            }
        }
        return outputFilters;
    }

    private boolean removeCryptFilter(CosArray filters) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        Iterator<CosObject> filtersIter = filters.iterator();
        while (filtersIter.hasNext()) {
            CosArray filterAtIndex = (CosArray)filtersIter.next();
            if (!ASName.k_Crypt.equals(((CosName)filterAtIndex.get(0)).nameValue())) continue;
            filtersIter.remove();
            return true;
        }
        return false;
    }

    EncryptionHandler getStreamDecryptionHandler(String cryptName) throws PDFSecurityException {
        this.getEncryptionImpl();
        return this.mEncryptionHandle.getStreamDecryptionHandler(cryptName);
    }

    EncryptionHandler getStreamEncryptionHandler(String cryptName) throws PDFSecurityException {
        this.getEncryptionImpl();
        return this.mEncryptionHandle.getStreamEncryptionHandler(cryptName);
    }

    EncryptionHandlerState getStreamDecryptionStateHandler(CosStream stream, InputByteStream content) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        EncryptionHandlerState stateHandler;
        if (!stream.needsDecryption(content)) {
            return null;
        }
        ASName cryptFilter = stream.getCryptFilter();
        String cryptName = cryptFilter == null ? null : cryptFilter.asString(true);
        this.getEncryptionImpl();
        EncryptionHandler handler = this.mEncryptionHandle.getStreamDecryptionHandler(cryptName);
        if (handler == null) {
            return null;
        }
        if (this.mDecryptionStateHandlers == null) {
            this.mDecryptionStateHandlers = new HashMap();
        }
        if ((stateHandler = (EncryptionHandlerState)this.mDecryptionStateHandlers.get(handler)) == null) {
            stateHandler = handler.createEncryptionHandlerState();
            this.mDecryptionStateHandlers.put(handler, stateHandler);
        }
        return stateHandler;
    }

    EncryptionHandlerState getStreamEncryptionStateHandler(CosStream stream) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        EncryptionHandlerState stateHandler;
        if (!stream.needsEncryption()) {
            return null;
        }
        this.getEncryptionImpl();
        ASName cryptFilter = stream.getCryptFilter();
        String cryptName = cryptFilter == null ? null : cryptFilter.asString(true);
        EncryptionHandler handler = this.mEncryptionHandle.getStreamEncryptionHandler(cryptName);
        if (handler == null) {
            return null;
        }
        if (this.mEncryptionStateHandlers == null) {
            this.mEncryptionStateHandlers = new HashMap();
        }
        if ((stateHandler = (EncryptionHandlerState)this.mEncryptionStateHandlers.get(handler)) == null) {
            stateHandler = handler.createEncryptionHandlerState();
            this.mEncryptionStateHandlers.put(handler, stateHandler);
        }
        return stateHandler;
    }

    void resetDecryptionStateHandlers() {
        this.mDecryptionStateHandlers = null;
    }

    void resetEncryptionStateHandlers() {
        this.mEncryptionStateHandlers = null;
    }
}

