/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosToken;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import java.io.IOException;

final class ByteArrayUtility {
    private ByteArrayUtility() {
    }

    static byte[] readLiteral(CosDocument doc, InputByteStream inBuf, long nextObjPos) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            byte[] dest = new byte[16];
            int destIndex = 0;
            int level = 1;
            do {
                if (doc.getOptions().skipCorruptObjects() && inBuf.getPosition() >= nextObjPos) {
                    return null;
                }
                int cur = inBuf.read();
                if (cur == 40) {
                    ++level;
                } else if (cur == 41) {
                    --level;
                } else if (cur == 92) {
                    cur = (byte)inBuf.read();
                    if (cur == 10) continue;
                    if (cur == 13) {
                        cur = (byte)inBuf.read();
                        if (cur == 10) continue;
                        inBuf.unget();
                        continue;
                    }
                    if (cur >= 48 && cur <= 55) {
                        cur = (byte)(cur - 48);
                        byte c = (byte)inBuf.read();
                        if (c >= 48 && c <= 55) {
                            c = (byte)(c - 48);
                            byte d = (byte)inBuf.read();
                            if (d >= 48 && d <= 55) {
                                d = (byte)(d - 48);
                                cur = (byte)(cur * 64 + c * 8 + d);
                                inBuf.read();
                            } else {
                                cur = (byte)(cur * 8 + c);
                            }
                        }
                        inBuf.unget();
                    } else if (cur == 110) {
                        cur = 10;
                    } else if (cur == 114) {
                        cur = 13;
                    } else if (cur == 116) {
                        cur = 9;
                    } else if (cur == 98) {
                        cur = 8;
                    } else if (cur == 102) {
                        cur = 12;
                    } else if (cur == 40) {
                        cur = 40;
                    } else if (cur == 41) {
                        cur = 41;
                    } else if (cur == 92) {
                        cur = 92;
                    }
                }
                if (destIndex == dest.length) {
                    byte[] newDest = new byte[dest.length * 2];
                    System.arraycopy(dest, 0, newDest, 0, dest.length);
                    dest = newDest;
                }
                dest[destIndex++] = cur;
            } while (level != 0 && !inBuf.eof());
            byte[] result = new byte[destIndex - 1];
            System.arraycopy(dest, 0, result, 0, destIndex - 1);
            return result;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    static void skipLiteral(InputByteStream inBuf) throws IOException {
        int level = 1;
        do {
            byte cur;
            if ((cur = (byte)inBuf.read()) == 40) {
                ++level;
                continue;
            }
            if (cur == 41) {
                --level;
                continue;
            }
            if (cur != 92) continue;
            cur = (byte)inBuf.read();
        } while (level != 0 && !inBuf.eof());
    }

    static byte[] readHex(InputByteStream buf) throws PDFCosParseException, IOException, PDFIOException {
        byte b = (byte)buf.read();
        int begin = (int)buf.getPosition() - 1;
        while (b != 62) {
            if (!ByteOps.isHexDigit(b) && !ByteArrayUtility.ignoreChar(b)) {
                throw new PDFCosParseException("Expected Hex Digit" + Long.toString(buf.getPosition() - 1L));
            }
            b = (byte)buf.read();
        }
        int end = (int)buf.getPosition() - 1;
        return ByteArrayUtility.hexToByteArray(buf, begin, end);
    }

    private static byte[] hexToByteArray(InputByteStream buf, int begin, int end) throws PDFCosParseException, IOException {
        byte[] rslt = new byte[(end - begin) / 2];
        int idx = 0;
        byte h = 0;
        byte l = 0;
        buf.seek(begin);
        for (int i = begin; i < end; i += 2) {
            byte currentChar = (byte)buf.read();
            while (ByteArrayUtility.ignoreChar(currentChar)) {
                currentChar = (byte)buf.read();
                ++i;
            }
            h = CosToken.toHexDigit(currentChar);
            l = CosToken.toHexDigit((byte)buf.read());
            rslt[idx++] = (byte)(h * 16 + l);
        }
        buf.seek(buf.getPosition() + 1L);
        return rslt;
    }

    private static boolean ignoreChar(byte byteValue) {
        if (byteValue == 13) {
            return true;
        }
        if (byteValue == 10) {
            return true;
        }
        return ByteOps.isWhitespace(byteValue);
    }
}

